/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.controller.engine.node;

import com.manageengine.dataengine.commons.concurrent.CommonThreadFactory;
import com.manageengine.dataengine.commons.connector.ConnectorType;
import com.manageengine.dataengine.commons.file.PropertiesFileUtil;
import com.manageengine.dataengine.commons.utils.WinServiceUtil;
import com.manageengine.dataengine.controller.AdapEnvironment;
import com.manageengine.dataengine.controller.DE;
import com.manageengine.dataengine.controller.connector.netcalls.XNodeTcpAdminNetCalls;
import com.manageengine.dataengine.controller.connector.netcalls.XNodeTcpDRNetCalls;
import com.manageengine.dataengine.controller.engine.node.DENode;
import com.manageengine.dataengine.controller.engine.node.XNodeSettings;
import com.manageengine.dataengine.controller.engine.node.winservice.WinServiceState;
import com.manageengine.dataengine.controller.engine.node.winservice.XNodeWinService;
import java.io.File;
import java.net.ConnectException;
import java.nio.file.Path;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.json.JSONArray;
import org.json.JSONObject;

public class XNode
implements DENode {
    private String nodeHost;
    private String location;
    private String serviceName;
    private boolean isLocal;
    private JSONObject stateAndNotifications;
    private ConnectorType connectorType;
    private int connectorPort;
    private XNodeTcpAdminNetCalls adminNetCalls;
    private XNodeTcpDRNetCalls drNetCalls;
    private XNodeWinService xnodeWinService;
    private XNodeSettings settings;
    private int index;
    private final ScheduledThreadPoolExecutor connectorScheduler;
    private long downTimeFrom;
    private String nodeErrMsg = null;
    private final Object confFileLock = new Object();
    private static final Logger LOGGER = Logger.getLogger("DataEngineLogger");

    private XNode(XNodeSettings settings, int index) {
        this.nodeHost = (String)settings.xnode_host.value();
        this.location = (String)settings.xnode_location.value();
        this.serviceName = (String)settings.xnode_service_name.value();
        this.connectorPort = (Integer)settings.xnode_connector_port.value();
        this.stateAndNotifications = new JSONObject().put("de_health", (Object)"RED").put("de_notifications", (Object)new JSONArray());
        this.settings = settings;
        this.isLocal = this.nodeHost.equalsIgnoreCase("localhost") || this.nodeHost.equalsIgnoreCase("local") || this.nodeHost.equalsIgnoreCase("127.0.0.1");
        this.xnodeWinService = new XNodeWinService(this);
        this.index = index;
        this.downTimeFrom = 0L;
        this.connectorScheduler = new ScheduledThreadPoolExecutor((int)((Integer)settings.xnode_connector_worker_count.value()), (ThreadFactory)new CommonThreadFactory("xnode-connector-worker-" + this.nodeHost));
        this.connectorScheduler.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.connectorScheduler.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        this.connectorScheduler.setRemoveOnCancelPolicy(true);
        if (!((String)settings.xnode_connector_type.value()).equalsIgnoreCase(ConnectorType.TCP.name())) {
            throw new IllegalArgumentException("EXCEPTION : XNode connector type '" + this.connectorType + "' not supported!");
        }
        this.connectorType = ConnectorType.TCP;
        this.adminNetCalls = new XNodeTcpAdminNetCalls(this);
        this.drNetCalls = new XNodeTcpDRNetCalls(this);
        this.logSettings();
    }

    @Override
    public String getNodeHost() {
        return this.nodeHost;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public boolean isLocal() {
        return this.isLocal;
    }

    @Override
    public ConnectorType getConnectorType() {
        return this.connectorType;
    }

    @Override
    public int getConnectorPort() {
        return this.connectorPort;
    }

    @Override
    public XNodeTcpAdminNetCalls admin() {
        return this.adminNetCalls;
    }

    @Override
    public XNodeTcpDRNetCalls DR() {
        return this.drNetCalls;
    }

    @Override
    public XNodeWinService getWinService() {
        return this.xnodeWinService;
    }

    public XNodeSettings getSettings() {
        return this.settings;
    }

    @Override
    public JSONObject getStateAndNotifications() {
        return this.stateAndNotifications;
    }

    @Override
    public JSONObject refreshStateAndNotifications() {
        this.syncCurrentXNodeStateAndNotification();
        return this.stateAndNotifications;
    }

    public void setStateAndNotifications(String newState, JSONArray notifications) {
        this.stateAndNotifications.remove("de_health");
        this.stateAndNotifications.put("de_health", (Object)newState);
        this.stateAndNotifications.remove("de_notifications");
        this.stateAndNotifications.put("de_notifications", (Object)notifications);
    }

    public boolean checkState(String state) {
        return this.stateAndNotifications.optString("de_health", "RED").equalsIgnoreCase(state);
    }

    @Override
    public void start() throws Exception {
        this.setStateAndNotifications("RED", new JSONArray());
        this.nodeErrMsg = null;
        try {
            LOGGER.log(Level.INFO, "DE XNode START :: STARTING DataEngine XNode @ {0}... ", this.getNodeHost());
            int portState = this.getXNodePortStatus();
            LOGGER.log(Level.INFO, "DE XNode START :: XNode port state : {0}", portState);
            if (this.isLocal()) {
                LOGGER.log(Level.INFO, "DE XNode START :: XNode location : local");
                if (portState == 0) {
                    LOGGER.log(Level.INFO, "DE XNode START :: XNode is not running! Going to start it...");
                    this.getWinService().start();
                    if (this.getWinService().getServiceState() == WinServiceState.RUNNING && this.retryAndCheckIfXNodeIsUp()) {
                        this.setStateAndNotifications("GREEN", new JSONArray());
                    }
                } else if (portState == 1) {
                    LOGGER.log(Level.INFO, "DE XNode START :: Unknown process is running in the XNode port {0}!!", this.getConnectorPort());
                    this.nodeErrMsg = "Unknown process is running in the XNode port " + this.getConnectorPort() + "!! Kindly stop it and restart the product.";
                } else if (portState == 2) {
                    LOGGER.log(Level.INFO, "DE XNode START :: Already XNode is running and is in expected state!");
                    this.getWinService().setServiceState(WinServiceState.RUNNING);
                    this.setStateAndNotifications("GREEN", new JSONArray());
                } else if (portState == 3 || portState == 4) {
                    LOGGER.log(Level.INFO, "DE XNode START :: Already XNode is running, but is not in expected state! Going to wait for expected state.");
                    if (this.retryAndCheckIfXNodeIsUp()) {
                        this.setStateAndNotifications("GREEN", new JSONArray());
                        this.getWinService().setServiceState(WinServiceState.RUNNING);
                    }
                } else {
                    LOGGER.log(Level.INFO, "DE XNode START :: Can't determine the state of the XNode port {0}", this.getConnectorPort());
                    this.nodeErrMsg = "Can't determine the state of the XNode port " + this.getConnectorPort();
                }
            } else {
                LOGGER.log(Level.INFO, "DE XNode START :: XNode location : remote");
                if (this.retryAndCheckIfXNodeIsUp()) {
                    this.getWinService().setServiceState(WinServiceState.RUNNING);
                    this.setStateAndNotifications("GREEN", new JSONArray());
                }
            }
            if (this.checkState("GREEN")) {
                LOGGER.log(Level.INFO, "DE XNode START :: Checking if XNode is compatible...");
                DE.admin().isNodeCompatible(this);
            }
            if ((this.checkState("RED") || this.checkState("ORANGE")) && this.nodeErrMsg == null) {
                this.nodeErrMsg = "DataEngine XNode @ " + this.getNodeHost() + " is not in expected state!!";
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "DEXNode.start() : {0}", e.getMessage());
            this.setStateAndNotifications("RED", new JSONArray());
            this.nodeErrMsg = "XNode.start() : " + e.getMessage();
            if (e.getMessage() != null && !e.getMessage().contains("COMPATIBILITY") && !WinServiceUtil.isWrapperRunningAsService((String)this.getWrapperConfFilePath(System.getProperty("product.home")))) {
                JOptionPane.showMessageDialog(null, "Unable to start DataEngine XNode \n" + this.nodeErrMsg, "Error", 0);
            }
            throw e;
        }
        if (!this.checkState("GREEN") && !WinServiceUtil.isWrapperRunningAsService((String)this.getWrapperConfFilePath(System.getProperty("product.home")))) {
            JOptionPane.showMessageDialog(null, "Unable to start DataEngine XNode \n" + this.nodeErrMsg, "Error", 0);
        }
        this.updateDownTime();
        LOGGER.log(Level.INFO, "DE XNode START :: STATE of DataEngine XNode at startup [Host : {0}] [ State : {1}] [ ServiceState : {2}]", new Object[]{this.getNodeHost(), this.getStateAndNotifications().optString("de_health", "RED"), this.getWinService().getServiceState()});
    }

    @Override
    public void stop() throws Exception {
        LOGGER.log(Level.INFO, "DE XNode STOP :: STOPPING DataEngine XNode @ {0}... ", this.getNodeHost());
        if (this.isLocal()) {
            this.getWinService().stop();
        }
        this.connectorScheduler.shutdownNow();
        LOGGER.log(Level.INFO, "DE XNode STOP :: STOPPED DataEngine XNode @ {0}!", this.getNodeHost());
    }

    @Override
    public long getDownTime() {
        return this.downTimeFrom == 0L ? 0L : System.currentTimeMillis() - this.downTimeFrom;
    }

    public ScheduledFuture schedule(Runnable task, long delay, TimeUnit unit) {
        return this.connectorScheduler.schedule(task, delay, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMigrateLegacyConfStatus(String status) throws Exception {
        Object object = this.confFileLock;
        synchronized (object) {
            PropertiesFileUtil.PropertiesFileHandle propFileHandler = PropertiesFileUtil.getPropertiesFileHandle((String)((Path)AdapEnvironment.DE_E_CONF_FILE.value()).toAbsolutePath().toString(), (boolean)false);
            propFileHandler.updateProperty(this.index + "." + "xnode.dr.migrate_legacy_conf_status", status);
            propFileHandler.saveFile();
            this.settings.xnode_dr_migrate_legacy_conf_status.set((Object)status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMigrateLegacyDataStatus(String status) throws Exception {
        Object object = this.confFileLock;
        synchronized (object) {
            PropertiesFileUtil.PropertiesFileHandle propFileHandler = PropertiesFileUtil.getPropertiesFileHandle((String)((Path)AdapEnvironment.DE_E_CONF_FILE.value()).toAbsolutePath().toString(), (boolean)false);
            propFileHandler.updateProperty(this.index + "." + "xnode.dr.migrate_legacy_data_status", status);
            propFileHandler.saveFile();
            this.settings.xnode_dr_migrate_legacy_data_status.set((Object)status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConnectorPassword(String password) throws Exception {
        Object object = this.confFileLock;
        synchronized (object) {
            PropertiesFileUtil.PropertiesFileHandle propFileHandler = PropertiesFileUtil.getPropertiesFileHandle((String)((Path)AdapEnvironment.DE_E_CONF_FILE.value()).toAbsolutePath().toString(), (boolean)false);
            propFileHandler.updateProperty(this.index + "." + "xnode.connector.password", password);
            propFileHandler.saveFile();
            this.settings.xnode_connector_password.set((Object)password);
        }
    }

    public static XNode build(PropertiesFileUtil.PropertiesFileHandle propFileHandler, int index) {
        XNodeSettings settings = new XNodeSettings();
        settings.xnode_host.set((Object)propFileHandler.getString(index + "." + "xnode.host", (String)settings.xnode_host.getDefaultValue()));
        settings.xnode_location.set((Object)propFileHandler.getString(index + "." + "xnode.location", (String)settings.xnode_location.getDefaultValue()));
        settings.xnode_service_name.set((Object)propFileHandler.getString(index + "." + "xnode.service_name", (String)settings.xnode_service_name.getDefaultValue()));
        settings.xnode_connector_type.set((Object)propFileHandler.getString(index + "." + "xnode.connector.type", (String)settings.xnode_connector_type.getDefaultValue()));
        settings.xnode_connector_port.set((Object)propFileHandler.getInt(index + "." + "xnode.connector.port", (Integer)settings.xnode_connector_port.getDefaultValue()));
        settings.xnode_connector_username.set((Object)propFileHandler.getString(index + "." + "xnode.connector.username", (String)settings.xnode_connector_username.getDefaultValue()));
        settings.xnode_connector_password.set((Object)propFileHandler.getString(index + "." + "xnode.connector.password", (String)settings.xnode_connector_password.getDefaultValue()));
        settings.xnode_connector_worker_count.set((Object)propFileHandler.getInt(index + "." + "xnode.connector.worker_count", (Integer)settings.xnode_connector_worker_count.getDefaultValue()));
        settings.xnode_connector_request_timeout.set((Object)propFileHandler.getInt(index + "." + "xnode.connector.request_timeout", (Integer)settings.xnode_connector_request_timeout.getDefaultValue()));
        settings.xnode_connector_authentication_timeout.set((Object)propFileHandler.getInt(index + "." + "xnode.connector.authentication_timeout", (Integer)settings.xnode_connector_authentication_timeout.getDefaultValue()));
        settings.xnode_connector_tcp_blocking_client.set((Object)propFileHandler.getBoolean(index + "." + "xnode.connector.tcp.blocking_client", (Boolean)settings.xnode_connector_tcp_blocking_client.getDefaultValue()));
        settings.xnode_connector_tcp_keep_alive.set((Object)propFileHandler.getBoolean(index + "." + "xnode.connector.tcp.keep_alive", (Boolean)settings.xnode_connector_tcp_keep_alive.getDefaultValue()));
        settings.xnode_connector_tcp_no_delay.set((Object)propFileHandler.getBoolean(index + "." + "xnode.connector.tcp.no_delay", (Boolean)settings.xnode_connector_tcp_no_delay.getDefaultValue()));
        settings.xnode_connector_tcp_reuse_address.set((Object)propFileHandler.getBoolean(index + "." + "xnode.connector.tcp.reuse_address", (Boolean)settings.xnode_connector_tcp_reuse_address.getDefaultValue()));
        settings.xnode_connector_tcp_netty_worker_count.set((Object)propFileHandler.getInt(index + "." + "xnode.connector.tcp.netty.worker_count", (Integer)settings.xnode_connector_tcp_netty_worker_count.getDefaultValue()));
        settings.xnode_connector_tcp_json_decode_size_mb.set((Object)propFileHandler.getInt(index + "." + "xnode.connector.tcp.json_decode_size_mb", (Integer)settings.xnode_connector_tcp_json_decode_size_mb.getDefaultValue()));
        settings.xnode_dr_sync_onstartup.set((Object)propFileHandler.getBoolean(index + "." + "xnode.dr.sync_on_startup", (Boolean)settings.xnode_dr_sync_onstartup.getDefaultValue()));
        settings.xnode_dr_migrate_legacy_conf_status.set((Object)propFileHandler.getString(index + "." + "xnode.dr.migrate_legacy_conf_status", (String)settings.xnode_dr_migrate_legacy_conf_status.getDefaultValue()));
        settings.xnode_dr_migrate_legacy_data_status.set((Object)propFileHandler.getString(index + "." + "xnode.dr.migrate_legacy_data_status", (String)settings.xnode_dr_migrate_legacy_data_status.getDefaultValue()));
        settings.xnode_dr_add_data_thread_count.set((Object)propFileHandler.getInt(index + "." + "xnode.dr.add_data_thread_count", (Integer)settings.xnode_dr_add_data_thread_count.getDefaultValue()));
        return new XNode(settings, index);
    }

    private int getXNodePortStatus() throws Exception {
        int portState = 5;
        try {
            String deHealth = this.admin().fetchNodeState();
            if (deHealth.equalsIgnoreCase("GREEN")) {
                portState = 2;
            } else if (deHealth.equalsIgnoreCase("ORANGE")) {
                portState = 3;
            } else if (deHealth.equalsIgnoreCase("RED")) {
                portState = 4;
            }
        }
        catch (Exception e) {
            if (e.getMessage().contains("listener timeout after waiting") || e.getMessage().contains("timed out after") || e.getMessage().contains("error while performing request") || e.getMessage().contains("existing connection was forcibly closed") || e.getMessage().contains("invalid JSON received")) {
                portState = 1;
            }
            if (e.getMessage().contains("Connection refused")) {
                portState = 0;
            }
            throw e;
        }
        return portState;
    }

    private void updateDownTime() {
        if (this.checkState("GREEN")) {
            this.downTimeFrom = 0L;
        } else if (this.downTimeFrom == 0L) {
            this.downTimeFrom = System.currentTimeMillis();
        }
    }

    private void syncCurrentXNodeStateAndNotification() {
        try {
            this.stateAndNotifications = this.admin().fetchNodeStateAndNotifications();
        }
        catch (Exception e) {
            this.stateAndNotifications = new JSONObject().put("de_health", (Object)"RED").put("de_notifications", (Object)new JSONArray());
            LOGGER.log(Level.SEVERE, "EXCEPTION while getting DataEngine XNode state @ {0} :: {1}", new Object[]{this.getNodeHost(), e.getMessage()});
            e.printStackTrace();
        }
        this.updateDownTime();
    }

    private boolean retryAndCheckIfXNodeIsUp() {
        boolean isStatusExpected = false;
        try {
            int maxRetryCount = 60;
            int retryCount = 0;
            do {
                try {
                    String deHealth = this.admin().fetchNodeState();
                    isStatusExpected = deHealth.equalsIgnoreCase("GREEN");
                    if (isStatusExpected) continue;
                    Thread.sleep(1000L);
                }
                catch (ConnectException ce) {
                    LOGGER.log(Level.WARNING, "CONNECT EXCEPTION while getting DataEngine XNode state, retrying again!");
                    Thread.sleep(1000L);
                }
            } while (++retryCount < maxRetryCount && !isStatusExpected);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "EXCEPTION while getting DataEngine XNode state @ {0} :: {1}", new Object[]{this.getNodeHost(), e.getMessage()});
            e.printStackTrace();
        }
        return isStatusExpected;
    }

    private String getWrapperConfFilePath(String homeDir) {
        if (homeDir == null) {
            homeDir = "..";
        }
        String wrapperConf = homeDir + File.separator + "conf" + File.separator + "wrapper.conf";
        return wrapperConf;
    }

    public void logSettings() {
        LOGGER.info(" ---------------------------------------------------------------------- ");
        LOGGER.info(" XNode '" + this.nodeHost + "' Settings :- ");
        LOGGER.info(" ---------------------------------------------------------------------- ");
        LOGGER.info(" # isLocal : " + this.isLocal);
        LOGGER.info(" # XNODE_HOST : " + (String)this.settings.xnode_host.value());
        LOGGER.info(" # XNODE_LOCATION : " + (String)this.settings.xnode_location.value());
        LOGGER.info(" # XNODE_SERVICE_NAME : " + (String)this.settings.xnode_service_name.value());
        LOGGER.info(" # XNODE_CONNECTOR_TYPE : " + (String)this.settings.xnode_connector_type.value());
        LOGGER.info(" # XNODE_CONNECTOR_PORT : " + this.settings.xnode_connector_port.value());
        LOGGER.info(" # XNODE_CONNECTOR_WORKER_COUNT : " + this.settings.xnode_connector_worker_count.value());
        LOGGER.info(" # XNODE_CONNECTOR_REQUEST_TIMEOUT : " + this.settings.xnode_connector_request_timeout.value());
        LOGGER.info(" # XNODE_CONNECTOR_AUTHENTICATION_TIMEOUT : " + this.settings.xnode_connector_authentication_timeout.value());
        LOGGER.info(" # XNODE_CONNECTOR_TCP_BLOCKING_CLIENT : " + this.settings.xnode_connector_tcp_blocking_client.value());
        LOGGER.info(" # XNODE_CONNECTOR_TCP_KEEP_ALIVE : " + this.settings.xnode_connector_tcp_keep_alive.value());
        LOGGER.info(" # XNODE_CONNECTOR_TCP_NO_DELAY : " + this.settings.xnode_connector_tcp_no_delay.value());
        LOGGER.info(" # XNODE_CONNECTOR_TCP_REUSE_ADDRESS : " + this.settings.xnode_connector_tcp_reuse_address.value());
        LOGGER.info(" # XNODE_CONNECTOR_TCP_NETTY_WORKER_COUNT : " + this.settings.xnode_connector_tcp_netty_worker_count.value());
        LOGGER.info(" # XNODE_CONNECTOR_TCP_JSON_DECODE_SIZE_MB : " + this.settings.xnode_connector_tcp_json_decode_size_mb.value());
        LOGGER.info(" # XNODE_DR_SYNC_ONSTARTUP : " + this.settings.xnode_dr_sync_onstartup.value());
        LOGGER.info(" # XNODE_DR_MIGRATE_LEGACY_CONF_STATUS : " + (String)this.settings.xnode_dr_migrate_legacy_conf_status.value());
        LOGGER.info(" # XNODE_DR_MIGRATE_LEGACY_DATA_STATUS : " + (String)this.settings.xnode_dr_migrate_legacy_data_status.value());
        LOGGER.info(" # XNODE_DR_ADD_DATA_THREAD_COUNT : " + this.settings.xnode_dr_add_data_thread_count.value());
        LOGGER.info(" ---------------------------------------------------------------------- ");
    }
}

