/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.controller.engine.node;

import com.manageengine.dataengine.commons.file.PropertiesFileUtil;
import com.manageengine.dataengine.controller.DE;
import com.manageengine.dataengine.controller.connector.netcalls.XNodeTcpAdminNetCalls;
import com.manageengine.dataengine.controller.connector.netcalls.XNodeTcpDRNetCalls;
import com.manageengine.dataengine.controller.engine.node.DENode;
import com.manageengine.dataengine.controller.engine.node.DENodes;
import com.manageengine.dataengine.controller.engine.node.XNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class XNodes
extends DENodes {
    private static final Logger LOGGER = Logger.getLogger("DataEngineLogger");
    private static volatile JSONObject xNodesStateAndNotifications = new JSONObject().put("de_health", (Object)"RED").put("de_notifications", (Object)new JSONArray());
    private static HashMap<String, XNode> xnodes;
    private static XNode localXNode;

    public XNodes() {
        xnodes = new HashMap();
    }

    @Override
    public JSONObject getStateAndNotifications() {
        return xNodesStateAndNotifications;
    }

    @Override
    public JSONObject refreshStateAndNotifications() {
        int upCount = 0;
        xNodesStateAndNotifications = new JSONObject().put("de_health", (Object)"RED").put("de_notifications", (Object)new JSONArray());
        JSONArray notifications = new JSONArray();
        JSONArray deDeletedBlocks = new JSONArray();
        for (XNode xnode : xnodes.values()) {
            JSONObject stateAndNotifications;
            if (!xnode.refreshStateAndNotifications().has("de_health") || !(stateAndNotifications = xnode.getStateAndNotifications()).getString("de_health").equals("GREEN")) continue;
            ++upCount;
            if (stateAndNotifications.has("de_notifications")) {
                JSONArray xnodeNotifications = stateAndNotifications.getJSONArray("de_notifications");
                for (int i = 0; i < xnodeNotifications.length(); ++i) {
                    notifications.put(xnodeNotifications.get(i));
                }
            }
            if (!stateAndNotifications.has("de_deleted_blocks")) continue;
            deDeletedBlocks = stateAndNotifications.getJSONArray("de_deleted_blocks");
        }
        if (xnodes.size() == upCount) {
            this.setStateAndNotification("GREEN", notifications, deDeletedBlocks);
        } else if (upCount == 0) {
            this.setStateAndNotification("RED", notifications, deDeletedBlocks);
        } else {
            this.setStateAndNotification("ORANGE", notifications, deDeletedBlocks);
        }
        return xNodesStateAndNotifications;
    }

    private void setStateAndNotification(String deState, JSONArray notifications, JSONArray deletedBlocks) {
        xNodesStateAndNotifications.remove("de_health");
        xNodesStateAndNotifications.put("de_health", (Object)deState);
        xNodesStateAndNotifications.remove("de_notifications");
        xNodesStateAndNotifications.put("de_notifications", (Object)notifications);
        xNodesStateAndNotifications.remove("de_deleted_blocks");
        xNodesStateAndNotifications.put("de_deleted_blocks", (Object)deletedBlocks);
    }

    @Override
    public void start() throws Exception {
        int upCount = 0;
        xNodesStateAndNotifications = new JSONObject().put("de_health", (Object)"RED").put("de_notifications", (Object)new JSONArray());
        for (XNode xnode : xnodes.values()) {
            xnode.start();
            if (!xnode.checkState("GREEN")) continue;
            ++upCount;
        }
        if (xnodes.size() == upCount) {
            this.setStateAndNotification("GREEN", new JSONArray(), new JSONArray());
        } else if (upCount == 0) {
            this.setStateAndNotification("RED", new JSONArray(), new JSONArray());
        } else {
            this.setStateAndNotification("ORANGE", new JSONArray(), new JSONArray());
        }
        String xNodesState = xNodesStateAndNotifications.optString("de_health", "RED");
        if (xNodesState.equals("GREEN") || xNodesState.equals("ORANGE")) {
            JSONArray drList = DE.DR().getDataRepositoriesAsJSON();
            JSONObject drSchemaList = DE.DR().getDRSchemasAsJSON();
            DE.DR().nodeActions().syncDRSchema(drSchemaList);
            DE.DR().nodeActions().syncDR(drList);
            DE.DR().migrateLegacyConf();
            DE.DR().migrateLegacyData();
        }
    }

    @Override
    public void stop() throws Exception {
        for (XNode xnode : xnodes.values()) {
            xnode.stop();
        }
    }

    @Override
    public void start(String host) throws Exception {
        this.node(host).start();
    }

    @Override
    public void stop(String host) throws Exception {
        this.node(host).stop();
    }

    @Override
    public XNodeTcpAdminNetCalls admin(String host) {
        return this.node(host).admin();
    }

    @Override
    public XNodeTcpDRNetCalls DR(String host) {
        return this.node(host).DR();
    }

    @Override
    public XNode node(String host) {
        XNode xnode = xnodes.get(host);
        if (xnode == null) {
            if (host.equalsIgnoreCase("localhost") || host.equalsIgnoreCase("local") || host.equalsIgnoreCase("127.0.0.1")) {
                xnode = localXNode;
            } else {
                throw new NoSuchElementException("EXCEPTION : XNode for " + host + " not found!");
            }
        }
        return xnode;
    }

    @Override
    public XNode localNode() {
        return localXNode;
    }

    @Override
    public ArrayList<DENode> nodes() {
        return new ArrayList<DENode>(xnodes.values());
    }

    @Override
    public void addNode(PropertiesFileUtil.PropertiesFileHandle propFileHandler, int index) {
        XNode xnode = XNode.build(propFileHandler, index);
        xnodes.put(xnode.getNodeHost(), xnode);
        if (xnode.isLocal()) {
            localXNode = xnode;
        }
    }

    static {
        localXNode = null;
    }
}

