/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.controller.engine.node.winservice;

import com.manageengine.dataengine.controller.engine.node.ElasticNode;
import com.manageengine.dataengine.controller.engine.node.winservice.DENodeWinService;
import com.manageengine.dataengine.controller.engine.node.winservice.WinServiceState;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ElasticNodeWinService
extends DENodeWinService {
    private ElasticNode elasticNode;
    private static final Logger LOGGER = Logger.getLogger("DataEngineLogger");
    private String esServiceErrMsg = "";
    private static final String ES_SERVICE_BAT = System.getProperty("server.home") + File.separator + "apps" + File.separator + "dataengine-elastic" + File.separator + "bin" + File.separator + "elasticsearch-service.bat";
    private static final String JAVA_HOME = new File(System.getProperty("server.home")).getAbsolutePath() + File.separator + "jre";

    public ElasticNodeWinService(ElasticNode elasticNode) {
        super(elasticNode.getNodeHost(), elasticNode.getServiceName(), elasticNode.isLocal());
        this.elasticNode = elasticNode;
    }

    @Override
    public void create() throws Exception {
        LOGGER.log(Level.INFO, "Creating ES Service... ");
    }

    @Override
    public void destroy() throws Exception {
        LOGGER.log(Level.INFO, "Destroying ES Service... ");
    }

    @Override
    public void start() throws Exception {
        try {
            LOGGER.log(Level.INFO, "Starting ES Service... ");
            if (!this.checkIfEsServiceInstalled()) {
                this.installESService();
            }
            this.startESService();
            if (!this.verifyEsClusterStatus()) {
                this.setServiceState(WinServiceState.ERROR);
                this.esServiceErrMsg = "ES Cluster not in expected state!!";
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "ES.start() : " + e.getMessage());
            this.setServiceState(WinServiceState.ERROR);
            this.esServiceErrMsg = "ES.start() : " + e.getMessage();
            throw e;
        }
        LOGGER.log(Level.INFO, " # DataEngine ELASTIC SERVICE(" + this.elasticNode.getServiceName() + ") State at startup : " + this.getServiceState().name());
    }

    @Override
    public void stop() throws Exception {
        LOGGER.log(Level.INFO, "Stopping ES Service... ");
        try {
            this.stopESService();
            LOGGER.log(Level.INFO, "ES Service stopped!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LOGGER.log(Level.INFO, " # DataEngine ELASTIC SERVICE(" + this.elasticNode.getServiceName() + ") State at shutdown : " + this.getServiceState().name());
    }

    private boolean verifyEsClusterStatus() {
        boolean isStatusExpected = false;
        int maxRetryCount = 60;
        int retryCount = 0;
        if (!isStatusExpected) {
            while (retryCount < maxRetryCount && !isStatusExpected) {
                try {
                    Thread.sleep(1000L);
                    isStatusExpected = this.elasticNode.admin().verifyNodeState("green");
                    ++retryCount;
                }
                catch (Exception e) {
                    LOGGER.severe("EXCEPTION while verifying ES cluster status retrying again!");
                }
            }
        }
        return isStatusExpected;
    }

    private void installESService() {
        try {
            String line;
            LOGGER.info("Installing ES Service...");
            String[] commandList = new String[]{ES_SERVICE_BAT, "install", this.elasticNode.getServiceName()};
            ProcessBuilder probuilder = new ProcessBuilder(commandList);
            probuilder.environment().put("JAVA_HOME", JAVA_HOME);
            probuilder.environment().put("SERVICE_DISPLAY_NAME", this.elasticNode.getServiceName());
            Process newProcess = probuilder.start();
            InputStreamReader isr = new InputStreamReader(newProcess.getInputStream());
            BufferedReader br = new BufferedReader(isr);
            LOGGER.info(" #----------------------------------------------");
            LOGGER.info(" # COMMAND : " + ES_SERVICE_BAT + " install " + this.elasticNode.getServiceName());
            this.setServiceState(WinServiceState.UNINSTALLED);
            while ((line = br.readLine()) != null) {
                LOGGER.info(" # " + line);
                if (!line.toLowerCase().contains("failed")) continue;
                boolean isServiceInstalled = this.checkIfEsServiceInstalled();
                if (isServiceInstalled) {
                    LOGGER.info("ES Service is already installed!");
                    this.setServiceState(WinServiceState.IDLE);
                    break;
                }
                this.esServiceErrMsg = "Error during installing ES service :: " + line;
                this.setServiceState(WinServiceState.ERROR);
                break;
            }
            LOGGER.info(" #----------------------------------------------");
            if (this.getServiceState() == WinServiceState.UNINSTALLED) {
                this.setServiceState(WinServiceState.IDLE);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.esServiceErrMsg = "Error during installing ES service :: " + e.getMessage();
            this.setServiceState(WinServiceState.ERROR);
        }
    }

    public void startESService() {
        try {
            String line;
            LOGGER.info("Starting ES Service...");
            String[] commandList = new String[]{ES_SERVICE_BAT, "start", this.elasticNode.getServiceName()};
            ProcessBuilder probuilder = new ProcessBuilder(commandList);
            probuilder.environment().put("JAVA_HOME", JAVA_HOME);
            Process newProcess = probuilder.start();
            InputStreamReader isr = new InputStreamReader(newProcess.getInputStream());
            BufferedReader br = new BufferedReader(isr);
            LOGGER.info(" #----------------------------------------------");
            LOGGER.info(" # COMMAND : " + ES_SERVICE_BAT + " start " + this.elasticNode.getServiceName());
            this.setServiceState(WinServiceState.IDLE);
            while ((line = br.readLine()) != null) {
                LOGGER.info(" # " + line);
                if (!line.toLowerCase().contains("failed")) continue;
                this.esServiceErrMsg = "Error during ES start :: " + line;
                this.setServiceState(WinServiceState.ERROR);
                break;
            }
            LOGGER.info(" #----------------------------------------------");
            if (this.getServiceState() == WinServiceState.IDLE) {
                this.setServiceState(WinServiceState.RUNNING);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.esServiceErrMsg = "Error during ES start :: " + e.getMessage();
            this.setServiceState(WinServiceState.ERROR);
        }
    }

    private void stopESService() {
        try {
            String line;
            LOGGER.info("Stopping ES Service...");
            String[] commandList = new String[]{ES_SERVICE_BAT, "stop", this.elasticNode.getServiceName()};
            ProcessBuilder probuilder = new ProcessBuilder(commandList);
            Process newProcess = probuilder.start();
            InputStreamReader isr = new InputStreamReader(newProcess.getInputStream());
            BufferedReader br = new BufferedReader(isr);
            LOGGER.info(" #----------------------------------------------");
            LOGGER.info(" # COMMAND : " + ES_SERVICE_BAT + " stop " + this.elasticNode.getServiceName());
            while ((line = br.readLine()) != null) {
                LOGGER.info(" # " + line);
                if (!line.toLowerCase().contains("failed")) continue;
                this.esServiceErrMsg = "Error during ES stop :: " + line;
                this.setServiceState(WinServiceState.ERROR);
                break;
            }
            LOGGER.info(" #----------------------------------------------");
            this.setServiceState(WinServiceState.IDLE);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.esServiceErrMsg = "Error during ES stop :: " + e.getMessage();
            this.setServiceState(WinServiceState.ERROR);
        }
    }

    private boolean checkIfEsServiceInstalled() {
        boolean isServiceInstalled = true;
        try {
            String line;
            LOGGER.info("Checking if ES service is installed...");
            String[] commandList = new String[]{"sc", "query", this.elasticNode.getServiceName()};
            ProcessBuilder probuilder = new ProcessBuilder(commandList);
            Process newProcess = probuilder.start();
            InputStreamReader isr = new InputStreamReader(newProcess.getInputStream());
            BufferedReader br = new BufferedReader(isr);
            LOGGER.info(" #----------------------------------------------");
            LOGGER.info(" # COMMAND : sc query " + this.elasticNode.getServiceName());
            while ((line = br.readLine()) != null) {
                LOGGER.info(" # " + line);
                if (!line.toLowerCase().contains("the specified service does not exist")) continue;
                isServiceInstalled = false;
                this.setServiceState(WinServiceState.UNINSTALLED);
            }
            LOGGER.info(" #----------------------------------------------");
        }
        catch (IOException e) {
            e.printStackTrace();
            isServiceInstalled = false;
        }
        return isServiceInstalled;
    }
}

