/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.controller.engine.node.winservice;

import com.manageengine.dataengine.commons.utils.ExecuteWinProcess;
import com.manageengine.dataengine.controller.DE;
import com.manageengine.dataengine.controller.engine.node.XNode;
import com.manageengine.dataengine.controller.engine.node.winservice.DENodeWinService;
import com.manageengine.dataengine.controller.engine.node.winservice.WinServiceState;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class XNodeWinService
extends DENodeWinService {
    private XNode node;
    private String startType;
    private static final String LOCAL_DE_XNODE_BAT = System.getProperty("server.home") + File.separator + "apps" + File.separator + "dataengine-xnode" + File.separator + "bin" + File.separator + "dataengine-xnode.bat";
    private static final String JAVA_HOME = System.getProperty("server.home") + File.separator + "jre";
    private static final Logger LOGGER = Logger.getLogger("DataEngineLogger");

    public XNodeWinService(XNode node) {
        super(node.getNodeHost(), node.getServiceName(), node.isLocal());
        this.node = node;
        this.startType = "service";
    }

    @Override
    public void create() throws Exception {
        LOGGER.log(Level.INFO, "CREATING DataEngine XNode Service @ " + this.getServiceHost() + "... ");
    }

    @Override
    public void destroy() throws Exception {
        LOGGER.log(Level.INFO, "DESTROYING DataEngine XNode Service @ " + this.getServiceHost() + "... ");
    }

    @Override
    public void start() throws Exception {
        LOGGER.log(Level.INFO, "DE XNode START :: STARTING DataEngine XNode Service @ {0}... ", this.getServiceHost());
        this.startLocalXNodeService();
        if (this.isLocal()) {
            if (this.getServiceState() == WinServiceState.UNINSTALLED) {
                this.installLocalXNodeService();
                if (this.getServiceState() == WinServiceState.ERROR) {
                    this.startLocalXNodeConsole();
                } else {
                    this.startLocalXNodeService();
                }
            }
            if (this.getServiceState() != WinServiceState.RUNNING) {
                this.setServiceState(WinServiceState.ERROR);
                this.setServiceErrMsg("DataEngine XNode @ " + this.getServiceHost() + " is not in expected state!!");
            }
        }
        LOGGER.log(Level.INFO, "DE XNode START :: Service STATE of XNode [Host : {0}] [StartUp Type : {1}] [ State : {2}]", new Object[]{this.getServiceHost(), this.startType, this.getServiceState().name()});
    }

    @Override
    public void stop() throws Exception {
        LOGGER.log(Level.INFO, "DE XNode STOP :: STOPPING DataEngine XNode Service @ {0}... ", this.getServiceHost());
        try {
            if (this.isLocal()) {
                this.stopXNodeProcess();
            }
        }
        catch (Exception e) {
            this.setServiceState(WinServiceState.ERROR);
            this.setServiceErrMsg("XNodeService.stop() : " + e.getMessage());
            e.printStackTrace();
        }
        LOGGER.log(Level.INFO, "DE XNode STOP :: STATE of DataEngine XNode at shutdown [Host : {0}] [StartUp Type : {1}] [ State : {2}]", new Object[]{this.getServiceHost(), this.startType, this.getServiceState().name()});
    }

    public String startType() {
        return this.startType;
    }

    private boolean checkIfLocalXNodeServiceInstalledSC() {
        boolean isServiceInstalled = true;
        try {
            String line;
            LOGGER.info("CHECKING if Local DataEngine XNode service is installed...");
            String[] commandList = new String[]{"sc", "query", this.getServiceName()};
            ProcessBuilder probuilder = new ProcessBuilder(commandList);
            Process newProcess = probuilder.start();
            InputStreamReader isr = new InputStreamReader(newProcess.getInputStream());
            BufferedReader br = new BufferedReader(isr);
            this.setServiceState(WinServiceState.IDLE);
            LOGGER.info(" #----------------------------------------------");
            LOGGER.info(" # COMMAND : sc query " + this.getServiceName());
            while ((line = br.readLine()) != null) {
                LOGGER.info(" # " + line);
                if (!line.toLowerCase().contains("the specified service does not exist")) continue;
                isServiceInstalled = false;
                this.setServiceState(WinServiceState.UNINSTALLED);
            }
            LOGGER.info(" #----------------------------------------------");
        }
        catch (IOException e) {
            this.setServiceState(WinServiceState.ERROR);
            e.printStackTrace();
            isServiceInstalled = false;
        }
        return isServiceInstalled;
    }

    public boolean checkIfLocalXNodeServiceInstalled() {
        boolean isServiceInstalled = false;
        try {
            LOGGER.info("CHECKING if Local DataEngine XNode service is installed...");
            String successMsg = this.getServiceName() + " Service is installed";
            String[] commandList = new String[]{LOCAL_DE_XNODE_BAT, "-q"};
            ExecuteWinProcess processHandle = new ExecuteWinProcess(commandList, null);
            processHandle.start();
            String[] inputStreamBuffer = processHandle.getInputStream().split("\n");
            String[] errorStreamBuffer = processHandle.getErrorStream().split("\n");
            LOGGER.info(" #----------------------------------------------");
            LOGGER.info(" # COMMAND : " + LOCAL_DE_XNODE_BAT + " -q");
            block2: for (int i = 0; i < 2; ++i) {
                String[] streamBuffer;
                LOGGER.info(" # " + (i == 0 ? "INPUT" : "ERROR") + " STREAM : ");
                LOGGER.info(" # --------------");
                for (String line : streamBuffer = i == 0 ? inputStreamBuffer : errorStreamBuffer) {
                    LOGGER.info(" # " + line);
                    if (!line.contains(successMsg)) continue;
                    this.setServiceState(WinServiceState.IDLE);
                    isServiceInstalled = true;
                    continue block2;
                }
            }
            LOGGER.info(" #----------------------------------------------");
        }
        catch (Exception e) {
            this.setServiceState(WinServiceState.ERROR);
            e.printStackTrace();
            isServiceInstalled = false;
        }
        return isServiceInstalled;
    }

    private void installLocalXNodeService() {
        try {
            LOGGER.info("INSTALLING Local DataEngine XNode Service...");
            String successMsg = this.getServiceName() + " service installed";
            String[] commandList = new String[]{LOCAL_DE_XNODE_BAT, "-i"};
            ExecuteWinProcess processHandle = new ExecuteWinProcess(commandList, null);
            processHandle.start();
            String[] inputStreamBuffer = processHandle.getInputStream().split("\n");
            String[] errorStreamBuffer = processHandle.getErrorStream().split("\n");
            LOGGER.info(" #----------------------------------------------");
            LOGGER.info(" # COMMAND : " + LOCAL_DE_XNODE_BAT + " -i");
            block2: for (int i = 0; i < 2; ++i) {
                String[] streamBuffer;
                LOGGER.info(" # " + (i == 0 ? "INPUT" : "ERROR") + " STREAM : ");
                LOGGER.info(" # --------------");
                for (String line : streamBuffer = i == 0 ? inputStreamBuffer : errorStreamBuffer) {
                    LOGGER.info(" # " + line);
                    if (!line.contains(successMsg)) continue;
                    this.setServiceState(WinServiceState.IDLE);
                    continue block2;
                }
            }
            LOGGER.info(" #----------------------------------------------");
            if (this.getServiceState() != WinServiceState.IDLE) {
                boolean isServiceInstalled = this.checkIfLocalXNodeServiceInstalled();
                if (isServiceInstalled) {
                    LOGGER.info("Local DataEngine XNode Service is already installed!");
                    this.setServiceState(WinServiceState.IDLE);
                } else {
                    this.setServiceErrMsg("EXCEPTION while installing Local DataEngine XNode service");
                    this.setServiceState(WinServiceState.ERROR);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setServiceErrMsg("EXCEPTION while installing Local DataEngine XNode service :: " + e.getMessage());
            this.setServiceState(WinServiceState.ERROR);
        }
    }

    private void uninstallLocalXNodeService() {
        try {
            LOGGER.info("UNINSTALLING Local DataEngine XNode Service...");
            String successMsg = this.getServiceName() + " service removed";
            String[] commandList = new String[]{LOCAL_DE_XNODE_BAT, "-r"};
            ExecuteWinProcess processHandle = new ExecuteWinProcess(commandList, null);
            processHandle.start();
            String[] inputStreamBuffer = processHandle.getInputStream().split("\n");
            String[] errorStreamBuffer = processHandle.getErrorStream().split("\n");
            LOGGER.info(" #----------------------------------------------");
            LOGGER.info(" # COMMAND : " + LOCAL_DE_XNODE_BAT + " -r");
            block2: for (int i = 0; i < 2; ++i) {
                String[] streamBuffer;
                LOGGER.info(" # " + (i == 0 ? "INPUT" : "ERROR") + " STREAM : ");
                LOGGER.info(" # --------------");
                for (String line : streamBuffer = i == 0 ? inputStreamBuffer : errorStreamBuffer) {
                    LOGGER.info(" # " + line);
                    if (!line.contains(successMsg)) continue;
                    this.setServiceState(WinServiceState.UNINSTALLED);
                    continue block2;
                }
            }
            LOGGER.info(" #----------------------------------------------");
            if (this.getServiceState() != WinServiceState.UNINSTALLED) {
                this.setServiceErrMsg("EXCEPTION while uninstalling Local DataEngine XNode service");
                this.setServiceState(WinServiceState.ERROR);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setServiceErrMsg("EXCEPTION while uninstalling Local DataEngine XNode service :: " + e.getMessage());
            this.setServiceState(WinServiceState.ERROR);
        }
    }

    public void startLocalXNodeService() {
        try {
            LOGGER.info("STARTING Local DataEngine XNode Service...");
            String successMsg = this.getServiceName() + " started";
            String alreadyRunningMsg = "service is already running";
            String notInstalledMsg = this.getServiceName() + " service is not installed";
            String[] commandList = new String[]{LOCAL_DE_XNODE_BAT, "-t"};
            ExecuteWinProcess processHandle = new ExecuteWinProcess(commandList, null);
            processHandle.start();
            String[] inputStreamBuffer = processHandle.getInputStream().split("\n");
            String[] errorStreamBuffer = processHandle.getErrorStream().split("\n");
            LOGGER.info(" #----------------------------------------------");
            LOGGER.info(" # COMMAND : " + LOCAL_DE_XNODE_BAT + " -t");
            block2: for (int i = 0; i < 2; ++i) {
                String[] streamBuffer;
                LOGGER.info(" # " + (i == 0 ? "INPUT" : "ERROR") + " STREAM : ");
                LOGGER.info(" # --------------");
                for (String line : streamBuffer = i == 0 ? inputStreamBuffer : errorStreamBuffer) {
                    LOGGER.info(" # " + line);
                    if (line.contains(successMsg) || line.contains(alreadyRunningMsg)) {
                        this.setServiceState(WinServiceState.RUNNING);
                        continue block2;
                    }
                    if (!line.contains(notInstalledMsg)) continue;
                    this.setServiceState(WinServiceState.UNINSTALLED);
                    continue block2;
                }
            }
            LOGGER.info(" #----------------------------------------------");
            if (this.getServiceState() != WinServiceState.RUNNING && this.getServiceState() != WinServiceState.UNINSTALLED) {
                this.setServiceErrMsg("EXCEPTION while starting Local DataEngine XNode service");
                this.setServiceState(WinServiceState.ERROR);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setServiceErrMsg("EXCEPTION while starting Local DataEngine XNode service :: " + e.getMessage());
            this.setServiceState(WinServiceState.ERROR);
        }
        LOGGER.info(" # STATE after start command : " + (Object)((Object)this.getServiceState()));
    }

    private void stopLocalXNodeService() {
        try {
            LOGGER.info("STOPPING Local DataEngine XNode Service...");
            String successMsg = this.getServiceName() + " stopped";
            String[] commandList = new String[]{LOCAL_DE_XNODE_BAT, "-p"};
            ExecuteWinProcess processHandle = new ExecuteWinProcess(commandList, null);
            processHandle.start();
            String[] inputStreamBuffer = processHandle.getInputStream().split("\n");
            String[] errorStreamBuffer = processHandle.getErrorStream().split("\n");
            LOGGER.info(" #----------------------------------------------");
            LOGGER.info(" # COMMAND : " + LOCAL_DE_XNODE_BAT + " -p");
            block2: for (int i = 0; i < 2; ++i) {
                String[] streamBuffer;
                LOGGER.info(" # " + (i == 0 ? "INPUT" : "ERROR") + " STREAM : ");
                LOGGER.info(" # --------------");
                for (String line : streamBuffer = i == 0 ? inputStreamBuffer : errorStreamBuffer) {
                    LOGGER.info(" # " + line);
                    if (!line.contains(successMsg)) continue;
                    this.setServiceState(WinServiceState.IDLE);
                    continue block2;
                }
            }
            LOGGER.info(" #----------------------------------------------");
            if (this.getServiceState() != WinServiceState.IDLE) {
                this.setServiceState(WinServiceState.ERROR);
                this.setServiceErrMsg("EXCEPTION while stopping Local DataEngine XNode service");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setServiceErrMsg("EXCEPTION while stopping Local DataEngine XNode service :: " + e.getMessage());
            this.setServiceState(WinServiceState.ERROR);
        }
    }

    private void startLocalXNodeConsole() {
        try {
            LOGGER.info("STARTING Local DataEngine XNode Console...");
            LOGGER.info(" #----------------------------------------------");
            LOGGER.info(" # COMMAND : " + LOCAL_DE_XNODE_BAT + " -c");
            Runtime.getRuntime().exec("cmd /c " + LOCAL_DE_XNODE_BAT + " -c");
            this.setServiceState(WinServiceState.RUNNING);
            this.startType = "console";
            LOGGER.info(" #----------------------------------------------");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setServiceErrMsg("EXCEPTION while starting Local DataEngine XNode console :: " + e.getMessage());
            this.setServiceState(WinServiceState.ERROR);
        }
        LOGGER.info(" # STATE after start command : " + (Object)((Object)this.getServiceState()));
    }

    private void stopXNodeProcess() {
        try {
            LOGGER.info("DE XNode STOP :: STOPPING DataEngine XNode Process...");
            DE.deNode(this.getServiceHost()).admin().shutdownNode();
            LOGGER.info("DE XNode STOP :: STOPPED DataEngine XNode Process!");
            this.setServiceState(WinServiceState.IDLE);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setServiceErrMsg("EXCEPTION while stopping DataEngine XNode process :: " + e.getMessage());
            this.setServiceState(WinServiceState.ERROR);
        }
    }
}

