/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.commons.concurrent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class CommonThreadFactory
implements ThreadFactory {
    private final String name;
    private final AtomicInteger integer = new AtomicInteger(1);
    private final List<Thread> threadList = Collections.synchronizedList(new ArrayList());

    public CommonThreadFactory(String name) {
        this.name = name;
    }

    @Override
    public Thread newThread(Runnable r) {
        if (this.integer.intValue() < 0 || this.integer.intValue() >= Integer.MAX_VALUE) {
            this.integer.set(1);
        }
        Thread thread = new Thread(r, this.name + "-" + this.integer.getAndIncrement());
        this.threadList.add(thread);
        return thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Thread> getRunningThreads() {
        ArrayList<Thread> runningThreads = new ArrayList<Thread>();
        List<Thread> list = this.threadList;
        synchronized (list) {
            for (Thread thread : this.threadList) {
                if (!thread.isAlive()) continue;
                runningThreads.add(thread);
            }
        }
        return runningThreads;
    }
}

