/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.commons.crypto;

import com.manageengine.dataengine.commons.crypto.EnDecrypt;
import com.manageengine.dataengine.commons.crypto.EnDecryptAES256Impl;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CryptoUtil {
    private static final Logger LOGGER = LogManager.getLogger((String)"XNode");
    private static EnDecrypt cryptInstance = null;

    public static void setEnDecryptInstance(EnDecrypt instance) throws Exception {
        if (null != cryptInstance) {
            LOGGER.error("Already crypt instance has been set and hence this [{0}] is ignored", (Object)instance);
            return;
        }
        cryptInstance = instance;
    }

    public static String encrypt(String plaintext) {
        if (null == plaintext || 0 == plaintext.trim().length()) {
            return plaintext;
        }
        if (cryptInstance == null) {
            LOGGER.warn("EnDecrypt instance has not been initialized. EnDeccryptInstance is [{0}]  ", (Object)cryptInstance);
            return plaintext;
        }
        try {
            return cryptInstance.encrypt(plaintext);
        }
        catch (Exception e) {
            LOGGER.warn("Encryption failed for " + plaintext);
            return plaintext;
        }
    }

    public static String encrypt(String plaintext, int algorithm) {
        if (null == plaintext || 0 == plaintext.trim().length()) {
            return plaintext;
        }
        if (algorithm == 2) {
            EnDecryptAES256Impl encryptor = new EnDecryptAES256Impl();
            return encryptor.encrypt(plaintext);
        }
        LOGGER.error("Specify an algorithm for encryption");
        return plaintext;
    }

    public static String decrypt(String cipherText) {
        if (null == cipherText || 0 == cipherText.trim().length()) {
            return cipherText;
        }
        if (cryptInstance == null) {
            LOGGER.warn("EnDecrypt instance has not been initialized. EnDecryptInstance is [{0}]  ", (Object)cryptInstance);
            return cipherText;
        }
        try {
            return cryptInstance.decrypt(cipherText);
        }
        catch (Exception e) {
            LOGGER.warn("Decryption failed for " + cipherText);
            return cipherText;
        }
    }

    public static String decrypt(String cipherText, int algorithm) {
        if (null == cipherText || 0 == cipherText.trim().length()) {
            return cipherText;
        }
        if (algorithm == 2) {
            EnDecryptAES256Impl decryptor = new EnDecryptAES256Impl();
            return decryptor.decrypt(cipherText);
        }
        LOGGER.error("Specify an algorithm for encryption");
        return cipherText;
    }

    private static boolean validateInputs(String[] args) {
        if (args[0].equalsIgnoreCase("-a") || args[0].equalsIgnoreCase("--algo")) {
            return !(!args[1].equalsIgnoreCase("des") && !args[1].equalsIgnoreCase("aes128") && !args[1].equalsIgnoreCase("aes256") && !args[1].equalsIgnoreCase("blowfish") || !args[2].equalsIgnoreCase("-v") && !args[2].equalsIgnoreCase("--values"));
        }
        return true;
    }

    public static void printUsage() {
        String format = "%-50s %-70s";
        System.console().writer().println(String.format(format, "encrypt.bat / encrypt.sh [options]", ""));
        System.console().writer().println(String.format(format, "Options::", ""));
        System.console().writer().println(String.format(format, "-a or --algo", "To specify the algorithm to be used for encryption. Available ones: des, aes128, aes256, blowfish"));
        System.console().writer().println(String.format(format, "-v or --values", "To specify one or more values separated by space to be encrypted"));
        System.console().writer().println(String.format(format, "If no options are specified, all the words, separated by space, following the script, will be considered as individual text to be encrypted using the DES algorithm", ""));
        System.console().writer().println(String.format(format, "Note: For using AES encryption with 256 bit key length, unlimited strength jce jars should be bundled with the jre used", ""));
    }

    public static void main(String[] args) {
        if (CryptoUtil.validateInputs(args)) {
            if (args[0].equalsIgnoreCase("-a") || args[0].equalsIgnoreCase("--algo")) {
                for (int i = 3; i < args.length; ++i) {
                    if (!args[1].equalsIgnoreCase("aes256")) continue;
                    String en = CryptoUtil.encrypt(args[i], 2);
                    String dn = CryptoUtil.decrypt(en, 2);
                    System.console().writer().println(dn + " (using AES encryption) = " + en);
                    System.console().writer().println(dn + " (using AES encryption) = " + dn);
                }
            } else if (args[0].equalsIgnoreCase("showUsage")) {
                CryptoUtil.printUsage();
            } else {
                for (String plainText : args) {
                    System.console().writer().println(plainText + "=" + CryptoUtil.encrypt(plainText, 0));
                }
            }
        } else {
            CryptoUtil.printUsage();
        }
    }
}

