/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.commons.crypto;

import com.manageengine.dataengine.commons.crypto.EnDecrypt;
import com.manageengine.dataengine.commons.crypto.EnDecryptUtil;
import java.nio.ByteBuffer;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EnDecryptAES256Impl
implements EnDecrypt {
    private static final Logger LOGGER = LogManager.getLogger((String)"XNode");
    private static final String KEY = "MLITE_ENCRYPT_DECRYPT";
    private static final String ENCODING = "UTF-8";

    @Override
    public String encrypt(String plainText) {
        try {
            SecureRandom random = new SecureRandom();
            byte[] bytes = new byte[20];
            random.nextBytes(bytes);
            SecretKeyFactory KeyFactory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            PBEKeySpec spec = new PBEKeySpec(KEY.toCharArray(), bytes, 65556, 256);
            SecretKey secretkey = KeyFactory.generateSecret(spec);
            SecretKeySpec skc = new SecretKeySpec(secretkey.getEncoded(), "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            byte[] iv = new byte[cipher.getBlockSize()];
            IvParameterSpec ivpa = new IvParameterSpec(iv);
            cipher.init(1, (Key)skc, ivpa);
            byte[] cleartext = plainText.getBytes(ENCODING);
            byte[] ciphertext = cipher.doFinal(cleartext);
            byte[] saltcipher = new byte[bytes.length + ciphertext.length];
            System.arraycopy(bytes, 0, saltcipher, 0, bytes.length);
            System.arraycopy(ciphertext, 0, saltcipher, bytes.length, ciphertext.length);
            String encryptedString = EnDecryptUtil.BASE16_ENCODE(saltcipher);
            return encryptedString;
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException nsa) {
            LOGGER.error("Key generation failed " + nsa.getMessage());
            throw new IllegalArgumentException(nsa.getMessage(), nsa);
        }
        catch (Exception e) {
            LOGGER.error("Encryption failed" + e.getMessage());
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public String decrypt(String cipherText) {
        try {
            byte[] saltBytes = new byte[20];
            ByteBuffer saltbuffer = ByteBuffer.wrap(EnDecryptUtil.BASE16_DECODE(cipherText));
            saltbuffer.get(saltBytes, 0, saltBytes.length);
            byte[] cipherbytes = new byte[saltbuffer.capacity() - saltBytes.length];
            saltbuffer.get(cipherbytes);
            SecretKeyFactory KeyFactory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            PBEKeySpec spec = new PBEKeySpec(KEY.toCharArray(), saltBytes, 65556, 256);
            SecretKey secretkey = KeyFactory.generateSecret(spec);
            SecretKeySpec skc = new SecretKeySpec(secretkey.getEncoded(), "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            byte[] iv = new byte[cipher.getBlockSize()];
            IvParameterSpec ivpa = new IvParameterSpec(iv);
            cipher.init(2, (Key)skc, ivpa);
            byte[] decryptbytes = cipher.doFinal(cipherbytes);
            String decryptedString = EnDecryptUtil.B2S(decryptbytes);
            return decryptedString;
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException nsa) {
            LOGGER.error("Key generation failed" + nsa.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("Decryption failed" + e.getMessage());
        }
        return cipherText;
    }
}

