/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.commons.datarepository;

import com.manageengine.dataengine.commons.datarepository.DRBlockRotationType;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.Hours;
import org.joda.time.Months;
import org.joda.time.ReadableInstant;
import org.joda.time.Weeks;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DRBlockUtil {
    private static final Logger LOGGER = LogManager.getLogger((String)"DataRepository");

    public static String getBlockName(long timestamp, String blockSuffixName, DRBlockRotationType blockRotationType) {
        String blockName = blockSuffixName;
        DateTime blockTime = new DateTime(timestamp * 1000L);
        if (blockRotationType.compareTo(DRBlockRotationType.TIME_HOUR) == 0 || blockRotationType.compareTo(DRBlockRotationType.TIME_DAY) == 0 || blockRotationType.compareTo(DRBlockRotationType.TIME_WEEK) == 0 || blockRotationType.compareTo(DRBlockRotationType.TIME_MONTH) == 0 || blockRotationType.compareTo(DRBlockRotationType.TIME_YEAR) == 0) {
            blockName = blockSuffixName + "_" + blockTime.toString(DateTimeFormat.forPattern((String)blockRotationType.getTimeFormat()));
        } else if (blockRotationType.compareTo(DRBlockRotationType.TIME_MONTH_3) == 0) {
            int fromTimeMon = blockTime.getMonthOfYear();
            blockTime = blockTime.minusMonths((fromTimeMon - 1) % 3);
            blockName = blockSuffixName + "_" + blockTime.toString(DateTimeFormat.forPattern((String)"yyyy.MM")) + "-" + blockTime.plusMonths(2).toString(DateTimeFormat.forPattern((String)"MM"));
        } else if (blockRotationType.compareTo(DRBlockRotationType.TIME_MONTH_6) == 0) {
            int fromTimeMon = blockTime.getMonthOfYear();
            blockTime = blockTime.minusMonths((fromTimeMon - 1) % 6);
            blockName = blockSuffixName + "_" + blockTime.toString(DateTimeFormat.forPattern((String)"yyyy.MM")) + "-" + blockTime.plusMonths(5).toString(DateTimeFormat.forPattern((String)"MM"));
        }
        return blockName;
    }

    public static ArrayList<String> getBlockList(long fromTimestamp, long toTimestamp, String blockSuffixName, DRBlockRotationType blockRotationType) {
        ArrayList<String> blockList;
        block8: {
            DateTime toTime;
            DateTime fromTime;
            block13: {
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                block7: {
                                    blockList = new ArrayList<String>();
                                    fromTime = new DateTime(fromTimestamp * 1000L);
                                    toTime = new DateTime(toTimestamp * 1000L);
                                    if (blockRotationType.compareTo(DRBlockRotationType.TIME_HOUR) != 0) break block7;
                                    DateTime iDate = fromTime;
                                    while (iDate.isBefore((ReadableInstant)toTime) || iDate.isEqual((ReadableInstant)toTime)) {
                                        blockList.add(blockSuffixName + "_" + iDate.toString(DateTimeFormat.forPattern((String)blockRotationType.getTimeFormat())));
                                        iDate = iDate.plusHours(1);
                                    }
                                    break block8;
                                }
                                if (blockRotationType.compareTo(DRBlockRotationType.TIME_DAY) != 0) break block9;
                                DateTime iDate = fromTime;
                                while (iDate.isBefore((ReadableInstant)toTime) || iDate.isEqual((ReadableInstant)toTime)) {
                                    blockList.add(blockSuffixName + "_" + iDate.toString(DateTimeFormat.forPattern((String)blockRotationType.getTimeFormat())));
                                    iDate = iDate.plusDays(1);
                                }
                                break block8;
                            }
                            if (blockRotationType.compareTo(DRBlockRotationType.TIME_WEEK) != 0) break block10;
                            DateTime iDate = fromTime;
                            while (iDate.isBefore((ReadableInstant)toTime) || iDate.isEqual((ReadableInstant)toTime)) {
                                blockList.add(blockSuffixName + "_" + iDate.toString(DateTimeFormat.forPattern((String)blockRotationType.getTimeFormat())));
                                iDate = iDate.plusWeeks(1);
                            }
                            break block8;
                        }
                        if (blockRotationType.compareTo(DRBlockRotationType.TIME_MONTH) != 0) break block11;
                        DateTime iDate = fromTime;
                        while (iDate.isBefore((ReadableInstant)toTime) || iDate.isEqual((ReadableInstant)toTime)) {
                            blockList.add(blockSuffixName + "_" + iDate.toString(DateTimeFormat.forPattern((String)blockRotationType.getTimeFormat())));
                            iDate = iDate.plusMonths(1);
                        }
                        break block8;
                    }
                    if (blockRotationType.compareTo(DRBlockRotationType.TIME_MONTH_3) != 0) break block12;
                    int fromTimeMon = fromTime.getMonthOfYear();
                    DateTime iDate = fromTime = fromTime.minusMonths((fromTimeMon - 1) % 3);
                    while (iDate.isBefore((ReadableInstant)toTime) || iDate.isEqual((ReadableInstant)toTime)) {
                        blockList.add(blockSuffixName + "_" + iDate.toString(DateTimeFormat.forPattern((String)"yyyy.MM")) + "-" + iDate.plusMonths(2).toString(DateTimeFormat.forPattern((String)"MM")));
                        iDate = iDate.plusMonths(3);
                    }
                    break block8;
                }
                if (blockRotationType.compareTo(DRBlockRotationType.TIME_MONTH_6) != 0) break block13;
                int fromTimeMon = fromTime.getMonthOfYear();
                DateTime iDate = fromTime = fromTime.minusMonths((fromTimeMon - 1) % 6);
                while (iDate.isBefore((ReadableInstant)toTime) || iDate.isEqual((ReadableInstant)toTime)) {
                    blockList.add(blockSuffixName + "_" + iDate.toString(DateTimeFormat.forPattern((String)"yyyy.MM")) + "-" + iDate.plusMonths(5).toString(DateTimeFormat.forPattern((String)"MM")));
                    iDate = iDate.plusMonths(6);
                }
                break block8;
            }
            if (blockRotationType.compareTo(DRBlockRotationType.TIME_YEAR) != 0) break block8;
            DateTime iDate = fromTime;
            while (iDate.isBefore((ReadableInstant)toTime) || iDate.isEqual((ReadableInstant)toTime)) {
                blockList.add(blockSuffixName + "_" + iDate.toString(DateTimeFormat.forPattern((String)blockRotationType.getTimeFormat())));
                iDate = iDate.plusYears(1);
            }
        }
        return blockList;
    }

    public static boolean canArchiveBlock(String blockName, int retentionCount, DRBlockRotationType blockRotationType) {
        boolean canArchive = false;
        String blockTimeFormat = blockRotationType.getTimeFormat();
        String blockTimeStr = blockName.substring(blockName.lastIndexOf(95) + 1, blockName.length());
        DateTime nowDate = DateTime.now();
        if (blockRotationType.compareTo(DRBlockRotationType.TIME_HOUR) == 0) {
            DateTime blockDate = DateTime.parse((String)blockTimeStr, (DateTimeFormatter)DateTimeFormat.forPattern((String)blockTimeFormat));
            int hourDiff = Hours.hoursBetween((ReadableInstant)blockDate, (ReadableInstant)nowDate).getHours();
            LOGGER.info("ARCH :: Index Name : " + blockName + " | Retention Hours : " + retentionCount + " | Index Elapsed Hours : " + hourDiff);
            canArchive = hourDiff >= retentionCount;
        } else if (blockRotationType.compareTo(DRBlockRotationType.TIME_DAY) == 0) {
            DateTime blockDate = DateTime.parse((String)blockTimeStr, (DateTimeFormatter)DateTimeFormat.forPattern((String)blockTimeFormat));
            int dayDiff = Days.daysBetween((ReadableInstant)blockDate, (ReadableInstant)nowDate).getDays();
            LOGGER.info("ARCH :: Index Name : " + blockName + " | Retention Days : " + retentionCount + " | Index Elapsed Days : " + dayDiff);
            canArchive = dayDiff >= retentionCount;
        } else if (blockRotationType.compareTo(DRBlockRotationType.TIME_WEEK) == 0) {
            DateTime blockDate = DateTime.parse((String)blockTimeStr, (DateTimeFormatter)DateTimeFormat.forPattern((String)blockTimeFormat));
            int weekDiff = Weeks.weeksBetween((ReadableInstant)blockDate, (ReadableInstant)nowDate).getWeeks();
            LOGGER.info("ARCH :: Index Name : " + blockName + " | Retention Weeks : " + retentionCount + " | Index Elapsed Weeks : " + weekDiff);
            canArchive = weekDiff >= retentionCount;
        } else if (blockRotationType.compareTo(DRBlockRotationType.TIME_MONTH) == 0) {
            DateTime blockDate = DateTime.parse((String)blockTimeStr, (DateTimeFormatter)DateTimeFormat.forPattern((String)blockTimeFormat));
            int monDiff = Months.monthsBetween((ReadableInstant)blockDate, (ReadableInstant)nowDate).getMonths();
            LOGGER.info("ARCH :: Index Name : " + blockName + " | Retention Months : " + retentionCount + " | Index Elapsed Months : " + monDiff);
            canArchive = monDiff >= retentionCount;
        } else if (blockRotationType.compareTo(DRBlockRotationType.TIME_MONTH_3) == 0) {
            blockTimeStr = blockTimeStr.substring(0, blockTimeStr.indexOf(45));
            DateTime blockDate = DateTime.parse((String)blockTimeStr, (DateTimeFormatter)DateTimeFormat.forPattern((String)"yyyy.MM"));
            int monDiff = Months.monthsBetween((ReadableInstant)blockDate, (ReadableInstant)nowDate).getMonths();
            LOGGER.info("ARCH :: Index Name : " + blockName + " | Retention Months(*3) : " + retentionCount + " | Index Elapsed Months(*3) : " + (monDiff /= 3));
            canArchive = monDiff >= retentionCount;
        } else if (blockRotationType.compareTo(DRBlockRotationType.TIME_MONTH_6) == 0) {
            blockTimeStr = blockTimeStr.substring(0, blockTimeStr.indexOf(45));
            DateTime blockDate = DateTime.parse((String)blockTimeStr, (DateTimeFormatter)DateTimeFormat.forPattern((String)"yyyy.MM"));
            int monDiff = Months.monthsBetween((ReadableInstant)blockDate, (ReadableInstant)nowDate).getMonths();
            LOGGER.info("ARCH :: Index Name : " + blockName + " | Retention Months(*6) : " + retentionCount + " | Index Elapsed Months(*6) : " + (monDiff /= 6));
            canArchive = monDiff >= retentionCount;
        } else if (blockRotationType.compareTo(DRBlockRotationType.TIME_YEAR) == 0) {
            DateTime blockDate = DateTime.parse((String)blockTimeStr, (DateTimeFormatter)DateTimeFormat.forPattern((String)blockTimeFormat));
            int yearDiff = nowDate.getYear() - blockDate.getYear();
            LOGGER.info("ARCH :: Index Name : " + blockName + " | Retention Years : " + retentionCount + " | Index Elapsed Years : " + yearDiff);
            canArchive = yearDiff >= retentionCount;
        }
        return canArchive;
    }
}

