/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.commons.datarepository;

import com.manageengine.dataengine.commons.lucene.LuceneAnalyzer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FloatPoint;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.search.TermInSetQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;

public enum DRFieldDataType {
    BOOLEAN("boolean", false, false, false){

        @Override
        public Number parse(Object value) {
            return null;
        }

        @Override
        public Query termQuery(String field, Object value) {
            return null;
        }

        @Override
        public Query termsQuery(String field, List<Object> values) {
            return null;
        }

        @Override
        public Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper) {
            return null;
        }

        @Override
        public List<Field> createFields(String name, Object value, boolean indexed, boolean docValued, boolean stored, String analyzer) {
            return null;
        }

        @Override
        public SortField sortField(String name, boolean reverse) {
            return null;
        }
    }
    ,
    BYTE("byte", true, false, false){

        @Override
        public Byte parse(Object value) {
            if (value instanceof Number) {
                double doubleValue = ((Number)value).doubleValue();
                if (doubleValue < -128.0 || doubleValue > 127.0) {
                    throw new IllegalArgumentException("Value [" + value + "] is out of range for a byte");
                }
                if (doubleValue % 1.0 != 0.0) {
                    throw new IllegalArgumentException("Value [" + value + "] has a decimal part");
                }
                return ((Number)value).byteValue();
            }
            if (value instanceof BytesRef) {
                value = ((BytesRef)value).utf8ToString();
            }
            return Byte.parseByte(value.toString());
        }

        @Override
        public Query termQuery(String field, Object value) {
            return INTEGER.termQuery(field, value);
        }

        @Override
        public Query termsQuery(String field, List<Object> values) {
            return INTEGER.termsQuery(field, values);
        }

        @Override
        public Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper) {
            return INTEGER.rangeQuery(field, lowerTerm, upperTerm, includeLower, includeUpper);
        }

        @Override
        public List<Field> createFields(String name, Object value, boolean indexed, boolean docValued, boolean stored, String analyzer) {
            return INTEGER.createFields(name, value, indexed, docValued, stored, analyzer);
        }

        @Override
        public SortField sortField(String name, boolean reverse) {
            return INTEGER.sortField(name, reverse);
        }
    }
    ,
    INTEGER("integer", true, false, false){

        @Override
        public Integer parse(Object value) {
            if (value instanceof Number) {
                double doubleValue = ((Number)value).doubleValue();
                if (doubleValue < -2.147483648E9 || doubleValue > 2.147483647E9) {
                    throw new IllegalArgumentException("Value [" + value + "] is out of range for an integer");
                }
                if (doubleValue % 1.0 != 0.0) {
                    throw new IllegalArgumentException("Value [" + value + "] has a decimal part");
                }
                return ((Number)value).intValue();
            }
            if (value instanceof BytesRef) {
                value = ((BytesRef)value).utf8ToString();
            }
            return Integer.parseInt(value.toString());
        }

        @Override
        public Query termQuery(String field, Object value) {
            try {
                if (this.hasDecimalPart(value)) {
                    return new MatchNoDocsQuery("Value [" + value + "] has a decimal part");
                }
                int v = this.parse(value);
                return IntPoint.newExactQuery((String)field, (int)v);
            }
            catch (NumberFormatException e) {
                return new MatchNoDocsQuery("Value [" + value + "] is not an integer!");
            }
        }

        @Override
        public Query termsQuery(String field, List<Object> values) {
            try {
                int[] v = new int[values.size()];
                int upTo = 0;
                for (int i = 0; i < values.size(); ++i) {
                    Object value = values.get(i);
                    if (this.hasDecimalPart(value)) continue;
                    v[upTo++] = this.parse(value);
                }
                if (upTo == 0) {
                    return new MatchNoDocsQuery("All values have a decimal part");
                }
                if (upTo != v.length) {
                    v = Arrays.copyOf(v, upTo);
                }
                return IntPoint.newSetQuery((String)field, (int[])v);
            }
            catch (NumberFormatException e) {
                return new MatchNoDocsQuery("Values [" + values + "] has a non-integer value!");
            }
        }

        @Override
        public Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper) {
            try {
                int l = Integer.MIN_VALUE;
                int u = Integer.MAX_VALUE;
                if (lowerTerm != null) {
                    l = this.parse(lowerTerm);
                    boolean lowerTermHasDecimalPart = this.hasDecimalPart(lowerTerm);
                    if (!lowerTermHasDecimalPart && !includeLower || lowerTermHasDecimalPart && this.signum(lowerTerm) > 0.0) {
                        if (l == Integer.MAX_VALUE) {
                            return new MatchNoDocsQuery();
                        }
                        ++l;
                    }
                }
                if (upperTerm != null) {
                    u = this.parse(upperTerm);
                    boolean upperTermHasDecimalPart = this.hasDecimalPart(upperTerm);
                    if (!upperTermHasDecimalPart && !includeUpper || upperTermHasDecimalPart && this.signum(upperTerm) < 0.0) {
                        if (u == Integer.MIN_VALUE) {
                            return new MatchNoDocsQuery();
                        }
                        --u;
                    }
                }
                return IntPoint.newRangeQuery((String)field, (int)l, (int)u);
            }
            catch (NumberFormatException e) {
                return new MatchNoDocsQuery("Values [" + lowerTerm + " or " + upperTerm + "] are not integer datatype!");
            }
        }

        @Override
        public List<Field> createFields(String name, Object value, boolean indexed, boolean docValued, boolean stored, String analyzer) {
            ArrayList<Field> fields = new ArrayList<Field>();
            if (indexed) {
                fields.add((Field)new IntPoint(name, new int[]{this.parse(value)}));
            }
            if (docValued) {
                fields.add((Field)new SortedNumericDocValuesField(name, (long)this.parse(value).intValue()));
            }
            if (stored) {
                fields.add((Field)new StoredField(name, this.parse(value).intValue()));
            }
            return fields;
        }

        @Override
        public SortField sortField(String name, boolean reverse) {
            return new SortedNumericSortField(name, SortField.Type.INT, reverse);
        }
    }
    ,
    LONG("long", true, false, false){

        @Override
        public Long parse(Object value) {
            if (value instanceof Number) {
                double doubleValue = ((Number)value).doubleValue();
                if (doubleValue < -9.223372036854776E18 || doubleValue > 9.223372036854776E18) {
                    throw new IllegalArgumentException("Value [" + value + "] is out of range for a long");
                }
                if (doubleValue % 1.0 != 0.0) {
                    throw new IllegalArgumentException("Value [" + value + "] has a decimal part");
                }
                return ((Number)value).longValue();
            }
            if (value instanceof BytesRef) {
                value = ((BytesRef)value).utf8ToString();
            }
            return Long.parseLong(value.toString());
        }

        @Override
        public Query termQuery(String field, Object value) {
            try {
                if (this.hasDecimalPart(value)) {
                    return new MatchNoDocsQuery("Value [" + value + "] has a decimal part");
                }
                long v = this.parse(value);
                return LongPoint.newExactQuery((String)field, (long)v);
            }
            catch (NumberFormatException e) {
                return new MatchNoDocsQuery("Value [" + value + "] is not a long datatype!");
            }
        }

        @Override
        public Query termsQuery(String field, List<Object> values) {
            try {
                long[] v = new long[values.size()];
                int upTo = 0;
                for (int i = 0; i < values.size(); ++i) {
                    Object value = values.get(i);
                    if (this.hasDecimalPart(value)) continue;
                    v[upTo++] = this.parse(value);
                }
                if (upTo == 0) {
                    return new MatchNoDocsQuery("All values have a decimal part");
                }
                if (upTo != v.length) {
                    v = Arrays.copyOf(v, upTo);
                }
                return LongPoint.newSetQuery((String)field, (long[])v);
            }
            catch (NumberFormatException e) {
                return new MatchNoDocsQuery("Values [" + values + "] has a non-long value!");
            }
        }

        @Override
        public Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper) {
            try {
                long l = Long.MIN_VALUE;
                long u = Long.MAX_VALUE;
                if (lowerTerm != null) {
                    l = this.parse(lowerTerm);
                    boolean lowerTermHasDecimalPart = this.hasDecimalPart(lowerTerm);
                    if (!lowerTermHasDecimalPart && !includeLower || lowerTermHasDecimalPart && this.signum(lowerTerm) > 0.0) {
                        if (l == Long.MAX_VALUE) {
                            return new MatchNoDocsQuery();
                        }
                        ++l;
                    }
                }
                if (upperTerm != null) {
                    u = this.parse(upperTerm);
                    boolean upperTermHasDecimalPart = this.hasDecimalPart(upperTerm);
                    if (!upperTermHasDecimalPart && !includeUpper || upperTermHasDecimalPart && this.signum(upperTerm) < 0.0) {
                        if (u == Long.MIN_VALUE) {
                            return new MatchNoDocsQuery();
                        }
                        --u;
                    }
                }
                return LongPoint.newRangeQuery((String)field, (long)l, (long)u);
            }
            catch (NumberFormatException e) {
                return new MatchNoDocsQuery("Values [" + lowerTerm + " or " + upperTerm + "] are not long datatype!");
            }
        }

        @Override
        public List<Field> createFields(String name, Object value, boolean indexed, boolean docValued, boolean stored, String analyzer) {
            ArrayList<Field> fields = new ArrayList<Field>();
            if (indexed) {
                fields.add((Field)new LongPoint(name, new long[]{this.parse(value)}));
            }
            if (docValued) {
                fields.add((Field)new SortedNumericDocValuesField(name, this.parse(value).longValue()));
            }
            if (stored) {
                fields.add((Field)new StoredField(name, this.parse(value).longValue()));
            }
            return fields;
        }

        @Override
        public SortField sortField(String name, boolean reverse) {
            return new SortedNumericSortField(name, SortField.Type.LONG, reverse);
        }
    }
    ,
    FLOAT("float", true, true, false){

        @Override
        public Float parse(Object value) {
            if (value instanceof Number) {
                return Float.valueOf(((Number)value).floatValue());
            }
            if (value instanceof BytesRef) {
                value = ((BytesRef)value).utf8ToString();
            }
            return Float.valueOf(Float.parseFloat(value.toString()));
        }

        @Override
        public Query termQuery(String field, Object value) {
            try {
                float v = this.parse(value).floatValue();
                return FloatPoint.newExactQuery((String)field, (float)v);
            }
            catch (NumberFormatException e) {
                return new MatchNoDocsQuery("Value [" + value + "] is not a float datatype!");
            }
        }

        @Override
        public Query termsQuery(String field, List<Object> values) {
            try {
                float[] v = new float[values.size()];
                for (int i = 0; i < values.size(); ++i) {
                    v[i] = this.parse(values.get(i)).floatValue();
                }
                return FloatPoint.newSetQuery((String)field, (float[])v);
            }
            catch (NumberFormatException e) {
                return new MatchNoDocsQuery("Values [" + values + "] has a non-float value!");
            }
        }

        @Override
        public Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper) {
            try {
                float l = Float.NEGATIVE_INFINITY;
                float u = Float.POSITIVE_INFINITY;
                if (lowerTerm != null) {
                    l = this.parse(lowerTerm).floatValue();
                    if (!includeLower) {
                        l = FloatPoint.nextUp((float)l);
                    }
                }
                if (upperTerm != null) {
                    u = this.parse(upperTerm).floatValue();
                    if (!includeUpper) {
                        u = FloatPoint.nextDown((float)u);
                    }
                }
                return FloatPoint.newRangeQuery((String)field, (float)l, (float)u);
            }
            catch (NumberFormatException e) {
                return new MatchNoDocsQuery("Values [" + lowerTerm + " or " + upperTerm + "] are not float datatype!");
            }
        }

        @Override
        public List<Field> createFields(String name, Object value, boolean indexed, boolean docValued, boolean stored, String analyzer) {
            ArrayList<Field> fields = new ArrayList<Field>();
            if (indexed) {
                fields.add((Field)new FloatPoint(name, new float[]{this.parse(value).floatValue()}));
            }
            if (docValued) {
                fields.add((Field)new SortedNumericDocValuesField(name, (long)NumericUtils.floatToSortableInt((float)this.parse(value).floatValue())));
            }
            if (stored) {
                fields.add((Field)new StoredField(name, this.parse(value).floatValue()));
            }
            return fields;
        }

        @Override
        public SortField sortField(String name, boolean reverse) {
            return new SortedNumericSortField(name, SortField.Type.FLOAT, reverse);
        }
    }
    ,
    DOUBLE("double", true, true, false){

        @Override
        public Double parse(Object value) {
            if (value instanceof Number) {
                return ((Number)value).doubleValue();
            }
            if (value instanceof BytesRef) {
                value = ((BytesRef)value).utf8ToString();
            }
            return Double.parseDouble(value.toString());
        }

        @Override
        public Query termQuery(String field, Object value) {
            try {
                double v = this.parse(value);
                return DoublePoint.newExactQuery((String)field, (double)v);
            }
            catch (NumberFormatException e) {
                return new MatchNoDocsQuery("Value [" + value + "] is not a double!");
            }
        }

        @Override
        public Query termsQuery(String field, List<Object> values) {
            try {
                double[] v = new double[values.size()];
                for (int i = 0; i < values.size(); ++i) {
                    v[i] = this.parse(values.get(i));
                }
                return DoublePoint.newSetQuery((String)field, (double[])v);
            }
            catch (NumberFormatException e) {
                return new MatchNoDocsQuery("Values [" + values + "] has a non-double value!");
            }
        }

        @Override
        public Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper) {
            try {
                double l = Double.NEGATIVE_INFINITY;
                double u = Double.POSITIVE_INFINITY;
                if (lowerTerm != null) {
                    l = this.parse(lowerTerm);
                    if (!includeLower) {
                        l = DoublePoint.nextUp((double)l);
                    }
                }
                if (upperTerm != null) {
                    u = this.parse(upperTerm);
                    if (!includeUpper) {
                        u = DoublePoint.nextDown((double)u);
                    }
                }
                return DoublePoint.newRangeQuery((String)field, (double)l, (double)u);
            }
            catch (NumberFormatException e) {
                return new MatchNoDocsQuery("Values [" + lowerTerm + " or " + upperTerm + "] are not double datatype!");
            }
        }

        @Override
        public List<Field> createFields(String name, Object value, boolean indexed, boolean docValued, boolean stored, String analyzer) {
            ArrayList<Field> fields = new ArrayList<Field>();
            if (indexed) {
                fields.add((Field)new DoublePoint(name, new double[]{this.parse(value)}));
            }
            if (docValued) {
                fields.add((Field)new SortedNumericDocValuesField(name, NumericUtils.doubleToSortableLong((double)this.parse(value))));
            }
            if (stored) {
                fields.add((Field)new StoredField(name, this.parse(value).doubleValue()));
            }
            return fields;
        }

        @Override
        public SortField sortField(String name, boolean reverse) {
            return new SortedNumericSortField(name, SortField.Type.DOUBLE, reverse);
        }
    }
    ,
    KEYWORD("keyword", false, false, false){

        @Override
        public Number parse(Object value) {
            return null;
        }

        @Override
        public Query termQuery(String field, Object value) {
            return new TermQuery(new Term(field, this.indexedValueForSearch(field, (String)value)));
        }

        @Override
        public Query termsQuery(String field, List<Object> values) {
            BytesRef[] bytesRefs = new BytesRef[values.size()];
            for (int i = 0; i < bytesRefs.length; ++i) {
                bytesRefs[i] = this.indexedValueForSearch(field, values.get(i));
            }
            return new TermInSetQuery(field, bytesRefs);
        }

        @Override
        public Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper) {
            return new TermRangeQuery(field, lowerTerm == null ? null : this.indexedValueForSearch(field, lowerTerm), upperTerm == null ? null : this.indexedValueForSearch(field, upperTerm), includeLower, includeUpper);
        }

        @Override
        protected BytesRef indexedValueForSearch(String fieldName, Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof BytesRef) {
                value = ((BytesRef)value).utf8ToString();
            }
            try {
                return LuceneAnalyzer.KEYWORD_LOWERCASE.analyzer().normalize(fieldName, value.toString());
            }
            catch (IOException e) {
                return new KeywordAnalyzer().normalize(fieldName, value.toString());
            }
        }

        @Override
        public List<Field> createFields(String name, Object value, boolean indexed, boolean docValued, boolean stored, String analyzer) {
            ArrayList<Field> fields = new ArrayList<Field>();
            if (indexed) {
                fields.add((Field)new StringField(name, (String)value, stored ? Field.Store.YES : Field.Store.NO));
            }
            if (docValued) {
                if (analyzer != null && analyzer.contains("LOWERCASE")) {
                    fields.add((Field)new SortedDocValuesField(name, new BytesRef(value == null ? null : ((String)value).toLowerCase())));
                } else {
                    fields.add((Field)new SortedDocValuesField(name, new BytesRef((CharSequence)((String)value))));
                }
            }
            return fields;
        }

        @Override
        public SortField sortField(String name, boolean reverse) {
            return new SortField(name, SortField.Type.STRING, reverse);
        }
    }
    ,
    TEXT("text", false, false, true){

        @Override
        public Number parse(Object value) {
            return null;
        }

        @Override
        public Query termQuery(String field, Object value) {
            return new TermQuery(new Term(field, this.indexedValueForSearch(field, (String)value)));
        }

        @Override
        public Query termsQuery(String field, List<Object> values) {
            BytesRef[] bytesRefs = new BytesRef[values.size()];
            for (int i = 0; i < bytesRefs.length; ++i) {
                bytesRefs[i] = this.indexedValueForSearch(field, values.get(i));
            }
            return new TermInSetQuery(field, bytesRefs);
        }

        @Override
        public Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper) {
            return new TermRangeQuery(field, lowerTerm == null ? null : this.indexedValueForSearch(field, lowerTerm), upperTerm == null ? null : this.indexedValueForSearch(field, upperTerm), includeLower, includeUpper);
        }

        @Override
        public List<Field> createFields(String name, Object value, boolean indexed, boolean docValued, boolean stored, String analyzer) {
            ArrayList<Field> fields = new ArrayList<Field>();
            if (analyzer != null && analyzer.equals(LuceneAnalyzer.WHITESPACE_LOWERCASE.toString())) {
                this.isWhiteSpace(true);
            }
            if (indexed) {
                fields.add((Field)new TextField(name, (String)value, stored ? Field.Store.YES : Field.Store.NO));
            }
            if (docValued) {
                if (analyzer != null && analyzer.contains("LOWERCASE")) {
                    fields.add((Field)new SortedDocValuesField(name, new BytesRef(value == null ? null : ((String)value).toLowerCase())));
                } else {
                    fields.add((Field)new SortedDocValuesField(name, new BytesRef((CharSequence)((String)value))));
                }
            }
            return fields;
        }

        @Override
        public SortField sortField(String name, boolean reverse) {
            return new SortField(name, SortField.Type.STRING, reverse);
        }
    };

    private String typeName;
    private boolean isNumeric = false;
    private boolean hasFloatingPoint = false;
    private boolean isTokenized = false;
    private boolean isWhiteSpace = false;

    private DRFieldDataType(String typeName, boolean isNumeric, boolean hasFloatingPoint, boolean isTokenized) {
        this.typeName = typeName;
        this.isNumeric = isNumeric;
        this.hasFloatingPoint = hasFloatingPoint;
        this.isTokenized = isTokenized;
        if (!isNumeric && hasFloatingPoint) {
            throw new IllegalStateException("Trying to set initialize Non-Numeric DataType with floating type! typeName : " + typeName);
        }
    }

    public String typeName() {
        return this.typeName;
    }

    public boolean isNumeric() {
        return this.isNumeric;
    }

    public boolean hasFloatingPoint() {
        return this.hasFloatingPoint;
    }

    public boolean isTokenized() {
        return this.isTokenized;
    }

    public boolean isWhiteSpace() {
        return this.isWhiteSpace;
    }

    public void isWhiteSpace(boolean val) {
        this.isWhiteSpace = val;
    }

    public static DRFieldDataType get(String fieldType) {
        for (DRFieldDataType drFieldType : DRFieldDataType.values()) {
            if (!drFieldType.typeName.equalsIgnoreCase(fieldType)) continue;
            return drFieldType;
        }
        return null;
    }

    protected BytesRef indexedValueForSearch(String fieldName, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof BytesRef) {
            return (BytesRef)value;
        }
        return new BytesRef((CharSequence)value.toString());
    }

    boolean hasDecimalPart(Object number) {
        if (number instanceof Number) {
            double doubleValue = ((Number)number).doubleValue();
            return doubleValue % 1.0 != 0.0;
        }
        if (number instanceof BytesRef) {
            number = ((BytesRef)number).utf8ToString();
        }
        if (number instanceof String) {
            return Double.parseDouble((String)number) % 1.0 != 0.0;
        }
        return false;
    }

    double signum(Object value) {
        if (value instanceof Number) {
            double doubleValue = ((Number)value).doubleValue();
            return Math.signum(doubleValue);
        }
        if (value instanceof BytesRef) {
            value = ((BytesRef)value).utf8ToString();
        }
        return Math.signum(Double.parseDouble(value.toString()));
    }

    public abstract Number parse(Object var1);

    public abstract Query termQuery(String var1, Object var2);

    public abstract Query termsQuery(String var1, List<Object> var2);

    public abstract Query rangeQuery(String var1, Object var2, Object var3, boolean var4, boolean var5);

    public abstract List<Field> createFields(String var1, Object var2, boolean var3, boolean var4, boolean var5, String var6);

    public abstract SortField sortField(String var1, boolean var2);
}

