/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.commons.datarepository;

import com.manageengine.dataengine.commons.datarepository.DRFieldDataType;
import com.manageengine.dataengine.commons.lucene.LuceneAnalyzer;

public class DRIndexField {
    private String fieldName;
    private String fieldAliasName;
    private int index;
    private String dataType;
    private boolean isNotNull;
    private boolean hasDocValue;
    private boolean isFacetEnabled;
    private LuceneAnalyzer analyzer;
    public static final String DOC_SUFFIX = "_DOC";

    public DRIndexField(String fieldName, int index, String dataType, boolean isNotNull, boolean hasDocValue, LuceneAnalyzer analyzer) {
        this.setFieldName(fieldName);
        this.setDataType(dataType);
        this.index = index;
        this.isNotNull = isNotNull;
        this.hasDocValue = hasDocValue;
        this.isFacetEnabled = false;
        this.analyzer = analyzer;
    }

    public DRIndexField(String fieldName, int index, String dataType, boolean isNotNull, boolean hasDocValue) {
        this(fieldName, index, dataType, isNotNull, hasDocValue, LuceneAnalyzer.KEYWORD_LOWERCASE);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getFieldAliasName() {
        return this.fieldAliasName;
    }

    public int getFieldIndex() {
        return this.index;
    }

    public void setFieldName(String fieldName) {
        if (fieldName == null) {
            throw new IllegalArgumentException("IndexField.fieldName can't be null!");
        }
        this.fieldName = fieldName;
    }

    public void setFieldAliasName(String fieldAliasName) {
        this.fieldAliasName = fieldAliasName;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        if (DRFieldDataType.get(dataType) == null) {
            throw new IllegalArgumentException("IndexField.dataType '" + dataType + "' not supported!");
        }
        this.dataType = dataType;
    }

    public boolean hasDocValue() {
        return this.hasDocValue;
    }

    public void setHasDocValue(boolean hasDocValue) {
        this.hasDocValue = hasDocValue;
    }

    public boolean isFacetEnabled() {
        return this.isFacetEnabled;
    }

    public boolean isNotNull() {
        return this.isNotNull;
    }

    public void setFacetEnabled(boolean isFacetEnabled) {
        this.isFacetEnabled = isFacetEnabled;
    }

    public LuceneAnalyzer getAnalyzer() {
        return this.analyzer;
    }
}

