/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.commons.datarepository;

import com.manageengine.dataengine.commons.datarepository.DRFieldDataType;
import com.manageengine.dataengine.commons.datarepository.DRIndexField;
import com.manageengine.dataengine.commons.lucene.LuceneAnalyzer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.miscellaneous.PerFieldAnalyzerWrapper;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class DRSchema {
    private String schemaName;
    private String rangeField;
    private ArrayList<DRIndexField> uniqueFields;
    private ArrayList<DRIndexField> indexSortFields;
    private ArrayList<String> indexSortFieldOrders;
    private LuceneAnalyzer defaultAnalyzer;
    private LinkedHashMap<String, DRIndexField> indexFieldMap = null;

    public DRSchema(String schemaName) throws JSONException {
        this.schemaName = schemaName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    protected void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getRangeField() {
        return this.rangeField;
    }

    protected void setRangeField(String timeField) {
        this.rangeField = timeField;
    }

    public ArrayList<DRIndexField> getUniqueFields() {
        return this.uniqueFields;
    }

    protected void setUniqueFields(ArrayList<DRIndexField> uniqueFields) {
        this.uniqueFields = uniqueFields;
    }

    public ArrayList<DRIndexField> getIndexSortFields() {
        return this.indexSortFields;
    }

    public ArrayList<String> getIndexSortFieldOrders() {
        return this.indexSortFieldOrders;
    }

    public Sort getIndexSortObj() {
        Sort sortBy = null;
        if (this.indexSortFields != null && this.indexSortFieldOrders != null && this.indexSortFields.size() > 0) {
            sortBy = new Sort();
            int i = 0;
            SortField[] sortFields = new SortField[this.indexSortFields.size()];
            for (DRIndexField sortField : this.indexSortFields) {
                DRFieldDataType drFieldDataType = DRFieldDataType.get(sortField.getDataType());
                sortFields[i] = drFieldDataType.sortField(sortField.getFieldName(), this.indexSortFieldOrders.get(i).equalsIgnoreCase("desc"));
                ++i;
            }
            sortBy.setSort(sortFields);
        }
        return sortBy;
    }

    protected void setIndexSortFields(ArrayList<DRIndexField> indexSortFields, ArrayList<String> indexSortFieldOrders) {
        this.indexSortFields = indexSortFields;
        this.indexSortFieldOrders = indexSortFieldOrders;
    }

    public LuceneAnalyzer getDefaultAnalyzer() {
        return this.defaultAnalyzer;
    }

    protected void setDefaultAnalyzer(LuceneAnalyzer defaultAnalyzer) {
        this.defaultAnalyzer = defaultAnalyzer;
    }

    public Analyzer getAnalyzerWrapper() throws IOException {
        return new PerFieldAnalyzerWrapper(LuceneAnalyzer.KEYWORD_LOWERCASE.analyzer(), this.getFieldVsAnalyzer());
    }

    public Map<String, Analyzer> getFieldVsAnalyzer() throws IOException {
        HashMap<String, Analyzer> fieldVsAnalyzer = new HashMap<String, Analyzer>();
        for (DRIndexField field : this.indexFieldMap.values()) {
            if (field.getAnalyzer() == LuceneAnalyzer.KEYWORD_LOWERCASE) continue;
            fieldVsAnalyzer.put(field.getFieldName(), field.getAnalyzer().analyzer());
        }
        return fieldVsAnalyzer;
    }

    public boolean hasIndexField(String fieldName) {
        return this.indexFieldMap.containsKey(fieldName);
    }

    public DRIndexField getIndexField(String fieldName) {
        DRIndexField retDRIndexField = this.indexFieldMap.get(fieldName);
        if (!"*".equals(fieldName) && retDRIndexField == null) {
            for (DRIndexField drIndexField : this.indexFieldMap.values()) {
                if (drIndexField.getFieldAliasName() == null || !fieldName.equalsIgnoreCase(drIndexField.getFieldAliasName())) continue;
                retDRIndexField = drIndexField;
                break;
            }
        }
        return retDRIndexField;
    }

    public DRIndexField getIndexFieldByAliasName(String fieldAliasName) {
        for (DRIndexField indexField : this.indexFieldMap.values()) {
            if (indexField.getFieldAliasName() == null || !fieldAliasName.equalsIgnoreCase(indexField.getFieldAliasName())) continue;
            return indexField;
        }
        return null;
    }

    public ArrayList<DRIndexField> getIndexFields() {
        return new ArrayList<DRIndexField>(this.indexFieldMap.values());
    }

    public ArrayList<String> getIndexFieldNames() {
        ArrayList<String> indexNames = new ArrayList<String>();
        for (DRIndexField indexField : this.indexFieldMap.values()) {
            indexNames.add(indexField.getFieldName());
        }
        return indexNames;
    }

    public ArrayList<String> getIndexFieldAliasNames() {
        ArrayList<String> indexNames = new ArrayList<String>();
        for (DRIndexField indexField : this.indexFieldMap.values()) {
            if (indexField.getFieldAliasName() != null) {
                indexNames.add(indexField.getFieldAliasName());
                continue;
            }
            indexNames.add(indexField.getFieldName());
        }
        return indexNames;
    }

    protected void setIndexFieldMap(LinkedHashMap<String, DRIndexField> indexFieldMap) {
        this.indexFieldMap = indexFieldMap;
    }

    public abstract void loadSchema(JSONObject var1) throws JSONException;

    public abstract JSONObject getElasticFieldMappingObj();

    public abstract JSONObject getElasticIndexSettingsObj();

    public abstract JSONObject getElasticAliasesObj();

    public abstract String getElasticIndexAlias();
}

