/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.commons.datarepository;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.configuration2.INIConfiguration;
import org.apache.commons.configuration2.SubnodeConfiguration;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticDRConfFile {
    private INIConfiguration config;
    private FileHandler confFileHandler;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"DataEngineLogger");

    private ElasticDRConfFile(File confFile) throws Exception {
        confFile.getParentFile().mkdirs();
        confFile.createNewFile();
        this.config = new INIConfiguration();
        this.confFileHandler = new FileHandler((FileBased)this.config);
        this.confFileHandler.load(confFile);
        this.confFileHandler.setFile(confFile);
    }

    public static ElasticDRConfFile load(File confFileToLoad) throws Exception {
        ElasticDRConfFile confFile = new ElasticDRConfFile(confFileToLoad);
        return confFile;
    }

    public static ElasticDRConfFile load(File confFileToLoad, JSONArray json) throws Exception {
        ElasticDRConfFile confFile = new ElasticDRConfFile(confFileToLoad);
        confFile.config.clear();
        confFile.confFileHandler.save();
        ArrayList<DataRepositoryBean> list = new ArrayList<DataRepositoryBean>();
        int arrLen = json.length();
        for (int i = 0; i < arrLen; ++i) {
            list.add(DataRepositoryBean.load(json.getJSONObject(i)));
        }
        confFile.add(list);
        return confFile;
    }

    public List<DataRepositoryBean> getDataRepositories() throws Exception {
        ArrayList<DataRepositoryBean> list = new ArrayList<DataRepositoryBean>();
        for (String section : this.config.getSections()) {
            list.add(DataRepositoryBean.load(this.config.getSection(section)));
        }
        return list;
    }

    public void add(DataRepositoryBean dataRepository) throws Exception {
        ArrayList<DataRepositoryBean> list = new ArrayList<DataRepositoryBean>();
        list.add(dataRepository);
        this.add(list);
    }

    public void add(ArrayList<DataRepositoryBean> dataRepositoryList) throws Exception {
        for (DataRepositoryBean dataRepository : dataRepositoryList) {
            dataRepository.updateToConf(this.config.getSection(dataRepository.repositoryName()));
        }
        this.confFileHandler.save();
    }

    public void remove(DataRepositoryBean dataRepositoryBean) throws Exception {
        for (String repoName : this.config.getSections()) {
            if (!this.config.getSection(repoName).getString("repository_name").equalsIgnoreCase(dataRepositoryBean.repositoryName())) continue;
            this.config.getSection(repoName).clear();
            this.confFileHandler.save();
            break;
        }
    }

    public void update(DataRepositoryBean dataRepositoryBean) throws Exception {
        for (String repoName : this.config.getSections()) {
            if (!this.config.getSection(repoName).getString("repository_name").equalsIgnoreCase(dataRepositoryBean.repositoryName())) continue;
            dataRepositoryBean.updateToConf(this.config.getSection(repoName));
            this.confFileHandler.save();
            break;
        }
    }

    public void update(JSONArray dataRepositoryArr) throws Exception {
        block0: for (int i = 0; i < dataRepositoryArr.length(); ++i) {
            JSONObject drObj = dataRepositoryArr.getJSONObject(i);
            for (String repoName : this.config.getSections()) {
                if (!this.config.getSection(repoName).getString("repository_name").equalsIgnoreCase(drObj.getString("repository_name"))) continue;
                DataRepositoryBean dataRepositoryBean = DataRepositoryBean.load(this.config.getSection(repoName));
                dataRepositoryBean.update(drObj);
                dataRepositoryBean.updateToConf(this.config.getSection(repoName));
                continue block0;
            }
        }
        this.confFileHandler.save();
    }

    public JSONArray toJSON() throws Exception {
        JSONArray json = new JSONArray();
        for (String repoName : this.config.getSections()) {
            json.put((Object)DataRepositoryBean.load(this.config.getSection(repoName)).toJSON());
        }
        return json;
    }

    public void logDataRepositoriesInfo() throws Exception {
        for (String repoName : this.config.getSections()) {
            DataRepositoryBean.load(this.config.getSection(repoName)).logDataRepositoryInfo();
        }
    }

    public static class DataRepositoryBean {
        private String repository_name;
        private String repository_state;
        private String repository_type;
        private String description;
        private Boolean is_legacy;
        private String legacy_table_name;
        private String schema_name;
        private Boolean store_raw_data;
        private Boolean contains_duplicate;
        private String block_prefix;
        private Integer block_main_hot_count;
        private Integer block_main_hot_refresh_interval;
        private String block_main_hot_rotation_type;
        private Integer block_main_hot_rotation_size;
        private String block_main_hot_rotation_period;
        private Integer block_main_retention_days;
        private Integer block_frozen_retention_days;
        private Integer block_defrost_retention_days;
        public ArrayList<String> nodes;

        private DataRepositoryBean() {
        }

        public String repositoryName() {
            return this.repository_name;
        }

        public String repositoryState() {
            return this.repository_state;
        }

        public String repositoryType() {
            return this.repository_type;
        }

        public String description() {
            return this.description;
        }

        public Boolean isLegacy() {
            return this.is_legacy;
        }

        public String legacyTableName() {
            return this.legacy_table_name;
        }

        public String schemaName() {
            return this.schema_name;
        }

        public Boolean storeRawData() {
            return this.store_raw_data;
        }

        public Boolean containsDuplicate() {
            return this.contains_duplicate;
        }

        public String blockPrefix() {
            return this.block_prefix;
        }

        public Integer blockMainHotCount() {
            return this.block_main_hot_count;
        }

        public Integer blockMainHotRefreshInterval() {
            return this.block_main_hot_refresh_interval;
        }

        public String blockMainHotRotationType() {
            return this.block_main_hot_rotation_type;
        }

        public Integer blockMainHotRotationSize() {
            return this.block_main_hot_rotation_size;
        }

        public String blockMainHotRotationPeriod() {
            return this.block_main_hot_rotation_period;
        }

        public Integer blockMainRetentionDays() {
            return this.block_main_retention_days;
        }

        public Integer blockFrozenRetentionDays() {
            return this.block_frozen_retention_days;
        }

        public Integer blockDefrostRetentionDays() {
            return this.block_defrost_retention_days;
        }

        public ArrayList<String> nodes() {
            return this.nodes;
        }

        public String containerName() {
            return null;
        }

        public static DataRepositoryBean load(JSONObject json) throws Exception {
            DataRepositoryBean dataRepository = new DataRepositoryBean();
            dataRepository.repository_name = json.optString("repository_name");
            dataRepository.repository_state = json.optString("repository_state");
            dataRepository.description = json.optString("description");
            dataRepository.is_legacy = json.optBoolean("is_legacy");
            dataRepository.legacy_table_name = json.optString("legacy_table_name");
            dataRepository.schema_name = json.optString("schema_name");
            dataRepository.block_prefix = json.optString("block_prefix");
            dataRepository.block_main_hot_count = json.optInt("block_main_hot_count");
            dataRepository.block_main_hot_refresh_interval = json.optInt("block_main_hot_refresh_interval");
            dataRepository.block_main_hot_rotation_type = json.optString("block_main_hot_rotation_type");
            dataRepository.block_main_hot_rotation_size = json.optInt("block_main_hot_rotation_size");
            dataRepository.block_main_retention_days = json.optInt("block_main_retention_days");
            dataRepository.nodes = new ArrayList();
            JSONArray jXNodes = json.getJSONArray("nodes");
            for (int i = 0; i < jXNodes.length(); ++i) {
                dataRepository.nodes.add(jXNodes.getString(i));
            }
            return dataRepository;
        }

        public static DataRepositoryBean load(SubnodeConfiguration subnodeConf) throws Exception {
            DataRepositoryBean dataRepository = new DataRepositoryBean();
            dataRepository.repository_name = subnodeConf.getString("repository_name");
            dataRepository.repository_state = subnodeConf.getString("repository_state");
            dataRepository.description = subnodeConf.getString("description");
            dataRepository.is_legacy = subnodeConf.getBoolean("is_legacy");
            dataRepository.legacy_table_name = subnodeConf.getString("legacy_table_name");
            dataRepository.schema_name = subnodeConf.getString("schema_name");
            dataRepository.block_prefix = subnodeConf.getString("block_prefix");
            dataRepository.block_main_hot_count = subnodeConf.getInt("block_main_hot_count");
            dataRepository.block_main_hot_refresh_interval = subnodeConf.getInt("block_main_hot_refresh_interval");
            dataRepository.block_main_hot_rotation_type = subnodeConf.getString("block_main_hot_rotation_type");
            dataRepository.block_main_hot_rotation_size = subnodeConf.getInt("block_main_hot_rotation_size");
            dataRepository.block_main_retention_days = subnodeConf.getInt("block_main_retention_days");
            dataRepository.nodes = new ArrayList<String>(Arrays.asList(subnodeConf.getStringArray("nodes")));
            return dataRepository;
        }

        public SubnodeConfiguration updateToConf(SubnodeConfiguration subnodeConf) throws JSONException {
            subnodeConf.setProperty("repository_name", (Object)this.repository_name);
            subnodeConf.setProperty("repository_state", (Object)this.repository_state);
            subnodeConf.setProperty("description", (Object)this.description);
            subnodeConf.setProperty("is_legacy", (Object)this.is_legacy);
            subnodeConf.setProperty("legacy_table_name", (Object)this.legacy_table_name);
            subnodeConf.setProperty("schema_name", (Object)this.schema_name);
            subnodeConf.setProperty("block_prefix", (Object)this.block_prefix);
            subnodeConf.setProperty("block_main_hot_count", (Object)this.block_main_hot_count);
            subnodeConf.setProperty("block_main_hot_refresh_interval", (Object)this.block_main_hot_refresh_interval);
            subnodeConf.setProperty("block_main_hot_rotation_type", (Object)this.block_main_hot_rotation_type);
            subnodeConf.setProperty("block_main_hot_rotation_size", (Object)this.block_main_hot_rotation_size);
            subnodeConf.setProperty("block_main_retention_days", (Object)this.block_main_retention_days);
            subnodeConf.setProperty("nodes", this.nodes);
            return subnodeConf;
        }

        public void update(DataRepositoryBean repositoryBean) throws Exception {
            this.repository_state = repositoryBean.repositoryState();
            this.description = repositoryBean.description();
            this.is_legacy = repositoryBean.isLegacy();
            this.legacy_table_name = repositoryBean.legacyTableName();
            this.schema_name = repositoryBean.schemaName();
            this.block_prefix = repositoryBean.blockPrefix();
            this.block_main_hot_count = repositoryBean.blockMainHotCount();
            this.block_main_hot_refresh_interval = repositoryBean.blockMainHotRefreshInterval();
            this.block_main_hot_rotation_type = repositoryBean.blockMainHotRotationType();
            this.block_main_hot_rotation_size = repositoryBean.blockMainHotRotationSize();
            this.block_main_retention_days = repositoryBean.blockMainRetentionDays();
            this.nodes = repositoryBean.nodes();
        }

        public void update(JSONObject repositoryObj) throws Exception {
            this.repository_name = repositoryObj.optString("repository_name", this.repository_name);
            this.repository_state = repositoryObj.optString("repository_state", this.repository_state);
            this.description = repositoryObj.optString("description", this.description);
            this.is_legacy = repositoryObj.optBoolean("is_legacy", this.is_legacy.booleanValue());
            this.legacy_table_name = repositoryObj.optString("legacy_table_name", this.legacy_table_name);
            this.schema_name = repositoryObj.optString("schema_name", this.schema_name);
            this.block_prefix = repositoryObj.optString("block_prefix", this.block_prefix);
            this.block_main_hot_count = repositoryObj.optInt("block_main_hot_count", this.block_main_hot_count.intValue());
            this.block_main_hot_refresh_interval = repositoryObj.optInt("block_main_hot_refresh_interval", this.block_main_hot_refresh_interval.intValue());
            this.block_main_hot_rotation_type = repositoryObj.optString("block_main_hot_rotation_type", this.block_main_hot_rotation_type);
            this.block_main_hot_rotation_size = repositoryObj.optInt("block_main_hot_rotation_size", this.block_main_hot_rotation_size.intValue());
            this.block_main_retention_days = repositoryObj.optInt("block_main_retention_days", this.block_main_retention_days.intValue());
            JSONArray jNodes = repositoryObj.optJSONArray("nodes");
            if (jNodes != null && jNodes.length() > 0) {
                this.nodes = new ArrayList();
                for (int i = 0; i < jNodes.length(); ++i) {
                    this.nodes.add(jNodes.getString(i));
                }
            }
        }

        public JSONObject toJSON() throws JSONException {
            JSONObject json = new JSONObject();
            json.put("repository_name", (Object)this.repository_name);
            json.put("repository_state", (Object)this.repository_state);
            json.put("description", (Object)this.description);
            json.put("is_legacy", (Object)this.is_legacy);
            json.put("legacy_table_name", (Object)this.legacy_table_name);
            json.put("schema_name", (Object)this.schema_name);
            json.put("block_prefix", (Object)this.block_prefix);
            json.put("block_main_hot_count", (Object)this.block_main_hot_count);
            json.put("block_main_hot_refresh_interval", (Object)this.block_main_hot_refresh_interval);
            json.put("block_main_hot_rotation_type", (Object)this.block_main_hot_rotation_type);
            json.put("block_main_hot_rotation_size", (Object)this.block_main_hot_rotation_size);
            json.put("block_main_retention_days", (Object)this.block_main_retention_days);
            json.put("nodes", (Object)new JSONArray(this.nodes));
            return json;
        }

        public void logDataRepositoryInfo() {
            LOGGER.info("------------------------------------------------");
            LOGGER.info(" DATA REPOSITORY - " + this.repository_name);
            LOGGER.info("------------------------------------------------");
            LOGGER.info(" # repository_state :: " + this.repository_state);
            LOGGER.info(" # description :: " + this.description);
            LOGGER.info(" # is_legacy :: " + this.is_legacy);
            LOGGER.info(" # legacy_table_name :: " + this.legacy_table_name);
            LOGGER.info(" # schema_name :: " + this.schema_name);
            LOGGER.info(" # block_prefix :: " + this.block_prefix);
            LOGGER.info(" # block_main_hot_count :: " + this.block_main_hot_count);
            LOGGER.info(" # block_main_hot_refresh_interval :: " + this.block_main_hot_refresh_interval);
            LOGGER.info(" # block_main_hot_rotation_type :: " + this.block_main_hot_rotation_type);
            LOGGER.info(" # block_main_hot_rotation_size :: " + this.block_main_hot_rotation_size);
            LOGGER.info(" # block_main_retention_days :: " + this.block_main_retention_days);
            LOGGER.info(" # nodes :: " + this.nodes);
            LOGGER.info("------------------------------------------------");
        }
    }
}

