/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.commons.datarepository;

import com.manageengine.dataengine.commons.datarepository.DRIndexField;
import com.manageengine.dataengine.commons.datarepository.DRSchema;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ElasticDRSchema
extends DRSchema {
    private JSONObject fieldMappingObj = null;
    private JSONObject indexSettingsObj = null;
    private JSONObject aliasesObj = null;
    private String indexAlias = null;
    private static final String MAPPINGS_KEY = "mappings";
    private static final String SETTINGS_KEY = "settings";
    private static final String ALIASES_KEY = "aliases";
    private static final String UNIQUE_FIELDS_KEY = "unique_fields";
    private static final String TIME_FIELD_KEY = "time_field";
    private static final String FIELD_LIST_KEY = "field_list";
    private static final String FIELD_ALIAS_NAME_KEY = "alias_name";
    private static final String TYPE_KEY = "type";
    private static final String NOT_NULL_KEY = "not_null";
    private static final String DOCS_VAL_KEY = "docs_val";
    private static final String FACET_KEY = "facet";

    public ElasticDRSchema(String schemaName, JSONObject fileContentObj) throws Exception {
        super(schemaName);
        this.loadSchema(fileContentObj);
    }

    @Override
    public void loadSchema(JSONObject fileContentObj) throws JSONException {
        JSONObject propertiesObj;
        JSONObject defaultObj;
        if (fileContentObj.has(MAPPINGS_KEY)) {
            JSONObject mappingsObj = fileContentObj.getJSONObject(MAPPINGS_KEY);
            JSONArray uniqueFieldArr = mappingsObj.optJSONArray(UNIQUE_FIELDS_KEY);
            this.setRangeField(mappingsObj.optString(TIME_FIELD_KEY, "TIME_GENERATED"));
            JSONArray propertiesArr = mappingsObj.getJSONArray(FIELD_LIST_KEY);
            int arrLen = propertiesArr.length();
            defaultObj = new JSONObject();
            propertiesObj = new JSONObject();
            LinkedHashMap<String, DRIndexField> indexFieldMap = new LinkedHashMap<String, DRIndexField>();
            for (int i = 0; i < arrLen; ++i) {
                JSONObject fieldObj = propertiesArr.optJSONObject(i);
                String fieldName = (String)fieldObj.keys().next();
                JSONObject fieldDataObj = fieldObj.getJSONObject(fieldName);
                propertiesObj.put(fieldName, (Object)fieldDataObj);
                DRIndexField indexField = new DRIndexField(fieldName, i, fieldDataObj.getString(TYPE_KEY), fieldDataObj.optBoolean(NOT_NULL_KEY, false), fieldDataObj.optBoolean(DOCS_VAL_KEY, false));
                indexField.setFacetEnabled(false);
                indexField.setFieldAliasName(fieldDataObj.optString(FIELD_ALIAS_NAME_KEY, null));
                indexFieldMap.put(fieldName, indexField);
            }
            this.setIndexFieldMap(indexFieldMap);
            if (uniqueFieldArr != null && uniqueFieldArr.length() != 0) {
                ArrayList<DRIndexField> uniqueFields = new ArrayList<DRIndexField>();
                for (int i = 0; i < uniqueFieldArr.length(); ++i) {
                    uniqueFields.add(indexFieldMap.get(uniqueFieldArr.getString(i)));
                }
                this.setUniqueFields(uniqueFields);
            }
        } else {
            throw new JSONException("mappings key not found in " + this.getSchemaName() + " template!");
        }
        this.fieldMappingObj = defaultObj.put("DefaultInstance", (Object)new JSONObject().put("properties", (Object)propertiesObj));
        this.indexSettingsObj = fileContentObj.getJSONObject(SETTINGS_KEY);
        this.aliasesObj = fileContentObj.getJSONObject(ALIASES_KEY);
        this.indexAlias = ((String)this.aliasesObj.keys().next()).toString();
    }

    @Override
    public JSONObject getElasticFieldMappingObj() {
        return this.fieldMappingObj;
    }

    @Override
    public JSONObject getElasticIndexSettingsObj() {
        return this.indexSettingsObj;
    }

    @Override
    public JSONObject getElasticAliasesObj() {
        return this.aliasesObj;
    }

    @Override
    public String getElasticIndexAlias() {
        return this.indexAlias;
    }
}

