/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.commons.datarepository;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.configuration2.INIConfiguration;
import org.apache.commons.configuration2.SubnodeConfiguration;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XNodeDRConfFile {
    private INIConfiguration config;
    private FileHandler confFileHandler;
    public static final boolean IS_LEGACY_DV = false;
    public static final boolean STORE_RAW_DATA_DV = true;
    public static final boolean CONTAINS_DUPLICATE_DV = false;
    public static final int BLOCK_MAIN_HOT_COUNT_DV = 1;
    public static final int BLOCK_MAIN_HOT_REFRESH_INTERVAL_DV = 0;
    public static final String BLOCK_MAIN_HOT_ROTATION_TYPE_DV = "SIZE";
    public static final int BLOCK_MAIN_HOT_ROTATION_SIZE_DV = 3000000;
    public static final String BLOCK_MAIN_HOT_ROTATION_PERIOD_DV = null;
    public static final int BLOCK_MAIN_RETENTION_DAYS_DV = 150;
    public static final int BLOCK_FROZEN_S1_RETENTION_DAYS_DV = -1;
    public static final int BLOCK_FROZEN_RETENTION_DAYS_DV = 99999;
    public static final int BLOCK_DEFROST_RETENTION_DAYS_DV = 7;
    public static final int BLOCK_GRACE_RETENTION_DAYS_DV = 20;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"DataEngineLogger");

    private XNodeDRConfFile(File confFile) throws Exception {
        confFile.getParentFile().mkdirs();
        confFile.createNewFile();
        this.config = new INIConfiguration();
        this.confFileHandler = new FileHandler((FileBased)this.config);
        this.confFileHandler.load(confFile);
        this.confFileHandler.setFile(confFile);
    }

    public static XNodeDRConfFile load(File confFileToLoad) throws Exception {
        XNodeDRConfFile confFile = new XNodeDRConfFile(confFileToLoad);
        return confFile;
    }

    public static XNodeDRConfFile load(File confFileToLoad, JSONArray json) throws Exception {
        XNodeDRConfFile confFile = new XNodeDRConfFile(confFileToLoad);
        confFile.config.clear();
        confFile.confFileHandler.save();
        ArrayList<DataRepositoryBean> list = new ArrayList<DataRepositoryBean>();
        int arrLen = json.length();
        for (int i = 0; i < arrLen; ++i) {
            list.add(DataRepositoryBean.load(json.getJSONObject(i)));
        }
        confFile.add(list);
        return confFile;
    }

    public List<DataRepositoryBean> getDataRepositories() throws Exception {
        ArrayList<DataRepositoryBean> list = new ArrayList<DataRepositoryBean>();
        for (String section : this.config.getSections()) {
            list.add(DataRepositoryBean.load(this.config.getSection(section)));
        }
        return list;
    }

    public void add(DataRepositoryBean dataRepository) throws Exception {
        ArrayList<DataRepositoryBean> list = new ArrayList<DataRepositoryBean>();
        list.add(dataRepository);
        this.add(list);
    }

    public void add(ArrayList<DataRepositoryBean> dataRepositoryList) throws Exception {
        for (DataRepositoryBean dataRepository : dataRepositoryList) {
            dataRepository.updateToConf(this.config.getSection(dataRepository.repositoryName()));
        }
        this.confFileHandler.save();
    }

    public void delete(String dataRepositoryName) throws Exception {
        for (String repoName : this.config.getSections()) {
            if (!this.config.getSection(repoName).getString("repository_name").equalsIgnoreCase(dataRepositoryName)) continue;
            this.config.getSection(repoName).clear();
            this.confFileHandler.save();
            break;
        }
    }

    public void update(DataRepositoryBean dataRepositoryBean) throws Exception {
        for (String repoName : this.config.getSections()) {
            if (!this.config.getSection(repoName).getString("repository_name").equalsIgnoreCase(dataRepositoryBean.repositoryName())) continue;
            dataRepositoryBean.updateToConf(this.config.getSection(repoName));
            this.confFileHandler.save();
            break;
        }
    }

    public void update(JSONArray dataRepositoryArr) throws Exception {
        block0: for (int i = 0; i < dataRepositoryArr.length(); ++i) {
            JSONObject drObj = dataRepositoryArr.getJSONObject(i);
            for (String repoName : this.config.getSections()) {
                if (!this.config.getSection(repoName).getString("repository_name").equalsIgnoreCase(drObj.getString("repository_name"))) continue;
                DataRepositoryBean dataRepositoryBean = DataRepositoryBean.load(this.config.getSection(repoName));
                dataRepositoryBean.update(drObj);
                dataRepositoryBean.updateToConf(this.config.getSection(repoName));
                continue block0;
            }
        }
        this.confFileHandler.save();
    }

    public JSONArray toJSON() throws Exception {
        JSONArray json = new JSONArray();
        for (String repoName : this.config.getSections()) {
            json.put((Object)DataRepositoryBean.load(this.config.getSection(repoName)).toJSON());
        }
        return json;
    }

    public void logDataRepositoriesInfo() throws Exception {
        for (String repoName : this.config.getSections()) {
            DataRepositoryBean.load(this.config.getSection(repoName)).logMinDataRepositoryInfo();
        }
    }

    public static class DataRepositoryBean {
        private String repository_name;
        private String repository_state;
        private String repository_type;
        private String description;
        private String container_name;
        private Boolean is_legacy;
        private String legacy_table_name;
        private String schema_name;
        private Boolean store_raw_data;
        private Boolean contains_duplicate;
        private String block_prefix;
        private Integer block_main_hot_count;
        private Integer block_main_hot_refresh_interval;
        private String block_main_hot_rotation_type;
        private Integer block_main_hot_rotation_size;
        private String block_main_hot_rotation_period;
        private Integer block_main_retention_days;
        private Integer block_frozen_s1_retention_days;
        private Integer block_frozen_retention_days;
        private Integer block_defrost_retention_days;
        private Integer block_grace_retention_days;
        private ArrayList<String> xnodes;

        private DataRepositoryBean() {
        }

        public String repositoryName() {
            return this.repository_name;
        }

        public String repositoryState() {
            return this.repository_state;
        }

        public String repositoryType() {
            return this.repository_type;
        }

        public String description() {
            return this.description;
        }

        public String containerName() {
            return this.container_name;
        }

        public Boolean isLegacy() {
            return this.is_legacy;
        }

        public String legacyTableName() {
            return this.legacy_table_name;
        }

        public String schemaName() {
            return this.schema_name;
        }

        public Boolean storeRawData() {
            return this.store_raw_data;
        }

        public Boolean containsDuplicate() {
            return this.contains_duplicate;
        }

        public String blockPrefix() {
            return this.block_prefix;
        }

        public Integer blockMainHotCount() {
            return this.block_main_hot_count;
        }

        public Integer blockMainHotRefreshInterval() {
            return this.block_main_hot_refresh_interval;
        }

        public String blockMainHotRotationType() {
            return this.block_main_hot_rotation_type;
        }

        public Integer blockMainHotRotationSize() {
            return this.block_main_hot_rotation_size;
        }

        public String blockMainHotRotationPeriod() {
            return this.block_main_hot_rotation_period;
        }

        public Integer blockMainRetentionDays() {
            return this.block_main_retention_days;
        }

        public Integer blockFrozenS1RetentionDays() {
            return this.block_frozen_s1_retention_days;
        }

        public Integer blockFrozenRetentionDays() {
            return this.block_frozen_retention_days;
        }

        public Integer blockDefrostRetentionDays() {
            return this.block_defrost_retention_days;
        }

        public Integer blockGraceRetentionDays() {
            return this.block_grace_retention_days;
        }

        public ArrayList<String> nodes() {
            return this.xnodes;
        }

        public static DataRepositoryBean load(JSONObject json) throws Exception {
            DataRepositoryBean dataRepository = new DataRepositoryBean();
            dataRepository.repository_name = json.getString("repository_name");
            dataRepository.repository_state = json.getString("repository_state");
            dataRepository.repository_type = json.getString("repository_type");
            dataRepository.description = json.optString("description");
            dataRepository.container_name = json.getString("container_name");
            dataRepository.is_legacy = json.optBoolean("is_legacy", false);
            dataRepository.legacy_table_name = json.optString("legacy_table_name");
            dataRepository.schema_name = json.getString("schema_name");
            dataRepository.store_raw_data = json.optBoolean("store_raw_data", true);
            dataRepository.contains_duplicate = json.optBoolean("contains_duplicate", false);
            dataRepository.block_prefix = json.getString("block_prefix");
            dataRepository.block_main_hot_count = json.optInt("block_main_hot_count", 1);
            dataRepository.block_main_hot_refresh_interval = json.optInt("block_main_hot_refresh_interval", 0);
            dataRepository.block_main_hot_rotation_type = json.optString("block_main_hot_rotation_type", XNodeDRConfFile.BLOCK_MAIN_HOT_ROTATION_TYPE_DV);
            dataRepository.block_main_hot_rotation_size = json.optInt("block_main_hot_rotation_size", 3000000);
            dataRepository.block_main_hot_rotation_period = json.optString("block_main_hot_rotation_period", BLOCK_MAIN_HOT_ROTATION_PERIOD_DV);
            dataRepository.block_main_retention_days = json.optInt("block_main_retention_days", 150);
            dataRepository.block_frozen_s1_retention_days = json.optInt("block_frozen_s1_retention_days", -1);
            dataRepository.block_frozen_retention_days = json.optInt("block_frozen_s2_retention_days", 99999);
            dataRepository.block_defrost_retention_days = json.optInt("block_defrost_retention_days", 7);
            dataRepository.block_grace_retention_days = json.optInt("block_grace_retention_days", 20);
            dataRepository.xnodes = new ArrayList();
            JSONArray jXNodes = json.getJSONArray("xnodes");
            for (int i = 0; i < jXNodes.length(); ++i) {
                dataRepository.xnodes.add(jXNodes.getString(i));
            }
            return dataRepository;
        }

        public static DataRepositoryBean load(SubnodeConfiguration subnodeConf) throws Exception {
            DataRepositoryBean dataRepository = new DataRepositoryBean();
            dataRepository.repository_name = subnodeConf.getString("repository_name");
            dataRepository.repository_state = subnodeConf.getString("repository_state");
            dataRepository.repository_type = subnodeConf.getString("repository_type");
            dataRepository.description = subnodeConf.getString("description");
            dataRepository.container_name = subnodeConf.getString("container_name");
            dataRepository.is_legacy = subnodeConf.getBoolean("is_legacy", false);
            dataRepository.legacy_table_name = subnodeConf.getString("legacy_table_name");
            dataRepository.schema_name = subnodeConf.getString("schema_name");
            dataRepository.store_raw_data = subnodeConf.getBoolean("store_raw_data", true);
            dataRepository.contains_duplicate = subnodeConf.getBoolean("contains_duplicate", false);
            dataRepository.block_prefix = subnodeConf.getString("block_prefix");
            dataRepository.block_main_hot_count = subnodeConf.getInt("block_main_hot_count", 1);
            dataRepository.block_main_hot_refresh_interval = subnodeConf.getInt("block_main_hot_refresh_interval", 0);
            dataRepository.block_main_hot_rotation_type = subnodeConf.getString("block_main_hot_rotation_type", XNodeDRConfFile.BLOCK_MAIN_HOT_ROTATION_TYPE_DV);
            dataRepository.block_main_hot_rotation_size = subnodeConf.getInt("block_main_hot_rotation_size", 3000000);
            dataRepository.block_main_hot_rotation_period = subnodeConf.getString("block_main_hot_rotation_period", BLOCK_MAIN_HOT_ROTATION_PERIOD_DV);
            dataRepository.block_main_retention_days = subnodeConf.getInt("block_main_retention_days", 150);
            dataRepository.block_frozen_s1_retention_days = subnodeConf.getInt("block_frozen_s1_retention_days", -1);
            dataRepository.block_frozen_retention_days = subnodeConf.getInt("block_frozen_s2_retention_days", 99999);
            dataRepository.block_defrost_retention_days = subnodeConf.getInt("block_defrost_retention_days", 7);
            dataRepository.block_grace_retention_days = subnodeConf.getInt("block_grace_retention_days", 20);
            dataRepository.xnodes = new ArrayList<String>(Arrays.asList(subnodeConf.getStringArray("xnodes")));
            return dataRepository;
        }

        public SubnodeConfiguration updateToConf(SubnodeConfiguration subnodeConf) throws JSONException {
            subnodeConf.setProperty("repository_name", (Object)this.repository_name);
            subnodeConf.setProperty("repository_state", (Object)this.repository_state);
            subnodeConf.setProperty("repository_type", (Object)this.repository_type);
            subnodeConf.setProperty("description", (Object)this.description);
            subnodeConf.setProperty("container_name", (Object)this.container_name);
            subnodeConf.setProperty("is_legacy", (Object)this.is_legacy);
            subnodeConf.setProperty("legacy_table_name", (Object)this.legacy_table_name);
            subnodeConf.setProperty("schema_name", (Object)this.schema_name);
            subnodeConf.setProperty("store_raw_data", (Object)this.store_raw_data);
            subnodeConf.setProperty("contains_duplicate", (Object)this.contains_duplicate);
            subnodeConf.setProperty("block_prefix", (Object)this.block_prefix);
            subnodeConf.setProperty("block_main_hot_count", (Object)this.block_main_hot_count);
            subnodeConf.setProperty("block_main_hot_refresh_interval", (Object)this.block_main_hot_refresh_interval);
            subnodeConf.setProperty("block_main_hot_rotation_type", (Object)this.block_main_hot_rotation_type);
            subnodeConf.setProperty("block_main_hot_rotation_size", (Object)this.block_main_hot_rotation_size);
            subnodeConf.setProperty("block_main_hot_rotation_period", (Object)this.block_main_hot_rotation_period);
            subnodeConf.setProperty("block_main_retention_days", (Object)this.block_main_retention_days);
            subnodeConf.setProperty("block_frozen_s1_retention_days", (Object)this.block_frozen_s1_retention_days);
            subnodeConf.setProperty("block_frozen_s2_retention_days", (Object)this.block_frozen_retention_days);
            subnodeConf.setProperty("block_defrost_retention_days", (Object)this.block_defrost_retention_days);
            subnodeConf.setProperty("block_grace_retention_days", (Object)this.block_grace_retention_days);
            subnodeConf.setProperty("xnodes", this.xnodes);
            return subnodeConf;
        }

        public void update(DataRepositoryBean repositoryBean) throws Exception {
            this.repository_state = repositoryBean.repositoryState();
            this.description = repositoryBean.description();
            this.is_legacy = repositoryBean.isLegacy();
            this.legacy_table_name = repositoryBean.legacyTableName();
            this.store_raw_data = repositoryBean.storeRawData();
            this.contains_duplicate = repositoryBean.containsDuplicate();
            this.block_prefix = repositoryBean.blockPrefix();
            this.block_main_hot_count = repositoryBean.blockMainHotCount();
            this.block_main_hot_refresh_interval = repositoryBean.blockMainHotRefreshInterval();
            this.block_main_hot_rotation_type = repositoryBean.blockMainHotRotationType();
            this.block_main_hot_rotation_size = repositoryBean.blockMainHotRotationSize();
            this.block_main_retention_days = repositoryBean.blockMainRetentionDays();
            this.xnodes = repositoryBean.nodes();
        }

        public void update(JSONObject repositoryObj) throws Exception {
            this.repository_name = repositoryObj.optString("repository_name", this.repository_name);
            this.repository_state = repositoryObj.optString("repository_state", this.repository_state);
            this.repository_type = repositoryObj.optString("repository_type", this.repository_type);
            this.description = repositoryObj.optString("description", this.description);
            this.container_name = repositoryObj.optString("container_name", this.container_name);
            this.is_legacy = repositoryObj.optBoolean("is_legacy", this.is_legacy.booleanValue());
            this.legacy_table_name = repositoryObj.optString("legacy_table_name", this.legacy_table_name);
            this.schema_name = repositoryObj.optString("schema_name", this.schema_name);
            this.store_raw_data = repositoryObj.optBoolean("store_raw_data", this.store_raw_data.booleanValue());
            this.contains_duplicate = repositoryObj.optBoolean("contains_duplicate", this.contains_duplicate.booleanValue());
            this.block_prefix = repositoryObj.optString("block_prefix", this.block_prefix);
            this.block_main_hot_count = repositoryObj.optInt("block_main_hot_count", this.block_main_hot_count.intValue());
            this.block_main_hot_refresh_interval = repositoryObj.optInt("block_main_hot_refresh_interval", this.block_main_hot_refresh_interval.intValue());
            this.block_main_hot_rotation_type = repositoryObj.optString("block_main_hot_rotation_type", this.block_main_hot_rotation_type);
            this.block_main_hot_rotation_size = repositoryObj.optInt("block_main_hot_rotation_size", this.block_main_hot_rotation_size.intValue());
            this.block_main_hot_rotation_period = repositoryObj.optString("block_main_hot_rotation_period", this.block_main_hot_rotation_period);
            this.block_main_retention_days = repositoryObj.optInt("block_main_retention_days", this.block_main_retention_days.intValue());
            this.block_frozen_s1_retention_days = repositoryObj.optInt("block_frozen_s1_retention_days", this.block_frozen_s1_retention_days.intValue());
            this.block_frozen_retention_days = repositoryObj.optInt("block_frozen_s2_retention_days", this.block_frozen_retention_days.intValue());
            this.block_defrost_retention_days = repositoryObj.optInt("block_defrost_retention_days", this.block_defrost_retention_days.intValue());
            this.block_grace_retention_days = repositoryObj.optInt("block_grace_retention_days", this.block_grace_retention_days.intValue());
            JSONArray jXNodes = repositoryObj.optJSONArray("xnodes");
            if (jXNodes != null && jXNodes.length() > 0) {
                this.xnodes = new ArrayList();
                for (int i = 0; i < jXNodes.length(); ++i) {
                    this.xnodes.add(jXNodes.getString(i));
                }
            }
        }

        public JSONObject toJSON() throws JSONException {
            JSONObject json = new JSONObject();
            json.put("repository_name", (Object)this.repository_name);
            json.put("repository_state", (Object)this.repository_state);
            json.put("repository_type", (Object)this.repository_type);
            json.put("description", (Object)this.description);
            json.put("container_name", (Object)this.container_name);
            json.put("is_legacy", (Object)this.is_legacy);
            json.put("legacy_table_name", (Object)this.legacy_table_name);
            json.put("schema_name", (Object)this.schema_name);
            json.put("store_raw_data", (Object)this.store_raw_data);
            json.put("contains_duplicate", (Object)this.contains_duplicate);
            json.put("block_prefix", (Object)this.block_prefix);
            json.put("block_main_hot_count", (Object)this.block_main_hot_count);
            json.put("block_main_hot_refresh_interval", (Object)this.block_main_hot_refresh_interval);
            json.put("block_main_hot_rotation_type", (Object)this.block_main_hot_rotation_type);
            json.put("block_main_hot_rotation_size", (Object)this.block_main_hot_rotation_size);
            json.put("block_main_hot_rotation_period", (Object)this.block_main_hot_rotation_period);
            json.put("block_main_retention_days", (Object)this.block_main_retention_days);
            json.put("block_frozen_s1_retention_days", (Object)this.block_frozen_s1_retention_days);
            json.put("block_frozen_s2_retention_days", (Object)this.block_frozen_retention_days);
            json.put("block_defrost_retention_days", (Object)this.block_defrost_retention_days);
            json.put("block_grace_retention_days", (Object)this.block_grace_retention_days);
            json.put("xnodes", (Object)new JSONArray(this.xnodes));
            return json;
        }

        public void logDataRepositoryInfo() {
            LOGGER.info("------------------------------------------------");
            LOGGER.info(" DATA REPOSITORY - " + this.repository_name);
            LOGGER.info("------------------------------------------------");
            LOGGER.info(" # repository_state :: " + this.repository_state);
            LOGGER.info(" # repository_type :: " + this.repository_type);
            LOGGER.info(" # description :: " + this.description);
            LOGGER.info(" # container_name :: " + this.container_name);
            LOGGER.info(" # is_legacy :: " + this.is_legacy);
            LOGGER.info(" # legacy_table_name :: " + this.legacy_table_name);
            LOGGER.info(" # schema_name :: " + this.schema_name);
            LOGGER.info(" # store_raw_data :: " + this.store_raw_data);
            LOGGER.info(" # contains_duplicate :: " + this.contains_duplicate);
            LOGGER.info(" # block_prefix :: " + this.block_prefix);
            LOGGER.info(" # block_main_hot_count :: " + this.block_main_hot_count);
            LOGGER.info(" # block_main_hot_refresh_interval :: " + this.block_main_hot_refresh_interval);
            LOGGER.info(" # block_main_hot_rotation_type :: " + this.block_main_hot_rotation_type);
            LOGGER.info(" # block_main_hot_rotation_size :: " + this.block_main_hot_rotation_size);
            LOGGER.info(" # block_main_hot_rotation_period :: " + this.block_main_hot_rotation_period);
            LOGGER.info(" # block_main_retention_days :: " + this.block_main_retention_days);
            LOGGER.info(" # block_frozen_s1_retention_days :: " + this.block_frozen_s1_retention_days);
            LOGGER.info(" # block_frozen_retention_days :: " + this.block_frozen_retention_days);
            LOGGER.info(" # block_defrost_retention_days :: " + this.block_defrost_retention_days);
            LOGGER.info(" # block_grace_retention_days :: " + this.block_grace_retention_days);
            LOGGER.info("------------------------------------------------");
        }

        public void logMinDataRepositoryInfo() {
            LOGGER.info("[ REPO : " + this.repository_name + "(" + this.repository_type + ") - " + this.repository_state + "] [schema_name : " + this.schema_name + "] [store_raw_data : " + this.store_raw_data + "] [contains_duplicate : " + this.contains_duplicate + "] [block_main_hot count/refresh_interval/rotation_type/rotation_size/rotation_period : " + this.block_main_hot_count + "/" + this.block_main_hot_refresh_interval + "/" + this.block_main_hot_rotation_type + "/" + this.block_main_hot_rotation_size + "/" + this.block_main_hot_rotation_period + "] [block_retention_days main/frozen_s1/frozen_s2/defrost/grace : " + this.block_main_retention_days + "/" + this.block_frozen_s1_retention_days + "/" + this.block_frozen_retention_days + "/" + this.block_defrost_retention_days + "/" + this.block_grace_retention_days + "]");
        }
    }
}

