/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.commons.datarepository;

import com.manageengine.dataengine.commons.datarepository.DRIndexField;
import com.manageengine.dataengine.commons.datarepository.DRSchema;
import com.manageengine.dataengine.commons.lucene.LuceneAnalyzer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class XNodeDRSchema
extends DRSchema {
    private static final String MAPPINGS_KEY = "mappings";
    private static final String UNIQUE_FIELDS_KEY = "unique_fields";
    private static final String INDEX_SORT_FIELDS_KEY = "index_sort_fields";
    private static final String INDEX_SORT_FIELD_NAME_KEY = "field";
    private static final String INDEX_SORT_FIELD_ORDER_KEY = "order";
    private static final String RANGE_FIELD_KEY = "range_field";
    private static final String FIELD_LIST_KEY = "field_list";
    private static final String DEFAULT_ANALYZER_KEY = "default_analyzer";
    private static final String FIELD_ALIAS_NAME_KEY = "alias_name";
    private static final String TYPE_KEY = "type";
    private static final String NOT_NULL_KEY = "not_null";
    private static final String DOCS_VAL_KEY = "docs_val";
    private static final String FACET_KEY = "facet";
    private static final String ANALYZER_KEY = "analyzer";

    public XNodeDRSchema(String schemaName, JSONObject jsonObj) throws JSONException {
        super(schemaName);
        this.loadSchema(jsonObj);
    }

    @Override
    public void loadSchema(JSONObject jsonObj) throws JSONException {
        if (jsonObj.has(MAPPINGS_KEY)) {
            JSONObject mappingsObj = jsonObj.getJSONObject(MAPPINGS_KEY);
            JSONArray uniqueFieldArr = mappingsObj.optJSONArray(UNIQUE_FIELDS_KEY);
            JSONArray indexSortFieldArr = mappingsObj.optJSONArray(INDEX_SORT_FIELDS_KEY);
            this.setRangeField(mappingsObj.optString(RANGE_FIELD_KEY, "TIME_GENERATED"));
            this.setDefaultAnalyzer(LuceneAnalyzer.get(mappingsObj.optString(DEFAULT_ANALYZER_KEY, "KEYWORD_LOWERCASE")));
            JSONArray fieldArr = mappingsObj.getJSONArray(FIELD_LIST_KEY);
            int arrLen = fieldArr.length();
            LinkedHashMap<String, DRIndexField> indexFieldMap = new LinkedHashMap<String, DRIndexField>();
            for (int i = 0; i < arrLen; ++i) {
                JSONObject fieldObj = fieldArr.optJSONObject(i);
                String fieldName = (String)fieldObj.keys().next();
                JSONObject fieldDataObj = fieldObj.getJSONObject(fieldName);
                boolean isNotNull = fieldDataObj.optBoolean(NOT_NULL_KEY, false);
                if (this.getRangeField().equalsIgnoreCase(fieldName)) {
                    isNotNull = true;
                }
                DRIndexField indexField = new DRIndexField(fieldName, i, fieldDataObj.getString(TYPE_KEY), isNotNull, fieldDataObj.optBoolean(DOCS_VAL_KEY, false), LuceneAnalyzer.get(fieldDataObj.optString(ANALYZER_KEY, "KEYWORD_LOWERCASE")));
                indexField.setFacetEnabled(fieldDataObj.optBoolean(FACET_KEY, false));
                indexField.setFieldAliasName(fieldDataObj.optString(FIELD_ALIAS_NAME_KEY, null));
                indexFieldMap.put(fieldName, indexField);
            }
            this.setIndexFieldMap(indexFieldMap);
            if (uniqueFieldArr != null && uniqueFieldArr.length() != 0) {
                ArrayList<DRIndexField> uniqueFields = new ArrayList<DRIndexField>();
                for (int i = 0; i < uniqueFieldArr.length(); ++i) {
                    uniqueFields.add(indexFieldMap.get(uniqueFieldArr.getString(i)));
                }
                this.setUniqueFields(uniqueFields);
            }
            if (indexSortFieldArr != null && indexSortFieldArr.length() != 0) {
                ArrayList<DRIndexField> indexSortFields = new ArrayList<DRIndexField>();
                ArrayList<String> indexSortFieldOrders = new ArrayList<String>();
                for (int i = 0; i < indexSortFieldArr.length(); ++i) {
                    JSONObject fieldObj = indexSortFieldArr.getJSONObject(i);
                    indexSortFields.add(indexFieldMap.get(fieldObj.getString(INDEX_SORT_FIELD_NAME_KEY)));
                    String sortOrder = fieldObj.getString(INDEX_SORT_FIELD_ORDER_KEY).toLowerCase();
                    if (!sortOrder.equals("asc") && !sortOrder.equals("desc")) {
                        throw new IllegalArgumentException("Unrecognized index sort order!! [Schema : " + this.getSchemaName() + "]");
                    }
                    indexSortFieldOrders.add(sortOrder);
                }
                this.setIndexSortFields(indexSortFields, indexSortFieldOrders);
            }
        } else {
            throw new JSONException("mappings key not found in " + this.getSchemaName() + " template!");
        }
    }

    @Override
    public JSONObject getElasticFieldMappingObj() {
        return null;
    }

    @Override
    public JSONObject getElasticIndexSettingsObj() {
        return null;
    }

    @Override
    public JSONObject getElasticAliasesObj() {
        return null;
    }

    @Override
    public String getElasticIndexAlias() {
        return null;
    }
}

