/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.commons.file;

import com.opencsv.CSVReader;
import com.opencsv.CSVWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class GzipUtil {
    private String encoding;

    public GzipUtil() {
        this.encoding = "UTF-8";
    }

    public GzipUtil(String encoding) {
        this.encoding = encoding;
    }

    public GzipWriteHandle getGzipWriteHandle(String zipFilePath) throws IOException {
        return new GzipWriteHandle(zipFilePath, this.encoding);
    }

    public GzipCsvWriteHandle getGzipCsvWriteHandle(String zipFilePath, char splitBy) throws IOException {
        return new GzipCsvWriteHandle(zipFilePath, this.encoding, splitBy);
    }

    public GzipCsvWriteHandle getGzipCsvWriteHandle(String zipFilePath, String encoding, char splitBy) throws IOException {
        return new GzipCsvWriteHandle(zipFilePath, encoding, splitBy);
    }

    public GzipCsvReadHandle getGzipCsvReadHandle(String zipFilePath, char splitBy) throws IOException {
        return new GzipCsvReadHandle(zipFilePath, this.encoding, splitBy);
    }

    public GzipCsvReadHandle getGzipCsvReadHandle(String zipFilePath, String encoding, char splitBy) throws IOException {
        return new GzipCsvReadHandle(zipFilePath, encoding, splitBy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long extractZip(String sourceZipPath, String destFile) throws Exception {
        InputStream gzipStream = null;
        BufferedReader br = null;
        BufferedWriter bw = null;
        long startTime = 0L;
        long endTime = 0L;
        try {
            startTime = System.currentTimeMillis();
            gzipStream = new GZIPInputStream(new FileInputStream(sourceZipPath));
            br = new BufferedReader(new InputStreamReader(gzipStream, this.encoding));
            bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(destFile)));
            String line = "";
            while ((line = br.readLine()) != null) {
                bw.write(line + "\r\n");
            }
            endTime = System.currentTimeMillis();
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (gzipStream != null) {
                gzipStream.close();
            }
            if (bw != null) {
                bw.close();
            }
        }
        return endTime - startTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkIfFileIsCorrupted(String sourceZipPath) throws Exception {
        boolean isCorrupted = false;
        GZIPInputStream gzipStream = null;
        BufferedReader br = null;
        try {
            gzipStream = new GZIPInputStream(new FileInputStream(sourceZipPath));
            br = new BufferedReader(new InputStreamReader((InputStream)gzipStream, this.encoding));
            String line = "";
            while (line != null) {
                line = br.readLine();
            }
        }
        catch (IOException e) {
            isCorrupted = true;
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (gzipStream != null) {
                ((InputStream)gzipStream).close();
            }
        }
        return isCorrupted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long mergeGzipFiles(File[] sourceZipFiles, String destFile, char splitBy) throws Exception {
        GzipCsvReadHandle readHandle = null;
        GzipCsvWriteHandle writeHandle = null;
        long totalLines = 0L;
        try {
            writeHandle = this.getGzipCsvWriteHandle(destFile, splitBy);
            for (File file : sourceZipFiles) {
                try {
                    String[] line;
                    readHandle = this.getGzipCsvReadHandle(file.getAbsolutePath(), splitBy);
                    while ((line = readHandle.readNext()) != null) {
                        writeHandle.writeNext(line);
                        ++totalLines;
                    }
                }
                catch (Exception ie) {
                    ie.printStackTrace();
                }
                finally {
                    if (readHandle != null) {
                        readHandle.close();
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (readHandle != null) {
                readHandle.close();
            }
            if (writeHandle != null) {
                writeHandle.close();
            }
        }
        return totalLines;
    }

    public class GzipCsvReadHandle {
        private String zipFilePath;
        private FileInputStream fileInStream;
        private InputStreamReader streamReader;
        private CSVReader csvReader;
        private char splitBy;

        private GzipCsvReadHandle(String zipFilePath, String encoding, char splitBy) throws IOException {
            this.zipFilePath = zipFilePath;
            this.splitBy = splitBy;
            this.fileInStream = new FileInputStream(this.zipFilePath);
            this.streamReader = encoding == null ? new InputStreamReader(new GZIPInputStream(this.fileInStream)) : new InputStreamReader((InputStream)new GZIPInputStream(this.fileInStream), encoding);
            this.csvReader = new CSVReader((Reader)new BufferedReader(this.streamReader), this.splitBy);
        }

        private GzipCsvReadHandle(String zipFilePath, char splitBy) throws IOException {
            this(zipFilePath, null, splitBy);
        }

        public String[] readNext() throws Exception {
            return this.csvReader.readNext();
        }

        public void close() throws IOException {
            if (this.csvReader != null) {
                this.csvReader.close();
            }
            if (this.streamReader != null) {
                this.streamReader.close();
            }
            if (this.fileInStream != null) {
                this.fileInStream.close();
            }
        }
    }

    public class GzipCsvWriteHandle {
        private String zipFilePath;
        private FileOutputStream zipOutStream;
        private OutputStreamWriter zipWriter;
        private CSVWriter csvWriter;
        private char splitBy;

        private GzipCsvWriteHandle(String zipFilePath, String encoding, char splitBy) throws IOException {
            this.zipFilePath = zipFilePath;
            this.splitBy = splitBy;
            this.zipOutStream = new FileOutputStream(this.zipFilePath, true);
            this.zipWriter = encoding == null ? new OutputStreamWriter(new GZIPOutputStream(this.zipOutStream)) : new OutputStreamWriter((OutputStream)new GZIPOutputStream(this.zipOutStream), encoding);
            this.csvWriter = new CSVWriter((Writer)this.zipWriter, this.splitBy, '\"', '\\');
        }

        private GzipCsvWriteHandle(String zipFilePath, char splitBy) throws IOException {
            this(zipFilePath, null, splitBy);
        }

        public void writeNext(String[] data) throws Exception {
            this.csvWriter.writeNext(data, false);
        }

        public void close() throws IOException {
            if (this.csvWriter != null) {
                this.csvWriter.close();
            }
            if (this.zipWriter != null) {
                this.zipWriter.close();
            }
            if (this.zipOutStream != null) {
                this.zipOutStream.close();
            }
        }
    }

    public class GzipWriteHandle {
        private String zipFilePath;
        private FileOutputStream zipOutStream;
        private OutputStreamWriter zipWriter;
        private String encoding;

        private GzipWriteHandle(String zipFilePath, String encoding) throws IOException {
            this.zipFilePath = zipFilePath;
            this.encoding = encoding;
            this.zipOutStream = new FileOutputStream(this.zipFilePath, true);
            this.zipWriter = encoding == null ? new OutputStreamWriter(new GZIPOutputStream(this.zipOutStream)) : new OutputStreamWriter((OutputStream)new GZIPOutputStream(this.zipOutStream), this.encoding);
        }

        private GzipWriteHandle(String zipFilePath) throws IOException {
            this(zipFilePath, null);
        }

        public void write(String str) throws IOException {
            this.zipWriter.write(str);
        }

        public void close() throws IOException {
            if (this.zipWriter != null) {
                this.zipWriter.close();
            }
            if (this.zipOutStream != null) {
                this.zipOutStream.close();
            }
        }
    }
}

