/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.commons.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.FileBasedConfiguration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class PropertiesFileUtil {
    private static final Logger LOGGER = LogManager.getLogger((String)"XNode");

    public static PropertiesFileHandle getPropertiesFileHandle(String filePath, boolean createIfNotExists) throws Exception {
        return new PropertiesFileHandle(filePath, createIfNotExists);
    }

    public static void updateProperties(String filePath, HashMap<String, String> updateParams) throws Exception {
        File file = new File(filePath);
        file.createNewFile();
        Parameters params = new Parameters();
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)params.properties().setFile(file)});
        Configuration config = (Configuration)builder.getConfiguration();
        for (String key : updateParams.keySet()) {
            config.setProperty(key, (Object)updateParams.get(key));
        }
        builder.save();
    }

    public static HashMap<String, Object> getProperties(String filePath, JSONArray getParams) throws Exception {
        HashMap<String, Object> valueParams = new HashMap<String, Object>();
        Parameters params = new Parameters();
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)params.properties().setFileName(filePath)});
        Configuration config = (Configuration)builder.getConfiguration();
        int len = getParams.length();
        for (int i = 0; i < len; ++i) {
            JSONObject paramObj = getParams.getJSONObject(i);
            if (!config.containsKey(paramObj.getString("key"))) continue;
            if (paramObj.getString("data_type").equals("string")) {
                valueParams.put(paramObj.getString("key"), config.getString(paramObj.getString("key")));
                continue;
            }
            if (paramObj.getString("data_type").equals("int")) {
                valueParams.put(paramObj.getString("key"), config.getInt(paramObj.getString("key")));
                continue;
            }
            if (paramObj.getString("data_type").equals("long")) {
                valueParams.put(paramObj.getString("key"), config.getLong(paramObj.getString("key")));
                continue;
            }
            if (paramObj.getString("data_type").equals("boolean")) {
                valueParams.put(paramObj.getString("key"), config.getBoolean(paramObj.getString("key")));
                continue;
            }
            if (!paramObj.getString("data_type").equals("array")) continue;
            valueParams.put(paramObj.getString("key"), config.getList(paramObj.getString("key")));
        }
        return valueParams;
    }

    public static HashMap<String, Object> getProperties(String filePath, HashMap<String, String> updateParams) throws Exception {
        HashMap<String, Object> valueParams = new HashMap<String, Object>();
        Parameters params = new Parameters();
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)params.properties().setFileName(filePath)});
        Configuration config = (Configuration)builder.getConfiguration();
        for (String key : updateParams.keySet()) {
            if (!config.containsKey(key)) continue;
            if (updateParams.get(key).equals("string")) {
                valueParams.put(key, config.getString(updateParams.get(key)));
                continue;
            }
            if (updateParams.get(key).equals("int")) {
                valueParams.put(key, config.getInt(updateParams.get(key)));
                continue;
            }
            if (updateParams.get(key).equals("long")) {
                valueParams.put(key, config.getLong(updateParams.get(key)));
                continue;
            }
            if (updateParams.get(key).equals("boolean")) {
                valueParams.put(key, config.getBoolean(updateParams.get(key)));
                continue;
            }
            if (!updateParams.get(key).equals("array")) continue;
            valueParams.put(key, config.getList(updateParams.get(key)));
        }
        return valueParams;
    }

    public static Properties getProperties(String fileName) {
        Properties props = new Properties();
        try (FileInputStream fis = new FileInputStream(fileName);){
            props.load(fis);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return props;
    }

    public static class PropertiesFileHandle {
        private String filePath;
        private FileBasedConfigurationBuilder<FileBasedConfiguration> builder;
        private PropertiesConfiguration config;

        private PropertiesFileHandle(String filePath, boolean createIfNotExists) throws Exception {
            this.filePath = filePath;
            if (createIfNotExists) {
                new File(this.filePath).createNewFile();
            }
            Parameters params = new Parameters();
            this.builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)params.properties().setFileName(filePath)});
            this.config = (PropertiesConfiguration)this.builder.getConfiguration();
        }

        public void updateProperty(String key, String value) throws IOException {
            this.config.setProperty(key, (Object)value);
        }

        public void saveFile() throws Exception {
            LOGGER.info("Going to save file - " + this.filePath);
            this.builder.save();
            LOGGER.info("Successfully saved file - " + this.filePath);
        }

        public Object getProperty(String key) {
            return this.config.getProperty(key);
        }

        public String getString(String key, String defaultValue) {
            return this.config.getString(key, defaultValue);
        }

        public Integer getInt(String key, Integer defaultValue) {
            if (this.config.containsKey(key)) {
                return this.config.getInt(key);
            }
            return defaultValue;
        }

        public Long getLong(String key, Long defaultValue) {
            if (this.config.containsKey(key)) {
                return this.config.getLong(key);
            }
            return defaultValue;
        }

        public Boolean getBoolean(String key, Boolean defaultValue) {
            if (this.config.containsKey(key)) {
                return this.config.getBoolean(key);
            }
            return defaultValue;
        }

        public List<Object> getList(String key) {
            return this.config.getList(key);
        }

        public String[] getStringArray(String key) {
            return this.config.getStringArray(key);
        }

        public void clearProperty(String key) {
            this.config.clearProperty(key);
        }

        public void clear() {
            this.config.clear();
        }

        public void setBlancLinesBefore(String key, int number) {
            this.config.getLayout().setBlancLinesBefore(key, number);
        }

        public void setComment(String key, String comment) {
            this.config.getLayout().setComment(key, comment);
        }
    }
}

