/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.commons.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SevenZipUtil {
    private static final Logger LOGGER = LogManager.getLogger((String)"XNode");
    private static String sevenZipPath;

    public SevenZipUtil() {
        sevenZipPath = System.getProperty("os.arch").contains("64") ? System.getProperty("tools.dir") + File.separator + "archiver" + File.separator + "windows" + File.separator + "x86-64" + File.separator + "7za.exe" : System.getProperty("tools.dir") + File.separator + "archiver" + File.separator + "windows" + File.separator + "x86" + File.separator + "7za.exe";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long zip(String srcPath, String destPath) throws Exception {
        int processExitValue;
        long start = System.currentTimeMillis();
        File srcFile = new File(srcPath);
        File destFile = new File(destPath);
        LOGGER.info("---------------------------------------------------------");
        LOGGER.info("SEVEN-ZIP-UTIL :: Compressing file: " + srcFile);
        ArrayList<String> commandList = new ArrayList<String>();
        commandList.add(sevenZipPath);
        commandList.add("a");
        commandList.add("-t7z");
        commandList.add("-m0=lzma2");
        commandList.add(destFile.getCanonicalPath());
        commandList.add(srcFile.getCanonicalPath());
        Process zipProcess = null;
        BufferedReader inpBuff = null;
        try {
            zipProcess = new ProcessBuilder(commandList).start();
            inpBuff = new BufferedReader(new InputStreamReader(zipProcess.getInputStream()));
            while (true) {
                String processConsoleOut;
                if ((processConsoleOut = inpBuff.readLine()) == null) break;
                LOGGER.info("SEVEN-ZIP-UTIL :: " + processConsoleOut);
            }
            zipProcess.waitFor();
            processExitValue = zipProcess.exitValue();
            if (processExitValue != 0) {
                if (processExitValue == 1) {
                    throw new Exception("SEVEN-ZIP-UTIL :: Decompression aborted prematurely with exit value - " + processExitValue);
                }
                if (processExitValue == 2) {
                    throw new Exception("SEVEN-ZIP-UTIL :: Decompression aborted due to FATAL ERROR, exit value - " + processExitValue);
                }
                if (processExitValue == 8) {
                    throw new Exception("SEVEN-ZIP-UTIL :: Decompression aborted due to out of memory with exit value - " + processExitValue);
                }
                if (processExitValue == 255) {
                    throw new Exception("SEVEN-ZIP-UTIL :: Decompression unexpectedly stopped due to SIGINT, exit value - " + processExitValue);
                }
                throw new Exception("SEVEN-ZIP-UTIL :: Decompression aborted with exit value - " + processExitValue);
            }
        }
        finally {
            if (inpBuff != null) {
                inpBuff.close();
            }
            if (zipProcess != null) {
                zipProcess.destroy();
            }
        }
        LOGGER.info("SEVEN-ZIP-UTIL :: Compression completed with value - " + processExitValue);
        return System.currentTimeMillis() - start;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long unzip(String srcPath, String destPath) throws Exception {
        int processExitValue;
        long start = System.currentTimeMillis();
        File srcFile = new File(srcPath);
        File destFile = new File(destPath);
        LOGGER.info("---------------------------------------------------------");
        LOGGER.info("SEVEN-ZIP-UTIL :: Decompressing file: " + srcFile);
        ArrayList<String> commandList = new ArrayList<String>();
        commandList.add(sevenZipPath);
        commandList.add("x");
        commandList.add("-y");
        commandList.add(srcFile.getCanonicalPath());
        commandList.add("-o" + destFile.getCanonicalPath().trim());
        Process zipProcess = null;
        BufferedReader inpBuff = null;
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(commandList);
            zipProcess = processBuilder.start();
            inpBuff = new BufferedReader(new InputStreamReader(zipProcess.getInputStream()));
            while (true) {
                String processConsoleOut;
                if ((processConsoleOut = inpBuff.readLine()) == null) break;
                LOGGER.info("SEVEN-ZIP-UTIL :: " + processConsoleOut);
            }
            zipProcess.waitFor();
            processExitValue = zipProcess.exitValue();
            if (processExitValue != 0) {
                if (processExitValue == 1) {
                    throw new Exception("SEVEN-ZIP-UTIL :: Decompression aborted prematurely with exit value - " + processExitValue);
                }
                if (processExitValue == 2) {
                    throw new Exception("SEVEN-ZIP-UTIL :: Decompression aborted due to FATAL ERROR, exit value - " + processExitValue);
                }
                if (processExitValue == 8) {
                    throw new Exception("SEVEN-ZIP-UTIL :: Decompression aborted due to out of memory with exit value - " + processExitValue);
                }
                if (processExitValue == 255) {
                    throw new Exception("SEVEN-ZIP-UTIL :: Decompression unexpectedly stopped due to SIGINT, exit value - " + processExitValue);
                }
                throw new Exception("SEVEN-ZIP-UTIL :: Decompression aborted with exit value - " + processExitValue);
            }
        }
        finally {
            if (inpBuff != null) {
                inpBuff.close();
            }
            if (zipProcess != null) {
                zipProcess.destroy();
            }
        }
        LOGGER.info("SEVEN-ZIP-UTIL :: Decompression Ended with value - " + processExitValue);
        return System.currentTimeMillis() - start;
    }
}

