/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.commons.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ZipUtil {
    private String encoding;
    static final int BUFFER = 2048;
    private static final Logger LOGGER = LogManager.getLogger((String)"XNode");

    public ZipUtil() {
        this.encoding = "UTF-8";
    }

    public ZipUtil(String encoding) {
        this.encoding = encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(String srcDirPath, String zipFileName) {
        FileOutputStream fos = null;
        ZipOutputStream zos = null;
        try {
            ArrayList<String> filesListInDir = new ArrayList<String>();
            File srcDirFile = new File(srcDirPath);
            ZipUtil.populateFilesList(srcDirFile, filesListInDir);
            fos = new FileOutputStream(zipFileName);
            zos = new ZipOutputStream(fos);
            for (String filePath : filesListInDir) {
                FileInputStream fis = null;
                try {
                    int len;
                    ZipEntry ze = new ZipEntry(filePath.substring(srcDirFile.getAbsolutePath().length() + 1, filePath.length()));
                    zos.putNextEntry(ze);
                    fis = new FileInputStream(filePath);
                    byte[] buffer = new byte[1024];
                    while ((len = fis.read(buffer)) > 0) {
                        zos.write(buffer, 0, len);
                    }
                    zos.closeEntry();
                }
                finally {
                    if (fis == null) continue;
                    fis.close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (zos != null) {
                    zos.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private static void populateFilesList(File dir, List<String> filesListInDir) throws IOException {
        File[] files;
        for (File file : files = dir.listFiles()) {
            if (file.isFile()) {
                filesListInDir.add(file.getAbsolutePath());
                continue;
            }
            ZipUtil.populateFilesList(file, filesListInDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unZip(String sourceZipPath, String destDirPath) {
        File destDir = new File(destDirPath);
        ZipFile zip = null;
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        try {
            zip = new ZipFile(sourceZipPath);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String entryName = entry.getName();
                File destFile = new File(destDir, entryName);
                if (!destFile.toPath().normalize().startsWith(destDir.toPath())) {
                    throw new Exception("Entry is outside of the target directory: " + entry.getName());
                }
                InputStream input = zip.getInputStream(entry);
                Files.copy(input, destFile.getCanonicalFile().toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                zip.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int unZip(File zipFile, File destinationFolder, List<String> includeFileList, List<String> excludeFileList, String archivePassword) throws IOException, InterruptedException {
        int exitValue1;
        LOGGER.info("---------------------------------------------------------");
        LOGGER.info("ZIP-UTIL :: Extract ZipFile - " + zipFile);
        String bitVersion = Integer.parseInt(System.getProperty("sun.arch.data.model")) == 64 ? "x86-64" : "x86";
        String sevenZipPath = System.getProperty("tools.dir") + File.separator + "archiver" + File.separator + "windows" + File.separator + bitVersion + File.separator + "7za.exe";
        if (System.getProperty("tools.dir") == null) {
            sevenZipPath = System.getProperty("server.home") + File.separator + "tools" + File.separator + "archiver" + File.separator + "windows" + File.separator + bitVersion + File.separator + "7za.exe";
        }
        ArrayList<String> commandList = new ArrayList<String>();
        commandList.add(sevenZipPath);
        commandList.add("x");
        commandList.add(zipFile.getCanonicalPath());
        commandList.add("-y");
        commandList.add("-o" + (destinationFolder == null ? "tmp" : destinationFolder.getCanonicalPath()));
        if (includeFileList != null) {
            for (String ipBuf : includeFileList) {
                commandList.add("-i!" + ipBuf);
            }
        }
        if (excludeFileList != null) {
            for (String ipBuf : excludeFileList) {
                commandList.add("-x!" + ipBuf);
            }
        }
        if (archivePassword != null && archivePassword.trim().length() > 0) {
            commandList.add("-p\"" + archivePassword + '\"');
        }
        Process start1 = null;
        BufferedReader ipBuf1 = null;
        boolean exitValue = true;
        try {
            start1 = ZipUtil.executeCommand(commandList);
            ipBuf1 = new BufferedReader(new InputStreamReader(start1.getInputStream()));
            String line = null;
            while (true) {
                if ((line = ipBuf1.readLine()) == null) {
                    start1.waitFor();
                    exitValue1 = start1.exitValue();
                    break;
                }
                LOGGER.info(line);
            }
        }
        finally {
            if (ipBuf1 != null) {
                ipBuf1.close();
            }
            if (start1 != null) {
                start1.destroy();
            }
        }
        LOGGER.info("ZIP-UTIL :: Exiting ZipFile extraction with value - [{0}]", (Object)exitValue1);
        LOGGER.info("---------------------------------------------------------");
        return exitValue1;
    }

    private static Process executeCommand(List<String> commandList) throws IOException {
        ProcessBuilder processBuilder = null;
        StringBuilder sb = new StringBuilder("[");
        for (String string : commandList) {
            if (string.startsWith("-p")) {
                string = "-p*****";
            }
            sb.append(string).append(", ");
        }
        sb.append("]");
        processBuilder = new ProcessBuilder(commandList);
        return processBuilder.start();
    }
}

