/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.commons.lucene;

import com.manageengine.dataengine.commons.lucene.ACLJsonTokenizerFactory;
import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordTokenizerFactory;
import org.apache.lucene.analysis.core.LowerCaseFilterFactory;
import org.apache.lucene.analysis.core.WhitespaceTokenizerFactory;
import org.apache.lucene.analysis.custom.CustomAnalyzer;

public enum LuceneAnalyzer {
    KEYWORD_LOWERCASE{

        @Override
        public Analyzer analyzer() throws IOException {
            CustomAnalyzer analyzer = CustomAnalyzer.builder().withTokenizer(KeywordTokenizerFactory.class, new String[0]).addTokenFilter(LowerCaseFilterFactory.class, new String[0]).build();
            return analyzer;
        }

        public String toString() {
            return "KEYWORD_LOWERCASE";
        }
    }
    ,
    WHITESPACE_LOWERCASE{

        @Override
        public Analyzer analyzer() throws IOException {
            CustomAnalyzer analyzer = CustomAnalyzer.builder().withTokenizer(WhitespaceTokenizerFactory.class, new String[0]).addTokenFilter(LowerCaseFilterFactory.class, new String[0]).build();
            return analyzer;
        }

        public String toString() {
            return "WHITESPACE_LOWERCASE";
        }
    }
    ,
    ACL_JSON_LOWERCASE{

        @Override
        public Analyzer analyzer() throws IOException {
            CustomAnalyzer analyzer = CustomAnalyzer.builder().withTokenizer(ACLJsonTokenizerFactory.class, new String[0]).addTokenFilter(LowerCaseFilterFactory.class, new String[0]).build();
            return analyzer;
        }

        public String toString() {
            return "ACL_JSON_LOWERCASE";
        }
    };


    public static LuceneAnalyzer get(String analyzerStr) {
        for (LuceneAnalyzer analyzer : LuceneAnalyzer.values()) {
            if (!analyzer.toString().equalsIgnoreCase(analyzerStr)) continue;
            return analyzer;
        }
        return null;
    }

    public abstract Analyzer analyzer() throws IOException;
}

