/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.commons.lucene;

import com.manageengine.dataengine.commons.lucene.CaseInsensitiveWhitespaceAnalyzer;
import java.util.Stack;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneQueryConstructor {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"DataEngineLogger");

    public static Query constructMultiQuery(String queryStr) {
        BooleanQuery.Builder booleanQuery = new BooleanQuery.Builder();
        try {
            int len = queryStr.length();
            String oper = null;
            int index = 0;
            int endIndex = 0;
            while (index < len) {
                endIndex = index;
                Query query = null;
                if (queryStr.charAt(index) != '[' && queryStr.charAt(index) != '(') {
                    oper = LuceneQueryConstructor.getOperator(queryStr, index);
                    if (oper != null) {
                        endIndex = index + oper.length() - 1;
                    }
                } else if (queryStr.charAt(index) == '[') {
                    endIndex = LuceneQueryConstructor.getMultiQueryEndIndex(queryStr, index);
                    query = LuceneQueryConstructor.constructMultiQuery(queryStr.substring(index + 1, endIndex));
                } else if (queryStr.charAt(index) == '(') {
                    endIndex = queryStr.indexOf(41, index);
                    query = LuceneQueryConstructor.constructSingleQuery(queryStr.substring(index + 1, endIndex));
                }
                if (query != null) {
                    if (oper == null) {
                        oper = LuceneQueryConstructor.getOperator(queryStr, endIndex + 1);
                    }
                    if (oper == null) {
                        booleanQuery.add(query, BooleanClause.Occur.MUST);
                    } else if (oper.equals("AND")) {
                        booleanQuery.add(query, BooleanClause.Occur.MUST);
                    } else {
                        booleanQuery.add(query, BooleanClause.Occur.SHOULD);
                    }
                }
                index = endIndex + 1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return booleanQuery.build();
    }

    public static Query constructSingleQuery(String queryStr) {
        String[] queryTokens = null;
        Query query = null;
        try {
            if (queryStr.contains("!=")) {
                queryTokens = queryStr.split("!=");
                String[] fields = queryTokens[0].split(",");
                MultiFieldQueryParser parser = new MultiFieldQueryParser(fields, (Analyzer)new CaseInsensitiveWhitespaceAnalyzer());
                parser.setAllowLeadingWildcard(true);
                BooleanQuery.Builder booleanQuery = new BooleanQuery.Builder();
                booleanQuery.add(new BooleanClause((Query)new MatchAllDocsQuery(), BooleanClause.Occur.SHOULD));
                booleanQuery.add(new BooleanClause(parser.parse(LuceneQueryConstructor.escape(queryTokens[1])), BooleanClause.Occur.MUST_NOT));
                query = booleanQuery.build();
            } else if (queryStr.contains("<=")) {
                queryTokens = queryStr.split("<=");
                query = LuceneQueryConstructor.longRangeQuery(queryTokens[0], null, Long.parseLong(queryTokens[1]), false, true);
            } else if (queryStr.contains(">=")) {
                queryTokens = queryStr.split(">=");
                query = LuceneQueryConstructor.longRangeQuery(queryTokens[0], Long.parseLong(queryTokens[1]), null, true, false);
            } else if (queryStr.contains("<")) {
                queryTokens = queryStr.split("<");
                query = LuceneQueryConstructor.longRangeQuery(queryTokens[0], null, Long.parseLong(queryTokens[1]), false, false);
            } else if (queryStr.contains(">")) {
                queryTokens = queryStr.split(">");
                query = LuceneQueryConstructor.longRangeQuery(queryTokens[0], Long.parseLong(queryTokens[1]), null, false, false);
            } else if (queryStr.contains("=")) {
                queryTokens = queryStr.split("=");
                String[] fields = queryTokens[0].split(",");
                MultiFieldQueryParser parser = new MultiFieldQueryParser(fields, (Analyzer)new CaseInsensitiveWhitespaceAnalyzer());
                parser.setAllowLeadingWildcard(true);
                query = parser.parse(LuceneQueryConstructor.escape(queryTokens[1]));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return query;
    }

    public static Query longRangeQuery(String field, Long lowerTerm, Long upperTerm, boolean includeLower, boolean includeUpper) {
        long l = Long.MIN_VALUE;
        long u = Long.MAX_VALUE;
        if (lowerTerm != null) {
            l = lowerTerm;
            if (!includeLower) {
                if (l == Long.MAX_VALUE) {
                    return new MatchNoDocsQuery();
                }
                ++l;
            }
        }
        if (upperTerm != null) {
            u = upperTerm;
            if (!includeUpper) {
                if (u == Long.MIN_VALUE) {
                    return new MatchNoDocsQuery();
                }
                --u;
            }
        }
        return LongPoint.newRangeQuery((String)field, (long)l, (long)u);
    }

    public static String removeExtraBrac(String queryStr) {
        String prosQueryStr = queryStr;
        boolean more = true;
        while (more) {
            more = false;
            int closeBracIndex = 0;
            int openBracIndex = 0;
            while (openBracIndex != -1 && closeBracIndex != -1) {
                String endPh;
                openBracIndex = prosQueryStr.lastIndexOf("[", closeBracIndex = prosQueryStr.indexOf("]", closeBracIndex + 1));
                if (openBracIndex == -1 || closeBracIndex == -1) continue;
                String subTerm = prosQueryStr.substring(openBracIndex, closeBracIndex + 1);
                if (subTerm.indexOf("(") == subTerm.lastIndexOf("(")) {
                    subTerm = subTerm.substring(1, subTerm.length() - 1);
                    more = true;
                }
                String startph = openBracIndex == 0 ? "" : prosQueryStr.substring(0, openBracIndex);
                String string = endPh = closeBracIndex == prosQueryStr.length() - 1 ? "" : prosQueryStr.substring(closeBracIndex + 1);
                while (startph.endsWith("[") && endPh.startsWith("]")) {
                    startph = startph.substring(0, startph.length() - 1);
                    endPh = endPh.substring(1);
                }
                prosQueryStr = startph + subTerm + endPh;
            }
        }
        return prosQueryStr;
    }

    private static int getMultiQueryEndIndex(String queryStr, int beginIndex) throws Exception {
        Stack<Character> stack = new Stack<Character>();
        int queryStrLen = queryStr.length();
        int endIndex = -1;
        for (int i = beginIndex; i < queryStrLen; ++i) {
            char curChar = queryStr.charAt(i);
            if (curChar == '[') {
                stack.push(Character.valueOf(curChar));
                continue;
            }
            if (curChar != ']') continue;
            if (!stack.isEmpty() && stack.pop() != null) {
                if (!stack.isEmpty()) continue;
                endIndex = i;
                break;
            }
            throw new Exception("Query - bracket parsing exception");
        }
        return endIndex;
    }

    private static String getOperator(String queryStr, int beginIndex) throws Exception {
        int len;
        String oper = null;
        if (queryStr != null && beginIndex < (len = queryStr.length())) {
            String subStr = queryStr.substring(beginIndex);
            if (subStr.startsWith("AND")) {
                oper = "AND";
            } else if (subStr.startsWith("OR")) {
                oper = "OR";
            }
        }
        return oper;
    }

    private static String escape(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '+' || c == '-' || c == '!' || c == '(' || c == ')' || c == ':' || c == '^' || c == '[' || c == ']' || c == '{' || c == '}' || c == '~' || c == '|' || c == '&') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

