/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.commons.utils;

public class BasicComponentState {
    private volatile State state = State.IDLE;

    public State state() {
        return this.state;
    }

    public boolean idle() {
        return this.state == State.IDLE;
    }

    public boolean started() {
        return this.state == State.STARTED;
    }

    public boolean stopped() {
        return this.state == State.STOPPED;
    }

    public boolean closed() {
        return this.state == State.CLOSED;
    }

    public boolean failed() {
        return this.state == State.FAILED;
    }

    public boolean canMoveToStarted() throws IllegalStateException {
        State localState = this.state;
        if (localState == State.IDLE || localState == State.STOPPED || localState == State.FAILED) {
            return true;
        }
        if (localState == State.STARTED) {
            return false;
        }
        if (localState == State.CLOSED) {
            throw new IllegalStateException("Can't move to started state when closed");
        }
        throw new IllegalStateException("Can't move to started with unknown state");
    }

    public boolean moveToStarted() throws IllegalStateException {
        State localState = this.state;
        if (localState == State.IDLE || localState == State.STOPPED || localState == State.FAILED) {
            this.state = State.STARTED;
            return true;
        }
        if (localState == State.STARTED) {
            return false;
        }
        if (localState == State.CLOSED) {
            throw new IllegalStateException("Can't move to started state when closed");
        }
        throw new IllegalStateException("Can't move to started with unknown state");
    }

    public boolean canMoveToStopped() throws IllegalStateException {
        State localState = this.state;
        if (localState == State.STARTED) {
            return true;
        }
        if (localState == State.STOPPED || localState == State.IDLE || localState == State.FAILED) {
            return false;
        }
        if (localState == State.CLOSED) {
            throw new IllegalStateException("Can't move to stopped state when closed");
        }
        throw new IllegalStateException("Can't move to stopped with unknown state");
    }

    public boolean moveToStopped() throws IllegalStateException {
        State localState = this.state;
        if (localState == State.STARTED) {
            this.state = State.STOPPED;
            return true;
        }
        if (localState == State.STOPPED || localState == State.IDLE || localState == State.FAILED) {
            return false;
        }
        if (localState == State.CLOSED) {
            throw new IllegalStateException("Can't move to stopped state when closed");
        }
        throw new IllegalStateException("Can't move to stopped with unknown state");
    }

    public boolean canMoveToClosed() throws IllegalStateException {
        State localState = this.state;
        return localState != State.CLOSED;
    }

    public boolean moveToClosed() throws IllegalStateException {
        State localState = this.state;
        if (localState == State.CLOSED) {
            return false;
        }
        this.state = State.CLOSED;
        return true;
    }

    public boolean canMoveToFailed() throws IllegalStateException {
        State localState = this.state;
        if (localState == State.STARTED) {
            return true;
        }
        if (localState == State.IDLE || localState == State.FAILED || localState == State.STOPPED) {
            return false;
        }
        if (localState == State.CLOSED) {
            throw new IllegalStateException("Can't move to failed state when closed");
        }
        throw new IllegalStateException("Can't move to failed with unknown state");
    }

    public boolean moveToFailed() throws IllegalStateException {
        State localState = this.state;
        if (localState == State.STARTED) {
            this.state = State.FAILED;
            return true;
        }
        if (localState == State.IDLE || localState == State.FAILED || localState == State.STOPPED) {
            return false;
        }
        if (localState == State.CLOSED) {
            throw new IllegalStateException("Can't move to failed state when closed");
        }
        throw new IllegalStateException("Can't move to failed with unknown state");
    }

    public String toString() {
        return this.state.toString();
    }

    public static enum State {
        IDLE{

            public String toString() {
                return "IDLE";
            }
        }
        ,
        STARTED{

            public String toString() {
                return "STARTED";
            }
        }
        ,
        STOPPED{

            public String toString() {
                return "STOPPED";
            }
        }
        ,
        FAILED{

            public String toString() {
                return "FAILED";
            }
        }
        ,
        CLOSED{

            public String toString() {
                return "CLOSED";
            }
        };

    }
}

