/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.commons.utils;

import com.manageengine.dataengine.commons.utils.BasicComponentState;

public abstract class BasicNonBlockingComponent {
    private BasicComponentState componentState = new BasicComponentState();

    public final boolean start() throws Exception {
        return this.changeStateTo(BasicComponentState.State.STARTED);
    }

    protected abstract boolean doStart() throws Exception;

    public final boolean stop() throws Exception {
        return this.changeStateTo(BasicComponentState.State.STOPPED);
    }

    protected abstract boolean doStop() throws Exception;

    public final boolean close() throws Exception {
        return this.changeStateTo(BasicComponentState.State.CLOSED);
    }

    protected abstract boolean doClose() throws Exception;

    public final boolean fail() throws Exception {
        return this.changeStateTo(BasicComponentState.State.FAILED);
    }

    protected abstract boolean doFail() throws Exception;

    public final synchronized boolean changeStateTo(BasicComponentState.State toState) throws Exception {
        boolean status = false;
        if (toState == BasicComponentState.State.STARTED) {
            if (!this.componentState.canMoveToStarted()) {
                return false;
            }
            status = this.doStart();
            if (status) {
                this.componentState.moveToStarted();
            }
        } else if (toState == BasicComponentState.State.STOPPED) {
            if (!this.componentState.canMoveToStopped()) {
                return false;
            }
            status = this.doStop();
            if (status) {
                this.componentState.moveToStopped();
            }
        } else if (toState == BasicComponentState.State.FAILED) {
            if (!this.componentState.canMoveToFailed()) {
                return false;
            }
            status = this.doFail();
            if (status) {
                this.componentState.moveToFailed();
            }
        } else if (toState == BasicComponentState.State.CLOSED) {
            if (!this.componentState.canMoveToClosed()) {
                return false;
            }
            status = this.doClose();
            if (status) {
                this.componentState.moveToClosed();
            }
        } else {
            throw new IllegalStateException("Can't move to " + (Object)((Object)toState) + " state!");
        }
        return status;
    }
}

