/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.commons.utils;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;
import org.joda.time.chrono.ISOChronology;

public enum DateTimeUnit {
    YEAR("year"){

        @Override
        public DateTimeField field(DateTimeZone tz) {
            return ISOChronology.getInstance((DateTimeZone)tz).yearOfCentury();
        }

        @Override
        public String format() {
            return "yyyy";
        }

        @Override
        public Period period(int val) {
            return Period.years((int)val);
        }
    }
    ,
    MONTH("month"){

        @Override
        public DateTimeField field(DateTimeZone tz) {
            return ISOChronology.getInstance((DateTimeZone)tz).monthOfYear();
        }

        @Override
        public String format() {
            return "MMM yyyy";
        }

        @Override
        public Period period(int val) {
            return Period.months((int)val);
        }
    }
    ,
    WEEK("week"){

        @Override
        public DateTimeField field(DateTimeZone tz) {
            return ISOChronology.getInstance((DateTimeZone)tz).weekOfWeekyear();
        }

        @Override
        public String format() {
            return "xxxx-ww";
        }

        @Override
        public Period period(int val) {
            return Period.weeks((int)val);
        }
    }
    ,
    DAY("day"){

        @Override
        public DateTimeField field(DateTimeZone tz) {
            return ISOChronology.getInstance((DateTimeZone)tz).dayOfMonth();
        }

        @Override
        public String format() {
            return "dd MMM";
        }

        @Override
        public Period period(int val) {
            return Period.days((int)val);
        }
    }
    ,
    HOUR("hour"){

        @Override
        public DateTimeField field(DateTimeZone tz) {
            return ISOChronology.getInstance((DateTimeZone)tz).hourOfDay();
        }

        @Override
        public String format() {
            return "dd, HH:mm";
        }

        @Override
        public Period period(int val) {
            return Period.hours((int)val);
        }
    }
    ,
    MINUTE("minute"){

        @Override
        public DateTimeField field(DateTimeZone tz) {
            return ISOChronology.getInstance((DateTimeZone)tz).minuteOfHour();
        }

        @Override
        public String format() {
            return "HH-mm";
        }

        @Override
        public Period period(int val) {
            return Period.minutes((int)val);
        }
    }
    ,
    SECOND("second"){

        @Override
        public DateTimeField field(DateTimeZone tz) {
            return ISOChronology.getInstance((DateTimeZone)tz).secondOfMinute();
        }

        @Override
        public String format() {
            return "HH-mm-ss";
        }

        @Override
        public Period period(int val) {
            return Period.seconds((int)val);
        }
    };

    private String unitName;

    private DateTimeUnit(String unitName) {
        this.unitName = unitName;
    }

    public static DateTimeUnit get(String unit) {
        for (DateTimeUnit dateTimeUnit : DateTimeUnit.values()) {
            if (!dateTimeUnit.unitName.equalsIgnoreCase(unit)) continue;
            return dateTimeUnit;
        }
        return null;
    }

    public abstract DateTimeField field(DateTimeZone var1);

    public abstract String format();

    public abstract Period period(int var1);

    public static String getTodayDate(Long time) {
        String dateFormat = "MMM dd,yyyy";
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        sdf.setTimeZone(TimeZone.getDefault());
        return sdf.format(new Date(time));
    }
}

