/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.commons.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;

public class ExecuteWinProcess {
    private String[] commandList;
    private Map<String, String> environment;
    private static final long TIMEOUT = 120000L;
    private StringBuffer inputStrBuffer;
    private StringBuffer errorStrBuffer;

    public ExecuteWinProcess(String[] commandList, Map<String, String> environment) {
        this.commandList = commandList;
        this.environment = environment;
        this.inputStrBuffer = new StringBuffer();
        this.errorStrBuffer = new StringBuffer();
    }

    public void start() throws Exception {
        this.createAndRunProcess();
    }

    public String getInputStream() {
        return this.inputStrBuffer.toString();
    }

    public String getErrorStream() {
        return this.errorStrBuffer.toString();
    }

    private void createAndRunProcess() throws Exception {
        ProcessBuilder pb = new ProcessBuilder(this.commandList);
        Map<String, String> pbEnv = pb.environment();
        if (this.environment != null && !this.environment.isEmpty()) {
            pbEnv.putAll(this.environment);
        }
        Process processHandle = pb.start();
        processHandle.waitFor();
        this.readStream(0, processHandle);
        this.readStream(1, processHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readStream(int streamType, Process processHandle) throws IOException {
        block19: {
            String bufferValue = null;
            long startTime = System.currentTimeMillis();
            InputStream inputStream = null;
            if (streamType == 0) {
                inputStream = processHandle.getInputStream();
            } else if (streamType == 1) {
                inputStream = processHandle.getErrorStream();
            } else {
                throw new IllegalArgumentException("Unsupported stream type!");
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
            block11: while (true) {
                while (true) {
                    if (br.ready()) {
                        bufferValue = br.readLine();
                        this.writeBuffer(streamType, bufferValue);
                        if (!this.stopProcess(processHandle, startTime)) continue;
                        break block19;
                    }
                    try {
                        processHandle.exitValue();
                        break block19;
                    }
                    catch (IllegalThreadStateException itse) {
                        try {
                            Thread.sleep(100L);
                            if (!this.stopProcess(processHandle, startTime)) continue block11;
                            break block19;
                        }
                        catch (InterruptedException ex) {
                            ex.printStackTrace();
                            continue;
                        }
                    }
                    break;
                }
                break;
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException iee) {
                        iee.printStackTrace();
                    }
                }
            }
        }
    }

    private void writeBuffer(int streamType, String bufferValue) {
        if (streamType == 0) {
            this.inputStrBuffer = this.inputStrBuffer.append(bufferValue).append("\n");
        } else {
            this.errorStrBuffer = this.errorStrBuffer.append(bufferValue).append("\n");
        }
    }

    private boolean stopProcess(Process proc, long startTime) {
        if (System.currentTimeMillis() - startTime > 120000L) {
            this.writeBuffer(1, "ERROR - timeout!");
            proc.destroy();
            return true;
        }
        return false;
    }
}

