/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.commons.utils;

import com.manageengine.dataengine.commons.connector.ConnectorType;
import com.manageengine.dataengine.commons.utils.Settings;
import java.nio.file.Path;
import org.apache.lucene.util.SetOnce;

public class Setting<T> {
    private String key;
    private T value = null;
    private SetOnce<T> setOnceValue = new SetOnce();
    private T defaultValue;
    private boolean isSetOnce = false;

    private Setting(String key, T defaultValue) {
        this.key = key;
        this.defaultValue = defaultValue;
    }

    private Setting(String key, T defaultValue, boolean setOnce) {
        this.key = key;
        this.defaultValue = defaultValue;
        this.isSetOnce = setOnce;
    }

    public String getKey() {
        return this.key;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public void set(T value) {
        if (this.isSetOnce) {
            this.setOnceValue.set(value);
        } else {
            this.value = value;
        }
    }

    public T value() {
        if (this.isSetOnce) {
            return (T)this.setOnceValue.get();
        }
        return this.value;
    }

    public boolean isSet() {
        if (this.isSetOnce) {
            return this.setOnceValue.get() != null;
        }
        return this.value != null;
    }

    public static Setting<Integer> intSetting(String key, int defaultValue) {
        return new Setting<Integer>(key, defaultValue);
    }

    public static Setting<Long> longSetting(String key, long defaultValue) {
        return new Setting<Long>(key, defaultValue);
    }

    public static Setting<Boolean> boolSetting(String key, boolean defaultValue) {
        return new Setting<Boolean>(key, defaultValue);
    }

    public static Setting<String> stringSetting(String key, String defaultValue) {
        return new Setting<String>(key, defaultValue);
    }

    public static Setting<Path> pathSetting(String key, Path defaultValue) {
        return new Setting<Path>(key, defaultValue);
    }

    public static Setting<ConnectorType> connectorTypeSetting(String key, ConnectorType defaultValue) {
        return new Setting<ConnectorType>(key, defaultValue);
    }

    public static Setting<Integer> intSetOnceSetting(String key, int defaultValue) {
        return new Setting<Integer>(key, defaultValue, true);
    }

    public static Setting<Long> longSetOnceSetting(String key, long defaultValue) {
        return new Setting<Long>(key, defaultValue, true);
    }

    public static Setting<Boolean> boolSetOnceSetting(String key, boolean defaultValue) {
        return new Setting<Boolean>(key, defaultValue, true);
    }

    public static Setting<String> stringSetOnceSetting(String key, String defaultValue) {
        return new Setting<String>(key, defaultValue, true);
    }

    public static Setting<Path> pathSetOnceSetting(String key, Path defaultValue) {
        return new Setting<Path>(key, defaultValue);
    }

    public static Setting<ConnectorType> connectorTypeSetOnceSetting(String key, ConnectorType defaultValue) {
        return new Setting<ConnectorType>(key, defaultValue, true);
    }

    public T get(Settings settings) {
        return (T)settings.get(this.getKey(), this.getDefaultValue());
    }
}

