/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.commons.utils;

import com.manageengine.dataengine.commons.file.PropertiesFileUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.Properties;

public class WinServiceUtil {
    public static boolean isRunningAsService(String serviceName) {
        try {
            String line = null;
            Process process = Runtime.getRuntime().exec("sc query \"" + serviceName + "\"");
            BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = in.readLine()) != null) {
                if (!line.contains("RUNNING")) continue;
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean isWrapperRunningAsService(String wrapperFilePath) {
        boolean isService = false;
        try {
            String serviceName = WinServiceUtil.getServiceNameFromWrapper(wrapperFilePath);
            isService = WinServiceUtil.isRunningAsService(serviceName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isService;
    }

    public static String getServiceNameFromWrapper(String wrapperFilePath) {
        String serviceName = null;
        try {
            if (new File(wrapperFilePath).exists()) {
                Properties props = PropertiesFileUtil.getProperties(wrapperFilePath);
                serviceName = props.getProperty("wrapper.ntservice.name");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return serviceName;
    }
}

