/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode;

import java.io.PrintStream;

public final class Version {
    public static final Version XNODE_1000 = new Version(1, 0, 0, 1000);
    public static final Version XNODE_1010 = new Version(1, 0, 1, 1010);
    public static final Version XNODE_1011 = new Version(1, 0, 1, 1011);
    public static final Version XNODE_1012 = new Version(1, 0, 1, 1012);
    public static final Version XNODE_1013 = new Version(1, 0, 1, 1013);
    public static final Version XNODE_1014 = new Version(1, 0, 1, 1014);
    public static final Version XNODE_1015 = new Version(1, 0, 1, 1015);
    public static final Version XNODE_1016 = new Version(1, 0, 1, 1016);
    public static final Version XNODE_1100 = new Version(1, 1, 0, 1100);
    public static final Version XNODE_1101 = new Version(1, 1, 0, 1101);
    public static final Version XNODE_1102 = new Version(1, 1, 0, 1102);
    public static final Version XNODE_1103 = new Version(1, 1, 0, 1103);
    public static final Version XNODE_1104 = new Version(1, 1, 0, 1104);
    public static final Version XNODE_1105 = new Version(1, 1, 0, 1105);
    public static final Version XNODE_1106 = new Version(1, 1, 0, 1106);
    public static final Version XNODE_1107 = new Version(1, 1, 0, 1107);
    public static final Version XNODE_1108 = new Version(1, 1, 0, 1108);
    public static final Version XNODE_1200 = new Version(1, 2, 0, 1200);
    public static final Version XNODE_1201 = new Version(1, 2, 0, 1201);
    public static final Version XNODE_1202 = new Version(1, 2, 0, 1202);
    public static final Version XNODE_1203 = new Version(1, 2, 0, 1203);
    public static final Version XNODE_1204 = new Version(1, 2, 0, 1204);
    public static final Version XNODE_1205 = new Version(1, 2, 0, 1205);
    public static final Version XNODE_1206 = new Version(1, 2, 0, 1206);
    public static final Version XNODE_1207 = new Version(1, 2, 0, 1207);
    public static final Version XNODE_1300 = new Version(1, 3, 0, 1300);
    public static final Version XNODE_1301 = new Version(1, 3, 0, 1301);
    public static final Version XNODE_1302 = new Version(1, 3, 0, 1302);
    public static final Version XNODE_1303 = new Version(1, 3, 0, 1303);
    public static final Version XNODE_1304 = new Version(1, 3, 0, 1304);
    public static final Version XNODE_1305;
    public static final Version LATEST;
    private final int major;
    private final int minor;
    private final int revision;
    private final int build;
    private int seqNumber;
    private static int counter;

    private Version(int major, int minor, int revision, int build) {
        this.major = major;
        this.minor = minor;
        this.revision = revision;
        this.build = build;
        this.seqNumber = counter++;
        if (major > 255 || major < 0) {
            throw new IllegalArgumentException("Illegal major version: " + major);
        }
        if (minor > 9 || minor < 0) {
            throw new IllegalArgumentException("Illegal minor version: " + minor);
        }
        if (revision > 9 || revision < 0) {
            throw new IllegalArgumentException("Illegal revision version: " + revision);
        }
        if (build < 0) {
            throw new IllegalArgumentException("Illegal build number: " + build);
        }
    }

    public int majorVersion() {
        return this.major;
    }

    public int minorVersion() {
        return this.minor;
    }

    public int revisionVersion() {
        return this.revision;
    }

    public int buildNumber() {
        return this.build;
    }

    public int seqNumber() {
        return this.seqNumber;
    }

    public String toString() {
        return String.format("DataEngine-XNode %d.%d.%d (%d)", this.major, this.minor, this.revision, this.build);
    }

    public String toMinString() {
        return String.format("DE-XNode_%d", this.build);
    }

    public boolean equals(Object o) {
        return o != null && o instanceof Version && ((Version)o).seqNumber() == this.seqNumber();
    }

    public int hashCode() {
        return this.seqNumber;
    }

    public boolean isLessThan(Version version) {
        return this.seqNumber() < version.seqNumber();
    }

    public boolean isGreaterThan(Version version) {
        return this.seqNumber() > version.seqNumber();
    }

    public static void main(String[] args) {
        PrintStream outStream = System.out;
        outStream.println(LATEST.toString());
    }

    static {
        LATEST = XNODE_1305 = new Version(1, 3, 0, 1305);
        counter = 0;
    }
}

