/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.bootstrap;

import com.manageengine.dataengine.commons.crypto.CryptoUtil;
import com.manageengine.dataengine.commons.file.PropertiesFileUtil;
import com.manageengine.dataengine.commons.notify.Notifications;
import com.manageengine.dataengine.commons.utils.DateTimeUnit;
import com.manageengine.dataengine.xnode.bootstrap.BootstrapSettings;
import com.manageengine.dataengine.xnode.connector.ConnectorSettings;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.SecureRandom;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Environment
implements BootstrapSettings,
ConnectorSettings {
    private static final Logger LOGGER = LogManager.getLogger((String)"XNode");
    private static final Object CONF_FILE_LOCK = new Object();

    public static void initialize() throws Exception {
        Environment.initializeBootstrapSettings();
        Environment.initializeConnectorSettings();
        Environment.loadFromConfFile();
    }

    private static void initializeBootstrapSettings() throws Exception {
        String homeDir = System.getProperty("xnode.home");
        if (homeDir == null) {
            throw new RuntimeException("xnode.home property not set!");
        }
        XNODE_HOME_DIR.set((Object)Paths.get(homeDir, new String[0]));
        XNODE_BIN_DIR.set((Object)((Path)XNODE_HOME_DIR.value()).resolve("bin"));
        XNODE_DB_DIR.set((Object)((Path)XNODE_HOME_DIR.value()).resolve("db"));
        XNODE_LIB_DIR.set((Object)((Path)XNODE_HOME_DIR.value()).resolve("lib"));
        XNODE_CONF_DIR.set((Object)((Path)XNODE_HOME_DIR.value()).resolve("conf"));
        XNODE_DR_CONF_DIR.set((Object)((Path)XNODE_CONF_DIR.value()).resolve("datarepository"));
        XNODE_DR_SCHEMA_DIR.set((Object)((Path)XNODE_DR_CONF_DIR.value()).resolve("schema"));
        XNODE_SCHEDULER_CONF_DIR.set((Object)((Path)XNODE_CONF_DIR.value()).resolve("scheduler"));
        XNODE_DATA_MAIN_DIR.set((Object)((Path)XNODE_HOME_DIR.value()).resolve("data").resolve("main"));
        XNODE_LOGS_DIR.set((Object)((Path)XNODE_HOME_DIR.value()).resolve("logs"));
        XNODE_CONF_FILE_NAME.set(XNODE_CONF_FILE_NAME.getDefaultValue());
        XNODE_CONF_FILE.set((Object)((Path)XNODE_CONF_DIR.value()).resolve((String)XNODE_CONF_FILE_NAME.value()));
        XNODE_DR_CONF_FILE_NAME.set(XNODE_DR_CONF_FILE_NAME.getDefaultValue());
        XNODE_DR_CONF_FILE.set((Object)((Path)XNODE_DR_CONF_DIR.value()).resolve((String)XNODE_DR_CONF_FILE_NAME.value()));
        XNODE_DR_ARCHIVE_LOCATIONS_CONF_FILE_NAME.set(XNODE_DR_ARCHIVE_LOCATIONS_CONF_FILE_NAME.getDefaultValue());
        XNODE_DR_ARCHIVE_LOCATIONS_CONF_FILE.set((Object)((Path)XNODE_DR_CONF_DIR.value()).resolve((String)XNODE_DR_ARCHIVE_LOCATIONS_CONF_FILE_NAME.value()));
        String dataArchiveDir = System.getProperty("xnode.data_archive_dir");
        if (dataArchiveDir == null) {
            XNODE_DATA_ARCHIVE_DIR.set((Object)((Path)XNODE_HOME_DIR.value()).resolve("data").resolve("archive"));
        } else {
            XNODE_DATA_ARCHIVE_DIR.set((Object)Paths.get(dataArchiveDir, new String[0]));
        }
        XNODE_MEMORY_LOCK.set((Object)false);
        XNODE_ADD_SHUTDOWN_HOOK.set((Object)((Integer)XNODE_START_TYPE.value() == 0 ? 1 : 0));
        XNODE_HOST_PROCESSOR_COUNT.set((Object)Runtime.getRuntime().availableProcessors());
        LOGGER.info(String.format("%40s : %s", "XNODE_HOME_DIR", XNODE_HOME_DIR.value()));
        LOGGER.info(String.format("%40s : %s", "XNODE_BIN_DIR", XNODE_BIN_DIR.value()));
        LOGGER.info(String.format("%40s : %s", "XNODE_DB_DIR", XNODE_DB_DIR.value()));
        LOGGER.info(String.format("%40s : %s", "XNODE_LIB_DIR", XNODE_LIB_DIR.value()));
        LOGGER.info(String.format("%40s : %s", "XNODE_CONF_DIR", XNODE_CONF_DIR.value()));
        LOGGER.info(String.format("%40s : %s", "XNODE_TOOLS_DIR", System.getProperty("tools.dir")));
        LOGGER.info(String.format("%40s : %s", "XNODE_DR_CONF_DIR", XNODE_DR_CONF_DIR.value()));
        LOGGER.info(String.format("%40s : %s", "XNODE_DR_SCHEMA_DIR", XNODE_DR_SCHEMA_DIR.value()));
        LOGGER.info(String.format("%40s : %s", "XNODE_SCHEDULER_CONF_DIR", XNODE_SCHEDULER_CONF_DIR.value()));
        LOGGER.info(String.format("%40s : %s", "XNODE_DATA_MAIN_DIR", XNODE_DATA_MAIN_DIR.value()));
        LOGGER.info(String.format("%40s : %s", "XNODE_DATA_ARCHIVE_DIR", XNODE_DATA_ARCHIVE_DIR.value()));
        LOGGER.info(String.format("%40s : %s", "XNODE_LOGS_DIR", XNODE_LOGS_DIR.value()));
        LOGGER.info(String.format("%40s : %s", "XNODE_CONF_FILE", XNODE_CONF_FILE.value()));
        LOGGER.info(String.format("%40s : %s", "XNODE_DR_CONF_FILE", XNODE_DR_CONF_FILE.value()));
        LOGGER.info(String.format("%40s : %s", "XNODE_DR_ARCHIVE_LOCATIONS_CONF_FILE", XNODE_DR_ARCHIVE_LOCATIONS_CONF_FILE.value()));
    }

    private static void initializeConnectorSettings() throws Exception {
        XNODE_CONNECTOR_MODE_1.set(XNODE_CONNECTOR_MODE_1.getDefaultValue());
        XNODE_CONNECTOR_TCP_KEEP_ALIVE.set(XNODE_CONNECTOR_TCP_KEEP_ALIVE.getDefaultValue());
        XNODE_CONNECTOR_TCP_NO_DELAY.set(XNODE_CONNECTOR_TCP_NO_DELAY.getDefaultValue());
        XNODE_CONNECTOR_TCP_BLOCKING_SERVER.set(XNODE_CONNECTOR_TCP_BLOCKING_SERVER.getDefaultValue());
        XNODE_CONNECTOR_TCP_REUSE_ADDRESS.set(XNODE_CONNECTOR_TCP_REUSE_ADDRESS.getDefaultValue());
        XNODE_CONNECTOR_TCP_CONNECT_TIMEOUT.set(XNODE_CONNECTOR_TCP_CONNECT_TIMEOUT.getDefaultValue());
        XNODE_CONNECTOR_TCP_NETTY_WORKER_COUNT.set((Object)((Integer)XNODE_HOST_PROCESSOR_COUNT.value() * 2));
    }

    private static void loadFromConfFile() throws Exception {
        PropertiesFileUtil.PropertiesFileHandle propFileHandler = PropertiesFileUtil.getPropertiesFileHandle((String)((Path)XNODE_CONF_FILE.value()).toAbsolutePath().toString(), (boolean)true);
        Integer portNo = propFileHandler.getInt("xnode.connector.port", null);
        if (portNo == null) {
            XNODE_CONNECTOR_PORT.set(XNODE_CONNECTOR_PORT.getDefaultValue());
            LOGGER.info(" # DataEngine-XNode Port(Default) : " + XNODE_CONNECTOR_PORT.value());
        } else {
            XNODE_CONNECTOR_PORT.set((Object)portNo);
            LOGGER.info(" # DataEngine-XNode Port(Conf) : " + XNODE_CONNECTOR_PORT.value());
        }
        XNODE_CONNECTOR_USERNAME.set((Object)propFileHandler.getString("xnode.connector.username", null));
        XNODE_CONNECTOR_PASSWORD.set((Object)propFileHandler.getString("xnode.connector.password", null));
        XNODE_CONNECTOR_ACCEPT_REMOTE_REQUEST.set((Object)propFileHandler.getBoolean("xnode.connector.accept_remote_request", (Boolean)XNODE_CONNECTOR_ACCEPT_REMOTE_REQUEST.getDefaultValue()));
        XNODE_CONNECTOR_TCP_JSON_DECODE_SIZE_MB.set((Object)propFileHandler.getInt("xnode.connector.tcp.json_decode_size_mb", (Integer)XNODE_CONNECTOR_TCP_JSON_DECODE_SIZE_MB.getDefaultValue()));
        Environment.validateConnectorPassword();
        XNODE_DB_STORE_DBNAME.set((Object)propFileHandler.getString("xnode.db.store.dbname", (String)XNODE_DB_STORE_DBNAME.getDefaultValue()));
        XNODE_DB_STORE_DBADAPTER.set((Object)propFileHandler.getString("xnode.db.store.dbadapter", (String)XNODE_DB_STORE_DBADAPTER.getDefaultValue()));
        XNODE_DB_STORE_USERNAME.set((Object)propFileHandler.getString("xnode.db.store.username", (String)XNODE_DB_STORE_USERNAME.getDefaultValue()));
        XNODE_DB_STORE_PASSWORD.set((Object)propFileHandler.getString("xnode.db.store.password", (String)XNODE_DB_STORE_PASSWORD.getDefaultValue()));
        XNODE_DB_REPAIR_ON_STARTUP.set((Object)propFileHandler.getBoolean("xnode.db.repair_on_startup", (Boolean)XNODE_DB_REPAIR_ON_STARTUP.getDefaultValue()));
        XNODE_DR_ARCHIVE_ZIP_PASSWORD.set((Object)propFileHandler.getString("xnode.dr.archive.zip_password", (String)XNODE_DR_ARCHIVE_ZIP_PASSWORD.getDefaultValue()));
        String archiveZipPassword = (String)XNODE_DR_ARCHIVE_ZIP_PASSWORD.value();
        if (archiveZipPassword != null && !archiveZipPassword.trim().isEmpty()) {
            XNODE_DR_ARCHIVE_ZIP_PASSWORD.set((Object)CryptoUtil.decrypt((String)archiveZipPassword, (int)2));
        }
        XNODE_LOGS_JAVA_PID_COUNT.set((Object)propFileHandler.getInt("xnode.logs.java_pid_count", (Integer)XNODE_LOGS_JAVA_PID_COUNT.getDefaultValue()));
        XNODE_DE_RESTART_BLOCKING_QUEUE_TIMEOUT.set((Object)propFileHandler.getInt("xnode.de_restart.blocking_queue_timeout", (Integer)XNODE_DE_RESTART_BLOCKING_QUEUE_TIMEOUT.getDefaultValue()));
        XNODE_DE_RESTART_COMMIT_FAILURE_THRESHOLD.set((Object)propFileHandler.getInt("xnode.de_restart.commit_failure_threshold", (Integer)XNODE_DE_RESTART_COMMIT_FAILURE_THRESHOLD.getDefaultValue()));
        XNODE_DE_RESTART_DAILY_RESTART_THRESHOLD.set((Object)propFileHandler.getInt("xnode.de_restart.restarts_threshold", (Integer)XNODE_DE_RESTART_DAILY_RESTART_THRESHOLD.getDefaultValue()));
        XNODE_DE_RESTART_STATUS.set((Object)propFileHandler.getString("xnode.de_restart.status", (String)XNODE_DE_RESTART_STATUS.getDefaultValue()));
        XNODE_DB_STORE_BACKUP_RETENTION.set((Object)propFileHandler.getInt("xnode.db.store.backup_retention", (Integer)XNODE_DB_STORE_BACKUP_RETENTION.getDefaultValue()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateConnectorPassword(String newPassword) throws Exception {
        Object object = CONF_FILE_LOCK;
        synchronized (object) {
            LOGGER.info("Going to update Connector Password");
            PropertiesFileUtil.PropertiesFileHandle propFileHandler = PropertiesFileUtil.getPropertiesFileHandle((String)((Path)XNODE_CONF_FILE.value()).toAbsolutePath().toString(), (boolean)true);
            propFileHandler.updateProperty("xnode.connector.password", newPassword);
            propFileHandler.saveFile();
            XNODE_CONNECTOR_PASSWORD.set((Object)newPassword);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateDRArchiveZipPassword(String newPassword) throws Exception {
        Object object = CONF_FILE_LOCK;
        synchronized (object) {
            LOGGER.info("Going to update DR ArchiveZip Password");
            String existingPassword = (String)XNODE_DR_ARCHIVE_ZIP_PASSWORD.value();
            String encryptedPassword = null;
            if (newPassword == null) {
                newPassword = "";
            }
            if (existingPassword == null) {
                existingPassword = "";
            }
            if (!newPassword.equals(existingPassword)) {
                encryptedPassword = CryptoUtil.encrypt((String)newPassword, (int)2);
                PropertiesFileUtil.PropertiesFileHandle propFileHandler = PropertiesFileUtil.getPropertiesFileHandle((String)((Path)XNODE_CONF_FILE.value()).toAbsolutePath().toString(), (boolean)true);
                propFileHandler.updateProperty("xnode.dr.archive.zip_password", encryptedPassword);
                propFileHandler.saveFile();
                XNODE_DR_ARCHIVE_ZIP_PASSWORD.set((Object)newPassword);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateDBRepairOnStartup(Boolean value) throws Exception {
        Object object = CONF_FILE_LOCK;
        synchronized (object) {
            LOGGER.info("Going to update DBRepair on Startup");
            PropertiesFileUtil.PropertiesFileHandle propFileHandler = PropertiesFileUtil.getPropertiesFileHandle((String)((Path)XNODE_CONF_FILE.value()).toAbsolutePath().toString(), (boolean)true);
            propFileHandler.updateProperty("xnode.db.repair_on_startup", value.toString());
            propFileHandler.saveFile();
            XNODE_DB_REPAIR_ON_STARTUP.set((Object)value);
        }
    }

    public static String genRandomString(int n) {
        String allowedChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789abcdefghijklmnopqrstuvxyz";
        StringBuilder sb = new StringBuilder(n);
        SecureRandom random = new SecureRandom();
        int lenAllowedChars = allowedChars.length();
        for (int i = 0; i < n; ++i) {
            sb.append(allowedChars.charAt(random.nextInt(lenAllowedChars)));
        }
        return sb.toString();
    }

    private static void validateConnectorPassword() throws Exception {
        String existingPassword = (String)XNODE_CONNECTOR_PASSWORD.value();
        if (existingPassword == null || existingPassword.equalsIgnoreCase("chegan")) {
            Environment.updateConnectorPassword(Environment.genRandomString(16));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateDERestartStatus() throws Exception {
        Object object = CONF_FILE_LOCK;
        synchronized (object) {
            String newStatus;
            LOGGER.info("Going to update DE Restart Status");
            PropertiesFileUtil.PropertiesFileHandle propFileHandler = PropertiesFileUtil.getPropertiesFileHandle((String)((Path)XNODE_CONF_FILE.value()).toAbsolutePath().toString(), (boolean)true);
            String existingStatus = (String)XNODE_DE_RESTART_STATUS.value();
            String[] status = existingStatus.split("_");
            LOGGER.info("status[0] = " + status[0]);
            LOGGER.info("DateTimeUnit.getTodayDate(System.currentTimeMillis()) = " + DateTimeUnit.getTodayDate((Long)System.currentTimeMillis()));
            if (status[0].equalsIgnoreCase(DateTimeUnit.getTodayDate((Long)System.currentTimeMillis()))) {
                Integer restartCount = Integer.parseInt(status[1]) + 1;
                newStatus = status[0] + "_" + restartCount;
            } else {
                newStatus = DateTimeUnit.getTodayDate((Long)System.currentTimeMillis()) + "_" + 0;
            }
            propFileHandler.updateProperty("xnode.de_restart.status", newStatus);
            propFileHandler.saveFile();
            XNODE_DE_RESTART_STATUS.set((Object)newStatus);
        }
    }

    public static void checkRestartStatusLimit() {
        try {
            String[] temp = ((String)XNODE_DE_RESTART_STATUS.value()).split("_");
            if (Integer.parseInt(temp[1]) >= (Integer)XNODE_DE_RESTART_DAILY_RESTART_THRESHOLD.value()) {
                if (temp[0].equalsIgnoreCase(DateTimeUnit.getTodayDate((Long)System.currentTimeMillis()))) {
                    Notifications.RESTART_LIMIT_CHECK.showNotification();
                } else {
                    Environment.updateDERestartStatus();
                    Notifications.RESTART_LIMIT_CHECK.hideNotification();
                }
            }
        }
        catch (Exception ex) {
            LOGGER.info("Exception in checking DE Restart Status");
        }
    }
}

