/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.bootstrap;

import com.manageengine.dataengine.commons.utils.ConsoleOut;
import com.manageengine.dataengine.commons.utils.DEService;
import com.manageengine.dataengine.commons.utils.HealthState;
import com.manageengine.dataengine.commons.utils.LogsUtil;
import com.manageengine.dataengine.xnode.Version;
import com.manageengine.dataengine.xnode.bootstrap.DataEngineXNode;
import com.manageengine.dataengine.xnode.bootstrap.Environment;
import com.manageengine.dataengine.xnode.connector.global.transport.TransportService;
import com.manageengine.dataengine.xnode.database.DBService;
import com.manageengine.dataengine.xnode.datarepository.DataRepositoryService;
import com.manageengine.dataengine.xnode.scheduler.SchedulerService;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.io.IoBuilder;

public class XNodeManager
implements Runnable {
    private static final Logger LOGGER = LogManager.getLogger((String)"XNode");
    private static volatile XNodeManager de_instance;
    private static boolean shutdownInitialized;
    private HealthState health = HealthState.RED;
    private final CountDownLatch keepAliveLatch = new CountDownLatch(1);
    private final Thread keepAliveThread;
    private DEService transportService = null;
    private DEService dataRepositoryService = null;
    private DEService databaseService = null;
    private DEService schedulerService = null;

    private XNodeManager() {
        this.initSystemLogger();
        this.keepAliveThread = new Thread((Runnable)this, "dataengine[keepAlive/" + Version.LATEST.toMinString() + "]");
        this.keepAliveThread.setDaemon(false);
    }

    public static void bootstrap(DataEngineXNode.StartType startType) throws Exception {
        Environment.XNODE_START_TYPE.set((Object)startType.ordinal());
        de_instance = new XNodeManager();
        de_instance.start();
    }

    public static void shutdown() throws Exception {
        shutdownInitialized = true;
        de_instance.stop();
    }

    public static boolean isShutdownInitialized() {
        return shutdownInitialized;
    }

    public static HealthState getHealth() {
        return XNodeManager.de_instance.health;
    }

    public static String getBanner(String msg) {
        char bannerChar = '*';
        String leftDivider = "----------|| ";
        String rightDivider = " ||----------";
        int bannerLen = 80;
        int leftPadding = 30;
        int lineLen = leftPadding + bannerLen;
        int msgLen = msg.length();
        int dividerLen = leftDivider.length();
        int dividerLeftSpaceLen = (bannerLen - 2 - msgLen) / 2;
        int dividerRightSpaceLen = bannerLen - 2 - msgLen - dividerLeftSpaceLen;
        return String.format("\n\n\n\n\n%" + lineLen + "s\n%" + lineLen + "s\n%" + lineLen + "s\n%" + lineLen + "s\n%" + lineLen + "s\n\n", StringUtils.rightPad((String)"", (int)bannerLen, (char)bannerChar), StringUtils.rightPad((String)(bannerChar + ""), (int)(bannerLen - 1), (char)' ') + bannerChar, StringUtils.leftPad((String)(bannerChar + ""), (int)(leftPadding + 1), (char)' ') + StringUtils.leftPad((String)leftDivider, (int)dividerLeftSpaceLen, (char)' ') + msg + StringUtils.rightPad((String)rightDivider, (int)dividerRightSpaceLen, (char)' ') + bannerChar, StringUtils.rightPad((String)(bannerChar + ""), (int)(bannerLen - 1), (char)' ') + bannerChar, StringUtils.rightPad((String)"", (int)bannerLen, (char)bannerChar));
    }

    private void start() throws Exception {
        this.keepAliveThread.start();
    }

    private void stop() throws Exception {
        this.doStop();
    }

    private void doStart() throws Exception {
        boolean status = false;
        try {
            this.printLogBanner();
            this.printSystemProperties();
            LOGGER.info("BOOTSTRAPING DataEngine-XNode...");
            LOGGER.info("Version : " + Version.LATEST);
            Environment.initialize();
            if (((Integer)Environment.XNODE_START_TYPE.value()).intValue() == DataEngineXNode.StartType.CMD.ordinal()) {
                this.addShutdownHook();
            }
            this.initBootstrapServices();
            status = this.startBootstrapServices();
            if (status) {
                this.health = HealthState.GREEN;
            }
            LOGGER.info("STARTED DataEngine-XNode!");
            LOGGER.info("Going to check JAVA_PID dump file...");
            LogsUtil.checkAndDeleteJavaPID((Path)((Path)Environment.XNODE_LOGS_DIR.value()), (Integer)((Integer)Environment.XNODE_LOGS_JAVA_PID_COUNT.value()));
            ConsoleOut.println((String)"\nSTARTED DataEngine-XNode!");
            LOGGER.info("-----------------------------------------------------------------");
        }
        catch (Throwable e) {
            LOGGER.info("EXCEPTION while bootstraping XNode! Error : " + e);
            this.health = HealthState.RED;
            throw e;
        }
    }

    private void doStop() {
        LOGGER.info("Going to SHUTDOWN DataEngine-XNode...");
        try {
            this.stopBootstrapServices();
            boolean isClosed = this.closeBootstrapServices();
            while (!isClosed) {
                LOGGER.info("DataEngine-XNode NOT SHUTDOWN, waiting for 300ms");
                Thread.sleep(300L);
                isClosed = this.closeBootstrapServices();
            }
        }
        catch (Throwable e) {
            e.printStackTrace(new PrintStream(IoBuilder.forLogger((Logger)LOGGER).buildOutputStream(), true));
        }
        LOGGER.info("DataEngine-XNode SHUTDOWN!!");
        this.keepAliveLatch.countDown();
    }

    private void initBootstrapServices() {
        this.dataRepositoryService = new DataRepositoryService();
        this.transportService = new TransportService();
        this.databaseService = new DBService();
        this.schedulerService = new SchedulerService();
    }

    private boolean startBootstrapServices() throws Exception {
        boolean status = this.databaseService.start();
        this.consoleStatusPrint("Database Service", "START", status);
        if (status) {
            status = this.dataRepositoryService.start();
        }
        this.consoleStatusPrint("DataRepository Service", "START", status);
        if (status) {
            status = this.schedulerService.start();
        }
        this.consoleStatusPrint("Scheduler Service", "START", status);
        if (status) {
            status = this.transportService.start();
        }
        this.consoleStatusPrint("Transport Service", "START", status);
        return status;
    }

    private boolean stopBootstrapServices() throws Exception {
        boolean status = true;
        if (this.transportService != null) {
            status = this.transportService.stop();
        }
        if (this.schedulerService != null) {
            status |= this.schedulerService.stop();
        }
        if (this.dataRepositoryService != null) {
            status |= this.dataRepositoryService.stop();
        }
        if (this.databaseService != null) {
            status |= this.databaseService.stop();
        }
        return status;
    }

    private boolean closeBootstrapServices() throws Exception {
        boolean status = true;
        if (this.transportService != null) {
            status = this.transportService.close();
        }
        this.consoleStatusPrint("Transport Service", "STOP", status);
        if (this.schedulerService != null) {
            status |= this.schedulerService.close();
        }
        this.consoleStatusPrint("Scheduler Service", "STOP", status);
        if (this.dataRepositoryService != null) {
            status |= this.dataRepositoryService.close();
        }
        this.consoleStatusPrint("DataRepository Service", "STOP", status);
        if (this.databaseService != null) {
            status |= this.databaseService.close();
        }
        this.consoleStatusPrint("Database Service", "STOP", status);
        return status;
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                XNodeManager.this.doStop();
            }
        });
    }

    private void initSystemLogger() {
        System.setOut(new PrintStream(IoBuilder.forLogger((Logger)LOGGER).buildOutputStream(), true));
        System.setErr(new PrintStream(IoBuilder.forLogger((Logger)LOGGER).buildOutputStream(), true));
    }

    private void printLogBanner() {
        LOGGER.info(XNodeManager.getBanner("DataEngine-XNode"));
        LogManager.getLogger((String)"NetTrace").info(XNodeManager.getBanner("DataEngine-XNode-NET"));
        LogManager.getLogger((String)"org.quartz").info(XNodeManager.getBanner("DataEngine-XNode-Scheduler"));
    }

    private void consoleStatusPrint(String msg, String action, boolean status) {
        this.consoleStatusPrint(msg, action, status ? "SUCCESS" : "FAILED");
    }

    private void consoleStatusPrint(String msg, String action, String status) {
        String printMsg = StringUtils.rightPad((String)(msg + " "), (int)50, (char)'.') + " [ " + action + " -> " + status + " ] ";
        LOGGER.info(printMsg);
        ConsoleOut.print((String)("\n" + printMsg));
    }

    private void printSystemProperties() {
        StringBuilder sb = new StringBuilder();
        Properties properties = System.getProperties();
        properties.remove("wrapper.key");
        properties.remove("wrapper.java.pid");
        properties.remove("wrapper.jvmid");
        Enumeration<Object> enumeration = properties.keys();
        sb.append(String.format("\n\n%48s\n%48s\n", "System Properties", "-----------------"));
        for (int i = 0; i < properties.size(); ++i) {
            Object obj = enumeration.nextElement();
            sb.append(String.format("%40s : %s\n", obj, System.getProperty(obj.toString())));
        }
        sb.append("\n\n");
        LOGGER.info(sb.toString());
    }

    @Override
    public void run() {
        try {
            this.doStart();
            this.keepAliveLatch.await();
        }
        catch (Throwable e) {
            e.printStackTrace(new PrintStream(IoBuilder.forLogger((Logger)LOGGER).buildOutputStream(), true));
            this.doStop();
            throw new RuntimeException("Unable to start DataEngineManager!! " + e);
        }
    }

    public static boolean rescheduleScheduler(String cronExpression) {
        return ((SchedulerService)XNodeManager.de_instance.schedulerService).reschedule(cronExpression);
    }

    static {
        shutdownInitialized = false;
    }
}

