/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.connector.global.actionhandlers;

import com.manageengine.dataengine.commons.notify.Notifications;
import com.manageengine.dataengine.xnode.Version;
import com.manageengine.dataengine.xnode.bootstrap.Environment;
import com.manageengine.dataengine.xnode.bootstrap.XNodeManager;
import com.manageengine.dataengine.xnode.connector.global.actionhandlers.TransportRequestHandler;
import com.manageengine.dataengine.xnode.connector.global.transport.TransportRequest;
import com.manageengine.dataengine.xnode.connector.global.transport.TransportResponse;
import com.manageengine.dataengine.xnode.datarepository.DataRepositoryManager;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class AdminRequestHandler
extends TransportRequestHandler {
    private static final Logger LOGGER = LogManager.getLogger((String)"NetTrace");

    @Override
    public TransportResponse processRequest(TransportRequest request) throws Exception {
        if (request.actionType().startsWith("admin:/health")) {
            return this.processHealthRequest(request);
        }
        if (request.actionType().startsWith("admin:/xnode_info")) {
            return this.processXNodeInfoRequest(request);
        }
        if (request.actionType().startsWith("admin:/update_security_settings")) {
            return this.processUpdateSecuritySettingsRequest(request);
        }
        if (request.actionType().startsWith("admin:/shutdown")) {
            return this.processShutdownRequest(request);
        }
        if (request.actionType().startsWith("admin:/archive_info")) {
            return this.processArchiveInfoRequest(request);
        }
        return TransportResponse.buildErrorResponse(request, 1, "Requested ADMIN operation not supported!");
    }

    private TransportResponse processHealthRequest(TransportRequest request) throws Exception {
        LOGGER.info("HEALTH_AT REQUEST received :: " + request.getRequest());
        if (request.has("de_health")) {
            JSONObject jComputedResp = new JSONObject();
            jComputedResp.put("de_health", (Object)XNodeManager.getHealth());
            JSONArray notifications = new JSONArray();
            Environment.checkRestartStatusLimit();
            for (Notifications notification : Notifications.values()) {
                if (!notification.check()) continue;
                notifications.put((Object)notification.toString());
            }
            if (notifications.length() > 0) {
                jComputedResp.put("de_notifications", (Object)notifications);
                for (int i = 0; i < notifications.length(); ++i) {
                    LOGGER.info("Notification " + i + " = " + notifications.get(i));
                }
            }
            LOGGER.info("Response = " + jComputedResp);
            return TransportResponse.buildResponse(request, jComputedResp);
        }
        return TransportResponse.buildErrorResponse(request, 1, "Requested ADMIN-HEALTH action not supported!");
    }

    private TransportResponse processXNodeInfoRequest(TransportRequest request) throws Exception {
        LOGGER.info("XNODE_INFO_AT REQUEST received :: " + request.getRequest());
        JSONObject jComputedResp = new JSONObject();
        jComputedResp.put("xnode_version", (Object)Version.LATEST.toString());
        jComputedResp.put("xnode_installation_path", (Object)Paths.get(FilenameUtils.normalizeNoEndSeparator((String)((Path)Environment.XNODE_HOME_DIR.value()).toFile().getAbsolutePath()), new String[0]).toAbsolutePath().toString());
        return TransportResponse.buildResponse(request, jComputedResp);
    }

    private TransportResponse processUpdateSecuritySettingsRequest(TransportRequest request) throws Exception {
        LOGGER.info("UPDATE_SECURITY_SETTINGS_AT REQUEST received");
        JSONObject jResponse = new JSONObject();
        if (request.has("archive_zip_pwd")) {
            Environment.updateDRArchiveZipPassword(request.getString("archive_zip_pwd"));
            jResponse.put("error_code", 0);
        } else {
            jResponse.put("error_code", 1);
        }
        return TransportResponse.buildResponse(request, jResponse);
    }

    private TransportResponse processShutdownRequest(TransportRequest request) throws Exception {
        LOGGER.info("SHUTDOWN_AT REQUEST received");
        XNodeManager.shutdown();
        return null;
    }

    private TransportResponse processArchiveInfoRequest(TransportRequest request) throws Exception {
        JSONObject jComputedResp = new JSONObject();
        LOGGER.info("ARCHIVE_AT REQUEST received");
        boolean isArchiveRunning = DataRepositoryManager.isArchiveRunning();
        jComputedResp.put("is_archive_running", isArchiveRunning);
        if (!isArchiveRunning) {
            JSONArray deletedBlocks = new JSONArray();
            if ((deletedBlocks = DataRepositoryManager.fetchDeletedBlocksMeta(deletedBlocks)) != null && deletedBlocks.length() > 0) {
                jComputedResp.put("de_deleted_blocks", (Object)deletedBlocks);
                LOGGER.info("DELETED Blocks: " + deletedBlocks);
            }
        }
        LOGGER.info("Response = " + jComputedResp);
        return TransportResponse.buildResponse(request, jComputedResp);
    }
}

