/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.connector.global.actionhandlers;

import com.manageengine.dataengine.xnode.connector.global.actionhandlers.TransportRequestHandler;
import com.manageengine.dataengine.xnode.connector.global.transport.TransportRequest;
import com.manageengine.dataengine.xnode.connector.global.transport.TransportResponse;
import com.manageengine.dataengine.xnode.datarepository.DataRepositoryActionRequest;
import com.manageengine.dataengine.xnode.datarepository.DataRepositoryManager;
import com.manageengine.dataengine.xnode.datarepository.search.SearchRequest;
import com.manageengine.dataengine.xnode.datarepository.search.SearchService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;

public class DataRepositoryRequestHandler
extends TransportRequestHandler {
    private static final Logger LOGGER = LogManager.getLogger((String)"NetTrace");

    @Override
    public TransportResponse processRequest(TransportRequest request) throws Exception {
        if (request.actionType().startsWith("dr:/dr_data_add")) {
            return this.processDataAddRequest(request);
        }
        if (request.actionType().startsWith("dr:/dr_migration_data_add")) {
            return this.processMigrationDataAddRequest(request);
        }
        if (request.actionType().startsWith("dr:/dr_migration_data_validate")) {
            return this.processMigrationDataValidateRequest(request);
        }
        if (request.actionType().startsWith("dr:/dr_data_update")) {
            return this.processDataUpdateRequest(request);
        }
        if (request.actionType().startsWith("dr:/dr_data_delete")) {
            return this.processDataDeleteRequest(request);
        }
        if (request.actionType().startsWith("dr:/dr_search")) {
            return this.processSearchRequest(request);
        }
        if (request.actionType().startsWith("dr:/dr_sync")) {
            return this.processDRSync(request);
        }
        if (request.actionType().startsWith("dr:/dr_update")) {
            return this.processDRUpdate(request);
        }
        if (request.actionType().startsWith("dr:/dr_main_blocks_disk_size_fetch")) {
            return this.processDRMainBlocksDiskSizeFetch(request);
        }
        if (request.actionType().startsWith("dr:/dr_main_blocks_disk_size_older_than_fetch")) {
            return this.processDRMainBlocksDiskSizeOlderThanFetch(request);
        }
        if (request.actionType().startsWith("dr:/dr_schema_sync")) {
            return this.processDRSchemaSync(request);
        }
        if (request.actionType().startsWith("dr:/dr_blocks_meta_sync")) {
            return this.processDRBlocksMetaSync(request);
        }
        if (request.actionType().startsWith("dr:/dr_blocks_meta_fetch")) {
            return this.processDRBlocksMetaFetch(request);
        }
        if (request.actionType().startsWith("dr:/dr_blocks_count_fetch")) {
            return this.processDRBlocksCountFetch(request);
        }
        if (request.actionType().startsWith("dr:/dr_archive_old_blocks")) {
            return this.processDRArchiveOldBlocks(request);
        }
        if (request.actionType().startsWith("dr:/dr_archive_blocks_load")) {
            return this.processArchiveBlocksLoad(request);
        }
        if (request.actionType().startsWith("dr:/dr_archive_blocks_unload")) {
            return this.processArchiveBlocksUnload(request);
        }
        if (request.actionType().startsWith("dr:/dr_archive_locations_sync")) {
            return this.processDRArchiveLocationsSync(request);
        }
        if (request.actionType().startsWith("dr:/dr_to_delete_blocks_meta_fetch")) {
            return this.processDRToDeleteBlocksMetaFetch(request);
        }
        if (request.actionType().startsWith("dr:/dr_archive_page_info_fetch")) {
            return this.processDRArchivePageInfoFetch(request);
        }
        if (request.actionType().startsWith("dr:/dr_archive_scheduler_sync")) {
            return this.processDRArchiveSchedulerSync(request);
        }
        if (request.actionType().startsWith("dr:/dr_deleted_blocks_meta_fetch")) {
            return this.processDRDeletedBlocksMetaFetch(request);
        }
        if (request.actionType().startsWith("dr:/dr_meta_info_update")) {
            return this.processDRMetaInfoUpdate(request);
        }
        if (request.actionType().startsWith("dr:/dr_meta_col_add")) {
            return this.processDRMetaInfoAdd(request);
        }
        return TransportResponse.buildErrorResponse(request, 1, "Requested DR Action not supported!");
    }

    private TransportResponse processDRMetaInfoUpdate(TransportRequest request) throws Exception {
        LOGGER.info("DR-META-INFO-UPDATE REQUEST received :: " + request.getRequest());
        DataRepositoryActionRequest drRequest = DataRepositoryActionRequest.buildMetaInfoUpdateRequest(request);
        JSONObject jcomputedResp = DataRepositoryManager.updateDRMetaInfo(drRequest);
        return TransportResponse.buildResponse(request, jcomputedResp);
    }

    private TransportResponse processDRMetaInfoAdd(TransportRequest request) throws Exception {
        LOGGER.info("DR-META-COL-ADD REQUEST received :: " + request.getRequest());
        DataRepositoryActionRequest drRequest = DataRepositoryActionRequest.buildMetaColAddRequest(request);
        JSONObject jComputedResp = DataRepositoryManager.addDRMetaCol(drRequest);
        return TransportResponse.buildResponse(request, jComputedResp);
    }

    private TransportResponse processDataAddRequest(TransportRequest request) throws Exception {
        LOGGER.info("DATA-ADD REQUEST received :: " + request.getString("dr_name"));
        DataRepositoryActionRequest drRequest = DataRepositoryActionRequest.buildDataAddRequest(request);
        JSONObject jComputedResp = drRequest.dataRepository().addData(drRequest);
        return TransportResponse.buildResponse(request, jComputedResp);
    }

    private TransportResponse processMigrationDataAddRequest(TransportRequest request) throws Exception {
        LOGGER.info("MIGRATION-DATA-ADD REQUEST received :: " + request.getRequest());
        DataRepositoryActionRequest drRequest = DataRepositoryActionRequest.buildMigrationDataAddRequest(request);
        JSONObject jComputedResp = drRequest.dataRepository().addMigrationData(drRequest);
        return TransportResponse.buildResponse(request, jComputedResp);
    }

    private TransportResponse processMigrationDataValidateRequest(TransportRequest request) throws Exception {
        LOGGER.info("MIGRATION-DATA-VALIDATE REQUEST received :: " + request.getRequest());
        DataRepositoryActionRequest drRequest = DataRepositoryActionRequest.buildMigrationDataValidateRequest(request);
        JSONObject jComputedResp = drRequest.dataRepository().validateMigrationData(drRequest);
        return TransportResponse.buildResponse(request, jComputedResp);
    }

    private TransportResponse processDataUpdateRequest(TransportRequest request) throws Exception {
        LOGGER.info("DATA-UPDATE REQUEST received :: " + request.getString("dr_name"));
        DataRepositoryActionRequest drRequest = DataRepositoryActionRequest.buildDataUpdateRequest(request);
        JSONObject jComputedResp = drRequest.dataRepository().updateData(drRequest);
        return TransportResponse.buildResponse(request, jComputedResp);
    }

    private TransportResponse processDataDeleteRequest(TransportRequest request) throws Exception {
        LOGGER.info("DATA-DELETE REQUEST received :: " + request.getString("dr_name"));
        DataRepositoryActionRequest drRequest = DataRepositoryActionRequest.buildDataDeleteRequest(request);
        JSONObject jComputedResp = drRequest.dataRepository().deleteData(drRequest);
        return TransportResponse.buildResponse(request, jComputedResp);
    }

    private TransportResponse processSearchRequest(TransportRequest request) throws Exception {
        LOGGER.info("SEARCH REQUEST received :: " + request.getRequest());
        SearchRequest searchRequest = SearchRequest.build(request);
        SearchService sService = new SearchService();
        return sService.executeSearch(searchRequest);
    }

    private TransportResponse processDRSync(TransportRequest request) throws Exception {
        LOGGER.info("DR SYNC REQUEST received");
        DataRepositoryActionRequest drRequest = DataRepositoryActionRequest.buildDRSyncOrUpdateRequest(request);
        JSONObject jComputedResp = DataRepositoryManager.syncDataRepositories(drRequest);
        return TransportResponse.buildResponse(request, jComputedResp);
    }

    private TransportResponse processDRUpdate(TransportRequest request) throws Exception {
        LOGGER.info("DR-UPDATE REQUEST received :: " + request.getRequest());
        DataRepositoryActionRequest drRequest = DataRepositoryActionRequest.buildDRSyncOrUpdateRequest(request);
        JSONObject jComputedResp = DataRepositoryManager.updateDataRepositories(drRequest);
        return TransportResponse.buildResponse(request, jComputedResp);
    }

    private TransportResponse processDRMainBlocksDiskSizeFetch(TransportRequest request) throws Exception {
        LOGGER.info("DR-MAIN-DISK-SIZE_FETCH REQUEST received :: " + request.getRequest());
        DataRepositoryActionRequest drRequest = DataRepositoryActionRequest.buildDRDiskSizeFetchRequest(request);
        JSONObject jComputedResp = DataRepositoryManager.fetchDRMainBlocksDiskSize(drRequest);
        return TransportResponse.buildResponse(request, jComputedResp);
    }

    private TransportResponse processDRMainBlocksDiskSizeOlderThanFetch(TransportRequest request) throws Exception {
        LOGGER.info("DR-MAIN-DISK-SIZE-OLDER-THAN_FETCH REQUEST received :: " + request.getRequest());
        DataRepositoryActionRequest drRequest = DataRepositoryActionRequest.buildDRDiskSizeFetchRequest(request);
        JSONObject jComputedResp = DataRepositoryManager.fetchDRMainBlocksDiskSizeOlderThan(drRequest);
        return TransportResponse.buildResponse(request, jComputedResp);
    }

    private TransportResponse processDRSchemaSync(TransportRequest request) throws Exception {
        LOGGER.info("DR-SCHEMA-SYNC REQUEST received");
        DataRepositoryActionRequest drRequest = DataRepositoryActionRequest.buildDRSchemaSyncRequest(request);
        JSONObject jComputedResp = DataRepositoryManager.syncDRSchemas(drRequest);
        return TransportResponse.buildResponse(request, jComputedResp);
    }

    private TransportResponse processDRBlocksMetaSync(TransportRequest request) throws Exception {
        LOGGER.info("DR-BLOCKS-META-SYNC REQUEST received");
        DataRepositoryActionRequest drRequest = DataRepositoryActionRequest.buildBlocksMetaSyncRequest(request);
        JSONObject jComputedResp = DataRepositoryManager.syncFrozenBlocksMeta(drRequest);
        return TransportResponse.buildResponse(request, jComputedResp);
    }

    private TransportResponse processDRBlocksMetaFetch(TransportRequest request) throws Exception {
        LOGGER.info("DR-BLOCKS-META-FETCH REQUEST received :: " + request.getRequest());
        DataRepositoryActionRequest drRequest = DataRepositoryActionRequest.buildBlocksMetaFetchRequest(request);
        JSONObject jComputedResp = DataRepositoryManager.fetchBlocksMeta(drRequest);
        return TransportResponse.buildResponse(request, jComputedResp);
    }

    private TransportResponse processDRBlocksCountFetch(TransportRequest request) throws Exception {
        LOGGER.info("DR-BLOCKS-COUNT-FETCH REQUEST received :: " + request.getRequest());
        DataRepositoryActionRequest drRequest = DataRepositoryActionRequest.buildBlocksCountFetchRequest(request);
        JSONObject jComputedResp = DataRepositoryManager.fetchBlocksCount(drRequest);
        return TransportResponse.buildResponse(request, jComputedResp);
    }

    private TransportResponse processDRArchiveOldBlocks(TransportRequest request) throws Exception {
        LOGGER.info("DR-ARCHIVE-NOW received :: " + request.getRequest());
        if (!DataRepositoryManager.isArchiveRunning()) {
            DataRepositoryManager.archiveOldBlocks();
        }
        return TransportResponse.buildResponse(request, new JSONObject().put("error_code", 0));
    }

    private TransportResponse processArchiveBlocksLoad(TransportRequest request) throws Exception {
        LOGGER.info("ARCHIVE-BLOCKS-LOAD REQUEST received :: " + request.getRequest());
        DataRepositoryActionRequest drRequest = DataRepositoryActionRequest.buildArchiveBlocksLoadRequest(request);
        JSONObject jComputedResp = drRequest.dataRepository().loadArchiveBlocks(drRequest);
        return TransportResponse.buildResponse(request, jComputedResp);
    }

    private TransportResponse processArchiveBlocksUnload(TransportRequest request) throws Exception {
        LOGGER.info("ARCHIVE-BLOCKS-UNLOAD REQUEST received :: " + request.getRequest());
        DataRepositoryActionRequest drRequest = DataRepositoryActionRequest.buildArchiveBlocksUnloadRequest(request);
        JSONObject jComputedResp = drRequest.dataRepository().unloadArchiveBlocks(drRequest);
        return TransportResponse.buildResponse(request, jComputedResp);
    }

    private TransportResponse processDRArchiveLocationsSync(TransportRequest request) throws Exception {
        LOGGER.info("DR-ARCHIVE-LOCATIONS-SYNC REQUEST received :: " + request.getRequest());
        DataRepositoryActionRequest drRequest = DataRepositoryActionRequest.buildArchiveLocationsSyncRequest(request);
        JSONObject jComputedResp = DataRepositoryManager.syncArchiveLocations(drRequest);
        return TransportResponse.buildResponse(request, jComputedResp);
    }

    private TransportResponse processDRToDeleteBlocksMetaFetch(TransportRequest request) throws Exception {
        LOGGER.info("DR-ARCHIVE-TO-DELETE-BLOCKS-META-FETCH REQUEST received :: " + request.getRequest());
        DataRepositoryActionRequest drRequest = DataRepositoryActionRequest.buildToDeleteBlocksMetaFetchRequest(request);
        JSONObject jComputedResp = DataRepositoryManager.fetchToDeleteBlocksMeta(drRequest);
        return TransportResponse.buildResponse(request, jComputedResp);
    }

    private TransportResponse processDRArchivePageInfoFetch(TransportRequest request) throws Exception {
        LOGGER.info("DR-ARCHIVE-PAGE-INFO-FETCH-REQUEST received :: " + request.getRequest());
        DataRepositoryActionRequest drRequest = DataRepositoryActionRequest.buildArchivePageInfoFetchRequest(request);
        JSONObject jComputedResp = DataRepositoryManager.fetchArchivePageInfo(drRequest);
        return TransportResponse.buildResponse(request, jComputedResp);
    }

    private TransportResponse processDRArchiveSchedulerSync(TransportRequest request) throws Exception {
        LOGGER.info("ARCHIVE-SCHEDULER-SYNC REQUEST received :: " + request.getRequest());
        DataRepositoryActionRequest drRequest = DataRepositoryActionRequest.buildDRArchiveSchedulerSyncRequest(request);
        JSONObject jComputedResp = DataRepositoryManager.syncSchedulerInterval(drRequest);
        return TransportResponse.buildResponse(request, jComputedResp);
    }

    private TransportResponse processDRDeletedBlocksMetaFetch(TransportRequest request) throws Exception {
        LOGGER.info("DR-DELETED-BLOCKS-META-FETCH-REQUEST received :: " + request.getRequest());
        DataRepositoryActionRequest drRequest = DataRepositoryActionRequest.buildDeletedBlocksMetaFetchRequest(request);
        JSONObject jComputedResp = DataRepositoryManager.fetchDeletedBlocksMeta(drRequest);
        return TransportResponse.buildResponse(request, jComputedResp);
    }
}

