/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.connector.global.transport;

import com.manageengine.dataengine.commons.notify.Notifications;
import com.manageengine.dataengine.xnode.connector.global.transport.TransportRequest;
import java.io.PrintStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.io.IoBuilder;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class TransportResponse {
    private final long requestId;
    private final String actionType;
    private static final Logger LOGGER = LogManager.getLogger((String)"NetTrace");

    protected TransportResponse(long requestId, String actionType) {
        this.requestId = requestId;
        this.actionType = actionType;
    }

    public abstract JSONObject castToJSON() throws JSONException;

    public long requestId() {
        return this.requestId;
    }

    public String actionType() {
        return this.actionType;
    }

    public final JSONObject toJSON() throws JSONException {
        JSONObject jResponse = new JSONObject();
        jResponse.put("request_id", this.requestId);
        jResponse.put("response", (Object)this.castToJSON());
        return jResponse;
    }

    public String toString() {
        String str = null;
        try {
            str = this.toJSON().toString();
        }
        catch (JSONException e) {
            e.printStackTrace(new PrintStream(IoBuilder.forLogger((Logger)LOGGER).buildOutputStream(), true));
        }
        return str;
    }

    public static TransportResponse buildResponse(TransportRequest request, final JSONObject jResponse) throws Exception {
        return new TransportResponse(request.requestId(), request.actionType()){

            @Override
            public JSONObject castToJSON() throws JSONException {
                return jResponse;
            }
        };
    }

    public static TransportResponse buildErrorResponse(TransportRequest request, final int errorCode, final String errorMsg) throws Exception {
        return new TransportResponse(request.requestId(), request.actionType()){

            @Override
            public JSONObject castToJSON() throws JSONException {
                JSONObject jErrResponse = new JSONObject();
                jErrResponse.put("error_code", errorCode);
                jErrResponse.put("error_msg", (Object)errorMsg);
                this.notify(errorMsg);
                return jErrResponse;
            }

            public void notify(String errorMsg2) {
                if (errorMsg2.contains("NoSuchElementException: DataRepository")) {
                    Notifications.DR_MISSING_CHECK.showNotification();
                }
            }
        };
    }
}

