/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.connector.global.transport;

import com.manageengine.dataengine.commons.utils.DEService;
import com.manageengine.dataengine.commons.utils.HealthState;
import com.manageengine.dataengine.xnode.connector.global.actionhandlers.AdminRequestHandler;
import com.manageengine.dataengine.xnode.connector.global.actionhandlers.DataRepositoryRequestHandler;
import com.manageengine.dataengine.xnode.connector.global.actionhandlers.TransportRequestHandler;
import com.manageengine.dataengine.xnode.connector.global.transport.netty.NettyTcpServer;
import java.util.HashMap;
import java.util.NoSuchElementException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransportService
extends DEService {
    private NettyTcpServer globalTcpServer = new NettyTcpServer(this);
    private HashMap<String, TransportRequestHandler> requestHandlers = new HashMap();
    private static final Logger LOGGER = LogManager.getLogger((String)"NetTrace");

    public TransportService() {
        this.initRequestHandlers();
    }

    public void initRequestHandlers() {
        this.registerRequestHandler("admin:", new AdminRequestHandler());
        this.registerRequestHandler("dr:", new DataRepositoryRequestHandler());
    }

    public void registerRequestHandler(String actionKey, TransportRequestHandler handler) {
        this.requestHandlers.put(actionKey, handler);
    }

    public TransportRequestHandler getTransportRequestHandler(String actionId) {
        TransportRequestHandler requestHandler = null;
        for (String key : this.requestHandlers.keySet()) {
            if (!actionId.startsWith(key)) continue;
            requestHandler = this.requestHandlers.get(key);
            break;
        }
        if (requestHandler == null) {
            throw new NoSuchElementException("Request handler for actionid '" + actionId + "' not found!");
        }
        return requestHandler;
    }

    protected boolean doStart() throws Exception {
        boolean status = false;
        try {
            status = this.globalTcpServer.start();
            if (status) {
                this.setHealth(HealthState.GREEN);
            }
        }
        catch (Throwable e) {
            this.setHealth(HealthState.RED);
            LOGGER.error("EXCEPTION : Unable to start TransportServer service : " + e.getMessage());
            throw e;
        }
        return status;
    }

    protected boolean doStop() throws Exception {
        boolean status = this.globalTcpServer.stop();
        this.setHealth(HealthState.RED);
        LOGGER.info("STOPPING TransportService, isStopped : " + status);
        return status;
    }

    protected boolean doClose() throws Exception {
        boolean status = this.globalTcpServer.close();
        this.setHealth(HealthState.RED);
        LOGGER.info("CLOSING TransportService, isClosed : " + status);
        return status;
    }

    protected boolean doFail() throws Exception {
        boolean status = this.globalTcpServer.fail();
        this.setHealth(HealthState.RED);
        return status;
    }
}

