/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.connector.global.transport.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NettyChannelMetricsHandler
extends ChannelInboundHandlerAdapter {
    final Set<Channel> openChannels = Collections.newSetFromMap(new ConcurrentHashMap());
    private final AtomicLong openChannelsMetric = new AtomicLong();
    private final AtomicLong totalChannelsMetric = new AtomicLong();
    private static final Logger LOGGER = LogManager.getLogger((String)"NetTrace");

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        LOGGER.info("Network channel OPENED : { " + ctx.channel() + " }");
        boolean added = this.openChannels.add(ctx.channel());
        if (added) {
            this.openChannelsMetric.incrementAndGet();
            this.totalChannelsMetric.incrementAndGet();
        }
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        boolean removed = this.openChannels.remove(ctx.channel());
        if (removed) {
            this.openChannelsMetric.decrementAndGet();
        }
        LOGGER.info("Network channel CLOSED : { " + ctx.channel() + " }");
        super.channelInactive(ctx);
    }

    public long numberOfOpenChannels() {
        return this.openChannelsMetric.longValue();
    }

    public long totalChannels() {
        return this.totalChannelsMetric.longValue();
    }

    public void close() {
        try {
            NettyChannelMetricsHandler.closeChannels(this.openChannels);
        }
        catch (IOException e) {
            LOGGER.info("EXCEPTION while closing channels " + e);
        }
        this.openChannels.clear();
    }

    public static void closeChannels(Collection<Channel> channels) throws IOException {
        Throwable closingExceptions = null;
        ArrayList<ChannelFuture> futures = new ArrayList<ChannelFuture>();
        for (Channel channel : channels) {
            try {
                if (channel == null || !channel.isOpen()) continue;
                futures.add(channel.close());
            }
            catch (Exception e) {
                if (closingExceptions == null) {
                    closingExceptions = new IOException("failed to close channels");
                }
                closingExceptions.addSuppressed(e);
            }
        }
        for (ChannelFuture future : futures) {
            future.awaitUninterruptibly();
        }
        if (closingExceptions != null) {
            throw closingExceptions;
        }
    }
}

