/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.connector.global.transport.netty;

import com.manageengine.dataengine.xnode.bootstrap.Environment;
import com.manageengine.dataengine.xnode.connector.global.transport.TransportRequest;
import com.manageengine.dataengine.xnode.connector.global.transport.TransportResponse;
import com.manageengine.dataengine.xnode.connector.global.transport.netty.NettyTcpChannelMsgHandler;
import com.manageengine.dataengine.xnode.connector.global.transport.netty.NettyTcpServer;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import org.json.JSONObject;

public class NettyTcpChannelAuthenticator
extends ChannelDuplexHandler {
    private NettyTcpServer nettyServer;

    public NettyTcpChannelAuthenticator(NettyTcpServer nettyServer) {
        this.nettyServer = nettyServer;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        Channel channel = ctx.channel();
        JSONObject jMsg = new JSONObject((String)msg);
        String username = jMsg.optString("username", null);
        String password = jMsg.optString("password", null);
        TransportRequest request = new TransportRequest(jMsg);
        InetSocketAddress remoteAddress = (InetSocketAddress)channel.remoteAddress();
        boolean isLocalAddress = this.isLocalAddress(remoteAddress.getAddress());
        boolean allowRemoteRequest = (Boolean)Environment.XNODE_CONNECTOR_ACCEPT_REMOTE_REQUEST.value();
        if (isLocalAddress || allowRemoteRequest) {
            if (username != null && password != null && username.equals(Environment.XNODE_CONNECTOR_USERNAME.value()) && password.equals(Environment.XNODE_CONNECTOR_PASSWORD.value())) {
                ctx.pipeline().remove((ChannelHandler)this);
                ctx.pipeline().addLast("request_processor", (ChannelHandler)new NettyTcpChannelMsgHandler(this.nettyServer));
                TransportResponse response = TransportResponse.buildResponse(request, new JSONObject().put("status", (Object)"authentication_success"));
                this.nettyServer.sendResponse(ctx.channel(), response);
            } else {
                TransportResponse response = TransportResponse.buildErrorResponse(request, 1, "Authentication failed!");
                this.nettyServer.sendResponse(ctx.channel(), response);
            }
        } else {
            TransportResponse response = TransportResponse.buildErrorResponse(request, 1, "Remote request-processing disabled!!");
            this.nettyServer.sendResponse(ctx.channel(), response);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.nettyServer.exceptionCaught(ctx, cause);
    }

    private boolean isLocalAddress(InetAddress addr) {
        if (addr.isAnyLocalAddress() || addr.isLoopbackAddress()) {
            return true;
        }
        try {
            return NetworkInterface.getByInetAddress(addr) != null;
        }
        catch (SocketException e) {
            return false;
        }
    }
}

