/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.connector.global.transport.netty;

import com.manageengine.dataengine.commons.concurrent.CommonThreadFactory;
import com.manageengine.dataengine.xnode.bootstrap.Environment;
import com.manageengine.dataengine.xnode.bootstrap.XNodeManager;
import com.manageengine.dataengine.xnode.connector.global.transport.TransportRequest;
import com.manageengine.dataengine.xnode.connector.global.transport.TransportResponse;
import com.manageengine.dataengine.xnode.connector.global.transport.TransportServer;
import com.manageengine.dataengine.xnode.connector.global.transport.TransportService;
import com.manageengine.dataengine.xnode.connector.global.transport.netty.NettyChannelMetricsHandler;
import com.manageengine.dataengine.xnode.connector.global.transport.netty.NettyTcpChannelAuthenticator;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.oio.OioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.oio.OioServerSocketChannel;
import io.netty.handler.codec.json.JsonObjectDecoder;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import java.io.PrintStream;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.io.IoBuilder;

public class NettyTcpServer
extends TransportServer {
    public static final String TCP_SERVER_WORKER_THREAD_NAME_PREFIX = "tcp_server_worker";
    protected final int eventLoopThreadCount = 5;
    protected int requestHandlerThreadCount = (Integer)Environment.XNODE_CONNECTOR_TCP_NETTY_WORKER_COUNT.value();
    protected final int requestHandlerMinThreadCount = 5;
    protected final int requestHandlerMaxThreadCount = 30;
    private ChannelFuture channelFuture;
    private ExecutorService executorService;
    private CommonThreadFactory threadFactory;
    private OioEventLoopGroup oioEventLoopGroup = null;
    private NioEventLoopGroup nioEventLoopGroup = null;
    private static final Logger LOGGER = LogManager.getLogger((String)"NetTrace");

    public NettyTcpServer(TransportService transportService) {
        super(transportService);
        if (this.requestHandlerThreadCount < 5) {
            this.requestHandlerThreadCount = 5;
        }
        if (this.requestHandlerThreadCount > 30) {
            this.requestHandlerThreadCount = 30;
        }
    }

    protected boolean doStart() throws Exception {
        return this.startServer("NettyTCPServer");
    }

    protected boolean doStop() throws Exception {
        return this.stopServer();
    }

    protected boolean doClose() throws Exception {
        return true;
    }

    protected boolean doFail() throws Exception {
        return this.stopServer();
    }

    private boolean startServer(String name) throws Exception {
        boolean serverStarted = false;
        ServerBootstrap serverBootstrap = null;
        try {
            LOGGER.info("Going to start TCP server...");
            this.threadFactory = new CommonThreadFactory("requestHandler");
            this.executorService = Executors.newFixedThreadPool(this.requestHandlerThreadCount, (ThreadFactory)this.threadFactory);
            serverBootstrap = this.createServerBootstrap(name);
            this.channelFuture = serverBootstrap.bind(((Integer)Environment.XNODE_CONNECTOR_PORT.value()).intValue()).sync();
            LOGGER.info("TCP server started at port : " + Environment.XNODE_CONNECTOR_PORT.value());
            if (this.channelFuture != null) {
                serverStarted = true;
            }
        }
        catch (Exception e) {
            if (this.executorService != null) {
                this.executorService.shutdown();
            }
            if (serverBootstrap != null && serverBootstrap.config() != null && serverBootstrap.config().group() != null) {
                serverBootstrap.config().group().shutdownGracefully();
            }
            throw e;
        }
        return serverStarted;
    }

    private boolean stopServer() throws Exception {
        LOGGER.info("Going to shutdown TCP server...");
        if (this.channelFuture != null && this.channelFuture.channel() != null) {
            this.channelFuture.channel().disconnect();
            this.channelFuture.channel().close();
            this.channelFuture.channel().closeFuture().sync();
            this.channelFuture.channel().eventLoop().shutdownGracefully().sync();
        }
        if (this.nioEventLoopGroup != null) {
            this.nioEventLoopGroup.shutdownGracefully();
        }
        if (this.oioEventLoopGroup != null) {
            this.oioEventLoopGroup.shutdownGracefully();
        }
        if (this.executorService != null) {
            this.killAllRequests();
        }
        LOGGER.info("TCP server shutdown");
        return true;
    }

    private void killAllRequests() {
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.executorService.shutdownNow();
                this.printRunningThreads();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void printRunningThreads() {
        List runningThreads = this.threadFactory.getRunningThreads();
        LOGGER.info("Running Threads: " + runningThreads.size());
        for (int i = 0; i < runningThreads.size(); ++i) {
            LOGGER.info("Thread - " + (i + 1) + " = " + ((Thread)runningThreads.get(i)).toString());
        }
    }

    private ServerBootstrap createServerBootstrap(String name) {
        boolean blockingServer = (Boolean)Environment.XNODE_CONNECTOR_TCP_BLOCKING_SERVER.value();
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        if (blockingServer) {
            this.oioEventLoopGroup = new OioEventLoopGroup(5);
            serverBootstrap.group((EventLoopGroup)this.oioEventLoopGroup);
            serverBootstrap.channel(OioServerSocketChannel.class);
        } else {
            this.nioEventLoopGroup = new NioEventLoopGroup(5);
            serverBootstrap.group((EventLoopGroup)this.nioEventLoopGroup);
            serverBootstrap.channel(NioServerSocketChannel.class);
        }
        serverBootstrap.childHandler((ChannelHandler)new ServerChannelInitializer(name));
        boolean reuseAddress = (Boolean)Environment.XNODE_CONNECTOR_TCP_REUSE_ADDRESS.value();
        serverBootstrap.validate();
        return serverBootstrap;
    }

    @Override
    public void requestReceived(final Channel channel, final TransportRequest request) throws Exception {
        try {
            this.executorService.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    TransportResponse response = null;
                    try {
                        if (!request.hasMandatoryParams()) {
                            throw new Exception("Mandatory request parameter not found in request!");
                        }
                        if (XNodeManager.isShutdownInitialized()) {
                            throw new Exception("Unable to process Request, DE shutdown is initiated already");
                        }
                        response = NettyTcpServer.this.transportService().getTransportRequestHandler(request.actionType()).processRequest(request);
                    }
                    catch (Throwable e) {
                        try {
                            response = TransportResponse.buildErrorResponse(request, 1, e.toString());
                        }
                        catch (Throwable e1) {
                            e1.printStackTrace();
                        }
                        e.printStackTrace(new PrintStream(IoBuilder.forLogger((Logger)LOGGER).buildOutputStream(), true));
                    }
                    finally {
                        try {
                            if (response != null) {
                                NettyTcpServer.this.sendResponse(channel, response);
                            } else {
                                LOGGER.error("EXCEPTION : TransportResponse set to null for request : " + request.getRequest());
                            }
                        }
                        catch (Throwable e1) {
                            e1.printStackTrace(new PrintStream(IoBuilder.forLogger((Logger)LOGGER).buildOutputStream(), true));
                        }
                    }
                }
            });
        }
        catch (Throwable submitEx) {
            try {
                TransportResponse response = TransportResponse.buildErrorResponse(request, 1, submitEx.toString());
                this.sendResponse(channel, response);
            }
            catch (Throwable e1) {
                e1.printStackTrace(new PrintStream(IoBuilder.forLogger((Logger)LOGGER).buildOutputStream(), true));
            }
        }
    }

    @Override
    public void sendResponse(Channel channel, TransportResponse response) throws Exception {
        channel.writeAndFlush((Object)response.toString());
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        LOGGER.error("NettyTcpServer.exceptionCaught Error : [" + cause.getMessage() + "]");
        cause.printStackTrace();
        ctx.close();
    }

    protected class ServerChannelInitializer
    extends ChannelInitializer<Channel> {
        protected final String name;

        protected ServerChannelInitializer(String name) {
            this.name = name;
        }

        protected void initChannel(Channel ch) throws Exception {
            ch.pipeline().addLast("open_channels", (ChannelHandler)new NettyChannelMetricsHandler());
            ch.pipeline().addLast(new ChannelHandler[]{new JsonObjectDecoder((Integer)Environment.XNODE_CONNECTOR_TCP_JSON_DECODE_SIZE_MB.value() * 1024 * 1024)});
            ch.pipeline().addLast(new ChannelHandler[]{new StringDecoder()});
            ch.pipeline().addLast("authenticator", (ChannelHandler)new NettyTcpChannelAuthenticator(NettyTcpServer.this));
            ch.pipeline().addLast(new ChannelHandler[]{new StringEncoder()});
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            LOGGER.error("NettyTcpServer.ServerChannelInitializer Error : [" + cause.getMessage() + "]");
            this.exceptionCaught(ctx, cause);
        }
    }
}

