/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.database;

import com.manageengine.dataengine.xnode.bootstrap.Environment;
import com.manageengine.dataengine.xnode.database.DBAdapter;
import com.manageengine.dataengine.xnode.database.HsqlDBAdapter;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DBManager {
    private static DBAdapter dbAdapter;
    private static final Logger LOGGER;

    public static boolean start() throws SQLException {
        return dbAdapter.initialize();
    }

    public static boolean stop() throws SQLException {
        while (dbAdapter.isCompactShuttingDown()) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception ex) {
                LOGGER.error("EXCEPTION :: Requesting store connection during DB compact shutdown request!");
                ex.printStackTrace();
            }
        }
        return dbAdapter.shutdown();
    }

    public static boolean close() throws SQLException {
        return true;
    }

    public static boolean fail() throws SQLException {
        while (dbAdapter.isCompactShuttingDown()) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception ex) {
                LOGGER.error("EXCEPTION :: Requesting store connection during DB compact shutdown request!");
                ex.printStackTrace();
            }
        }
        return dbAdapter.shutdown();
    }

    public static void writeCompact() throws Exception {
        if (dbAdapter instanceof HsqlDBAdapter) {
            if (dbAdapter.isShuttingDown()) {
                LOGGER.error("EXCEPTION :: Requesting store connection after DB shutdown request!");
            } else {
                dbAdapter.shutdownCompact();
            }
        }
    }

    public static Connection getStoreConnection() throws SQLException {
        if (dbAdapter.isShuttingDown()) {
            LOGGER.error("EXCEPTION :: Requesting store connection after DB shutdown request!");
            return null;
        }
        while (dbAdapter.isCompactShuttingDown()) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception ex) {
                LOGGER.error("EXCEPTION :: Requesting store connection during DB compact shutdown request!");
                ex.printStackTrace();
            }
        }
        return dbAdapter.getConnection();
    }

    static {
        LOGGER = LogManager.getLogger((String)"XNode");
        try {
            if (!((String)Environment.XNODE_DB_STORE_DBADAPTER.value()).equalsIgnoreCase("hsqldb")) {
                throw new Exception("DB Adapter '" + dbAdapter + "'not supported!");
            }
            dbAdapter = new HsqlDBAdapter();
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

