/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.database;

import com.manageengine.dataengine.commons.utils.DEService;
import com.manageengine.dataengine.commons.utils.HealthState;
import com.manageengine.dataengine.xnode.database.DBManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DBService
extends DEService {
    private static final Logger LOGGER = LogManager.getLogger((String)"XNode");

    protected boolean doStart() throws Exception {
        boolean status = false;
        try {
            status = DBManager.start();
            if (status) {
                this.setHealth(HealthState.GREEN);
            }
        }
        catch (Throwable e) {
            this.setHealth(HealthState.RED);
            LOGGER.error("EXCEPTION : Unable to start DatabaseService : " + e.getMessage());
            throw e;
        }
        return status;
    }

    protected boolean doStop() throws Exception {
        boolean status = DBManager.stop();
        this.setHealth(HealthState.RED);
        LOGGER.info("STOPPING DatabaseService, isStopped : " + status);
        return status;
    }

    protected boolean doClose() throws Exception {
        boolean status = DBManager.close();
        this.setHealth(HealthState.RED);
        LOGGER.info("CLOSING DatabaseService, isClosed : " + status);
        return status;
    }

    protected boolean doFail() throws Exception {
        boolean status = DBManager.fail();
        this.setHealth(HealthState.RED);
        return status;
    }
}

