/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.database;

import com.manageengine.dataengine.commons.utils.ConsoleOut;
import com.manageengine.dataengine.xnode.bootstrap.BootstrapSettings;
import com.manageengine.dataengine.xnode.bootstrap.Environment;
import com.manageengine.dataengine.xnode.database.DBAdapter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hsqldb.jdbc.JDBCDataSource;
import org.joda.time.format.DateTimeFormat;

public class HsqlDBAdapter
implements DBAdapter {
    private static final String FILE_URL_PREFIX = "jdbc:hsqldb:file:";
    private String confDBUrl;
    private JDBCDataSource dataSource;
    private static volatile boolean isShuttingDown = false;
    private static volatile boolean isCompactShuttingDown = false;
    private String dbPath = ((Path)Environment.XNODE_DB_DIR.value()).toString();
    private String storePath = this.dbPath + File.separator + (String)Environment.XNODE_DB_STORE_DBNAME.value() + File.separator;
    private int backupRetentionDays = (Integer)Environment.XNODE_DB_STORE_BACKUP_RETENTION.value();
    private static final Logger LOGGER = LogManager.getLogger((String)"XNode");

    public HsqlDBAdapter() throws Exception {
        boolean status = false;
        try {
            status = new File(this.dbPath).isDirectory() ? this.backupAndCheckDB() : true;
        }
        catch (Exception ex) {
            LOGGER.error("DB STARTUP : corrupted in startUp, Trying to Restore DB from backup");
        }
        if (!status) {
            try {
                if (!this.restoreDBBackup()) {
                    LOGGER.error("DB STARTUP : Restore Failed.");
                    throw new Exception("DB Restore Failed in StartUp");
                }
                LOGGER.error("DB STARTUP : Restore Success.");
            }
            catch (Exception ex) {
                LOGGER.error("DB STARTUP : Restore Failed.");
                ex.printStackTrace();
                throw new Exception("DB Restore Failed in StartUp");
            }
        }
        this.confDBUrl = FILE_URL_PREFIX + Environment.XNODE_DB_DIR.value() + File.separator + (String)Environment.XNODE_DB_STORE_DBNAME.value() + File.separator + ";hsqldb.write_delay=false;shutdown=false";
        this.dataSource = new JDBCDataSource();
        this.dataSource.setDatabase(this.confDBUrl);
    }

    @Override
    public boolean initialize() throws SQLException {
        return true;
    }

    @Override
    public boolean shutdown() throws SQLException {
        isShuttingDown = true;
        try (Connection con = this.dataSource.getConnection();
             Statement statement = con.createStatement();){
            statement.execute("SHUTDOWN");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean shutdownCompact() throws Exception {
        block30: {
            try {
                isCompactShuttingDown = true;
                LOGGER.info("DB COMPACT SHUTDOWN : Started !");
                if (this.backupAndCheckDB()) {
                    try (Connection con = this.dataSource.getConnection();
                         Statement statement = con.createStatement();){
                        statement.execute("SHUTDOWN COMPACT");
                        LOGGER.info("DB COMPACT SHUTDOWN : Successful !");
                        break block30;
                    }
                    catch (Exception ex) {
                        isCompactShuttingDown = false;
                        LOGGER.error("DB COMPACT SHUTDOWN : Failure !");
                        ex.printStackTrace();
                        this.notifyAndRestart();
                    }
                    break block30;
                }
                LOGGER.error("DB COMPACT SHUTDOWN : Backup Failed !");
            }
            finally {
                isCompactShuttingDown = false;
            }
        }
        return true;
    }

    @Override
    public Connection getConnection() throws SQLException {
        boolean retry;
        Connection connection = null;
        int retryLockErrCount = 4;
        do {
            retry = false;
            try {
                connection = this.dataSource.getConnection();
            }
            catch (SQLException e) {
                LOGGER.info("EXCEPTION while connecting to database! Retrying " + retryLockErrCount + " more times!");
                e.printStackTrace();
                --retryLockErrCount;
                if (e.getMessage().contains("integrity constraint violation: unique constraint") || e.getMessage().contains("Header not allowed or too long")) {
                    try {
                        retry = this.restoreDBBackup();
                        Environment.updateDBRepairOnStartup(false);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        retry = false;
                    }
                } else if (e.getMessage().contains("Database lock acquisition failure")) {
                    if (retryLockErrCount == 1) {
                        try {
                            LOGGER.info("Going to delete .lck file and check...");
                            Files.delete(Paths.get(this.storePath + File.separator + ".lck", new String[0]));
                            LOGGER.info("Deleted .lck file!");
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                    }
                    retry = retryLockErrCount > 0;
                }
                LOGGER.info("Retry for DB Connection : " + retry);
            }
        } while (retry);
        return connection;
    }

    @Override
    public boolean isShuttingDown() {
        return isShuttingDown;
    }

    @Override
    public boolean isCompactShuttingDown() {
        return isCompactShuttingDown;
    }

    private boolean repairScriptError() {
        boolean repaired;
        block48: {
            repaired = true;
            LOGGER.info("DB REPAIR : Going to repair DB");
            try {
                String backupPath = Environment.XNODE_HOME_DIR.value() + File.separator + "backup" + File.separator + "db_" + DateTimeFormat.forPattern((String)"dd-MM-yyyy_HH-mm-ss").print(System.currentTimeMillis());
                HashMap map = new HashMap();
                HashMap<String, Integer> tableColCountMap = new HashMap<String, Integer>();
                tableColCountMap.put("_MAIN", 14);
                tableColCountMap.put("_ARCHIVE", 14);
                String lineStartStr = "block_id";
                this.backupDB(backupPath);
                if (!this.isBackupSuccess(backupPath)) {
                    LOGGER.error("DB REPAIR : Backup DB failed!");
                    break block48;
                }
                File storeDir = new File(this.storePath);
                for (File dbFile : storeDir.listFiles()) {
                    if (!dbFile.isFile() || !dbFile.getName().endsWith(".meta")) continue;
                    HashMap<String, Integer> fileMap = new HashMap<String, Integer>();
                    String fileName = dbFile.getName().replace(".meta", "").toUpperCase();
                    String fileType = fileName.substring(fileName.lastIndexOf("_"));
                    try (BufferedReader reader = new BufferedReader(new FileReader(dbFile));){
                        String line;
                        while ((line = reader.readLine()) != null) {
                            if (line.startsWith(lineStartStr)) continue;
                            String[] tokens = line.split("\t", -1);
                            int tokensLen = tokens.length;
                            if ((Integer)tableColCountMap.get(fileType) == tokensLen) {
                                fileMap.put(tokens[1], tokensLen);
                                continue;
                            }
                            LOGGER.warn("DB REPAIR : INVALID LINE '" + dbFile.getName() + "' :: " + line);
                        }
                    }
                    map.put(fileName, fileMap);
                }
                LOGGER.info("DB REPAIR : Fetched table info");
                File orgScriptFile = new File(this.storePath + ".script");
                File newScriptFile = new File(this.storePath + ".script_new");
                try (BufferedReader reader = new BufferedReader(new FileReader(orgScriptFile));
                     BufferedWriter writer = new BufferedWriter(new FileWriter(newScriptFile));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        if (line.startsWith("INSERT") && !line.startsWith("INSERT INTO BLOCKS")) {
                            String[] lineTokens = line.split(" VALUES");
                            if (lineTokens.length >= 2 && lineTokens[1].startsWith("(") && lineTokens[1].endsWith(")")) {
                                String fileName = lineTokens[0].replace("INSERT INTO ", "");
                                String fileType = fileName.substring(fileName.lastIndexOf("_"));
                                String[] valueTokens = lineTokens[1].split(",", -1);
                                if (!(valueTokens.length < (Integer)tableColCountMap.get(fileType) || map.containsKey(fileName) && ((HashMap)map.get(fileName)).containsKey(valueTokens[1].replace("'", "")))) {
                                    writer.write(line + "\r\n");
                                    continue;
                                }
                                if (valueTokens.length < (Integer)tableColCountMap.get(fileType)) {
                                    LOGGER.warn("DB REPAIR : INVALID LINE in SCRIPT '" + fileName + "' :: " + line);
                                    continue;
                                }
                                LOGGER.warn("DB REPAIR : SKIPPING from script '" + fileName + "' :: " + line);
                                continue;
                            }
                            LOGGER.warn("DB REPAIR : INVALID LINE in SCRIPT :: " + line);
                            continue;
                        }
                        writer.write(line + "\r\n");
                    }
                }
                LOGGER.info("DB REPAIR : Deleting original script file, status : " + orgScriptFile.delete());
                if (!orgScriptFile.exists()) {
                    LOGGER.info("DB REPAIR : Renaming new script file, status : " + newScriptFile.renameTo(orgScriptFile));
                }
            }
            catch (Exception e) {
                LOGGER.error("DB REPAIR : Exception occurred while repairing DB");
                e.printStackTrace();
                repaired = false;
            }
        }
        return repaired;
    }

    private boolean isBackupSuccess(String backupPath) {
        if (!this.sizeCheck(backupPath)) {
            LOGGER.info("DB BACKUP : !! Size check Failed !!");
            return false;
        }
        if (!this.scriptCheck(backupPath, ".script")) {
            LOGGER.info("DB BACKUP : !! Script check Failed !!");
            return false;
        }
        if (!this.scriptCheck(backupPath, ".script.new")) {
            LOGGER.info("DB BACKUP : !! Script new check Failed !!");
            return false;
        }
        return true;
    }

    private void backupDB(String backupPath) throws IOException {
        LOGGER.info("DB BACKUP : Backing DB to : " + backupPath);
        if (new File(this.dbPath).isDirectory()) {
            FileUtils.copyDirectory((File)new File(this.dbPath), (File)new File(backupPath));
        }
    }

    private boolean sizeCheck(String backupPath) {
        long origSize = FileUtils.sizeOfDirectory((File)new File(this.dbPath));
        long backupSize = FileUtils.sizeOfDirectory((File)new File(backupPath));
        LOGGER.info("DB BACKUP : Original DB Size : " + origSize);
        LOGGER.info("DB BACKUP : Backup DB Size : " + backupSize);
        return origSize == backupSize;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean scriptCheck(String backupPath, String fileName) {
        File scriptFile = new File(backupPath + File.separator + "store" + File.separator + fileName);
        if (!scriptFile.exists() && fileName.equalsIgnoreCase(".script.new")) {
            return true;
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(scriptFile));){
            String line;
            do {
                if ((line = reader.readLine()) == null) return true;
            } while (!line.startsWith("INSERT") || line.startsWith("INSERT INTO BLOCKS"));
            boolean bl = false;
            return bl;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    private void limitBackup() throws IOException {
        int index;
        ArrayList<File> dumpFiles = new ArrayList<File>();
        String backupPath = Environment.XNODE_HOME_DIR.value() + File.separator + "dbBackup";
        File backupFolder = new File(backupPath);
        if (!backupFolder.isDirectory()) {
            return;
        }
        File[] fileList = backupFolder.listFiles();
        int fileList_size = fileList.length;
        long cutoffTime = System.currentTimeMillis() - (long)(this.backupRetentionDays * 24 * 60 * 60) * 1000L;
        for (index = 0; index < fileList_size; ++index) {
            if (fileList[index].isDirectory()) {
                long createdTime;
                if (!fileList[index].getName().startsWith("db_") || (createdTime = Long.parseLong(fileList[index].getName().split("_")[1])) >= cutoffTime) continue;
                dumpFiles.add(fileList[index]);
                continue;
            }
            if (!fileList[index].getName().startsWith("_db_")) continue;
            dumpFiles.add(fileList[index]);
        }
        for (index = 0; index < dumpFiles.size(); ++index) {
            File fileToDelete = (File)dumpFiles.get(index);
            FileUtils.deleteDirectory((File)fileToDelete);
        }
    }

    private boolean backupAndCheckDB() throws Exception {
        long curTime = System.currentTimeMillis();
        String backupPath = Environment.XNODE_HOME_DIR.value() + File.separator + "dbBackup" + File.separator + "_db_" + curTime;
        boolean backupSuccess = false;
        int retry = 0;
        while (!backupSuccess && retry < 3) {
            this.backupDB(backupPath);
            if (this.isBackupSuccess(backupPath)) {
                String alteredPath = Environment.XNODE_HOME_DIR.value() + File.separator + "dbBackup" + File.separator + "db_" + curTime;
                FileUtils.copyDirectory((File)new File(backupPath), (File)new File(alteredPath));
                FileUtils.deleteDirectory((File)new File(backupPath));
                LOGGER.info("DB BACKUP : Backup successful " + alteredPath);
                backupSuccess = true;
                continue;
            }
            FileUtils.deleteDirectory((File)new File(backupPath));
            LOGGER.info("DB BACKUP : Backup DB Failed for " + ++retry + " time");
        }
        if (!backupSuccess) {
            throw new Exception("Backup DB Failed size of original and backup DB's aren't equal!!!!");
        }
        try {
            this.limitBackup();
        }
        catch (Exception ex) {
            LOGGER.info("Unable to delete old backup files!!!");
            ex.printStackTrace();
        }
        return true;
    }

    private boolean restoreDBBackup() throws IOException {
        ArrayList<File> dumpFiles = new ArrayList<File>();
        String backupPath = Environment.XNODE_HOME_DIR.value() + File.separator + "dbBackup";
        File backupFolder = new File(backupPath);
        File[] fileList = backupFolder.listFiles();
        int fileList_size = fileList.length;
        for (int index = 0; index < fileList_size; ++index) {
            if (!fileList[index].isDirectory() || !fileList[index].getName().startsWith("db_")) continue;
            dumpFiles.add(fileList[index]);
        }
        if (dumpFiles.size() == 0) {
            return false;
        }
        Collections.sort(dumpFiles, Comparator.reverseOrder());
        String backupFile = String.valueOf(dumpFiles.get(0));
        LOGGER.info("DB RESTORE : Going to restore db from " + backupFile);
        try {
            FileUtils.deleteDirectory((File)new File(this.dbPath));
        }
        catch (Exception ex) {
            LOGGER.info("DB RESTORE : Exception in deleting db - " + ex.getMessage());
            ex.printStackTrace();
        }
        FileUtils.copyDirectory((File)new File(String.valueOf(dumpFiles.get(0))), (File)new File(this.dbPath));
        LOGGER.info("DB RESTORE : Restore db Completed !");
        return true;
    }

    private void notifyAndRestart() {
        try {
            for (int i = 0; i < (Integer)BootstrapSettings.XNODE_DE_RESTART_DAILY_RESTART_THRESHOLD.value(); ++i) {
                Environment.updateDERestartStatus();
            }
            ConsoleOut.println((String)"SHUTDOWN-COMPACT-FAILED");
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
        }
    }
}

