/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository;

import com.csvreader.CsvReader;
import com.manageengine.dataengine.commons.datarepository.DRIndexField;
import com.manageengine.dataengine.commons.file.GzipUtil;
import com.manageengine.dataengine.xnode.database.DBManager;
import com.manageengine.dataengine.xnode.datarepository.AuditLogDR;
import com.manageengine.dataengine.xnode.datarepository.AuditLogDRBlock;
import com.manageengine.dataengine.xnode.datarepository.DRBlock;
import com.manageengine.dataengine.xnode.datarepository.DataRepositoryActionRequest;
import com.manageengine.dataengine.xnode.datarepository.LuceneIndexHandler;
import com.manageengine.dataengine.xnode.datarepository.MetaFileType;
import com.manageengine.dataengine.xnode.datarepository.search.SearchService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.json.JSONArray;
import org.json.JSONObject;

public class AdapMigrationUtil {
    private static final Logger LOGGER = LogManager.getLogger((String)"DataRepository");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject addMigrationData(AuditLogDR dataRepository, DataRepositoryActionRequest request) throws Exception {
        JSONObject jResponse = new JSONObject();
        int READ_BUF_SIZE = 4056;
        JSONArray errorLineList = new JSONArray();
        JSONArray dataFilePathList = request.dataFilePathList();
        Charset fileEncoding = request.fileEncoding();
        long blockCreationTime = request.creationTime();
        char splitBy = request.splitBy();
        ArrayList<DRIndexField> fieldList = dataRepository.getIndexFields();
        GzipUtil gzipUtil = new GzipUtil();
        GzipUtil.GzipCsvWriteHandle gzipCsvWriteHandle = null;
        IndexWriter indexWriter = null;
        String blockName = dataRepository.blockPrefix() + "_" + blockCreationTime;
        String blockPath = dataRepository.defaultMainBlocksLocation() + File.separator + blockName + File.separator;
        String rawDataFilePath = blockPath + File.separator + "raw-data" + File.separator + "rawData.gz";
        int errLineCount = 0;
        int indexedCount = 0;
        int totalCount = 0;
        int lineNo = 0;
        boolean isMSSql = false;
        String msSQLLineTerminator = "|**|**|";
        String msSQLFieldTerminator = "\\|\\*\\*\\|";
        LOGGER.info("DATA MIGRATION :: Going to migrate data to block '" + blockName + "'");
        try {
            File rawDataDir = new File(blockPath + File.separator + "raw-data");
            if (!rawDataDir.exists()) {
                rawDataDir.mkdirs();
            }
            if (fileEncoding != null && fileEncoding.toString().equalsIgnoreCase("UTF-16")) {
                isMSSql = true;
            }
            indexWriter = LuceneIndexHandler.getIndexWriter(blockPath + "luc-index", dataRepository.getAnalyzerWrapper(), dataRepository.getIndexSortObj());
            gzipCsvWriteHandle = gzipUtil.getGzipCsvWriteHandle(rawDataFilePath, "UTF-8", '\t');
            Long elapsedIndexTimeMillis = System.currentTimeMillis();
            for (int pathIndex = 0; pathIndex < dataFilePathList.length(); ++pathIndex) {
                String dataFilePath = dataFilePathList.getString(pathIndex);
                JSONArray fileErrorLineList = new JSONArray();
                BufferedReader br = null;
                CsvReader csvReader = null;
                lineNo = 0;
                try {
                    br = fileEncoding == null ? new BufferedReader(new InputStreamReader(new FileInputStream(dataFilePath)), 4056) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(dataFilePath), fileEncoding), 4056);
                    if (!dataRepository.isStopping()) {
                        Document doc;
                        if (isMSSql) {
                            String line = "";
                            while ((line = br.readLine()) != null) {
                                try {
                                    ++lineNo;
                                    if (!line.endsWith(msSQLLineTerminator)) {
                                        String secondline;
                                        while ((secondline = br.readLine()) != null) {
                                            ++lineNo;
                                            if (!(line = line + secondline).endsWith(msSQLLineTerminator)) continue;
                                        }
                                    }
                                    ++totalCount;
                                    String[] colVals = line.split(msSQLFieldTerminator, -1);
                                    if (colVals.length != fieldList.size()) {
                                        colVals = DRBlock.fillMissingCols(colVals, fieldList.size());
                                    }
                                    if (colVals[12].startsWith("%{")) {
                                        colVals[12] = colVals[12].substring(2, colVals[12].length() - 1);
                                    }
                                    doc = DRBlock.getLucDocument(colVals, fieldList);
                                    indexWriter.addDocument((Iterable)doc);
                                    gzipCsvWriteHandle.writeNext(colVals);
                                    ++indexedCount;
                                }
                                catch (Exception e) {
                                    LOGGER.error("Archive Index Parsing Exception[" + e.getMessage() + "] :: " + line);
                                    ++errLineCount;
                                    fileErrorLineList.put(lineNo);
                                }
                            }
                            indexWriter.commit();
                        } else {
                            csvReader = new CsvReader((Reader)br, splitBy);
                            csvReader.setSafetySwitch(false);
                            while (csvReader.readRecord()) {
                                ++lineNo;
                                ++totalCount;
                                try {
                                    String[] colVals = csvReader.getValues();
                                    String[] colValsEsc = new String[colVals.length];
                                    for (int i = 0; i < colVals.length; ++i) {
                                        colValsEsc[i] = colVals[i].replace("\\\\", "\\");
                                        if (!colValsEsc[i].equals("\\N")) continue;
                                        colValsEsc[i] = "";
                                    }
                                    if (colValsEsc.length != fieldList.size()) {
                                        colValsEsc = DRBlock.fillMissingCols(colValsEsc, fieldList.size());
                                    }
                                    if (colValsEsc[12].startsWith("%{")) {
                                        colValsEsc[12] = colValsEsc[12].substring(2, colValsEsc[12].length() - 1);
                                    }
                                    doc = DRBlock.getLucDocument(colValsEsc, fieldList);
                                    indexWriter.addDocument((Iterable)doc);
                                    gzipCsvWriteHandle.writeNext(colValsEsc);
                                    ++indexedCount;
                                }
                                catch (Exception e) {
                                    LOGGER.error("Archive Index Parsing Exception[" + e.getMessage() + "] :: " + csvReader.getRawRecord());
                                    ++errLineCount;
                                    fileErrorLineList.put(lineNo);
                                }
                            }
                            indexWriter.commit();
                        }
                        errorLineList.put((Object)fileErrorLineList);
                        continue;
                    }
                    throw new Exception("DataEngine XNode is shutting down!");
                }
                finally {
                    if (csvReader != null) {
                        csvReader.close();
                    }
                    if (br != null) {
                        br.close();
                    }
                }
            }
            long elapsedMergeTimeMillis = System.currentTimeMillis();
            indexWriter.forceMerge(1, true);
            indexWriter.commit();
            elapsedMergeTimeMillis = System.currentTimeMillis() - elapsedMergeTimeMillis;
            elapsedIndexTimeMillis = System.currentTimeMillis() - elapsedIndexTimeMillis;
            LOGGER.info("DATA MIGRATION :: Total time to merge index : " + elapsedMergeTimeMillis);
            LOGGER.info("DATA MIGRATION :: Total time to index block '" + blockName + "' :: " + elapsedIndexTimeMillis);
            LOGGER.info("DATA MIGRATION :: Index-Document count :: " + indexWriter.getDirectory() + " : " + indexWriter.numDocs());
            long blockSize = FileUtils.sizeOf((File)new File(blockPath));
            long rawSize = FileUtils.sizeOf((File)new File(blockPath + "raw-data"));
            int docCount = indexWriter.numDocs();
            AuditLogDRBlock drBlock = AuditLogDRBlock.loadBlock(dataRepository, blockName, 10, AuditLogDRBlock.State.COLD.toString(), "-", blockCreationTime, 0L, 0L, docCount, blockSize, rawSize, 0);
            boolean isMerged = SearchService.getSegmentCount(drBlock) == 1;
            JSONObject jRes = SearchService.getMinMaxLongField(dataRepository.schema().getRangeField(), drBlock);
            long rangeFrom = jRes.getLong("min") == -1L ? 0L : jRes.getLong("min");
            long rangeTo = jRes.getLong("max") == -1L ? 0L : jRes.getLong("max");
            drBlock.isMerged(isMerged);
            drBlock.rangeFrom(rangeFrom);
            drBlock.rangeTo(rangeTo);
            try (Connection connection = DBManager.getStoreConnection();){
                dataRepository.persistenceHandler().addToMetaFile(connection, drBlock, MetaFileType.MAIN);
            }
            dataRepository.addBlockToColdMap(drBlock);
            LOGGER.info("DATA MIGRATION :: Successfully migrated data! [blockName : " + blockName + "]");
            jResponse.put("error_code", 0);
            jResponse.put("error_count", errLineCount);
            jResponse.put("error_line_list", (Object)errorLineList);
            jResponse.put("index_process_time", (Object)elapsedIndexTimeMillis);
            jResponse.put("indexed_doc_count", indexedCount);
            jResponse.put("actual_doc_count", docCount);
            jResponse.put("line_count", totalCount);
        }
        finally {
            if (indexWriter != null) {
                indexWriter.close();
                indexWriter.getDirectory().close();
                indexWriter = null;
            }
            if (gzipCsvWriteHandle != null) {
                gzipCsvWriteHandle.close();
            }
        }
        return jResponse;
    }
}

