/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository;

import com.manageengine.dataengine.xnode.bootstrap.Environment;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.apache.commons.configuration2.INIConfiguration;
import org.apache.commons.configuration2.SubnodeConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ArchiveLocationsConfFile {
    private static final File CONF_FILE = ((Path)Environment.XNODE_DR_ARCHIVE_LOCATIONS_CONF_FILE.value()).toFile();
    private static final String KEY_PREFIX = "ARCHIVE_LOCATION_";
    public static final String CURRENT_STATE = "current";
    public static final String OBSOLETE_STATE = "obsolete";
    public static final String UNDEFINED_STATE = "undefined";
    private INIConfiguration config;
    private FileHandler confFileHandler;
    private static final Logger LOGGER = LogManager.getLogger((String)"DataRepository");

    private ArchiveLocationsConfFile(File confFile) throws Exception {
        confFile.getParentFile().mkdirs();
        confFile.createNewFile();
        this.config = new INIConfiguration();
        this.confFileHandler = new FileHandler((FileBased)this.config);
        this.confFileHandler.load(confFile);
        this.confFileHandler.setFile(confFile);
    }

    public static ArchiveLocationsConfFile load() throws Exception {
        CONF_FILE.getParentFile().mkdirs();
        CONF_FILE.createNewFile();
        ArchiveLocationsConfFile archiveLocationsConfFile = new ArchiveLocationsConfFile(CONF_FILE);
        return archiveLocationsConfFile;
    }

    public static ArchiveLocationsConfFile load(JSONArray json) throws Exception {
        ArchiveLocationsConfFile archiveLocationsConfFile = new ArchiveLocationsConfFile(CONF_FILE);
        archiveLocationsConfFile.config.clear();
        archiveLocationsConfFile.confFileHandler.save();
        int arrLen = json.length();
        for (int i = 0; i < arrLen; ++i) {
            archiveLocationsConfFile.add(ArchiveLocation.load(json.getJSONObject(i)));
        }
        archiveLocationsConfFile.confFileHandler.save();
        return archiveLocationsConfFile;
    }

    public static ArchiveLocationsConfFile loadDefaultLocation() throws Exception {
        ArchiveLocationsConfFile archiveLocationsConfFile = new ArchiveLocationsConfFile(CONF_FILE);
        archiveLocationsConfFile.config.clear();
        archiveLocationsConfFile.confFileHandler.save();
        archiveLocationsConfFile.add(ArchiveLocation.loadDefault());
        archiveLocationsConfFile.confFileHandler.save();
        return archiveLocationsConfFile;
    }

    public static ArchiveLocationsConfFile cleanAndAddAll(JSONArray json) throws Exception {
        ArchiveLocationsConfFile archiveLocationsConfFile = new ArchiveLocationsConfFile(CONF_FILE);
        int arrLen = json.length();
        for (int i = 0; i < arrLen; ++i) {
            boolean isNew = true;
            for (String archiveLocation : archiveLocationsConfFile.config.getSections()) {
                if (!FilenameUtils.equalsNormalizedOnSystem((String)archiveLocationsConfFile.config.getSection(archiveLocation).getString("path"), (String)FilenameUtils.normalizeNoEndSeparator((String)((JSONObject)json.get(i)).getString("path")))) continue;
                isNew = false;
                break;
            }
            if (!isNew) continue;
            archiveLocationsConfFile.add(ArchiveLocation.load((JSONObject)json.get(i)));
        }
        archiveLocationsConfFile.confFileHandler.save();
        return archiveLocationsConfFile;
    }

    public void add(ArchiveLocation archiveLocationBean) throws Exception {
        String newKey = KEY_PREFIX + (this.config.getSections().size() + 1);
        archiveLocationBean.fillSection(this.config.getSection(newKey));
        this.confFileHandler.save();
    }

    public void changeCurrentArchiveLocationTo(ArchiveLocation archiveLocation) throws Exception {
        boolean foundPath = false;
        for (String arcLocation : this.config.getSections()) {
            SubnodeConfiguration subnodeConf = this.config.getSection(arcLocation);
            if (FilenameUtils.equalsNormalizedOnSystem((String)subnodeConf.getString("path"), (String)archiveLocation.path())) {
                subnodeConf.setProperty("state", (Object)CURRENT_STATE);
                foundPath = true;
                continue;
            }
            subnodeConf.setProperty("state", (Object)OBSOLETE_STATE);
        }
        this.confFileHandler.save();
        if (!foundPath) {
            this.add(archiveLocation);
        }
    }

    public void remove(String archiveLocation) throws Exception {
        for (String arcLocation : this.config.getSections()) {
            SubnodeConfiguration subnodeConf = this.config.getSection(arcLocation);
            if (!FilenameUtils.equalsNormalizedOnSystem((String)subnodeConf.getString("path"), (String)archiveLocation)) continue;
            subnodeConf.clear();
            this.confFileHandler.save();
            break;
        }
    }

    public ArrayList<String> getArchiveLocations() {
        ArrayList<String> archiveLocationList = new ArrayList<String>();
        for (String arcLocation : this.config.getSections()) {
            archiveLocationList.add(this.config.getSection(arcLocation).getString("path"));
        }
        return archiveLocationList;
    }

    public String getCurrentArchiveLocation() throws IOException, ConfigurationException {
        SubnodeConfiguration currentArchivePathSection = this.getCurrentArchiveLocationSection();
        return currentArchivePathSection == null ? null : currentArchivePathSection.getString("path");
    }

    public void updateCurrentArchiveLocationBlockCount(int blockCount) throws IOException, ConfigurationException {
        SubnodeConfiguration currentArchivePathSection = this.getCurrentArchiveLocationSection();
        if (currentArchivePathSection != null) {
            currentArchivePathSection.setProperty("blocks_count", (Object)(currentArchivePathSection.getInt("blocks_count", 0) + blockCount));
            this.confFileHandler.save();
        }
    }

    private SubnodeConfiguration getCurrentArchiveLocationSection() throws ConfigurationException {
        SubnodeConfiguration tempConf;
        int i;
        SubnodeConfiguration currentArchivePathSection = null;
        ArrayList archiveLocationList = new ArrayList(this.config.getSections());
        ArrayList<Integer> curArchLocations = new ArrayList<Integer>();
        for (i = 0; i < archiveLocationList.size(); ++i) {
            tempConf = this.config.getSection((String)archiveLocationList.get(i));
            if (!tempConf.getString("state").equalsIgnoreCase(CURRENT_STATE)) continue;
            curArchLocations.add(i);
            currentArchivePathSection = tempConf;
        }
        if (curArchLocations.size() == 0) {
            for (i = archiveLocationList.size() - 1; i >= 0; --i) {
                tempConf = this.config.getSection((String)archiveLocationList.get(i));
                if (!new File(tempConf.getString("path")).exists()) continue;
                tempConf.setProperty("state", (Object)CURRENT_STATE);
                this.confFileHandler.save();
                currentArchivePathSection = tempConf;
                break;
            }
        } else if (curArchLocations.size() > 1) {
            boolean foundCurrent = false;
            for (int i2 = curArchLocations.size() - 1; i2 >= 0; --i2) {
                SubnodeConfiguration tempConf2 = this.config.getSection((String)archiveLocationList.get((Integer)curArchLocations.get(i2)));
                if (foundCurrent) {
                    tempConf2.setProperty("state", (Object)OBSOLETE_STATE);
                    continue;
                }
                if (!new File(tempConf2.getString("path")).exists()) continue;
                currentArchivePathSection = tempConf2;
                foundCurrent = true;
            }
            this.confFileHandler.save();
        }
        return currentArchivePathSection;
    }

    public JSONArray toJSON() throws Exception {
        JSONArray json = new JSONArray();
        for (String arcLocation : this.config.getSections()) {
            json.put((Object)ArchiveLocation.load(this.config.getSection(arcLocation)).toJSON());
        }
        return json;
    }

    public void logArchiveLocationsInfo() throws Exception {
        for (String arcLocation : this.config.getSections()) {
            ArchiveLocation.load(this.config.getSection(arcLocation)).logArchiveLocationInfo();
        }
    }

    public static class ArchiveLocation {
        private String path;
        private Integer blocks_count;
        private Long size;
        private String state;

        private ArchiveLocation() {
        }

        public String path() {
            return this.path;
        }

        public void path(String path) {
            this.path = Paths.get(FilenameUtils.normalizeNoEndSeparator((String)path), new String[0]).toAbsolutePath().toString();
        }

        public Integer blocksCount() {
            return this.blocks_count;
        }

        public void blocksCount(Integer blockCount) {
            this.blocks_count = blockCount;
        }

        public Long size() {
            return this.size;
        }

        public void size(Long size) {
            this.size = size;
        }

        public String state() {
            return this.state;
        }

        public void state(String state) {
            this.state = state;
        }

        public static ArchiveLocation loadDefault() throws Exception {
            ArchiveLocation dataRepository = new ArchiveLocation();
            dataRepository.path = FilenameUtils.normalizeNoEndSeparator((String)((Path)Environment.XNODE_DATA_ARCHIVE_DIR.value()).toAbsolutePath().toString());
            dataRepository.blocks_count = 0;
            dataRepository.size = 0L;
            dataRepository.state = ArchiveLocationsConfFile.CURRENT_STATE;
            return dataRepository;
        }

        public static ArchiveLocation load(String path) throws Exception {
            ArchiveLocation dataRepository = new ArchiveLocation();
            dataRepository.path = FilenameUtils.normalizeNoEndSeparator((String)Paths.get(path, new String[0]).toAbsolutePath().toString());
            dataRepository.blocks_count = 0;
            dataRepository.size = 0L;
            dataRepository.state = ArchiveLocationsConfFile.CURRENT_STATE;
            return dataRepository;
        }

        public static ArchiveLocation load(SubnodeConfiguration subnodeConf) {
            ArchiveLocation dataRepository = new ArchiveLocation();
            dataRepository.path = Paths.get(FilenameUtils.normalizeNoEndSeparator((String)subnodeConf.getString("path")), new String[0]).toAbsolutePath().toString();
            dataRepository.blocks_count = subnodeConf.getInt("blocks_count", 0);
            dataRepository.size = subnodeConf.getLong("size", 0L);
            dataRepository.state = subnodeConf.getString("state", ArchiveLocationsConfFile.UNDEFINED_STATE);
            return dataRepository;
        }

        public static ArchiveLocation load(JSONObject json) throws Exception {
            ArchiveLocation dataRepository = new ArchiveLocation();
            dataRepository.path = Paths.get(FilenameUtils.normalizeNoEndSeparator((String)json.getString("path")), new String[0]).toAbsolutePath().toString();
            dataRepository.blocks_count = json.optInt("blocks_count", 0);
            dataRepository.size = json.optLong("size", 0L);
            dataRepository.state = json.optString("state", ArchiveLocationsConfFile.UNDEFINED_STATE);
            return dataRepository;
        }

        public void update(ArchiveLocation repositoryBean) throws Exception {
            this.blocks_count = repositoryBean.blocksCount();
            this.size = repositoryBean.size();
            this.state = repositoryBean.state();
        }

        public SubnodeConfiguration fillSection(SubnodeConfiguration subnodeConf) throws JSONException {
            subnodeConf.setProperty("path", (Object)this.path);
            subnodeConf.setProperty("blocks_count", (Object)this.blocks_count);
            subnodeConf.setProperty("size", (Object)this.size);
            subnodeConf.setProperty("state", (Object)this.state);
            return subnodeConf;
        }

        public JSONObject toJSON() throws JSONException {
            JSONObject json = new JSONObject();
            json.put("path", (Object)this.path);
            json.put("blocks_count", (Object)this.blocks_count);
            json.put("size", (Object)this.size);
            json.put("state", (Object)this.state);
            return json;
        }

        public void logArchiveLocationInfo() {
            LOGGER.info("------------------------------------------------");
            LOGGER.info(" ACHIVE LOCATION - " + this.path);
            LOGGER.info("------------------------------------------------");
            LOGGER.info(" # blocks_count :: " + this.blocks_count);
            LOGGER.info(" # size :: " + this.size);
            LOGGER.info(" # state :: " + this.state);
            LOGGER.info("------------------------------------------------");
        }
    }
}

