/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository;

import com.csvreader.CsvReader;
import com.manageengine.dataengine.commons.crypto.CryptoUtil;
import com.manageengine.dataengine.commons.datarepository.DRIndexField;
import com.manageengine.dataengine.commons.datarepository.XNodeDRConfFile;
import com.manageengine.dataengine.commons.file.GzipUtil;
import com.manageengine.dataengine.commons.utils.ConsoleOut;
import com.manageengine.dataengine.xnode.bootstrap.Environment;
import com.manageengine.dataengine.xnode.bootstrap.XNodeManager;
import com.manageengine.dataengine.xnode.database.DBManager;
import com.manageengine.dataengine.xnode.datarepository.AdapMigrationUtil;
import com.manageengine.dataengine.xnode.datarepository.AuditLogDRBlock;
import com.manageengine.dataengine.xnode.datarepository.DRBlock;
import com.manageengine.dataengine.xnode.datarepository.DataRepository;
import com.manageengine.dataengine.xnode.datarepository.DataRepositoryActionRequest;
import com.manageengine.dataengine.xnode.datarepository.DataRepositoryManager;
import com.manageengine.dataengine.xnode.datarepository.LuceneIndexHandler;
import com.manageengine.dataengine.xnode.datarepository.MetaFileType;
import com.manageengine.dataengine.xnode.datarepository.search.SearchService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.io.IoBuilder;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CheckIndex;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.AlreadyClosedException;
import org.json.JSONArray;
import org.json.JSONObject;

public class AuditLogDR
extends DataRepository {
    private HashMap<String, AuditLogDRBlock> hotBlockMap;
    private HashMap<String, AuditLogDRBlock> coldBlockMap;
    private HashMap<String, AuditLogDRBlock> coldToFrozenBlockMap;
    private HashMap<String, Integer> frozenBlockMap;
    private HashMap<String, AuditLogDRBlock> defrostBlockMap;
    private BlockingQueue<AuditLogDRBlock> hotBlockQueue;
    private JSONArray deletedBlocksList = new JSONArray();
    private boolean loadDefrostBlocksForSearch = true;
    private volatile boolean shutdown = false;
    protected final Object archive_lock = new Object();
    private ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private ScheduledFuture<?> schedulerFuture;
    private int hotIndexErrCount = 0;
    private int blockingQueueTimeout = (Integer)Environment.XNODE_DE_RESTART_BLOCKING_QUEUE_TIMEOUT.value();
    private int commitFailureThreshold = (Integer)Environment.XNODE_DE_RESTART_COMMIT_FAILURE_THRESHOLD.value();
    private int commitFailureCount = 0;
    private boolean restartedAlready = false;
    private static final Logger LOGGER = LogManager.getLogger((String)"DataRepository");

    public AuditLogDR(XNodeDRConfFile.DataRepositoryBean drBean) throws Exception {
        super(drBean);
        this.initBlocksMetaFile();
        this.loadMainBlocksFromMetaFile();
        this.initHotBlocks();
        this.loadArchiveBlocksFromMetaFile();
        this.updateColdToFrozenBlocks();
        if (this.hotBlockRefreshInterval() != 0) {
            this.schedulerFuture = this.scheduler.scheduleWithFixedDelay(new HotIndexCommitter(), 0L, this.hotBlockRefreshInterval(), TimeUnit.SECONDS);
        }
    }

    @Override
    public AuditLogDR update(XNodeDRConfFile.DataRepositoryBean drBean) throws Exception {
        super.update(drBean);
        if (this.schedulerFuture != null) {
            this.schedulerFuture.cancel(false);
        }
        if (this.hotBlockRefreshInterval() != 0) {
            this.schedulerFuture = this.scheduler.scheduleWithFixedDelay(new HotIndexCommitter(), 0L, this.hotBlockRefreshInterval(), TimeUnit.SECONDS);
        }
        return this;
    }

    private void initBlocksMetaFile() throws Exception {
        try (Connection connection = DBManager.getStoreConnection();){
            if (!this.persistenceHandler().checkIfMetaFileExists(connection, MetaFileType.MAIN)) {
                LOGGER.info("CREATING Main-MetaInfo table for DataRepository '" + this.repositoryName() + "'");
                this.persistenceHandler().createMetaFile(connection, MetaFileType.MAIN);
            } else {
                LOGGER.info("Main-MetaInfo table for DataRepository '" + this.repositoryName() + "' already exists!");
            }
            if (!this.persistenceHandler().checkIfMetaFileExists(connection, MetaFileType.ARCHIVE)) {
                LOGGER.info("CREATING Archive-MetaInfo table for DataRepository '" + this.repositoryName() + "'");
                this.persistenceHandler().createMetaFile(connection, MetaFileType.ARCHIVE);
            } else {
                LOGGER.info("Archive-MetaInfo table for DataRepository '" + this.repositoryName() + "' already exists!");
            }
        }
    }

    private void initHotBlocks() throws Exception {
        int i;
        int diff;
        LOGGER.info("VALIDATING Hot-Blocks for DataRepository '" + this.repositoryName() + "', [Allowed Hot-Blocks count : " + this.hotBlockCount() + "] [Current Hot-Blocks count : " + this.hotBlockMap.size() + "]");
        if (this.hotBlockMap.size() < this.hotBlockCount()) {
            diff = this.hotBlockCount() - this.hotBlockMap.size();
            for (i = 0; i < diff; ++i) {
                this.createHotBlock();
            }
        } else if (this.hotBlockMap.size() > this.hotBlockCount()) {
            diff = this.hotBlockMap.size() - this.hotBlockCount();
            for (i = 0; i < diff; ++i) {
                this.moveHotBlockToCold(this.hotBlockMap.values().iterator().next());
            }
        }
        this.hotBlockQueue = new LinkedBlockingDeque<AuditLogDRBlock>(this.hotBlockCount());
        for (AuditLogDRBlock drBlock : this.hotBlockMap.values()) {
            this.hotBlockQueue.put(drBlock);
        }
    }

    private void loadMainBlocksFromMetaFile() throws Exception {
        this.hotBlockMap = new HashMap();
        this.coldBlockMap = new HashMap();
        this.coldToFrozenBlockMap = new HashMap();
        int errCount = 0;
        int batchFetchCount = 500;
        int fetchedCount = -1;
        int offset = 0;
        LOGGER.info("LOADING Main-Blocks for DataRepository '" + this.repositoryName() + "'");
        try (Connection storeCon = DBManager.getStoreConnection();){
            while (fetchedCount != 0) {
                JSONArray resultBlockList = this.persistenceHandler().readFromMetaFile(storeCon, MetaFileType.MAIN, offset, batchFetchCount);
                fetchedCount = resultBlockList.length();
                offset += batchFetchCount;
                for (int i = 0; i < fetchedCount; ++i) {
                    AuditLogDRBlock drBlock = null;
                    try {
                        drBlock = this.buildDRBlock(resultBlockList.getJSONObject(i), true);
                        if (drBlock != null && drBlock.currentBlockStateAction().toString().startsWith(AuditLogDRBlock.State.HOT.toString())) {
                            if (drBlock.isFull()) {
                                this.moveHotBlockToCold(drBlock);
                                continue;
                            }
                            this.hotBlockMap.put(drBlock.blockName(), drBlock);
                            continue;
                        }
                        if (drBlock != null && drBlock.currentBlockStateAction().toString().equals(AuditLogDRBlock.State.COLD__TO_FROZEN.toString())) {
                            this.coldToFrozenBlockMap.put(drBlock.blockName(), drBlock);
                            continue;
                        }
                        if (drBlock == null || !drBlock.currentBlockStateAction().toString().startsWith(AuditLogDRBlock.State.COLD.toString())) continue;
                        this.coldBlockMap.put(drBlock.blockName(), drBlock);
                        continue;
                    }
                    catch (Exception e) {
                        LOGGER.error("EXCEPTION while loading Main-Block : " + (drBlock == null ? null : drBlock.blockName()) + " :: " + e.getMessage());
                        e.printStackTrace(new PrintStream(IoBuilder.forLogger((Logger)LOGGER).buildOutputStream(), true));
                        ++errCount;
                    }
                }
            }
        }
        LOGGER.info("SUMMARY of Main-Blocks for DataRepository '" + this.repositoryName() + "' [Hot Blocks : " + this.hotBlockMap.size() + "] [Cold Blocks : " + this.coldBlockMap.size() + "] [Error Blocks : " + errCount + "]");
    }

    private void loadArchiveBlocksFromMetaFile() throws Exception {
        this.defrostBlockMap = new HashMap();
        this.frozenBlockMap = new HashMap();
        int errCount = 0;
        int batchFetchCount = 500;
        int fetchedCount = -1;
        int offset = 0;
        LOGGER.info("LOADING Defrost-Blocks for DataRepository '" + this.repositoryName() + "'");
        try (Connection storeCon = DBManager.getStoreConnection();){
            while (fetchedCount != 0) {
                JSONArray resultBlockList = this.persistenceHandler().readFromMetaFile(storeCon, MetaFileType.ARCHIVE, offset, batchFetchCount);
                fetchedCount = resultBlockList.length();
                offset += batchFetchCount;
                for (int i = 0; i < fetchedCount; ++i) {
                    AuditLogDRBlock drBlock = null;
                    try {
                        drBlock = this.buildDRBlock(resultBlockList.getJSONObject(i), false);
                        if (drBlock == null) continue;
                        if (drBlock.currentBlockStateAction().toString().equals(AuditLogDRBlock.State.FROZEN__TO_DEFROST.toString())) {
                            LOGGER.error("EXCEPTION while loading archive-blocks, block - " + drBlock.blockName() + " is in DEFROSTING state, DELETING the defrost block folder!");
                            FileUtils.deleteDirectory((File)new File(this.defaultDefrostBlocksLocation() + drBlock.blockName()));
                            if (drBlock.status().equals(AuditLogDRBlock.State.FROZEN__TO_DEFROST.toString())) {
                                drBlock.status(AuditLogDRBlock.State.FROZEN.toString());
                            }
                            drBlock.changeStateTo(AuditLogDRBlock.State.FROZEN);
                            LOGGER.error("RESET the state of block - " + drBlock.currentBlockStateAction() + " from BLOCK_STATE_FROZEN__TO_DEFROST to FROZEN state");
                            this.frozenBlockMap.put(drBlock.blockName(), drBlock.metaIndex());
                            continue;
                        }
                        if (drBlock.currentBlockStateAction().toString().equals(AuditLogDRBlock.State.COLD__TO_FROZEN.toString())) {
                            this.coldToFrozenBlockMap.put(drBlock.blockName(), drBlock);
                            this.frozenBlockMap.put(drBlock.blockName(), drBlock.metaIndex());
                            continue;
                        }
                        if (drBlock.currentBlockStateAction().toString().startsWith(AuditLogDRBlock.State.FROZEN.toString())) {
                            this.frozenBlockMap.put(drBlock.blockName(), drBlock.metaIndex());
                            continue;
                        }
                        if (!drBlock.currentBlockStateAction().toString().startsWith(AuditLogDRBlock.State.DEFROST.toString())) continue;
                        this.defrostBlockMap.put(drBlock.blockName(), drBlock);
                        continue;
                    }
                    catch (Exception e) {
                        LOGGER.error("EXCEPTION while loading archive-blocks : " + (drBlock == null ? null : drBlock.blockName()) + ", DELETING the defrost block folder! :: " + e.getMessage());
                        e.printStackTrace(new PrintStream(IoBuilder.forLogger((Logger)LOGGER).buildOutputStream(), true));
                        if (drBlock != null) {
                            FileUtils.deleteDirectory((File)new File(this.defaultDefrostBlocksLocation() + drBlock.blockName()));
                        }
                        ++errCount;
                    }
                }
            }
        }
        catch (Exception e) {
            if (e.getMessage().contains("Column not found: cold_size")) {
                LOGGER.info("cold_size Column not found");
            }
            throw e;
        }
        LOGGER.info("SUMMARY of Archive-Blocks for DataRepository '" + this.repositoryName() + "' [Frozen Blocks : " + this.frozenBlockMap.size() + "] [Defrost Blocks : " + this.defrostBlockMap.size() + "] [Error Blocks : " + errCount + "]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<AuditLogDRBlock> getBlocksToMarkForDelete(boolean isStage1) throws Exception {
        ArrayList<AuditLogDRBlock> blocksToDelete = new ArrayList<AuditLogDRBlock>();
        LOGGER.info("LOADING Archive Blocks to be marked for deletion");
        try (Connection connection = DBManager.getStoreConnection();){
            JSONArray blocksList;
            if (!isStage1) {
                Object object = this.archive_lock;
                synchronized (object) {
                    blocksList = this.persistenceHandler().getBlocksToMarkForDelete(connection, isStage1 ? this.absoluteFrozenS1BlockRetentionDays() : this.absoluteFrozenBlockRetentionDays(), MetaFileType.ARCHIVE, isStage1);
                    for (int i = 0; i < blocksList.length(); ++i) {
                        this.frozenBlockMap.remove(blocksList.getJSONObject(i).getString("block_name"));
                    }
                }
            } else {
                blocksList = this.persistenceHandler().getBlocksToMarkForDelete(connection, isStage1 ? this.absoluteFrozenS1BlockRetentionDays() : this.absoluteFrozenBlockRetentionDays(), MetaFileType.ARCHIVE, isStage1);
            }
            for (int i = 0; i < blocksList.length(); ++i) {
                AuditLogDRBlock drBlock = null;
                try {
                    drBlock = this.buildDRBlock(blocksList.getJSONObject(i), false);
                    blocksToDelete.add(drBlock);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return blocksToDelete;
    }

    private ArrayList<AuditLogDRBlock> getBlocksToPurge(boolean isMain) throws Exception {
        ArrayList<AuditLogDRBlock> blocksToPurge = new ArrayList<AuditLogDRBlock>();
        LOGGER.info("LOADING Archive Blocks to Purge");
        try (Connection connection = DBManager.getStoreConnection();){
            JSONArray blocksList = this.persistenceHandler().getBlocksToPurge(connection, this.graceBlockRetentionDays(), isMain);
            for (int i = 0; i < blocksList.length(); ++i) {
                AuditLogDRBlock drBlock = null;
                try {
                    drBlock = this.buildDRBlock(blocksList.getJSONObject(i), false);
                    blocksToPurge.add(drBlock);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return blocksToPurge;
    }

    protected AuditLogDRBlock buildDRBlock(JSONObject blockObj, boolean isMain) throws Exception {
        AuditLogDRBlock block = null;
        String blockName = blockObj.getString("block_name");
        if (blockName != null) {
            int blockId = blockObj.getInt("block_id");
            String dataRepositoryName = blockObj.getString("datarepository_name");
            Long creationTime = blockObj.getLong("creation_time");
            String state = blockObj.getString("state");
            String status = blockObj.optString("status");
            int version = blockObj.getInt("version");
            String zipPassword = blockObj.optString("zip_password");
            Boolean isMerged = blockObj.optBoolean("is_merged");
            if (blockName == null || dataRepositoryName == null || creationTime == null || state == null) {
                throw new IllegalStateException("EXCEPTION while reading block meta file, either of blockName|dataRepositoryName|creationTime|state parameter's value is null!");
            }
            if (status == null || status.isEmpty()) {
                status = "-";
            }
            if (!this.repositoryName().equalsIgnoreCase(dataRepositoryName)) {
                throw new IllegalStateException("EXCEPTION while reading block meta file, dataRepositoryName doesn't match! Name in MetaFile : " + dataRepositoryName + ", Processing Name : " + this.repositoryName());
            }
            if (isMain && !state.startsWith(AuditLogDRBlock.State.HOT.toString()) && !state.startsWith(AuditLogDRBlock.State.COLD.toString())) {
                throw new IllegalStateException("EXCEPTION while reading main-block meta file, block " + blockName + " should be either in HOT or COLD state, but current state - " + state + "!");
            }
            if (!(isMain || state.startsWith(AuditLogDRBlock.State.DEFROST.toString()) || state.startsWith(AuditLogDRBlock.State.FROZEN.toString()) || state.equals(AuditLogDRBlock.State.COLD__TO_FROZEN.toString()) || state.equals(AuditLogDRBlock.State.DELETED.toString()))) {
                throw new IllegalStateException("EXCEPTION while reading archive-block meta file, block " + blockName + " should be either in DEFROST|FROZEN state, but current state - " + state + "!");
            }
            if (state.startsWith(AuditLogDRBlock.State.HOT.toString())) {
                block = AuditLogDRBlock.loadHotBlock(this, blockName, version, status, creationTime, blockId);
                block.encryptedZipPassword(zipPassword);
            } else {
                Long startTime = blockObj.getLong("range_from");
                Long endTime = blockObj.getLong("range_to");
                Integer docCount = blockObj.getInt("doc_count");
                Long size = blockObj.getLong("size");
                Long rawSize = blockObj.getLong("raw_size");
                block = AuditLogDRBlock.loadBlock(this, blockName, version, state, status, creationTime, startTime, endTime, docCount, size, rawSize, blockId);
                block.encryptedZipPassword(zipPassword);
                block.isMerged(isMerged);
                if (!isMain) {
                    Long coldSize = blockObj.getLong("cold_size");
                    block.coldSize(coldSize);
                }
            }
        }
        return block;
    }

    private void updateColdToFrozenBlocks() throws Exception {
        LOGGER.info("SUMMARY of ColdToFrozen-Blocks for DataRepository '" + this.repositoryName() + "' [ColdToFrozen Blocks : " + this.coldToFrozenBlockMap.size() + "]");
        try (Connection storeCon = DBManager.getStoreConnection();){
            for (DRBlock dRBlock : this.coldToFrozenBlockMap.values()) {
                LOGGER.error("EXCEPTION while loading drblocks, block - " + dRBlock.blockName() + " is in BLOCK_STATE_COLD__TO_FROZEN state, DELETING the cold block folder!");
                try {
                    if (!this.frozenBlockMap.containsKey(dRBlock.blockName())) {
                        this.persistenceHandler().addToMetaFile(storeCon, dRBlock, MetaFileType.ARCHIVE);
                    }
                    this.persistenceHandler().deleteFromMetaFile(storeCon, dRBlock, MetaFileType.MAIN);
                    File file = new File(this.defaultMainBlocksLocation() + dRBlock.blockName());
                    FileUtils.deleteDirectory((File)file);
                    if (file.exists()) {
                        dRBlock.changeStateTo(AuditLogDRBlock.State.FROZEN__COLD_INDEX_ND);
                    } else {
                        dRBlock.changeStateTo(AuditLogDRBlock.State.FROZEN);
                    }
                    this.frozenBlockMap.put(dRBlock.blockName(), dRBlock.metaIndex());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                LOGGER.info("RESET the state of block - " + dRBlock.blockName() + " from BLOCK_STATE_COLD__TO_FROZEN to FROZEN state");
            }
            this.coldToFrozenBlockMap.clear();
        }
    }

    private void printAndRestart() {
        try {
            if (!this.restartedAlready) {
                Environment.updateDERestartStatus();
                ConsoleOut.println((String)"HOT-INDEX-CLOSED");
                this.restartedAlready = true;
            }
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
        }
    }

    private AuditLogDRBlock getHotBlockFromQueue() {
        try {
            AuditLogDRBlock drBlock = this.hotBlockQueue.poll(this.blockingQueueTimeout, TimeUnit.SECONDS);
            if (drBlock == null) {
                ++this.commitFailureCount;
                if (this.commitFailureCount > this.commitFailureThreshold) {
                    LOGGER.error("TimeOut in Blocking Queue - Unable to commit. Failed for last " + this.commitFailureCount + " times. Going to Restart");
                    this.printAndRestart();
                }
                return null;
            }
            this.commitFailureCount = 0;
            return drBlock;
        }
        catch (Exception ex) {
            LOGGER.error("Exception while getting HOT-BLOCK from Queue");
            ex.printStackTrace();
            return null;
        }
    }

    private void commitHotBlocks() throws Exception {
        AuditLogDRBlock drBlock = this.getHotBlockFromQueue();
        if (drBlock == null) {
            return;
        }
        try {
            drBlock.commitIndex();
            this.hotIndexErrCount = 0;
        }
        catch (AlreadyClosedException ae) {
            ++this.hotIndexErrCount;
            LOGGER.error("HOT-INDEX-CLOSED : DRBlock '" + drBlock.blockName() + "' is closed! ErrCount : " + this.hotIndexErrCount);
            if (this.hotIndexErrCount > 100) {
                ae.printStackTrace();
                this.printAndRestart();
            }
        }
        finally {
            this.hotBlockQueue.put(drBlock);
        }
    }

    private AuditLogDRBlock createHotBlock() throws Exception {
        Long currentTime = System.currentTimeMillis();
        String blockName = this.blockPrefix() + "_" + currentTime;
        AuditLogDRBlock block = AuditLogDRBlock.createHotBlock(this, blockName, currentTime, 0);
        this.hotBlockMap.put(blockName, block);
        LOGGER.info("CREATED Hot-Block '" + blockName + "' for DataRepository '" + this.repositoryName() + "'");
        return block;
    }

    private void moveHotBlockToCold(AuditLogDRBlock drBlock) throws Exception {
        drBlock.changeStateTo(AuditLogDRBlock.State.COLD);
        this.hotBlockMap.remove(drBlock.blockName());
        this.coldBlockMap.put(drBlock.blockName(), drBlock);
        LOGGER.info("CHANGED STATE of DataRepository '" + this.repositoryName() + "' - Block '" + drBlock.blockName() + "' from HOT to COLD");
    }

    @Override
    public ArrayList<DRBlock> getBlocksFromList(JSONArray blockNameList) {
        LOGGER.info("# Going to get Indices From Request");
        ArrayList<DRBlock> refDRBlockList = new ArrayList<DRBlock>();
        int totalMainIndcices = this.coldBlockMap.size() + this.hotBlockMap.size();
        int totalArchiveIndices = this.defrostBlockMap.size();
        int selectedMainIndcices = 0;
        int selectedArchiveIndices = 0;
        HashMap<String, AuditLogDRBlock> blockMap = new HashMap<String, AuditLogDRBlock>(this.coldBlockMap);
        blockMap.putAll(this.hotBlockMap);
        if (this.loadDefrostBlocksForSearch) {
            blockMap.putAll(this.defrostBlockMap);
        }
        for (DRBlock dRBlock : blockMap.values()) {
            String blockName = dRBlock.blockName();
            boolean flag = false;
            for (int i = 0; i < blockNameList.length(); ++i) {
                if (!blockNameList.getString(i).equalsIgnoreCase(blockName)) continue;
                flag = true;
                break;
            }
            if (!flag) continue;
            refDRBlockList.add(dRBlock);
            if (dRBlock.currentBlockStateAction().toString().startsWith(AuditLogDRBlock.State.COLD.toString()) || dRBlock.currentBlockStateAction().toString().startsWith(AuditLogDRBlock.State.HOT.toString())) {
                ++selectedMainIndcices;
                continue;
            }
            if (!dRBlock.currentBlockStateAction().toString().startsWith(AuditLogDRBlock.State.DEFROST.toString())) continue;
            ++selectedArchiveIndices;
        }
        LOGGER.info("[Selected Main Indices : " + selectedMainIndcices + "/" + totalMainIndcices + "] [Selected Archive Indices : " + selectedArchiveIndices + "/" + totalArchiveIndices + "]");
        return refDRBlockList;
    }

    @Override
    public ArrayList<DRBlock> getBlocksInRange(Long fromTimestamp, Long toTimestamp) throws Exception {
        LOGGER.info("# Going to get Indices in range : " + fromTimestamp + " : " + toTimestamp);
        ArrayList<DRBlock> refDRBlockList = new ArrayList<DRBlock>();
        int totalMainIndcices = this.coldBlockMap.size() + this.hotBlockMap.size();
        int totalArchiveIndices = this.defrostBlockMap.size();
        int selectedMainIndcices = 0;
        int selectedArchiveIndices = 0;
        HashMap<String, AuditLogDRBlock> blockMap = new HashMap<String, AuditLogDRBlock>(this.coldBlockMap);
        if (this.loadDefrostBlocksForSearch) {
            blockMap.putAll(this.defrostBlockMap);
        }
        for (DRBlock dRBlock : blockMap.values()) {
            Long startTime = dRBlock.rangeFrom();
            Long endTime = dRBlock.rangeTo();
            if (fromTimestamp == null || toTimestamp == null || startTime == null || endTime == null || !(startTime >= fromTimestamp && endTime <= toTimestamp || startTime <= fromTimestamp && endTime >= toTimestamp || startTime >= fromTimestamp && startTime <= toTimestamp) && (endTime < fromTimestamp || endTime > toTimestamp)) continue;
            refDRBlockList.add(dRBlock);
            if (dRBlock.currentBlockStateAction().toString().startsWith(AuditLogDRBlock.State.COLD.toString()) || dRBlock.currentBlockStateAction().toString().startsWith(AuditLogDRBlock.State.HOT.toString())) {
                ++selectedMainIndcices;
                continue;
            }
            if (!dRBlock.currentBlockStateAction().toString().startsWith(AuditLogDRBlock.State.DEFROST.toString())) continue;
            ++selectedArchiveIndices;
        }
        blockMap = new HashMap<String, AuditLogDRBlock>(this.hotBlockMap);
        for (DRBlock dRBlock : blockMap.values()) {
            refDRBlockList.add(dRBlock);
            ++selectedMainIndcices;
        }
        LOGGER.info("[Selected Main Indices : " + selectedMainIndcices + "/" + totalMainIndcices + "] [Selected Archive Indices : " + selectedArchiveIndices + "/" + totalArchiveIndices + "]");
        return refDRBlockList;
    }

    public void mergeColdBlockSegments() throws Exception {
        try (Connection storeCon = DBManager.getStoreConnection();){
            for (DRBlock dRBlock : this.coldBlockMap.values()) {
                if (dRBlock.isMerged().booleanValue()) continue;
                LOGGER.info("DRBlock '" + dRBlock.blockName() + "' segments not merged!");
                dRBlock.mergeIndex();
                int segmentCount = SearchService.getSegmentCount(dRBlock);
                LOGGER.info("DRBlock '" + dRBlock.blockName() + "' segment count after merge : " + segmentCount + ", IndexRefCount : " + LuceneIndexHandler.getIndexReaderRefCount(dRBlock));
                if (segmentCount != 1) continue;
                dRBlock.isMerged(true);
                this.persistenceHandler().updateToMetaFile(storeCon, dRBlock, MetaFileType.MAIN);
            }
        }
    }

    @Override
    public long getMainBlocksDiskSizeOlderThan(int noDays) throws Exception {
        long totalSize = 0L;
        for (AuditLogDRBlock drBlock : this.coldBlockMap.values()) {
            if (!drBlock.isOlderThan(noDays)) continue;
            totalSize += FileUtils.sizeOf((File)new File(drBlock.blockPath()));
        }
        return totalSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JSONObject addData(DataRepositoryActionRequest request) throws Exception {
        JSONObject jResponse = new JSONObject();
        if (!this.isStopping()) {
            AuditLogDRBlock hotBlock = this.hotBlockQueue.take();
            try {
                if (request.dataFilePath() != null) {
                    jResponse = hotBlock.addDataToIndex(request.dataFilePath(), request.fileEncoding(), request.splitBy());
                }
                jResponse = hotBlock.addDataToIndex(request.bulkData());
            }
            catch (AlreadyClosedException ae) {
                LOGGER.error("HOT-INDEX-CLOSED : DRBlock '" + hotBlock.blockName() + "' is closed!");
                ae.printStackTrace();
                this.printAndRestart();
            }
            finally {
                if (hotBlock.isFull()) {
                    this.moveHotBlockToCold(hotBlock);
                    this.hotBlockQueue.put(this.createHotBlock());
                } else {
                    this.hotBlockQueue.put(hotBlock);
                }
            }
        } else {
            throw new Exception("DataEngine XNode is shutting down!");
        }
        return jResponse;
    }

    @Override
    public JSONObject updateData(DataRepositoryActionRequest request) throws Exception {
        throw new UnsupportedOperationException("Index-Update not supported for Audit-Log Repository '" + this.repositoryName() + "'!");
    }

    @Override
    public JSONObject deleteData(DataRepositoryActionRequest request) throws Exception {
        throw new UnsupportedOperationException("Index-Delete not supported for Audit-Log Repository '" + this.repositoryName() + "'!");
    }

    private boolean isArchiveEnabled() {
        return this.frozenBlockRetentionDays() != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void archiveOldBlocks() throws Exception {
        ArrayList<AuditLogDRBlock> toArchiveBlocks = new ArrayList<AuditLogDRBlock>();
        Object object = this.archive_lock;
        synchronized (object) {
            Iterator<Map.Entry<String, AuditLogDRBlock>> iter = this.coldBlockMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, AuditLogDRBlock> entry = iter.next();
                if (!entry.getValue().isOlderThan(this.mainBlockRetentionDays())) continue;
                toArchiveBlocks.add(entry.getValue());
                iter.remove();
            }
        }
        if (this.isArchiveEnabled()) {
            int totalSuccess = 0;
            ArrayList<AuditLogDRBlock> s2blocksToMark = this.getBlocksToMarkForDelete(false);
            this.markBlocks(s2blocksToMark);
            ArrayList<AuditLogDRBlock> s1blocksToMark = this.getBlocksToMarkForDelete(true);
            this.purgeArchiveBlocks(s1blocksToMark, true);
            for (AuditLogDRBlock drBlock : toArchiveBlocks) {
                if (XNodeManager.isShutdownInitialized()) continue;
                try {
                    drBlock.freezeBlock(this.frozenS1BlockRetentionDays() > 0);
                    ++totalSuccess;
                    this.frozenBlockMap.put(drBlock.blockName(), drBlock.metaIndex());
                }
                catch (Exception e) {
                    if (XNodeManager.isShutdownInitialized()) continue;
                    File file = new File(this.defaultMainBlocksLocation() + drBlock.blockName());
                    if (file.exists()) {
                        this.coldBlockMap.put(drBlock.blockName(), drBlock);
                        continue;
                    }
                    if (drBlock.currentBlockStateAction().toString().equals(AuditLogDRBlock.State.COLD__TO_FROZEN.toString())) {
                        this.frozenBlockMap.put(drBlock.blockName(), drBlock.metaIndex());
                    }
                    LOGGER.error("COLD-FREEZE :: block '" + drBlock.blockName() + " is in inconsistent state, index folder got deleted and is not in frozen state!");
                }
            }
            if (!XNodeManager.isShutdownInitialized()) {
                DataRepositoryManager.updateCurrentArchiveLocationBlockCount(totalSuccess);
            }
        } else {
            for (AuditLogDRBlock drBlock : toArchiveBlocks) {
                try {
                    drBlock.markMainBlockForDeletion();
                    this.deletedBlocksList.put((Object)this.getDeletedObj(drBlock));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (!XNodeManager.isShutdownInitialized()) {
            ArrayList<AuditLogDRBlock> frozenBlocksToPurge = this.getBlocksToPurge(false);
            this.purgeArchiveBlocks(frozenBlocksToPurge, false);
            ArrayList<AuditLogDRBlock> mainBlocksToPurge = this.getBlocksToPurge(true);
            this.purgeMainBlocks(mainBlocksToPurge);
            LOGGER.info("Total deleted blocks: " + this.deletedBlocksList.length());
        }
    }

    private void purgeArchiveBlocks(ArrayList<AuditLogDRBlock> blocks, boolean isStage1) {
        for (AuditLogDRBlock drBlock : blocks) {
            if (drBlock != null) {
                String absArchivePath = this.getBlockArchivePath(drBlock);
                try {
                    drBlock.deleteArchiveBlock(absArchivePath, isStage1);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            LOGGER.info("Unable to find meta entry for archive block");
        }
    }

    private void purgeMainBlocks(ArrayList<AuditLogDRBlock> blocks) {
        for (AuditLogDRBlock drBlock : blocks) {
            if (drBlock != null) {
                try {
                    drBlock.deleteMainBlock();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            LOGGER.info("Unable to find meta entry for MAIN block in archive meta!!!");
        }
    }

    private void markBlocks(ArrayList<AuditLogDRBlock> blocks) {
        for (AuditLogDRBlock drBlock : blocks) {
            if (drBlock != null) {
                try {
                    drBlock.markArchiveBlockForDeletion();
                    this.deletedBlocksList.put((Object)this.getDeletedObj(drBlock));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.frozenBlockMap.put(drBlock.blockName(), drBlock.metaIndex());
                }
                continue;
            }
            LOGGER.info("Unable to find meta entry for archive block");
        }
    }

    private JSONObject getDeletedObj(AuditLogDRBlock drBlock) throws Exception {
        JSONObject blockObj = new JSONObject();
        blockObj.put("block_name", (Object)drBlock.blockName());
        blockObj.put("range_from", (Object)drBlock.rangeFrom());
        blockObj.put("range_to", (Object)drBlock.rangeTo());
        blockObj.put("deleted_time", System.currentTimeMillis() / 1000L);
        return blockObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JSONObject loadArchiveBlocks(DataRepositoryActionRequest request) throws Exception {
        JSONObject jResponse;
        block34: {
            jResponse = new JSONObject();
            String absArchivePath = null;
            DRBlock defrostingBlock = null;
            String blockName = request.blockName();
            Object object = this.archive_lock;
            synchronized (object) {
                try {
                    AuditLogDRBlock defrostBlock = this.defrostBlockMap.get(blockName);
                    Integer frozenBlockIndex = this.frozenBlockMap.get(blockName);
                    if (defrostBlock == null && frozenBlockIndex == null) {
                        throw new Exception("EXCEPTION while processing defrost-request, no info found about the archive block - " + blockName);
                    }
                    if (defrostBlock != null && frozenBlockIndex == null) {
                        throw new Exception("EXCEPTION while processing defrost-request, the archive block - " + blockName + " is already indexed/indexing!");
                    }
                    if (defrostBlock == null && frozenBlockIndex != null) {
                        boolean blockCounts = false;
                        try (Connection connection = DBManager.getStoreConnection();){
                            JSONObject blockObj = this.persistenceHandler().readFromMetaFile(connection, MetaFileType.ARCHIVE, blockName);
                            defrostingBlock = this.buildDRBlock(blockObj, false);
                        }
                        if (defrostingBlock == null) {
                            throw new Exception("EXCEPTION while processing defrost-request, unable to find meta entry for archive block - " + blockName);
                        }
                        absArchivePath = this.getBlockArchivePath(defrostingBlock);
                        if (absArchivePath == null) {
                            throw new Exception("EXCEPTION while processing defrost-request, unable to find the raw file for archive block - " + blockName);
                        }
                    } else {
                        throw new Exception("EXCEPTION while processing defrost-request, frozen and defrost map not in expected state!");
                    }
                    LOGGER.info("DEFROSTING archive block '" + blockName + "' from the path - " + absArchivePath);
                    defrostingBlock.status(AuditLogDRBlock.State.FROZEN__TO_DEFROST.toString());
                    defrostingBlock.changeStateTo(AuditLogDRBlock.State.FROZEN__TO_DEFROST);
                    this.defrostBlockMap.put(blockName, (AuditLogDRBlock)defrostingBlock);
                    this.frozenBlockMap.remove(blockName);
                }
                catch (Exception e) {
                    if (defrostingBlock != null) {
                        defrostingBlock.status(e.getMessage());
                        defrostingBlock.updateToMetaFile(MetaFileType.ARCHIVE);
                    }
                    throw e;
                }
            }
            try {
                if (request.canLoad()) {
                    jResponse = defrostingBlock.version() == 1 ? ((AuditLogDRBlock)defrostingBlock).defrostLegacy(absArchivePath) : ((AuditLogDRBlock)defrostingBlock).defrost(absArchivePath);
                    break block34;
                }
                throw new Exception("Insufficient Disk Space, available disk space: " + request.availableSpace());
            }
            catch (Exception e) {
                if (!XNodeManager.isShutdownInitialized()) {
                    Object object2 = this.archive_lock;
                    synchronized (object2) {
                        if (defrostingBlock != null && ((AuditLogDRBlock)defrostingBlock).currentBlockStateAction().toString().equals(AuditLogDRBlock.State.FROZEN__TO_DEFROST.toString())) {
                            String message = e.getMessage();
                            defrostingBlock.status(message != null ? message : "Unable to load corrupted archive: " + new File(absArchivePath).getName());
                            defrostingBlock.changeStateTo(AuditLogDRBlock.State.FROZEN);
                            this.defrostBlockMap.remove(defrostingBlock.blockName());
                            this.frozenBlockMap.put(defrostingBlock.blockName(), defrostingBlock.metaIndex());
                        }
                    }
                } else {
                    e.printStackTrace();
                }
                throw e;
            }
        }
        return jResponse;
    }

    @Override
    public JSONObject unloadArchiveBlocks(DataRepositoryActionRequest request) throws Exception {
        return this.unloadArchiveBlocks(request.blockName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject unloadArchiveBlocks(String blockName) throws Exception {
        JSONObject jResponse = new JSONObject();
        DRBlock toFreezeBlock = null;
        Object object = this.archive_lock;
        synchronized (object) {
            DRBlock defrostBlock = this.defrostBlockMap.get(blockName);
            Integer frozenBlockIndex = this.frozenBlockMap.get(blockName);
            if (defrostBlock == null && frozenBlockIndex == null) {
                throw new Exception("EXCEPTION while processing freeze-request, no info found about the archive block - " + blockName);
            }
            if (defrostBlock == null && frozenBlockIndex != null) {
                throw new Exception("EXCEPTION while processing freeze-request, the archive block - " + blockName + " is already frozen!");
            }
            if (defrostBlock != null && frozenBlockIndex == null) {
                toFreezeBlock = defrostBlock;
                LOGGER.info("FREEZING DEFROST archive block '" + blockName + "' in the path - " + this.defaultDefrostBlocksLocation() + blockName);
                this.defrostBlockMap.remove(toFreezeBlock.blockName());
                this.frozenBlockMap.put(toFreezeBlock.blockName(), toFreezeBlock.metaIndex());
                toFreezeBlock.status("-");
                File file = new File(this.defaultDefrostBlocksLocation() + blockName);
                FileUtils.deleteDirectory((File)file);
                if (file.exists()) {
                    toFreezeBlock.changeStateTo(AuditLogDRBlock.State.FROZEN__DEFROST_INDEX_ND);
                } else {
                    toFreezeBlock.changeStateTo(AuditLogDRBlock.State.FROZEN);
                }
            } else {
                throw new Exception("EXCEPTION while processing freeze-request, frozen and defrost map not in expected state!");
            }
            jResponse.put("error_code", 0);
        }
        return jResponse;
    }

    public void unloadOldArchiveBlocks() throws Exception {
        ArrayList<String> toUnloadBlocks = new ArrayList<String>();
        for (AuditLogDRBlock drBlock : this.defrostBlockMap.values()) {
            if (!drBlock.isCreationTimeOlderThan(this.defrostBlockRetentionDays())) continue;
            toUnloadBlocks.add(drBlock.blockName());
        }
        for (String blockName : toUnloadBlocks) {
            if (XNodeManager.isShutdownInitialized()) continue;
            this.unloadArchiveBlocks(blockName);
        }
    }

    public void reindexBlockFromRawFile(String blockName, PrintStream ps) throws Exception {
        AuditLogDRBlock block = this.getHotOrColdBlock(blockName);
        block.reindexFromRawFile(ps);
    }

    public CheckIndex.Status checkBlockIndex(String blockName, PrintStream ps) throws Exception {
        AuditLogDRBlock block = this.getHotOrColdBlock(blockName);
        try {
            if (AuditLogDRBlock.State.HOT.toString().equalsIgnoreCase(block.currentBlockStateAction().toString())) {
                block.currentBlockStateAction().closeIndexWriter();
            }
        }
        catch (Exception ex) {
            LOGGER.info("Exception in closing index writer");
        }
        return block.checkIndex(ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rewriteRawFileFromIndexBlock(String blockName, PrintStream ps) throws Exception {
        AuditLogDRBlock block;
        IndexSearcher indexSearcher;
        block12: {
            long totalRecords = 0L;
            indexSearcher = null;
            GzipUtil.GzipCsvWriteHandle gzipCsvWriteHandle = null;
            block = this.getHotOrColdBlock(blockName);
            String rawDir = block.dataRepository().defaultMainBlocksLocation() + File.separator + blockName + File.separator + "raw-data" + File.separator;
            if (new File(rawDir).exists()) {
                FileUtils.deleteDirectory((File)new File(rawDir));
            }
            if (!new File(rawDir).exists()) {
                new File(rawDir).mkdirs();
            }
            try {
                ArrayList<DRIndexField> fieldList = block.dataRepository().getIndexFields();
                gzipCsvWriteHandle = new GzipUtil().getGzipCsvWriteHandle(rawDir + "rawData.gz", "UTF-8", '\t');
                indexSearcher = LuceneIndexHandler.getIndexSearcher(block);
                Sort sortBy = new Sort();
                SortedNumericSortField sortField = new SortedNumericSortField(block.dataRepository().schema().getRangeField(), SortField.Type.LONG, false);
                sortBy.setSort((SortField)sortField);
                int batchCount = 10000;
                int batchNo = 1;
                boolean hasMore = true;
                ScoreDoc afterScoreDoc = null;
                while (hasMore) {
                    TopDocs topDocs = indexSearcher.searchAfter(afterScoreDoc, (Query)new MatchAllDocsQuery(), batchCount, sortBy);
                    if (topDocs != null) {
                        ScoreDoc[] scoreHits = topDocs.scoreDocs;
                        totalRecords = topDocs.totalHits;
                        int currentfetchCount = scoreHits.length;
                        for (int i = 0; i < currentfetchCount; ++i) {
                            Document doc = indexSearcher.doc(scoreHits[i].doc);
                            String[] lineData = new String[fieldList.size()];
                            int index = 0;
                            for (DRIndexField indexField : fieldList) {
                                lineData[index++] = doc.get(indexField.getFieldName());
                            }
                            gzipCsvWriteHandle.writeNext(lineData);
                        }
                        afterScoreDoc = scoreHits[scoreHits.length - 1];
                    }
                    if (totalRecords <= (long)(batchNo * batchCount)) {
                        hasMore = false;
                        continue;
                    }
                    ++batchNo;
                }
                if (gzipCsvWriteHandle == null) break block12;
            }
            catch (Throwable throwable) {
                if (gzipCsvWriteHandle != null) {
                    gzipCsvWriteHandle.close();
                }
                if (indexSearcher != null) {
                    LuceneIndexHandler.releaseIndexSearcher(indexSearcher, block);
                    indexSearcher = null;
                }
                throw throwable;
            }
            gzipCsvWriteHandle.close();
        }
        if (indexSearcher != null) {
            LuceneIndexHandler.releaseIndexSearcher(indexSearcher, block);
            indexSearcher = null;
        }
    }

    public void repairBlockIndex(String blockName, PrintStream ps, CheckIndex.Status status) throws Exception {
        AuditLogDRBlock block = this.getHotOrColdBlock(blockName);
        try {
            if (AuditLogDRBlock.State.HOT.toString().equalsIgnoreCase(block.currentBlockStateAction().toString())) {
                block.currentBlockStateAction().closeIndexWriter();
            }
        }
        catch (Exception ex) {
            LOGGER.info("Exception in closing index writer");
        }
        block.repairIndex(ps, status);
    }

    public int getRawDocCount(String blockName) throws Exception {
        AuditLogDRBlock block = this.getHotOrColdBlock(blockName);
        return block.getRawDocCount();
    }

    public int getIndexDocCount(String blockName) throws Exception {
        AuditLogDRBlock block = this.getHotOrColdBlock(blockName);
        return block.getIndexDocCount();
    }

    @Override
    public JSONObject syncBlocksMeta(DataRepositoryActionRequest request) throws Exception {
        JSONObject jResponse = new JSONObject();
        JSONObject syncObjList = request.dataRepositoryListObj();
        if (syncObjList.has(this.repositoryName())) {
            JSONArray blockList = syncObjList.getJSONArray(this.repositoryName());
            int len = blockList.length();
            for (int i = 0; i < len; ++i) {
                JSONObject blockObj = blockList.getJSONObject(i);
                if (!(blockObj.has("block_name") && blockObj.has("state") && blockObj.has("range_from") && blockObj.has("range_to"))) {
                    throw new Exception("EXCEPTION while processing sync-block-request, missing parameters(block_name|state|range_from|range_to)");
                }
                blockObj.put("block_id", 0);
                String zipPassword = blockObj.optString("zip_password", "");
                if (zipPassword != null && !zipPassword.trim().isEmpty()) {
                    blockObj.put("zip_password", (Object)CryptoUtil.encrypt((String)zipPassword, (int)2));
                }
                this.frozenBlockMap.put(blockObj.getString("block_name"), 0);
            }
            try (Connection connection = DBManager.getStoreConnection();){
                this.persistenceHandler().addToMetaFile(connection, blockList, MetaFileType.ARCHIVE);
            }
        }
        jResponse.put("error_code", 0);
        return jResponse;
    }

    @Override
    public boolean drop() throws Exception {
        if (!this.scheduler.isShutdown()) {
            this.scheduler.shutdown();
        }
        LOGGER.info("DROPPED DataRepository '" + this.repositoryName() + "'!");
        return true;
    }

    @Override
    public void doStop() {
        this.shutdown = true;
    }

    @Override
    public boolean doClose() {
        boolean isSuccess = true;
        try {
            this.scheduler.shutdown();
            this.commitHotBlocks();
        }
        catch (Exception e) {
            isSuccess = false;
            e.printStackTrace();
        }
        return isSuccess;
    }

    @Override
    public boolean isStopping() {
        return this.shutdown;
    }

    private AuditLogDRBlock getHotOrColdBlock(String blockName) throws Exception {
        AuditLogDRBlock block = this.coldBlockMap.get(blockName);
        if (block == null) {
            block = this.hotBlockMap.get(blockName);
        }
        if (block == null) {
            throw new Exception("Unable to find Hot/Cold - DRBlock with the name : " + blockName);
        }
        return block;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JSONObject addMigrationData(DataRepositoryActionRequest request) throws Exception {
        if (request.dataRepository().repositoryName().equalsIgnoreCase("AdapADLogonAuditLog")) {
            return AdapMigrationUtil.addMigrationData(this, request);
        }
        JSONObject jResponse = new JSONObject();
        int READ_BUF_SIZE = 4056;
        JSONArray errorLineList = new JSONArray();
        JSONArray dataFilePathList = request.dataFilePathList();
        Charset fileEncoding = request.fileEncoding();
        long blockCreationTime = request.creationTime();
        char splitBy = request.splitBy();
        ArrayList<DRIndexField> fieldList = this.getIndexFields();
        GzipUtil gzipUtil = new GzipUtil();
        GzipUtil.GzipCsvWriteHandle gzipCsvWriteHandle = null;
        IndexWriter indexWriter = null;
        String blockName = this.blockPrefix() + "_" + blockCreationTime;
        String blockPath = this.defaultMainBlocksLocation() + File.separator + blockName + File.separator;
        String rawDataFilePath = blockPath + File.separator + "raw-data" + File.separator + "rawData.gz";
        int errLineCount = 0;
        int indexedCount = 0;
        int totalCount = 0;
        int lineNo = 0;
        boolean isMSSql = false;
        String msSQLLineTerminator = "|**|**|";
        String msSQLFieldTerminator = "\\|\\*\\*\\|";
        LOGGER.info("DATA MIGRATION :: Going to migrate data to block '" + blockName + "'");
        try {
            File rawDataDir = new File(blockPath + File.separator + "raw-data");
            if (!rawDataDir.exists()) {
                rawDataDir.mkdirs();
            }
            if (fileEncoding != null && fileEncoding.toString().equalsIgnoreCase("UTF-16")) {
                isMSSql = true;
            }
            indexWriter = LuceneIndexHandler.getIndexWriter(blockPath + "luc-index", this.getAnalyzerWrapper(), this.getIndexSortObj());
            gzipCsvWriteHandle = gzipUtil.getGzipCsvWriteHandle(rawDataFilePath, "UTF-8", '\t');
            Long elapsedIndexTimeMillis = System.currentTimeMillis();
            for (int pathIndex = 0; pathIndex < dataFilePathList.length(); ++pathIndex) {
                String dataFilePath = dataFilePathList.getString(pathIndex);
                JSONArray fileErrorLineList = new JSONArray();
                BufferedReader br = null;
                CsvReader csvReader = null;
                lineNo = 0;
                try {
                    br = fileEncoding == null ? new BufferedReader(new InputStreamReader(new FileInputStream(dataFilePath)), 4056) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(dataFilePath), fileEncoding), 4056);
                    if (!this.isStopping()) {
                        Document doc;
                        if (isMSSql) {
                            String line = "";
                            while ((line = br.readLine()) != null) {
                                try {
                                    ++lineNo;
                                    if (!line.endsWith(msSQLLineTerminator)) {
                                        String secondline;
                                        while ((secondline = br.readLine()) != null) {
                                            ++lineNo;
                                            if (!(line = line + secondline).endsWith(msSQLLineTerminator)) continue;
                                        }
                                    }
                                    ++totalCount;
                                    String[] colVals = line.split(msSQLFieldTerminator, -1);
                                    if (colVals.length != fieldList.size()) {
                                        colVals = DRBlock.fillMissingCols(colVals, fieldList.size());
                                    }
                                    doc = DRBlock.getLucDocument(colVals, fieldList);
                                    indexWriter.addDocument((Iterable)doc);
                                    gzipCsvWriteHandle.writeNext(colVals);
                                    ++indexedCount;
                                }
                                catch (Exception e) {
                                    LOGGER.error("Archive Index Parsing Exception[" + e.getMessage() + "] :: " + line);
                                    ++errLineCount;
                                    fileErrorLineList.put(lineNo);
                                }
                            }
                            indexWriter.commit();
                        } else {
                            csvReader = new CsvReader((Reader)br, splitBy);
                            csvReader.setSafetySwitch(false);
                            while (csvReader.readRecord()) {
                                ++lineNo;
                                ++totalCount;
                                try {
                                    String[] colVals = csvReader.getValues();
                                    String[] colValsEsc = new String[colVals.length];
                                    for (int i = 0; i < colVals.length; ++i) {
                                        colValsEsc[i] = colVals[i].replace("\\\\", "\\");
                                        if (!colValsEsc[i].equals("\\N")) continue;
                                        colValsEsc[i] = "";
                                    }
                                    if (colValsEsc.length != fieldList.size()) {
                                        colValsEsc = DRBlock.fillMissingCols(colValsEsc, fieldList.size());
                                    }
                                    doc = DRBlock.getLucDocument(colValsEsc, fieldList);
                                    indexWriter.addDocument((Iterable)doc);
                                    gzipCsvWriteHandle.writeNext(colValsEsc);
                                    ++indexedCount;
                                }
                                catch (Exception e) {
                                    LOGGER.error("Archive Index Parsing Exception[" + e.getMessage() + "] :: " + csvReader.getRawRecord());
                                    ++errLineCount;
                                    fileErrorLineList.put(lineNo);
                                }
                            }
                            indexWriter.commit();
                        }
                        errorLineList.put((Object)fileErrorLineList);
                        continue;
                    }
                    throw new Exception("DataEngine XNode is shutting down!");
                }
                finally {
                    if (csvReader != null) {
                        csvReader.close();
                    }
                    if (br != null) {
                        br.close();
                    }
                }
            }
            long elapsedMergeTimeMillis = System.currentTimeMillis();
            indexWriter.forceMerge(1, true);
            indexWriter.commit();
            elapsedMergeTimeMillis = System.currentTimeMillis() - elapsedMergeTimeMillis;
            elapsedIndexTimeMillis = System.currentTimeMillis() - elapsedIndexTimeMillis;
            LOGGER.info("DATA MIGRATION :: Total time to merge index : " + elapsedMergeTimeMillis);
            LOGGER.info("DATA MIGRATION :: Total time to index block '" + blockName + "' :: " + elapsedIndexTimeMillis);
            LOGGER.info("DATA MIGRATION :: Index-Document count :: " + indexWriter.getDirectory() + " : " + indexWriter.numDocs());
            long blockSize = FileUtils.sizeOf((File)new File(blockPath));
            long rawSize = FileUtils.sizeOf((File)new File(blockPath + "raw-data"));
            int docCount = indexWriter.numDocs();
            AuditLogDRBlock drBlock = AuditLogDRBlock.loadBlock(this, blockName, 10, AuditLogDRBlock.State.COLD.toString(), "-", blockCreationTime, 0L, 0L, docCount, blockSize, rawSize, 0);
            boolean isMerged = SearchService.getSegmentCount(drBlock) == 1;
            JSONObject jRes = SearchService.getMinMaxLongField(this.schema().getRangeField(), drBlock);
            long rangeFrom = jRes.getLong("min") == -1L ? 0L : jRes.getLong("min");
            long rangeTo = jRes.getLong("max") == -1L ? 0L : jRes.getLong("max");
            drBlock.isMerged(isMerged);
            drBlock.rangeFrom(rangeFrom);
            drBlock.rangeTo(rangeTo);
            try (Connection connection = DBManager.getStoreConnection();){
                this.persistenceHandler().addToMetaFile(connection, drBlock, MetaFileType.MAIN);
            }
            this.coldBlockMap.put(drBlock.blockName(), drBlock);
            LOGGER.info("DATA MIGRATION :: Successfully migrated data! [blockName : " + blockName + "]");
            jResponse.put("error_code", 0);
            jResponse.put("error_count", errLineCount);
            jResponse.put("error_line_list", (Object)errorLineList);
            jResponse.put("index_process_time", (Object)elapsedIndexTimeMillis);
            jResponse.put("indexed_doc_count", indexedCount);
            jResponse.put("actual_doc_count", docCount);
            jResponse.put("line_count", totalCount);
        }
        finally {
            if (indexWriter != null) {
                indexWriter.close();
                indexWriter.getDirectory().close();
                indexWriter = null;
            }
            if (gzipCsvWriteHandle != null) {
                gzipCsvWriteHandle.close();
            }
        }
        return jResponse;
    }

    @Override
    public JSONObject validateMigrationData(DataRepositoryActionRequest request) throws Exception {
        JSONObject jResponse = new JSONObject();
        try {
            long blockCreationTime = request.creationTime();
            String blockName = this.blockPrefix() + "_" + blockCreationTime;
            LOGGER.info("DATA MIGRATION :: Validating block '" + blockName + "'...");
            if (this.coldBlockMap.containsKey(blockName)) {
                jResponse.put("migration_status", 0);
                LOGGER.info("DATA MIGRATION :: Block '" + blockName + "' already migrated!");
            } else {
                LOGGER.info("DATA MIGRATION :: Block '" + blockName + "' not migrated completely!");
                try (Connection connection = DBManager.getStoreConnection();){
                    this.persistenceHandler().deleteFromMetaFile(connection, blockName, MetaFileType.MAIN);
                }
                LOGGER.info("DATA MIGRATION :: Deleted block information from meta file!");
                File blockDir = new File(this.defaultMainBlocksLocation() + File.separator + blockName);
                if (blockDir.exists()) {
                    FileUtils.deleteDirectory((File)blockDir);
                    boolean status = !blockDir.exists();
                    LOGGER.info("DATA MIGRATION :: Deleted block index! status : " + status);
                }
                jResponse.put("migration_status", 1);
            }
            LOGGER.info("DATA MIGRATION :: Block '" + blockName + "' validation completed!");
        }
        catch (Exception e) {
            e.printStackTrace();
            jResponse.put("migration_status", 1);
        }
        jResponse.put("error_code", 0);
        return jResponse;
    }

    public void addBlockToColdMap(AuditLogDRBlock drBlock) {
        this.coldBlockMap.put(drBlock.blockName(), drBlock);
    }

    public JSONArray getDeletedBlocksList() {
        return this.deletedBlocksList;
    }

    public void resetDeletedBlocksList() {
        this.deletedBlocksList = new JSONArray();
    }

    private final class HotIndexCommitter
    implements Runnable {
        private HotIndexCommitter() {
        }

        @Override
        public void run() {
            try {
                Thread.currentThread().setName("HotIndexCommitter_" + AuditLogDR.this.repositoryName());
                AuditLogDR.this.commitHotBlocks();
            }
            catch (Throwable e) {
                LOGGER.error("EXCEPTION HotIndexCommitter : " + e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

