/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository;

import com.manageengine.dataengine.commons.datarepository.DRIndexField;
import com.manageengine.dataengine.commons.file.GuessEncoding;
import com.manageengine.dataengine.commons.file.GzipUtil;
import com.manageengine.dataengine.commons.file.SevenZipUtil;
import com.manageengine.dataengine.commons.file.ZipUtil;
import com.manageengine.dataengine.xnode.bootstrap.XNodeManager;
import com.manageengine.dataengine.xnode.database.DBManager;
import com.manageengine.dataengine.xnode.datarepository.DRBlock;
import com.manageengine.dataengine.xnode.datarepository.DRBlockState;
import com.manageengine.dataengine.xnode.datarepository.DRBlockStateFacade;
import com.manageengine.dataengine.xnode.datarepository.DataRepository;
import com.manageengine.dataengine.xnode.datarepository.LuceneIndexHandler;
import com.manageengine.dataengine.xnode.datarepository.MetaFileType;
import com.manageengine.dataengine.xnode.datarepository.search.SearchService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CheckIndex;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.SetOnce;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;
import org.json.JSONArray;
import org.json.JSONObject;

public class AuditLogDRBlock
extends DRBlock {
    private final SetOnce<DRBlockStateFacade> stateFacade = new SetOnce();
    private static final Logger LOGGER = LogManager.getLogger((String)"DataRepository");
    private final DRBlockState hot = new DRBlockState("HOT"){
        private volatile IndexWriter hotIndexWriter;

        @Override
        protected void init(DRBlockState oldState) throws Exception {
            try {
                this.hotIndexWriter = LuceneIndexHandler.getIndexWriter(this.blockPath() + "luc-index", AuditLogDRBlock.this.dataRepository().getAnalyzerWrapper(), AuditLogDRBlock.this.dataRepository().getIndexSortObj());
            }
            catch (CorruptIndexException ce) {
                if (ce.getMessage().contains("segment not sorted with indexSort")) {
                    this.hotIndexWriter = LuceneIndexHandler.getIndexWriter(this.blockPath() + "luc-index", AuditLogDRBlock.this.dataRepository().getAnalyzerWrapper(), null);
                }
                throw ce;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void beforeExit(DRBlockState newState) throws Exception {
            if (newState != AuditLogDRBlock.this.cold && newState != AuditLogDRBlock.this.error) {
                throw new IllegalStateException("Can't move to " + newState.toString() + " state from " + this.toString() + "!");
            }
            int currentDocCount = 0;
            try {
                IndexWriter indexWriter = this.indexWriter();
                int n = currentDocCount = indexWriter == null ? 0 : indexWriter.numDocs();
                if (indexWriter != null) {
                    indexWriter.forceMerge(1, true);
                }
            }
            finally {
                this.closeIndexWriter();
            }
            AuditLogDRBlock.this.isMerged(SearchService.getSegmentCount(AuditLogDRBlock.this) == 1);
            JSONObject jRes = SearchService.getMinMaxLongField(AuditLogDRBlock.this.dataRepository().schema().getRangeField(), AuditLogDRBlock.this);
            AuditLogDRBlock.this.rangeFrom(jRes.getLong("min") == -1L ? 0L : jRes.getLong("min"));
            AuditLogDRBlock.this.rangeTo(jRes.getLong("max") == -1L ? 0L : jRes.getLong("max"));
            AuditLogDRBlock.this.docCount(currentDocCount);
            AuditLogDRBlock.this.size(FileUtils.sizeOf((File)new File(this.blockPath())));
            AuditLogDRBlock.this.rawSize(FileUtils.sizeOf((File)new File(this.blockPath() + "raw-data")));
        }

        @Override
        protected void afterExit(DRBlockState newState) throws Exception {
            AuditLogDRBlock.this.updateToMetaFile(MetaFileType.MAIN);
        }

        @Override
        protected String blockPath() {
            return AuditLogDRBlock.this.dataRepository().defaultMainBlocksLocation() + File.separator + AuditLogDRBlock.this.blockName() + File.separator;
        }

        @Override
        protected IndexWriter indexWriter() throws Exception {
            return this.hotIndexWriter;
        }

        @Override
        protected void commitIndexWriter() throws Exception {
            if (this.hotIndexWriter != null && this.hotIndexWriter.isOpen() && this.hotIndexWriter.hasUncommittedChanges()) {
                LOGGER.debug("COMMITING HOT Block - '" + AuditLogDRBlock.this.blockName() + "'!");
                this.hotIndexWriter.commit();
            }
        }

        @Override
        protected void closeIndexWriter() throws Exception {
            if (this.hotIndexWriter != null) {
                this.hotIndexWriter.commit();
                this.hotIndexWriter.close();
                this.hotIndexWriter.getDirectory().close();
                this.hotIndexWriter = null;
            }
        }

        @Override
        protected int docCount() {
            return this.hotIndexWriter.numDocs();
        }
    };
    private final DRBlockState cold = new DRBlockState("COLD"){

        @Override
        protected void beforeExit(DRBlockState newState) throws Exception {
            if (newState != AuditLogDRBlock.this.cold__to_frozen && newState != AuditLogDRBlock.this.error && newState != AuditLogDRBlock.this.deleted) {
                throw new IllegalStateException("Can't move to " + newState.toString() + " state from " + this.toString() + "!");
            }
        }

        @Override
        protected void afterExit(DRBlockState newState) throws Exception {
            try (Connection connection = DBManager.getStoreConnection();){
                AuditLogDRBlock.this.dataRepository().persistenceHandler().updateToMetaFile(connection, AuditLogDRBlock.this, MetaFileType.MAIN);
                AuditLogDRBlock.this.dataRepository().persistenceHandler().addToMetaFile(connection, AuditLogDRBlock.this, MetaFileType.ARCHIVE);
                AuditLogDRBlock.this.dataRepository().persistenceHandler().deleteFromMetaFile(connection, AuditLogDRBlock.this, MetaFileType.MAIN);
            }
        }

        @Override
        protected String blockPath() {
            return AuditLogDRBlock.this.dataRepository().defaultMainBlocksLocation() + File.separator + AuditLogDRBlock.this.blockName() + File.separator;
        }

        @Override
        protected void mergeIndex() throws Exception {
            IndexWriter indexWriter = LuceneIndexHandler.getIndexWriter(this.blockPath() + "luc-index", AuditLogDRBlock.this.dataRepository().getAnalyzerWrapper(), AuditLogDRBlock.this.dataRepository().getIndexSortObj());
            indexWriter.forceMerge(1, true);
            indexWriter.close();
        }
    };
    private final DRBlockState cold__to_frozen = new DRBlockState("COLD__TO_FROZEN"){

        @Override
        protected void beforeExit(DRBlockState newState) throws Exception {
            if (newState != AuditLogDRBlock.this.frozen && newState != AuditLogDRBlock.this.frozen__cold_index_nd && newState != AuditLogDRBlock.this.error) {
                throw new IllegalStateException("Can't move to " + newState.toString() + " state from " + this.toString() + "!");
            }
        }

        @Override
        protected void afterExit(DRBlockState newState) throws Exception {
            AuditLogDRBlock.this.updateToMetaFile(MetaFileType.ARCHIVE);
        }

        @Override
        protected String blockPath() {
            return AuditLogDRBlock.this.dataRepository().defaultMainBlocksLocation() + File.separator + AuditLogDRBlock.this.blockName() + File.separator;
        }
    };
    private final DRBlockState frozen = new DRBlockState("FROZEN"){

        @Override
        protected void beforeExit(DRBlockState newState) throws Exception {
            if (newState != AuditLogDRBlock.this.frozen__to_defrost && newState != AuditLogDRBlock.this.error && newState != AuditLogDRBlock.this.deleted) {
                throw new IllegalStateException("Can't move to " + newState.toString() + " state from " + this.toString() + "!");
            }
        }

        @Override
        protected void afterExit(DRBlockState newState) throws Exception {
            AuditLogDRBlock.this.updateToMetaFile(MetaFileType.ARCHIVE);
        }

        @Override
        protected String blockPath() {
            return AuditLogDRBlock.this.dataRepository().currentFrozenBlocksLocation() + File.separator + AuditLogDRBlock.this.blockName() + File.separator;
        }
    };
    private final DRBlockState frozen__cold_index_nd = new DRBlockState("FROZEN__COLD_INDEX_ND"){

        @Override
        protected void beforeExit(DRBlockState newState) throws Exception {
            if (newState != AuditLogDRBlock.this.frozen__to_defrost && newState != AuditLogDRBlock.this.error) {
                throw new IllegalStateException("Can't move to " + newState.toString() + " state from " + this.toString() + "!");
            }
        }

        @Override
        protected void afterExit(DRBlockState newState) throws Exception {
            AuditLogDRBlock.this.updateToMetaFile(MetaFileType.ARCHIVE);
        }

        @Override
        protected String blockPath() {
            return AuditLogDRBlock.this.dataRepository().currentFrozenBlocksLocation() + File.separator + AuditLogDRBlock.this.blockName() + File.separator;
        }
    };
    private final DRBlockState frozen__defrost_index_nd = new DRBlockState("FROZEN__DEFROST_INDEX_ND"){

        @Override
        protected void beforeExit(DRBlockState newState) throws Exception {
            if (newState != AuditLogDRBlock.this.frozen__to_defrost && newState != AuditLogDRBlock.this.error) {
                throw new IllegalStateException("Can't move to " + newState.toString() + " state from " + this.toString() + "!");
            }
        }

        @Override
        protected void afterExit(DRBlockState newState) throws Exception {
            AuditLogDRBlock.this.updateToMetaFile(MetaFileType.ARCHIVE);
        }

        @Override
        protected String blockPath() {
            return AuditLogDRBlock.this.dataRepository().currentFrozenBlocksLocation() + File.separator + AuditLogDRBlock.this.blockName() + File.separator;
        }
    };
    private final DRBlockState frozen__to_defrost = new DRBlockState("FROZEN__TO_DEFROST"){
        private IndexWriter defrostIndexWriter;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void beforeExit(DRBlockState newState) throws Exception {
            if (newState != AuditLogDRBlock.this.defrost && newState != AuditLogDRBlock.this.frozen && newState != AuditLogDRBlock.this.error) {
                throw new IllegalStateException("Can't move to " + newState.toString() + " state from " + this.toString() + "!");
            }
            try {
                IndexWriter defrostIndexWriter = this.indexWriter();
                long elapsedMergeTimeMillis = System.currentTimeMillis();
                defrostIndexWriter.forceMerge(1, true);
                defrostIndexWriter.commit();
                elapsedMergeTimeMillis = System.currentTimeMillis() - elapsedMergeTimeMillis;
                JSONObject jRes = SearchService.getMinMaxLongField(AuditLogDRBlock.this.dataRepository().schema().getRangeField(), AuditLogDRBlock.this);
                if (jRes.getLong("min") != -1L && jRes.getLong("max") != -1L) {
                    AuditLogDRBlock.this.rangeFrom(jRes.getLong("min"));
                    AuditLogDRBlock.this.rangeTo(jRes.getLong("max"));
                }
                AuditLogDRBlock.this.docCount(defrostIndexWriter.numDocs());
                LOGGER.info("DEFROST :: Total time to merge index : " + elapsedMergeTimeMillis);
                LOGGER.info("DEFROST :: Index-Document count : " + defrostIndexWriter.getDirectory() + " : " + defrostIndexWriter.numDocs());
                LOGGER.info("DEFROST :: maxDoc : " + defrostIndexWriter.maxDoc());
                LOGGER.info("DEFROST :: numRamDocs : " + defrostIndexWriter.numRamDocs());
            }
            finally {
                this.closeIndexWriter();
            }
        }

        @Override
        protected void afterExit(DRBlockState newState) throws Exception {
            AuditLogDRBlock.this.updateToMetaFile(MetaFileType.ARCHIVE);
        }

        @Override
        protected String blockPath() {
            return AuditLogDRBlock.this.dataRepository().defaultDefrostBlocksLocation() + File.separator + AuditLogDRBlock.this.blockName() + File.separator;
        }

        @Override
        protected IndexWriter indexWriter() throws Exception {
            if (this.defrostIndexWriter == null) {
                this.defrostIndexWriter = LuceneIndexHandler.getIndexWriter(this.blockPath() + "luc-index", AuditLogDRBlock.this.dataRepository().getAnalyzerWrapper(), AuditLogDRBlock.this.dataRepository().getIndexSortObj());
            }
            return this.defrostIndexWriter;
        }

        @Override
        protected void commitIndexWriter() throws Exception {
            if (this.defrostIndexWriter != null && this.defrostIndexWriter.hasUncommittedChanges()) {
                this.defrostIndexWriter.commit();
            }
        }

        @Override
        protected void closeIndexWriter() throws Exception {
            if (this.defrostIndexWriter != null) {
                if (this.defrostIndexWriter.isOpen()) {
                    this.defrostIndexWriter.commit();
                    this.defrostIndexWriter.close();
                    this.defrostIndexWriter.getDirectory().close();
                    this.defrostIndexWriter = null;
                } else {
                    LOGGER.info("Index writer for " + AuditLogDRBlock.this.blockName() + "is already closed!");
                }
            }
        }
    };
    private final DRBlockState defrost = new DRBlockState("DEFROST"){

        @Override
        protected void beforeExit(DRBlockState newState) throws Exception {
            if (newState != AuditLogDRBlock.this.frozen && newState != AuditLogDRBlock.this.frozen__defrost_index_nd && newState != AuditLogDRBlock.this.error) {
                throw new IllegalStateException("Can't move to " + newState.toString() + " state from " + this.toString() + "!");
            }
        }

        @Override
        protected void afterExit(DRBlockState newState) throws Exception {
            AuditLogDRBlock.this.updateToMetaFile(MetaFileType.ARCHIVE);
        }

        @Override
        protected String blockPath() {
            return AuditLogDRBlock.this.dataRepository().defaultDefrostBlocksLocation() + File.separator + AuditLogDRBlock.this.blockName() + File.separator;
        }
    };
    private final DRBlockState error = new DRBlockState("ERROR"){

        @Override
        protected void beforeExit(DRBlockState newState) throws Exception {
        }

        @Override
        protected void afterExit(DRBlockState newState) throws Exception {
        }

        @Override
        protected String blockPath() {
            return null;
        }
    };
    private final DRBlockState deleted = new DRBlockState("DELETED"){

        @Override
        protected void beforeExit(DRBlockState newState) throws Exception {
            throw new IllegalStateException("Can't move to " + newState.toString() + " state from " + this.toString() + "!");
        }

        @Override
        protected void afterExit(DRBlockState newState) throws Exception {
            AuditLogDRBlock.this.updateToMetaFile(MetaFileType.ARCHIVE);
        }

        @Override
        protected String blockPath() {
            return null;
        }
    };

    @Override
    protected DRBlockState blockState(DRBlock.State state) {
        switch ((State)state) {
            case HOT: {
                return this.hot;
            }
            case COLD: {
                return this.cold;
            }
            case COLD__TO_FROZEN: {
                return this.cold__to_frozen;
            }
            case FROZEN: {
                return this.frozen;
            }
            case FROZEN__COLD_INDEX_ND: {
                return this.frozen__cold_index_nd;
            }
            case FROZEN__DEFROST_INDEX_ND: {
                return this.frozen__defrost_index_nd;
            }
            case FROZEN__TO_DEFROST: {
                return this.frozen__to_defrost;
            }
            case DEFROST: {
                return this.defrost;
            }
            case DELETED: {
                return this.deleted;
            }
            case ERROR: {
                return this.error;
            }
        }
        return null;
    }

    private AuditLogDRBlock(DataRepository dataRepository, String blockName, int version, State state, String status, Long creationTime, int metaIndex, boolean isNew) throws Exception {
        super(dataRepository, blockName, version, status, creationTime, metaIndex, isNew);
        if (blockName == null || dataRepository == null || creationTime == null) {
            throw new NullPointerException("Trying to initailize DRBlock with blockName|dataRepository|creationTime's value as null!");
        }
        this.stateFacade.set((Object)new DRBlockStateFacade(this.blockState(state)));
        if (isNew) {
            try (Connection connection = DBManager.getStoreConnection();){
                this.dataRepository().persistenceHandler().addToMetaFile(connection, this, MetaFileType.MAIN);
            }
        }
        this.rawDataFilePath(this.blockPath() + File.separator + "raw-data" + File.separator + "rawData.gz");
        this.updateStateFile();
    }

    public static AuditLogDRBlock createHotBlock(DataRepository dataRepository, String blockName, Long creationTime, int metaIndex) throws Exception {
        AuditLogDRBlock block = new AuditLogDRBlock(dataRepository, blockName, 10, State.HOT, "-", creationTime, metaIndex, true);
        block.initRawDataDir();
        try {
            block.commitIndex();
        }
        catch (AlreadyClosedException ae) {
            LOGGER.error("HOT-INDEX-CLOSED : DRBlock '" + block.blockName() + "' is closed! ");
            throw ae;
        }
        return block;
    }

    public static AuditLogDRBlock loadHotBlock(DataRepository dataRepository, String blockName, int version, String status, Long creationTime, int metaIndex) throws Exception {
        AuditLogDRBlock block = new AuditLogDRBlock(dataRepository, blockName, version, State.HOT, status, creationTime, metaIndex, false);
        block.initRawDataDir();
        return block;
    }

    public static AuditLogDRBlock loadBlock(DataRepository dataRepository, String blockName, int version, String stateStr, String status, Long creationTime, Long startTime, Long endTime, Integer docCount, Long size, Long rawSize, int metaIndex) throws Exception {
        State state = State.get(stateStr);
        if (state == null) {
            throw new IllegalStateException("EXCEPTION while Loading DRBlock, " + blockName + " not in expected state! current state - " + state);
        }
        if (startTime == null || endTime == null || docCount == null || size == null || rawSize == null || startTime == -1L || endTime == -1L || docCount == -1 || size == -1L || rawSize == -1L) {
            throw new NullPointerException("Trying to LOAD DRBlock with startTime|endTime|docCount|size|rawSize's value as null!");
        }
        AuditLogDRBlock block = new AuditLogDRBlock(dataRepository, blockName, version, state, status, creationTime, metaIndex, false);
        block.rangeFrom(startTime);
        block.rangeTo(endTime);
        block.docCount(docCount);
        block.size(size);
        block.rawSize(rawSize);
        return block;
    }

    @Override
    public DRBlockState currentBlockStateAction() {
        return ((DRBlockStateFacade)this.stateFacade.get()).state();
    }

    @Override
    public DRBlockState currentBlockStateFacade() {
        return (DRBlockState)this.stateFacade.get();
    }

    @Override
    public void updateStateFile() throws Exception {
        if (this.blockPath() == null) {
            return;
        }
        File[] matchingFiles = new File(this.blockPath()).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("block.state");
            }
        });
        if (matchingFiles != null && (this.currentBlockStateAction().toString().startsWith(this.hot.toString()) || this.currentBlockStateAction().toString().startsWith(this.cold.toString()))) {
            for (File file : matchingFiles) {
                file.delete();
            }
            new File(this.blockPath() + File.separator + "block.state." + this.currentBlockStateAction().toString().toLowerCase()).createNewFile();
        }
    }

    private void initRawDataDir() {
        int count;
        File rawDataDir = new File(this.blockPath() + "raw-data");
        if (!rawDataDir.exists()) {
            rawDataDir.mkdirs();
        }
        if ((count = rawDataDir.listFiles().length) > 0) {
            String newFileName = this.blockPath() + File.separator + "raw-data" + File.separator + "rawData.gz".replace(".gz", "") + "_" + count + ".gz";
            new File(this.rawDataFilePath()).renameTo(new File(newFileName));
        }
    }

    public long saveIndexFilesTo7z(String luceneIndexPath, String archivePath) throws Exception {
        return new SevenZipUtil().zip(luceneIndexPath, archivePath);
    }

    public long createIndexFilesFrom7z(String archivePath, String destPath) throws Exception {
        long millis = new SevenZipUtil().unzip(archivePath, destPath);
        try {
            LuceneIndexHandler.getIndexSearcher(this);
            LuceneIndexHandler.releaseIndexReader(this);
        }
        catch (IOException e) {
            throw new Exception("Unzipped active archive's index in corrupted state");
        }
        return millis;
    }

    public void freezeBlock(boolean isS1Enabled) throws Exception {
        String archiveFilePath = "";
        long elapsedTime = 0L;
        try {
            LOGGER.info("COLD-FREEZE :: Going to freeze cold block - " + this.blockName());
            archiveFilePath = this.dataRepository().currentFrozenBlocksLocation() + File.separator + this.blockName();
            long totalMergedRecords = this.mergeRawFiles(archiveFilePath + "_S2.gz");
            long totalIndexRecords = 0L;
            try {
                totalIndexRecords = SearchService.getDocCount(this);
            }
            catch (CorruptIndexException cie) {
                cie.printStackTrace();
                totalIndexRecords = 0L;
            }
            boolean rawCorrupted = false;
            LOGGER.info("COLD-FREEZE :: Block name : " + this.blockName() + " :: raw file count : " + totalMergedRecords + " | index doc count : " + totalIndexRecords);
            if (totalIndexRecords == totalMergedRecords) {
                LOGGER.info("Both lucence indices and raw file have the same # of records");
            } else if (totalIndexRecords > totalMergedRecords) {
                LOGGER.warn("WARNING : raw file of block " + this.blockName() + " might be corrupted!");
                rawCorrupted = true;
            } else {
                LOGGER.warn("WARNING: lucene indices of block " + this.blockName() + " might be corrupted");
                LOGGER.warn("Re-Indexing " + this.blockName() + " from raw file");
                this.reindexFromRawFile();
            }
            if (isS1Enabled) {
                LOGGER.info("COLD-FREEZE :: Going to freeze cold block - " + this.blockName() + " to stage 1");
                elapsedTime = this.saveIndexFilesTo7z(this.blockPath() + "luc-index", archiveFilePath + "_S1.7z");
                LOGGER.info("COLD-FREEZE :: Block name : " + this.blockName() + " :: saved lucene indices to 7z in " + (double)elapsedTime / 1000.0 + " secs");
            }
            LOGGER.info("COLD-FREEZE :: Going to freeze cold block - " + this.blockName() + " to stage 2");
            if (rawCorrupted) {
                SearchService.writeIndexToRawFile(this, archiveFilePath + "_S2.gz");
            }
            this.size(FileUtils.sizeOf((File)new File(this.blockPath() + "luc-index")));
            if (isS1Enabled) {
                this.coldSize(FileUtils.sizeOf((File)new File(archiveFilePath + "_S1.7z")));
                this.version(11);
            }
            this.rawSize(FileUtils.sizeOf((File)new File(archiveFilePath + "_S2.gz")));
            this.changeStateTo(State.COLD__TO_FROZEN);
            File file = new File(this.dataRepository().defaultMainBlocksLocation() + this.blockName());
            FileUtils.deleteDirectory((File)file);
            if (file.exists()) {
                this.changeStateTo(State.FROZEN__COLD_INDEX_ND);
            } else {
                this.changeStateTo(State.FROZEN);
            }
            LOGGER.info("COLD-FREEZE :: Cold block '" + this.blockName() + "' FROZEN!");
        }
        catch (Exception e) {
            if (!XNodeManager.isShutdownInitialized()) {
                LOGGER.error("COLD-FREEZE :: EXCEPTION while freezing block '" + this.blockName() + "!");
                e.printStackTrace();
                LOGGER.info("COLD-FREEZE :: Reverting back!");
                if (this.currentBlockStateAction().toString().equals(this.cold.toString())) {
                    if (isS1Enabled) {
                        LOGGER.info("COLD-FREEZE :: block in BLOCK_STATE_COLD state, deleting archive 7z file if exists");
                        File sevenZFile = new File(archiveFilePath + "_S1.7z");
                        if (sevenZFile.exists()) {
                            sevenZFile.delete();
                        }
                    }
                    LOGGER.info("COLD-FREEZE :: block in BLOCK_STATE_COLD state, deleting archive gz file if exists");
                    File gzFile = new File(archiveFilePath + "_S2.gz");
                    if (gzFile.exists()) {
                        gzFile.delete();
                    }
                } else if (this.currentBlockStateAction().toString().equals(this.cold__to_frozen.toString())) {
                    LOGGER.info("COLD-FREEZE :: block in BLOCK_STATE_COLD__TO_FROZEN state!");
                }
            }
            throw e;
        }
    }

    public void markMainBlockForDeletion() throws Exception {
        LOGGER.info("COLD-DELETE-MARK :: Marking COLD block: " + this.blockName() + " for deletion");
        this.creationTime(System.currentTimeMillis());
        this.status("MAIN_MARK_FOR_DELETION");
        this.changeStateTo(State.DELETED);
    }

    public void markArchiveBlockForDeletion() throws Exception {
        LOGGER.info("FROZEN-DELETE-MARK :: Marking Frozen block: " + this.blockName() + " in FROZEN_S2 state");
        this.creationTime(System.currentTimeMillis());
        this.status("FROZEN_MARK_FOR_DELETION");
        this.changeStateTo(State.DELETED);
    }

    public void deleteMainBlock() throws Exception {
        LOGGER.info("COLD-DELETE:: Deleting COLD block: " + this.blockName());
        File file = new File(this.dataRepository().defaultMainBlocksLocation() + this.blockName());
        FileUtils.deleteDirectory((File)file);
        if (file.exists()) {
            throw new Exception("COLD-DELETE:: Unable to delete COLD block: " + this.blockName());
        }
        LOGGER.info("COLD-DELETE:: COLD block: " + this.blockName() + " deleted successfully");
        this.status("");
        try (Connection connection = DBManager.getStoreConnection();){
            this.dataRepository().persistenceHandler().updateToMetaFile(connection, this, MetaFileType.ARCHIVE);
        }
    }

    public void deleteArchiveBlock(String archiveFileBase, boolean isS1Block) throws Exception {
        LOGGER.info("FROZEN-DELETE :: Deleting FROZEN block: " + this.blockName() + " in " + (isS1Block ? "FROZEN_S1 " : "FROZEN_S2 ") + "state");
        boolean isDeleted = false;
        if (archiveFileBase != null) {
            isDeleted = new File(archiveFileBase).delete();
        } else {
            if (isS1Block) {
                throw new Exception("FROZEN-DELETE :: Raw file not found unable to delete FROZEN block: " + this.blockName() + " in FROZEN_S1 state");
            }
            LOGGER.info("FROZEN-DELETE :: Unable to delete FROZEN block: " + this.blockName() + " in FROZEN_S2 state. Removing meta entry because file is not found");
        }
        if (!isDeleted) {
            throw new Exception("FROZEN-DELETE :: Unable to delete FROZEN block: " + this.blockName() + " in " + (isS1Block ? "FROZEN_S1" : "FROZEN_S2") + "state");
        }
        if (isS1Block) {
            this.coldSize(0L);
            this.rawSize(FileUtils.sizeOf((File)new File(archiveFileBase.replace("_S1.7z", "_S2.gz"))));
            this.version(10);
        } else {
            this.status("");
        }
        try (Connection connection = DBManager.getStoreConnection();){
            this.dataRepository().persistenceHandler().updateToMetaFile(connection, this, MetaFileType.ARCHIVE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject defrost(String archiveAbsPath) throws Exception {
        JSONObject jResponse = new JSONObject();
        File fileObj = new File(archiveAbsPath);
        IndexWriter defrostIndexWriter = null;
        GzipUtil gzipUtil = new GzipUtil();
        GzipUtil.GzipCsvReadHandle gzipCsvReadHandle = null;
        int commitBatchSize = 300000;
        JSONArray errorLineList = new JSONArray();
        boolean isS1Present = archiveAbsPath.endsWith("_S1.7z");
        if (!fileObj.exists()) {
            throw new Exception("EXCEPTION while indexing file[" + archiveAbsPath + "], file does not exist!!");
        }
        FileUtils.deleteDirectory((File)new File(this.dataRepository().defaultDefrostBlocksLocation() + this.blockName()));
        if (isS1Present) {
            try {
                long elapsedTime = this.createIndexFilesFrom7z(archiveAbsPath, this.dataRepository().defaultDefrostBlocksLocation() + File.separator + this.blockName());
                this.status("S1_LOAD");
                this.creationTime(System.currentTimeMillis());
                this.changeStateTo(State.DEFROST);
                LOGGER.info("DEFROST :: Total time to extract index file '" + archiveAbsPath + "' : " + elapsedTime);
                jResponse.put("error_code", 0);
                jResponse.put("index_process_time", elapsedTime);
            }
            catch (Exception e) {
                LOGGER.info("DEFROST :: Cannot load from active archive: " + archiveAbsPath);
                LOGGER.info("DEFROST :: Falling back to load from deep archive");
                this.defrost(archiveAbsPath.replace("_S1.7z", "_S2.gz"));
            }
        } else {
            try {
                String[] line;
                LOGGER.info("DEFROST :: Starting to index file : " + archiveAbsPath + " ...");
                long startTimeMillis = System.currentTimeMillis();
                gzipCsvReadHandle = gzipUtil.getGzipCsvReadHandle(archiveAbsPath, "UTF-8", '\t');
                ArrayList<DRIndexField> fieldList = this.dataRepository().getIndexFields();
                defrostIndexWriter = this.currentBlockStateAction().indexWriter();
                int totalLineCount = 0;
                int errLineCount = 0;
                int lineNo = 0;
                startTimeMillis = System.currentTimeMillis();
                while ((line = gzipCsvReadHandle.readNext()) != null) {
                    try {
                        ++totalLineCount;
                        if (line.length != fieldList.size()) {
                            line = AuditLogDRBlock.fillMissingCols(line, fieldList.size());
                        }
                        Document doc = AuditLogDRBlock.getLucDocument(line, fieldList);
                        defrostIndexWriter.addDocument((Iterable)doc);
                        if (totalLineCount % commitBatchSize == 0) {
                            defrostIndexWriter.commit();
                        }
                    }
                    catch (Exception e) {
                        if (XNodeManager.isShutdownInitialized()) {
                            e.printStackTrace();
                            throw new Exception("DEFROST :: ShutDown Interrupted Load Action at line - " + totalLineCount);
                        }
                        if (errLineCount < 10) {
                            LOGGER.error("EXCEPTION while parsing archive file : " + line);
                            LOGGER.error("EXCEPTION :: " + e.getMessage());
                        }
                        ++errLineCount;
                        errorLineList.put(lineNo);
                    }
                    ++lineNo;
                }
                defrostIndexWriter.commit();
                if (totalLineCount == errLineCount) {
                    throw new Exception("EXCEPTION while parsing file[" + archiveAbsPath + "], total error lines : " + errLineCount);
                }
                if (errLineCount > 0 && errLineCount < 10000) {
                    this.status("WARNING : Unable to parse " + errLineCount + " lines!");
                } else if (errLineCount > 10000) {
                    this.status("SEVERE : Unable to parse " + errLineCount + " lines!");
                } else {
                    this.status("S2_LOAD");
                }
                this.creationTime(System.currentTimeMillis());
                this.changeStateTo(State.DEFROST);
                long endTimeMillis = System.currentTimeMillis();
                LOGGER.info("DEFROST :: Total time to index file '" + archiveAbsPath + "' : " + (endTimeMillis - startTimeMillis));
                jResponse.put("error_code", 0);
                jResponse.put("error_count", errLineCount);
                jResponse.put("error_line_list", (Object)errorLineList);
                jResponse.put("index_process_time", endTimeMillis - startTimeMillis);
            }
            finally {
                if (gzipCsvReadHandle != null) {
                    gzipCsvReadHandle.close();
                }
                defrostIndexWriter = null;
            }
        }
        return jResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject defrostLegacy(String absFileName) throws Exception {
        JSONObject jResponse = new JSONObject();
        Charset encoding = Charset.forName("UTF-8");
        String splitBy = "\t";
        Boolean isMySqlDb = false;
        Boolean isMSSqlDb = false;
        BufferedReader br = null;
        File fileObj = new File(absFileName);
        IndexWriter defrostIndexWriter = null;
        int commitBatchSize = 300000;
        JSONArray errorLineList = new JSONArray();
        String msSQLLineTerminator = "|**|**|";
        if (!fileObj.exists()) {
            throw new Exception("EXCEPTION while indexing file[" + absFileName + "], file does not exist!!");
        }
        try {
            String line;
            LOGGER.info("DEFROST :: Starting to unzip file : " + absFileName + " ...");
            long startTimeMillis = System.currentTimeMillis();
            ZipUtil.unZip((File)fileObj, (File)fileObj.getParentFile(), null, null, (String)this.zipPassword());
            long endTimeMillis = System.currentTimeMillis();
            LOGGER.info("DEFROST :: Unzipped file : " + absFileName + ", total time : " + (endTimeMillis - startTimeMillis));
            encoding = GuessEncoding.getArchiveFileEncoding((File)new File(absFileName.replace(".zip", ".csv")));
            if (encoding.toString().equals("UTF-16LE")) {
                splitBy = "\\|\\*\\*\\|";
                isMSSqlDb = true;
            } else {
                br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(absFileName.replace(".zip", ".csv")), encoding));
                String firstLine = br.readLine();
                if (firstLine.contains("|**|")) {
                    splitBy = "\\|\\*\\*\\|";
                    isMSSqlDb = true;
                } else if (!firstLine.contains("\t")) {
                    splitBy = ",";
                    isMySqlDb = true;
                }
                br.close();
            }
            LOGGER.info("DEFROST :: Delimeter for file '" + absFileName + "' : " + splitBy);
            LOGGER.info("DEFROST :: Encoding for file '" + absFileName + "' : " + encoding);
            ArrayList<DRIndexField> fieldList = this.dataRepository().getIndexFields();
            defrostIndexWriter = this.currentBlockStateAction().indexWriter();
            int totalLineCount = 0;
            int errLineCount = 0;
            int lineNo = 0;
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(absFileName.replace(".zip", ".csv")), encoding));
            startTimeMillis = System.currentTimeMillis();
            while ((line = br.readLine()) != null) {
                try {
                    String[] str;
                    ++totalLineCount;
                    if (isMSSqlDb.booleanValue() && !line.endsWith(msSQLLineTerminator)) {
                        String secondline;
                        while ((secondline = br.readLine()) != null && !(line = line + secondline).endsWith(msSQLLineTerminator)) {
                        }
                    }
                    if (!isMSSqlDb.booleanValue() && !isMySqlDb.booleanValue()) {
                        line = line.replace("\\\\", "\\");
                    }
                    if ((str = this.splitLine(line, splitBy, fieldList.size(), isMySqlDb)).length != fieldList.size()) {
                        str = AuditLogDRBlock.fillMissingCols(str, fieldList.size());
                    }
                    Document doc = AuditLogDRBlock.getLucDocument(str, fieldList);
                    defrostIndexWriter.addDocument((Iterable)doc);
                    if (totalLineCount % commitBatchSize == 0) {
                        defrostIndexWriter.commit();
                    }
                }
                catch (Exception e) {
                    if (XNodeManager.isShutdownInitialized()) {
                        throw new Exception("DEFROST :: ShutDown Interrupted Load Action at line - " + totalLineCount);
                    }
                    if (errLineCount < 10) {
                        LOGGER.error("EXCEPTION while parsing archive file : " + line);
                        LOGGER.error("EXCEPTION :: " + e.getMessage());
                    }
                    ++errLineCount;
                    errorLineList.put(lineNo);
                }
                ++lineNo;
            }
            defrostIndexWriter.commit();
            if (totalLineCount == errLineCount) {
                throw new Exception("EXCEPTION while parsing file[" + fileObj.getName().replace(".zip", ".csv") + "], total error lines : " + errLineCount);
            }
            if (errLineCount > 0 && errLineCount < 10000) {
                this.status("WARNING : Unable to parse " + errLineCount + " lines!");
            } else if (errLineCount > 10000) {
                this.status("SEVERE : Unable to parse " + errLineCount + " lines!");
            } else {
                this.status("-");
            }
            this.creationTime(System.currentTimeMillis());
            this.changeStateTo(State.DEFROST);
            endTimeMillis = System.currentTimeMillis();
            LOGGER.info("DEFROST :: Total time to index file '" + absFileName + "' : " + (endTimeMillis - startTimeMillis));
            jResponse.put("error_code", 0);
            jResponse.put("error_count", errLineCount);
            jResponse.put("error_line_list", (Object)errorLineList);
            jResponse.put("index_process_time", endTimeMillis - startTimeMillis);
        }
        finally {
            if (br != null) {
                br.close();
            }
            defrostIndexWriter = null;
            new File(absFileName.replace(".zip", ".csv")).delete();
        }
        return jResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reindexFromRawFile(PrintStream ps) throws Exception {
        IndexWriter indexWriter = null;
        GzipUtil gzipUtil = new GzipUtil();
        GzipUtil.GzipCsvReadHandle gzipCsvReadHandle = null;
        int commitBatchSize = 300000;
        boolean closeIndexWriter = true;
        try {
            File rawDataDir = new File(this.blockPath() + "raw-data");
            if (!rawDataDir.exists()) {
                return;
            }
            File[] gzFiles = rawDataDir.listFiles();
            if (gzFiles == null || gzFiles.length == 0) {
                return;
            }
            ArrayList<DRIndexField> fieldList = this.dataRepository().getIndexFields();
            int totalLineCount = 0;
            int errLineCount = 0;
            long startTimeMillis = System.currentTimeMillis();
            this.printInfoInLogAndConsole(ps, "RE-INDEX :: Going to re-index block " + this.blockName() + " from raw files...");
            this.printInfoInLogAndConsole(ps, "RE-INDEX :: Deleting old index...");
            FileUtils.deleteDirectory((File)new File(this.blockPath() + "luc-index"));
            this.printInfoInLogAndConsole(ps, "RE-INDEX :: Deleted old index!");
            if (this.currentBlockStateAction().toString().startsWith(State.HOT.toString())) {
                try {
                    this.printInfoInLogAndConsole(ps, "RE-INDEX :: Going to close IndexWriter for block " + this.blockName());
                    this.currentBlockStateAction().closeIndexWriter();
                    this.printInfoInLogAndConsole(ps, "RE-INDEX :: Closed IndexWriter for block " + this.blockName());
                }
                catch (Exception ex) {
                    this.printInfoInLogAndConsole(ps, "Exception while closing IndexWriter for block " + this.blockName());
                    this.printErrorInLogAndConsole(ps, "EXCEPTION :: " + ex.getMessage());
                }
                indexWriter = LuceneIndexHandler.getIndexWriter(this.blockPath() + "luc-index", this.dataRepository().getAnalyzerWrapper(), this.dataRepository().getIndexSortObj());
            } else if (this.currentBlockStateAction().toString().startsWith(State.COLD.toString())) {
                indexWriter = LuceneIndexHandler.getIndexWriter(this.blockPath() + "luc-index", this.dataRepository().getAnalyzerWrapper(), this.dataRepository().getIndexSortObj());
            } else {
                throw new Exception("EXCEPTION while re-indexing DRBlock '" + this.blockName() + "', can't re-index in " + this.currentBlockStateAction().toString() + " state!");
            }
            for (File rawFile : gzFiles) {
                String[] line;
                this.printInfoInLogAndConsole(ps, "RE-INDEX :: Starting to index file : " + rawFile.getName() + " ...");
                gzipCsvReadHandle = gzipUtil.getGzipCsvReadHandle(rawFile.getAbsolutePath(), "UTF-8", '\t');
                while ((line = gzipCsvReadHandle.readNext()) != null) {
                    try {
                        Document doc = AuditLogDRBlock.getLucDocument(line, fieldList);
                        indexWriter.addDocument((Iterable)doc);
                        if (++totalLineCount % commitBatchSize != 0) continue;
                        this.printInfoInLogAndConsole(ps, "RE-INDEX :: Committing @ : " + totalLineCount);
                        indexWriter.commit();
                    }
                    catch (Exception e) {
                        this.printErrorInLogAndConsole(ps, "EXCEPTION while parsing raw file : " + line);
                        this.printErrorInLogAndConsole(ps, "EXCEPTION :: " + e.getMessage());
                        ++errLineCount;
                    }
                }
                indexWriter.commit();
            }
            this.printInfoInLogAndConsole(ps, "RE-INDEX :: Going to merge index...");
            indexWriter.forceMerge(1, true);
            indexWriter.commit();
            this.printInfoInLogAndConsole(ps, "RE-INDEX :: Merged!");
            if (totalLineCount == errLineCount) {
                throw new Exception("EXCEPTION while parsing raw files for re-index, total error lines : " + errLineCount);
            }
            this.isMerged(SearchService.getSegmentCount(this) == 1);
            JSONObject jRes = SearchService.getMinMaxLongField(this.dataRepository().schema().getRangeField(), this);
            this.rangeFrom(jRes.getLong("min") == -1L ? 0L : jRes.getLong("min"));
            this.rangeTo(jRes.getLong("max") == -1L ? 0L : jRes.getLong("max"));
            this.docCount(indexWriter == null ? 0 : indexWriter.numDocs());
            this.size(FileUtils.sizeOf((File)new File(this.blockPath())));
            this.rawSize(FileUtils.sizeOf((File)new File(this.blockPath() + "raw-data")));
            this.updateToMetaFile(MetaFileType.MAIN);
            long endTimeMillis = System.currentTimeMillis();
            this.printInfoInLogAndConsole(ps, "RE-INDEX :: Total time to re-index block '" + this.blockName() + "' : " + (endTimeMillis - startTimeMillis));
        }
        finally {
            if (gzipCsvReadHandle != null) {
                gzipCsvReadHandle.close();
            }
            if (indexWriter != null) {
                indexWriter.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reindexFromRawFile() throws Exception {
        IndexWriter indexWriter = null;
        GzipUtil gzipUtil = new GzipUtil();
        GzipUtil.GzipCsvReadHandle gzipCsvReadHandle = null;
        int commitBatchSize = 300000;
        boolean closeIndexWriter = true;
        try {
            File rawDataDir = new File(this.blockPath() + "raw-data");
            if (!rawDataDir.exists()) {
                return;
            }
            File[] gzFiles = rawDataDir.listFiles();
            if (gzFiles == null || gzFiles.length == 0) {
                return;
            }
            ArrayList<DRIndexField> fieldList = this.dataRepository().getIndexFields();
            int totalLineCount = 0;
            int errLineCount = 0;
            long startTimeMillis = System.currentTimeMillis();
            FileUtils.deleteDirectory((File)new File(this.blockPath() + "luc-index"));
            if (this.currentBlockStateAction().toString().startsWith(State.HOT.toString())) {
                indexWriter = this.currentBlockStateAction().indexWriter();
            } else if (this.currentBlockStateAction().toString().startsWith(State.COLD.toString())) {
                indexWriter = LuceneIndexHandler.getIndexWriter(this.blockPath() + "luc-index", this.dataRepository().getAnalyzerWrapper());
            } else {
                throw new Exception("EXCEPTION while re-indexing DRBlock '" + this.blockName() + "', can't re-index in " + this.currentBlockStateAction().toString() + " state!");
            }
            for (File rawFile : gzFiles) {
                String[] line;
                gzipCsvReadHandle = gzipUtil.getGzipCsvReadHandle(rawFile.getAbsolutePath(), "UTF-8", '\t');
                while ((line = gzipCsvReadHandle.readNext()) != null) {
                    try {
                        Document doc = AuditLogDRBlock.getLucDocument(line, fieldList);
                        indexWriter.addDocument((Iterable)doc);
                        if (++totalLineCount % commitBatchSize != 0) continue;
                        indexWriter.commit();
                    }
                    catch (Exception e) {
                        ++errLineCount;
                    }
                }
                indexWriter.commit();
            }
            indexWriter.forceMerge(1, true);
            indexWriter.commit();
            if (totalLineCount == errLineCount) {
                throw new Exception("EXCEPTION while parsing raw files for re-index, total error lines : " + errLineCount);
            }
            this.isMerged(SearchService.getSegmentCount(this) == 1);
            JSONObject jRes = SearchService.getMinMaxLongField(this.dataRepository().schema().getRangeField(), this);
            this.rangeFrom(jRes.getLong("min") == -1L ? 0L : jRes.getLong("min"));
            this.rangeTo(jRes.getLong("max") == -1L ? 0L : jRes.getLong("max"));
            this.docCount(indexWriter == null ? 0 : indexWriter.numDocs());
            this.size(FileUtils.sizeOf((File)new File(this.blockPath())));
            this.rawSize(FileUtils.sizeOf((File)new File(this.blockPath() + "raw-data")));
            this.updateToMetaFile(MetaFileType.MAIN);
            long endTimeMillis = System.currentTimeMillis();
        }
        finally {
            if (gzipCsvReadHandle != null) {
                gzipCsvReadHandle.close();
            }
            if (indexWriter != null && !this.currentBlockStateAction().toString().startsWith(State.HOT.toString())) {
                indexWriter.close();
            }
        }
    }

    public CheckIndex.Status checkIndex(PrintStream ps) throws Exception {
        Directory dir = LuceneIndexHandler.getIndexDirectory(this.blockPath() + "luc-index");
        try (CheckIndex checkIndex = new CheckIndex(dir);){
            if (ps != null) {
                checkIndex.setInfoStream(ps);
            }
            CheckIndex.Status status = checkIndex.checkIndex();
            return status;
        }
    }

    public void repairIndex(PrintStream ps, CheckIndex.Status status) throws Exception {
        Directory dir = LuceneIndexHandler.getIndexDirectory(this.blockPath() + "luc-index");
        try (CheckIndex ci = new CheckIndex(dir);){
            if (ps != null) {
                ci.setInfoStream(ps);
            }
            ci.exorciseIndex(status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRawDocCount() throws Exception {
        int totalLineCount = 0;
        Object indexWriter = null;
        GzipUtil gzipUtil = new GzipUtil();
        boolean closeIndexWriter = true;
        try (GzipUtil.GzipCsvReadHandle gzipCsvReadHandle = null;){
            File rawDataDir = new File(this.blockPath() + "raw-data");
            if (!rawDataDir.exists()) {
                int n = totalLineCount;
                return n;
            }
            File[] gzFiles = rawDataDir.listFiles();
            if (gzFiles == null || gzFiles.length == 0) {
                int n = totalLineCount;
                return n;
            }
            for (File rawFile : gzFiles) {
                String[] line;
                gzipCsvReadHandle = gzipUtil.getGzipCsvReadHandle(rawFile.getAbsolutePath(), "UTF-8", '\t');
                while ((line = gzipCsvReadHandle.readNext()) != null) {
                    ++totalLineCount;
                }
            }
        }
        return totalLineCount;
    }

    public int getIndexDocCount() throws Exception {
        try (IndexWriter indexWriter = null;){
            if (this.currentBlockStateAction().toString().startsWith(State.HOT.toString())) {
                try {
                    this.currentBlockStateAction().closeIndexWriter();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                indexWriter = LuceneIndexHandler.getIndexWriter(this.blockPath() + "luc-index", this.dataRepository().getAnalyzerWrapper(), this.dataRepository().getIndexSortObj());
            } else if (this.currentBlockStateAction().toString().startsWith(State.COLD.toString())) {
                indexWriter = LuceneIndexHandler.getIndexWriter(this.blockPath() + "luc-index", this.dataRepository().getAnalyzerWrapper(), this.dataRepository().getIndexSortObj());
            } else {
                throw new Exception("EXCEPTION while getting doc count of DRBlock '" + this.blockName() + "', can't get count in " + this.currentBlockStateAction().toString() + " state!");
            }
            int n = indexWriter.numDocs();
            return n;
        }
    }

    @Override
    public boolean isOlderThan(int noDays) throws Exception {
        if (this.currentBlockStateAction() != this.cold && this.currentBlockStateAction() != this.frozen || noDays <= 0) {
            return false;
        }
        DateTime nowDate = DateTime.now();
        DateTime blockEndTime = new DateTime(this.rangeTo() * 1000L);
        int dayDiff = Days.daysBetween((ReadableInstant)blockEndTime, (ReadableInstant)nowDate).getDays();
        return dayDiff >= noDays;
    }

    private long mergeRawFiles(String destFilePath) throws Exception {
        long totalRecords = 0L;
        File rawDataDir = new File(this.blockPath() + "raw-data");
        if (rawDataDir.exists()) {
            File archiveDir = new File(this.dataRepository().currentFrozenBlocksLocation());
            if (!archiveDir.exists()) {
                archiveDir.mkdirs();
            }
            if (new File(destFilePath).exists()) {
                new File(destFilePath).delete();
            }
            GzipUtil gzipUtil = new GzipUtil();
            totalRecords = gzipUtil.mergeGzipFiles(rawDataDir.listFiles(), destFilePath, '\t');
        }
        return totalRecords;
    }

    private String[] splitLine(String line, String splitBy, int totalCols, boolean isMySql) {
        int i;
        String[] rColStr = new String[totalCols];
        String[] aColStr = isMySql ? this.splitMySqlLine(line, totalCols) : line.split(splitBy, -1);
        int actualColLen = aColStr.length;
        int indexLen = totalCols;
        if (actualColLen < totalCols) {
            indexLen = actualColLen;
        }
        for (i = 0; i < indexLen; ++i) {
            rColStr[i] = aColStr[i] == null || aColStr[i].isEmpty() ? "-" : aColStr[i];
        }
        for (i = actualColLen; i < totalCols; ++i) {
            rColStr[i] = "-";
        }
        return rColStr;
    }

    private String[] splitMySqlLine(String line, int totalCols) {
        String[] splitStr = new String[totalCols];
        int len = line.length();
        int commaBeginIndex = 0;
        int commaEndIndex = 0;
        int splitStrIndex = 0;
        while (commaEndIndex < len && splitStrIndex < totalCols) {
            boolean isQuoteChk = false;
            if (line.charAt(commaBeginIndex) == '\"') {
                for (commaEndIndex = ++commaBeginIndex; commaEndIndex < len && (line.charAt(commaEndIndex) != '\"' || line.charAt(commaEndIndex - 1) == '\\' && commaEndIndex - 2 >= 0 && line.charAt(commaEndIndex - 2) != '\\'); ++commaEndIndex) {
                }
                isQuoteChk = true;
            } else {
                commaEndIndex = line.indexOf(44, commaBeginIndex);
            }
            if (commaEndIndex == -1) {
                commaEndIndex = len;
            }
            String colVal = line.substring(commaBeginIndex, commaEndIndex);
            if ((colVal = colVal.replace("\\\\", "\\")).equals("\\N")) {
                colVal = "";
            }
            splitStr[splitStrIndex++] = colVal;
            commaEndIndex = commaBeginIndex = commaEndIndex + (isQuoteChk ? 2 : 1);
        }
        return splitStr;
    }

    private void printInfoInLogAndConsole(PrintStream ps, String msg) {
        LOGGER.info(msg);
        ps.print("\n" + msg);
        ps.flush();
    }

    private void printErrorInLogAndConsole(PrintStream ps, String msg) {
        LOGGER.error(msg);
        ps.print("\n" + msg);
        ps.flush();
    }

    public static enum State implements DRBlock.State
    {
        HOT("HOT"),
        COLD("COLD"),
        COLD__TO_FROZEN("COLD__TO_FROZEN"),
        FROZEN("FROZEN"),
        FROZEN__COLD_INDEX_ND("FROZEN__COLD_INDEX_ND"),
        FROZEN__DEFROST_INDEX_ND("FROZEN__DEFROST_INDEX_ND"),
        FROZEN__TO_DEFROST("FROZEN__TO_DEFROST"),
        DEFROST("DEFROST"),
        ERROR("ERROR"),
        DELETED("DELETED");

        private String stateText;

        private State(String stateText) {
            this.stateText = stateText;
        }

        public String toString() {
            return this.stateText;
        }

        public static State get(String stateText) {
            for (State stateType : State.values()) {
                if (!stateType.stateText.equalsIgnoreCase(stateText)) continue;
                return stateType;
            }
            return null;
        }
    }
}

