/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository;

import com.csvreader.CsvReader;
import com.glaforge.i18n.io.CharsetToolkit;
import com.manageengine.dataengine.commons.crypto.CryptoUtil;
import com.manageengine.dataengine.commons.datarepository.DRFieldDataType;
import com.manageengine.dataengine.commons.datarepository.DRIndexField;
import com.manageengine.dataengine.commons.file.GzipUtil;
import com.manageengine.dataengine.xnode.database.DBManager;
import com.manageengine.dataengine.xnode.datarepository.DRBlockState;
import com.manageengine.dataengine.xnode.datarepository.DataRepository;
import com.manageengine.dataengine.xnode.datarepository.MetaFileType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class DRBlock {
    private String blockName = null;
    private int metaIndex;
    private DataRepository dataRepository = null;
    private int version = 10;
    private String status = null;
    private Long creationTime = 0L;
    private Long deletedTime = 0L;
    private Long rangeFrom = 0L;
    private Long rangeTo = 0L;
    private String zipPassword = null;
    private String encryptedZipPassword = null;
    private Boolean isMerged = false;
    private Integer docCount = 0;
    private Long size = 0L;
    private Long coldSize = 0L;
    private Long rawSize = 0L;
    public static final int VERSION_LEGACY_V1 = 1;
    public static final int VERSION_DE_V1 = 10;
    public static final int VERSION_DE_S1 = 11;
    public static final int CURRENT_VERSION = 10;
    public static final String DEFAULT_STATUS = "-";
    public static final String S1_LOADED_STATUS = "S1_LOAD";
    public static final String S2_LOADED_STATUS = "S2_LOAD";
    public static final String COLD_INDEX_NOT_DELETED_STATUS = "_COLD_INDEX_NOT_DELETED";
    public static final String DEFROST_INDEX_NOT_DELETED_STATUS = "_DEFROST_INDEX_NOT_DELETED";
    public static final String LUC_INDEX_DIR = "luc-index";
    public static final String LUC_FACET_DIR = "luc-facet";
    public static final String RAW_DATA_DIR = "raw-data";
    public static final String RAW_GZ_FILE_NAME = "rawData.gz";
    public static final String S1_EXT = "_S1.7z";
    public static final String S2_EXT = "_S2.gz";
    public static final String LEGACY_GZ_EXT = ".gz";
    public static final String LEGACY_ZIP_EXT = ".zip";
    public static final char INDEX_FILE_SPLIT_BY = '\t';
    public static final String INDEX_FILE_ENCODING = "UTF-8";
    public static final char RAW_GZ_SPLIT_BY = '\t';
    public static final String RAW_GZ_ENCODING = "UTF-8";
    private static final String UNIQUE_FIELD = "UNIQUE_FIELD";
    private String uniqueFieldValue;
    private boolean isIndexing = false;
    private boolean isFull = false;
    private String rawDataFilePath = null;
    public final Object index_lock = new Object();
    public final Object index_reader_lock = new Object();
    private static final Logger LOGGER = LogManager.getLogger((String)"DataRepository");

    protected DRBlock(DataRepository dataRepository, String blockName, int version, String status, Long creationTime, int metaIndex, boolean isNew) throws Exception {
        if (blockName == null || dataRepository == null || creationTime == null) {
            throw new NullPointerException("Trying to initailize DRBlock with blockName|dataRepository|creationTime's value as null!");
        }
        this.blockName = blockName;
        this.version = version;
        this.metaIndex = metaIndex;
        this.dataRepository = dataRepository;
        this.status = status;
        this.creationTime = creationTime;
    }

    public String blockName() {
        return this.blockName;
    }

    public void blockName(String blockName) {
        this.blockName = blockName;
    }

    public int version() {
        return this.version;
    }

    public void version(int version) {
        this.version = version;
    }

    public String blockPath() {
        return this.currentBlockStateAction().blockPath();
    }

    public int metaIndex() {
        return this.metaIndex;
    }

    public void metaIndex(int metaIndex) {
        this.metaIndex = metaIndex;
    }

    public DataRepository dataRepository() {
        return this.dataRepository;
    }

    public void dataRepository(DataRepository dataRepository) {
        this.dataRepository = dataRepository;
    }

    public Long creationTime() {
        return this.creationTime;
    }

    public void creationTime(Long creationTime) {
        this.creationTime = creationTime;
    }

    public Long deletedTime() {
        return this.deletedTime;
    }

    public void deletedTime(Long deletedTime) {
        this.deletedTime = deletedTime;
    }

    public String zipPassword() {
        return this.zipPassword;
    }

    public String encryptedZipPassword() {
        return this.encryptedZipPassword;
    }

    protected void zipPassword(String zipPassword) throws Exception {
        this.zipPassword = zipPassword;
        if (zipPassword != null && !zipPassword.trim().isEmpty()) {
            this.encryptedZipPassword = CryptoUtil.encrypt((String)zipPassword, (int)2);
        }
    }

    protected void encryptedZipPassword(String encryptedZipPassword) throws Exception {
        this.encryptedZipPassword = encryptedZipPassword;
        if (encryptedZipPassword != null && !encryptedZipPassword.trim().isEmpty()) {
            this.zipPassword = CryptoUtil.decrypt((String)encryptedZipPassword, (int)2);
        }
    }

    public Boolean isMerged() {
        return this.isMerged;
    }

    protected void isMerged(Boolean isMerged) {
        this.isMerged = isMerged;
    }

    public String status() {
        return this.status;
    }

    public void status(String status) {
        this.status = status;
    }

    public Long rangeFrom() throws Exception {
        return this.rangeFrom;
    }

    public void rangeFrom(Long rangeFrom) {
        this.rangeFrom = rangeFrom;
    }

    public Long rangeTo() throws Exception {
        return this.rangeTo;
    }

    public void rangeTo(Long rangeTo) {
        this.rangeTo = rangeTo;
    }

    public Integer docCount() {
        return this.docCount;
    }

    public void docCount(Integer docCount) {
        this.docCount = docCount;
    }

    public Long size() {
        return this.size;
    }

    public void size(Long size) {
        this.size = size;
    }

    public Long rawSize() {
        return this.rawSize;
    }

    public void rawSize(Long rawSize) {
        this.rawSize = rawSize;
    }

    public void coldSize(Long coldSize) {
        this.coldSize = coldSize;
    }

    public Long coldSize() {
        return this.coldSize;
    }

    public String rawDataFilePath() {
        return this.rawDataFilePath;
    }

    public void rawDataFilePath(String rawDataFilePath) {
        this.rawDataFilePath = rawDataFilePath;
    }

    public void logMetaInfo() {
        LOGGER.info("  -------------------------------");
        LOGGER.info("   BLOCK META INFO - " + this.blockName);
        LOGGER.info("   # DR Name : " + this.dataRepository.repositoryName());
        LOGGER.info("   # Version : " + this.version);
        LOGGER.info("   # Creation Time : " + this.creationTime);
        LOGGER.info("   # Block State : " + this.currentBlockStateAction().toString());
        LOGGER.info("   # Status : " + this.status);
        LOGGER.info("   # Range From : " + this.rangeFrom);
        LOGGER.info("   # Range To : " + this.rangeTo);
        LOGGER.info("   # Doc Count : " + this.docCount);
        LOGGER.info("   # Size : " + this.size);
        LOGGER.info("   # Raw Size : " + this.rawSize);
        LOGGER.info("  -------------------------------");
    }

    public void logMinMetaInfo() {
        LOGGER.info("BLOCK META INFO [BlockName : " + this.blockName + "] [Block State : " + this.currentBlockStateAction().toString() + "] [Range From : " + this.rangeFrom + "] [Range To : " + this.rangeTo + "] [Doc Count : " + this.docCount + "]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean book() {
        Object object = this.index_lock;
        synchronized (object) {
            if (this.isIndexing || this.isFull) {
                return false;
            }
            this.isIndexing = true;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int unbook() throws Exception {
        Object object = this.index_lock;
        synchronized (object) {
            this.isIndexing = false;
            return this.isFull() ? 1 : 0;
        }
    }

    protected void updateToMetaFile(MetaFileType metaFileType) throws Exception {
        try (Connection connection = DBManager.getStoreConnection();){
            this.dataRepository().persistenceHandler().updateToMetaFile(connection, this, metaFileType);
        }
    }

    public boolean isFull() throws Exception {
        this.isFull = this.getRemainingIndexableDocCount() <= 0;
        return this.isFull;
    }

    public boolean isEmpty() throws Exception {
        return this.currentBlockStateAction().docCount() == 0;
    }

    public int getRemainingIndexableDocCount() throws Exception {
        return this.dataRepository().hotBlockThresholdDocCount() - this.currentBlockStateAction().docCount();
    }

    public void mergeIndex() throws Exception {
        this.currentBlockStateAction().mergeIndex();
    }

    public void commitIndex() throws Exception {
        this.currentBlockStateAction().commitIndexWriter();
    }

    public final synchronized DRBlockState changeStateTo(State toState) throws Exception {
        DRBlockState toBlockState = this.blockState(toState);
        this.currentBlockStateFacade().moveTo(toBlockState);
        this.updateStateFile();
        return toBlockState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject addDataToIndex(String absFileName, Charset fileEncoding, char splitBy) throws Exception {
        JSONObject jResponse;
        block14: {
            jResponse = new JSONObject();
            int READ_BUF_SIZE = 4056;
            JSONArray errorLineList = new JSONArray();
            ArrayList<DRIndexField> fieldList = this.dataRepository().getIndexFields();
            BufferedReader br = null;
            CsvReader csvReader = null;
            GzipUtil gzipUtil = new GzipUtil();
            GzipUtil.GzipCsvWriteHandle gzipCsvWriteHandle = null;
            IndexWriter indexWriter = this.currentBlockStateAction().indexWriter();
            boolean storeRawData = this.dataRepository().storeRawData();
            try {
                int errLineCount = 0;
                int indexedCount = 0;
                int lineNo = 0;
                br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(absFileName), fileEncoding), 4056);
                csvReader = new CsvReader((Reader)br, splitBy);
                csvReader.setSafetySwitch(false);
                if (storeRawData) {
                    gzipCsvWriteHandle = gzipUtil.getGzipCsvWriteHandle(this.rawDataFilePath(), "UTF-8", '\t');
                }
                Long startTimeMillis = System.currentTimeMillis();
                if (!this.dataRepository.isStopping()) {
                    while (csvReader.readRecord()) {
                        try {
                            String[] colVals = csvReader.getValues();
                            if (colVals.length != fieldList.size()) {
                                colVals = DRBlock.fillMissingCols(colVals, fieldList.size());
                            }
                            Document doc = DRBlock.getLucDocument(colVals, fieldList);
                            indexWriter.addDocument((Iterable)doc);
                            if (storeRawData) {
                                gzipCsvWriteHandle.writeNext(colVals);
                            }
                            ++indexedCount;
                        }
                        catch (Exception e) {
                            LOGGER.error("Archive Index Parsing Exception[" + e.getMessage() + "] :: " + csvReader.getRawRecord());
                            ++errLineCount;
                            errorLineList.put(lineNo);
                        }
                        ++lineNo;
                    }
                    if (this.dataRepository.hotBlockRefreshInterval() == 0) {
                        indexWriter.commit();
                    }
                    Long endTimeMillis = System.currentTimeMillis();
                    jResponse.put("error_code", 0);
                    jResponse.put("error_count", errLineCount);
                    jResponse.put("error_line_list", (Object)errorLineList);
                    jResponse.put("index_process_time", endTimeMillis - startTimeMillis);
                    jResponse.put("indexed_doc_count", indexedCount);
                    break block14;
                }
                throw new Exception("DataEngine XNode is shutting down!");
            }
            finally {
                if (csvReader != null) {
                    csvReader.close();
                }
                if (br != null) {
                    br.close();
                }
                if (gzipCsvWriteHandle != null) {
                    gzipCsvWriteHandle.close();
                }
            }
        }
        return jResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject addDataToIndex(JSONArray jDocList) throws Exception {
        JSONObject jResponse;
        block12: {
            jResponse = new JSONObject();
            JSONArray errorLineList = new JSONArray();
            ArrayList<DRIndexField> fieldList = this.dataRepository().getIndexFields();
            GzipUtil gzipUtil = new GzipUtil();
            GzipUtil.GzipCsvWriteHandle gzipCsvWriteHandle = null;
            IndexWriter indexWriter = this.currentBlockStateAction().indexWriter();
            boolean storeRawData = this.dataRepository().storeRawData();
            try {
                JSONArray jRow = null;
                int errLineCount = 0;
                int indexedCount = 0;
                int lineNo = 0;
                if (storeRawData) {
                    gzipCsvWriteHandle = gzipUtil.getGzipCsvWriteHandle(this.rawDataFilePath(), "UTF-8", '\t');
                }
                Long startTimeMilis = System.currentTimeMillis();
                if (!this.dataRepository.isStopping()) {
                    int totalDocs = jDocList.length();
                    for (int i = 0; i < totalDocs; ++i) {
                        try {
                            jRow = jDocList.getJSONArray(i);
                            int len = jRow.length();
                            String[] actualColStr = new String[len];
                            for (int colIndex = 0; colIndex < len; ++colIndex) {
                                actualColStr[colIndex] = jRow.getString(colIndex);
                            }
                            Document doc = DRBlock.getLucDocument(actualColStr, fieldList);
                            indexWriter.addDocument((Iterable)doc);
                            if (storeRawData) {
                                gzipCsvWriteHandle.writeNext(actualColStr);
                            }
                            ++indexedCount;
                        }
                        catch (Exception e) {
                            LOGGER.error("Archive Index Parsing Exception[" + e.getMessage() + "] :: " + jRow.toString());
                            e.printStackTrace();
                            ++errLineCount;
                            errorLineList.put(lineNo);
                        }
                        ++lineNo;
                    }
                    if (this.dataRepository.hotBlockRefreshInterval() == 0) {
                        indexWriter.commit();
                    }
                    Long endTimeMillis = System.currentTimeMillis();
                    jResponse.put("error_code", 0);
                    jResponse.put("error_count", errLineCount);
                    jResponse.put("error_line_list", (Object)errorLineList);
                    jResponse.put("index_process_time", endTimeMillis - startTimeMilis);
                    jResponse.put("indexed_doc_count", indexedCount);
                    break block12;
                }
                throw new Exception("DataEngine XNode is shutting down!");
            }
            finally {
                if (gzipCsvWriteHandle != null) {
                    gzipCsvWriteHandle.close();
                }
            }
        }
        return jResponse;
    }

    public boolean isCreationTimeOlderThan(int noDays) throws Exception {
        DateTime nowDate = DateTime.now();
        DateTime blockEndTime = new DateTime((Object)this.creationTime());
        int dayDiff = Days.daysBetween((ReadableInstant)blockEndTime, (ReadableInstant)nowDate).getDays();
        return dayDiff >= noDays;
    }

    protected Document getLucDocument(String[] actualColStr, ArrayList<DRIndexField> uniqueFieldList, ArrayList<DRIndexField> lucArchFieldList) throws Exception {
        Document doc = null;
        doc = new Document();
        this.uniqueFieldValue = "";
        for (DRIndexField field : lucArchFieldList) {
            String fieldDataType = field.getDataType();
            String fieldVal = actualColStr[field.getFieldIndex()];
            if (fieldVal != null && !fieldVal.trim().isEmpty() && !fieldVal.equals(DEFAULT_STATUS)) {
                DRFieldDataType drFieldType = DRFieldDataType.get((String)fieldDataType);
                List lucFields = drFieldType.createFields(field.getFieldName(), (Object)fieldVal, true, field.hasDocValue(), true, field.getAnalyzer().name());
                for (Field lucField : lucFields) {
                    doc.add((IndexableField)lucField);
                }
                continue;
            }
            if (!field.isNotNull()) continue;
            throw new Exception("NOT NULL constraint failed for field " + field.getFieldName() + "!");
        }
        for (DRIndexField indexField : uniqueFieldList) {
            this.uniqueFieldValue = this.uniqueFieldValue + actualColStr[indexField.getFieldIndex()];
        }
        doc.add((IndexableField)new SortedDocValuesField(UNIQUE_FIELD, new BytesRef((CharSequence)this.uniqueFieldValue)));
        doc.add((IndexableField)new StringField(UNIQUE_FIELD, this.uniqueFieldValue, Field.Store.YES));
        return doc;
    }

    protected static Document getLucDocument(String[] actualColStr, ArrayList<DRIndexField> lucArchFieldList) throws Exception {
        Document doc = null;
        doc = new Document();
        for (DRIndexField field : lucArchFieldList) {
            String fieldDataType = field.getDataType();
            String fieldVal = actualColStr[field.getFieldIndex()];
            if (fieldVal != null && !fieldVal.trim().isEmpty() && !fieldVal.equals(DEFAULT_STATUS)) {
                DRFieldDataType drFieldType = DRFieldDataType.get((String)fieldDataType);
                List lucFields = drFieldType.createFields(field.getFieldName(), (Object)fieldVal, true, field.hasDocValue(), true, field.getAnalyzer().name());
                for (Field lucField : lucFields) {
                    doc.add((IndexableField)lucField);
                }
                continue;
            }
            if (!field.isNotNull()) continue;
            throw new Exception("NOT NULL constraint failed for field " + field.getFieldName() + "!");
        }
        return doc;
    }

    protected static String[] fillMissingCols(String[] lineVals, int totalCols) {
        int i;
        String[] aColStr = lineVals;
        String[] rColStr = new String[totalCols];
        int actualColLen = aColStr.length;
        int indexLen = totalCols;
        if (actualColLen < totalCols) {
            indexLen = actualColLen;
        }
        for (i = 0; i < indexLen; ++i) {
            rColStr[i] = aColStr[i] == null || aColStr[i].isEmpty() ? "" : aColStr[i];
        }
        for (i = actualColLen; i < totalCols; ++i) {
            rColStr[i] = "";
        }
        return rColStr;
    }

    protected Charset getEncoding(String fileName) throws Exception {
        Charset guessedCharset = null;
        guessedCharset = CharsetToolkit.guessEncoding((File)new File(fileName), (int)4096);
        return guessedCharset;
    }

    protected abstract DRBlockState blockState(State var1);

    protected abstract DRBlockState currentBlockStateAction();

    protected abstract DRBlockState currentBlockStateFacade();

    public abstract boolean isOlderThan(int var1) throws Exception;

    public abstract void updateStateFile() throws Exception;

    public static interface State {
    }
}

