/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository;

import org.apache.lucene.index.IndexWriter;

public abstract class DRBlockState {
    private String stateText;

    public DRBlockState(String stateText) {
        this.stateText = stateText;
    }

    protected void init(DRBlockState oldState) throws Exception {
    }

    protected DRBlockState moveTo(DRBlockState newState) throws Exception {
        throw new UnsupportedOperationException("moveTo operation not supported for state : " + this.stateText + "!");
    }

    protected IndexWriter indexWriter() throws Exception {
        throw new UnsupportedOperationException("getIndexWriter operation not supported for state : " + this.stateText + "!");
    }

    protected void commitIndexWriter() throws Exception {
        throw new UnsupportedOperationException("commitIndexWriter operation not supported for state : " + this.stateText + "!");
    }

    protected void closeIndexWriter() throws Exception {
        throw new UnsupportedOperationException("closeIndexWriter operation not supported for state : " + this.stateText + "!");
    }

    protected int docCount() throws Exception {
        throw new UnsupportedOperationException("docCount operation not supported for state : " + this.stateText + "!");
    }

    protected void mergeIndex() throws Exception {
        throw new UnsupportedOperationException("merge operation not supported for state : " + this.stateText + "!");
    }

    protected abstract void beforeExit(DRBlockState var1) throws Exception;

    protected abstract void afterExit(DRBlockState var1) throws Exception;

    protected abstract String blockPath();

    public boolean equals(Object stateType) {
        if (stateType instanceof DRBlockState) {
            return this.stateText.equalsIgnoreCase(((DRBlockState)stateType).stateText);
        }
        return false;
    }

    public int hashCode() {
        return this.stateText == null ? 0 : this.stateText.hashCode();
    }

    public String toString() {
        return this.stateText;
    }
}

