/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository;

import com.manageengine.dataengine.xnode.bootstrap.Environment;
import com.manageengine.dataengine.xnode.datarepository.DRBlock;
import com.manageengine.dataengine.xnode.datarepository.DataRepository;
import com.manageengine.dataengine.xnode.datarepository.MetaFileType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import org.json.JSONArray;
import org.json.JSONObject;

public class DRPersistenceHandler {
    private DataRepository dataRepository;
    private String mainTableName;
    private String archiveTableName;
    private static final Logger LOGGER = LogManager.getLogger((String)"DataRepository");

    protected DRPersistenceHandler(DataRepository dataRepository) {
        this.dataRepository = dataRepository;
        this.mainTableName = dataRepository.repositoryName() + "_main";
        this.archiveTableName = dataRepository.repositoryName() + "_archive";
        this.mainTableName = this.mainTableName.replaceAll("-", "_");
        this.archiveTableName = this.archiveTableName.replaceAll("-", "_");
    }

    protected int getBlocksCount(Connection connection, MetaFileType metaFileType, long fromTime, long toTime, String searchText) throws Exception {
        int count = 0;
        JSONArray searchCriteriaValueList = new JSONArray();
        String[] searchArr = new String[]{};
        String query = "SELECT COUNT(*) AS COUNT FROM " + this.getTableName(metaFileType);
        boolean isTimeSet = false;
        boolean isSearchSet = false;
        if (!(fromTime == -1L && toTime == -1L || fromTime == 0L && toTime == 0L)) {
            query = query + " WHERE ((NOT (range_from<? AND range_to<?)) AND (NOT (range_from>? AND range_to>?)))";
            isTimeSet = true;
        }
        if (searchText != null && !searchText.isEmpty()) {
            JSONObject temp = this.setSearchCriteria(query, searchText);
            query = temp.optString("query");
            searchCriteriaValueList = temp.getJSONArray("searchCriteriaValueList");
        }
        if (metaFileType == MetaFileType.ARCHIVE) {
            query = query + (query.contains("WHERE") ? " AND state != 'DELETED'" : " WHERE state != 'DELETED'");
        }
        try (PreparedStatement preparedStatement = connection.prepareStatement(query);){
            int psArgCount = 1;
            if (isTimeSet) {
                preparedStatement.setLong(psArgCount++, fromTime);
                preparedStatement.setLong(psArgCount++, fromTime);
                preparedStatement.setLong(psArgCount++, toTime);
                preparedStatement.setLong(psArgCount++, toTime);
            }
            if (searchCriteriaValueList.length() > 0) {
                for (int i = 0; i < searchCriteriaValueList.length(); ++i) {
                    preparedStatement.setString(psArgCount++, searchCriteriaValueList.optString(i).replace("'", ""));
                }
            }
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    count = resultSet.getInt("COUNT");
                }
            }
        }
        return count;
    }

    protected JSONArray readFromMetaFile(Connection connection, MetaFileType metaFileType, long fromTime, long toTime, int size, int offset, String sortField, String sortOrder, String searchText) throws Exception {
        JSONObject blockObj = null;
        JSONArray blockList = new JSONArray();
        JSONArray searchCriteriaValueList = new JSONArray();
        String[] searchArr = new String[]{};
        boolean isTimeSet = false;
        boolean isSearchSet = false;
        boolean isSizeSet = false;
        String query = "SELECT * FROM " + this.getTableName(metaFileType);
        if (!(fromTime == -1L && toTime == -1L || fromTime == 0L && toTime == 0L)) {
            query = query + " WHERE ((NOT (range_from<? AND range_to<?)) AND (NOT (range_from>? AND range_to>?)))";
            isTimeSet = true;
        }
        if (searchText != null && !searchText.isEmpty()) {
            JSONObject temp = this.setSearchCriteria(query, searchText);
            query = temp.optString("query");
            searchCriteriaValueList = temp.getJSONArray("searchCriteriaValueList");
        }
        if (metaFileType == MetaFileType.ARCHIVE) {
            query = query + (query.contains("WHERE") ? " AND state != 'DELETED'" : " WHERE state != 'DELETED'");
        }
        if (sortField != null && !sortField.isEmpty() && sortOrder != null && !sortOrder.isEmpty() && this.sortOrderCheck(sortOrder) && this.sortColumnCheck(sortField)) {
            query = query + " ORDER BY " + sortField + " " + sortOrder;
        }
        if (size != 0) {
            query = query + " LIMIT ? OFFSET ?";
            isSizeSet = true;
        }
        try (PreparedStatement preparedStatement = connection.prepareStatement(query);){
            int psArgCount = 1;
            if (isTimeSet) {
                preparedStatement.setLong(psArgCount++, fromTime);
                preparedStatement.setLong(psArgCount++, fromTime);
                preparedStatement.setLong(psArgCount++, toTime);
                preparedStatement.setLong(psArgCount++, toTime);
            }
            if (searchCriteriaValueList.length() > 0) {
                for (int i = 0; i < searchCriteriaValueList.length(); ++i) {
                    preparedStatement.setString(psArgCount++, searchCriteriaValueList.optString(i).replace("'", ""));
                }
            }
            if (isSizeSet) {
                preparedStatement.setInt(psArgCount++, size);
                preparedStatement.setInt(psArgCount++, offset);
            }
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    blockObj = new JSONObject();
                    blockObj.put("version", resultSet.getInt("version"));
                    blockObj.put("block_name", (Object)resultSet.getString("block_name"));
                    blockObj.put("datarepository_name", (Object)resultSet.getString("datarepository_name"));
                    blockObj.put("creation_time", resultSet.getLong("creation_time"));
                    blockObj.put("state", (Object)resultSet.getString("state"));
                    blockObj.put("status", (Object)resultSet.getString("status"));
                    blockObj.put("range_from", resultSet.getLong("range_from"));
                    blockObj.put("range_to", resultSet.getLong("range_to"));
                    blockObj.put("doc_count", resultSet.getInt("doc_count"));
                    blockObj.put("zip_password", (Object)resultSet.getString("zip_password"));
                    blockObj.put("is_merged", resultSet.getBoolean("is_merged"));
                    blockObj.put("size", resultSet.getLong("size"));
                    if (MetaFileType.ARCHIVE == metaFileType) {
                        blockObj.put("raw_size", resultSet.getLong("cold_size") + resultSet.getLong("raw_size"));
                    } else {
                        blockObj.put("raw_size", resultSet.getLong("raw_size"));
                    }
                    blockList.put((Object)blockObj);
                }
            }
        }
        return blockList;
    }

    protected JSONObject readFromMetaFile(Connection connection, MetaFileType metaFileType, String blockName) throws Exception {
        JSONObject blockObj = null;
        String query = "SELECT * FROM " + this.getTableName(metaFileType) + " WHERE " + "block_name" + "=?";
        if (metaFileType == MetaFileType.ARCHIVE) {
            query = query + (query.contains("WHERE") ? " AND state != 'DELETED'" : " WHERE state != 'DELETED'");
        }
        try (PreparedStatement preparedStatement = connection.prepareStatement(query);){
            int psArgCount = 1;
            preparedStatement.setString(psArgCount++, blockName);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    blockObj = this.readFromMetaFile(resultSet, metaFileType);
                }
            }
        }
        return blockObj;
    }

    protected JSONArray readFromMetaFile(Connection connection, MetaFileType metaFileType, Integer offset, Integer limit) throws Exception {
        JSONArray resArr = new JSONArray();
        String query = "SELECT * FROM " + this.getTableName(metaFileType);
        if (metaFileType == MetaFileType.ARCHIVE) {
            query = query + (query.contains("WHERE") ? " AND state != 'DELETED'" : " WHERE state != 'DELETED'");
        }
        query = query + (offset == null ? "" : " OFFSET ?") + (limit == null ? "" : " LIMIT ?");
        try (PreparedStatement preparedStatement = connection.prepareStatement(query);){
            int psArgCount = 1;
            if (offset != null) {
                preparedStatement.setInt(psArgCount++, offset);
            }
            if (limit != null) {
                preparedStatement.setInt(psArgCount++, limit);
            }
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    resArr.put((Object)this.readFromMetaFile(resultSet, metaFileType));
                }
            }
        }
        return resArr;
    }

    protected JSONObject readFromMetaFile(ResultSet resultSet, MetaFileType metaFileType) throws Exception {
        JSONObject blockObj = new JSONObject();
        blockObj.put("block_id", resultSet.getInt("block_id"));
        blockObj.put("block_name", (Object)resultSet.getString("block_name"));
        blockObj.put("version", resultSet.getInt("version"));
        blockObj.put("datarepository_name", (Object)resultSet.getString("datarepository_name"));
        blockObj.put("creation_time", resultSet.getLong("creation_time"));
        blockObj.put("state", (Object)resultSet.getString("state"));
        blockObj.put("status", (Object)resultSet.getString("status"));
        blockObj.put("range_from", resultSet.getLong("range_from"));
        blockObj.put("range_to", resultSet.getLong("range_to"));
        blockObj.put("doc_count", resultSet.getInt("doc_count"));
        blockObj.put("zip_password", (Object)resultSet.getString("zip_password"));
        blockObj.put("is_merged", (Object)resultSet.getString("is_merged"));
        blockObj.put("size", resultSet.getLong("size"));
        if (MetaFileType.ARCHIVE == metaFileType) {
            long coldSize = 0L;
            try {
                coldSize = resultSet.getLong("cold_size");
            }
            catch (SQLException e) {
                LOGGER.info("Cold size column yet to be updated in DB");
            }
            blockObj.put("raw_size", coldSize + resultSet.getLong("raw_size"));
            blockObj.put("cold_size", coldSize);
        } else {
            blockObj.put("raw_size", resultSet.getLong("raw_size"));
        }
        return blockObj;
    }

    protected void addToMetaFile(Connection connection, DRBlock block, MetaFileType metaFileType) throws Exception {
        String query = "INSERT INTO " + this.getTableName(metaFileType) + "(" + "block_name" + "," + "version" + "," + "datarepository_name" + "," + "creation_time" + "," + "state" + "," + "status" + "," + "range_from" + "," + "range_to" + "," + "doc_count" + "," + "zip_password" + "," + "is_merged" + "," + "size" + (metaFileType == MetaFileType.ARCHIVE ? ",cold_size," : ",") + "raw_size" + ") VALUES (?,?,?,?,?,?,?,?,?,?,?,?," + (metaFileType == MetaFileType.ARCHIVE ? "?," : "") + "?)";
        try (PreparedStatement preparedStatement = connection.prepareStatement(query);){
            int psArgCount = 1;
            preparedStatement.setString(psArgCount++, block.blockName() == null ? null : "" + block.blockName() + "");
            preparedStatement.setInt(psArgCount++, block.version());
            preparedStatement.setString(psArgCount++, this.dataRepository.repositoryName() == null ? null : "" + this.dataRepository.repositoryName() + "");
            preparedStatement.setLong(psArgCount++, block.creationTime());
            preparedStatement.setString(psArgCount++, block.currentBlockStateAction() == null ? null : "" + block.currentBlockStateAction() + "");
            preparedStatement.setString(psArgCount++, block.status() == null ? null : "" + block.status() + "");
            preparedStatement.setLong(psArgCount++, block.rangeFrom());
            preparedStatement.setLong(psArgCount++, block.rangeTo());
            preparedStatement.setInt(psArgCount++, block.docCount());
            preparedStatement.setString(psArgCount++, block.encryptedZipPassword() == null ? null : "" + block.encryptedZipPassword() + "");
            preparedStatement.setBoolean(psArgCount++, block.isMerged());
            preparedStatement.setLong(psArgCount++, block.size());
            if (metaFileType == MetaFileType.ARCHIVE) {
                preparedStatement.setLong(psArgCount++, block.coldSize());
            }
            preparedStatement.setLong(psArgCount++, block.rawSize());
            preparedStatement.executeUpdate();
            connection.commit();
        }
    }

    protected void addToMetaFile(Connection connection, JSONArray blockList, MetaFileType metaFileType) throws Exception {
        String queryPrefix = "INSERT INTO " + this.getTableName(metaFileType) + "(" + "block_name" + "," + "version" + "," + "datarepository_name" + "," + "creation_time" + "," + "state" + "," + "status" + "," + "range_from" + "," + "range_to" + "," + "doc_count" + "," + "zip_password" + "," + "is_merged" + "," + "size" + (MetaFileType.ARCHIVE == metaFileType ? ",cold_size," : ",") + "raw_size" + ") VALUES (";
        int listSize = blockList.length();
        for (int i = 0; i < listSize; ++i) {
            JSONObject block = blockList.getJSONObject(i);
            String query = queryPrefix + "?,?,?,?,?,?,?,?,?,?,?,?," + (metaFileType == MetaFileType.ARCHIVE ? "?," : "") + "?)";
            try (PreparedStatement preparedStatement = connection.prepareStatement(query);){
                int psArgCount = 1;
                preparedStatement.setString(psArgCount++, block.getString("block_name") == null ? null : "" + block.getString("block_name") + "");
                preparedStatement.setInt(psArgCount++, block.optInt("version", 10));
                preparedStatement.setString(psArgCount++, block.optString("datarepository_name", this.dataRepository.repositoryName()));
                preparedStatement.setLong(psArgCount++, block.optLong("creation_time", 0L));
                preparedStatement.setString(psArgCount++, block.getString("state") == null ? null : "" + block.getString("state") + "");
                preparedStatement.setString(psArgCount++, block.getString("status") == null ? null : "" + block.getString("status") + "");
                preparedStatement.setLong(psArgCount++, block.getLong("range_from"));
                preparedStatement.setLong(psArgCount++, block.getLong("range_to"));
                preparedStatement.setLong(psArgCount++, block.optLong("doc_count", 0L));
                preparedStatement.setString(psArgCount++, block.optString("zip_password", null) == null ? null : "" + block.optString("zip_password") + "");
                preparedStatement.setBoolean(psArgCount++, block.optBoolean("is_merged", false));
                preparedStatement.setLong(psArgCount++, block.optLong("size", 0L));
                if (metaFileType == MetaFileType.ARCHIVE) {
                    preparedStatement.setLong(psArgCount++, block.optLong("cold_size", 0L));
                }
                preparedStatement.setLong(psArgCount++, block.optLong("raw_size", 0L));
                preparedStatement.executeUpdate();
                continue;
            }
        }
        connection.commit();
    }

    protected void updateToMetaFile(Connection connection, DRBlock block, MetaFileType metaFileType) throws Exception {
        String query = "UPDATE " + this.getTableName(metaFileType) + " SET " + "version" + "=?," + "creation_time" + "=?," + "state" + "=?," + "status" + "=?," + "range_from" + "=?," + "range_to" + "=?," + "doc_count" + "=?," + "zip_password" + "=?," + "is_merged" + "=?," + "size" + "=?," + (MetaFileType.ARCHIVE == metaFileType ? "cold_size=?," : "") + "raw_size" + "=? WHERE " + "block_name" + "=?";
        try (PreparedStatement preparedStatement = connection.prepareStatement(query);){
            int psArgCount = 1;
            preparedStatement.setInt(psArgCount++, block.version());
            preparedStatement.setLong(psArgCount++, block.creationTime());
            preparedStatement.setString(psArgCount++, block.currentBlockStateAction() == null ? null : "" + block.currentBlockStateAction() + "");
            preparedStatement.setString(psArgCount++, block.status() == null ? null : "" + block.status() + "");
            preparedStatement.setLong(psArgCount++, block.rangeFrom());
            preparedStatement.setLong(psArgCount++, block.rangeTo());
            preparedStatement.setInt(psArgCount++, block.docCount());
            preparedStatement.setString(psArgCount++, block.encryptedZipPassword() == null ? null : "" + block.encryptedZipPassword() + "");
            preparedStatement.setBoolean(psArgCount++, block.isMerged());
            preparedStatement.setLong(psArgCount++, block.size());
            if (MetaFileType.ARCHIVE == metaFileType) {
                preparedStatement.setLong(psArgCount++, block.coldSize());
            }
            preparedStatement.setLong(psArgCount++, block.rawSize());
            preparedStatement.setString(psArgCount++, block.blockName());
            preparedStatement.executeUpdate();
            connection.commit();
        }
    }

    protected void deleteFromMetaFile(Connection connection, String blockName, MetaFileType metaFileType) throws Exception {
        String query = "DELETE FROM " + this.getTableName(metaFileType) + " WHERE " + "block_name" + "=?";
        try (PreparedStatement preparedStatement = connection.prepareStatement(query);){
            int psArgCount = 1;
            preparedStatement.setString(psArgCount++, blockName);
            preparedStatement.executeUpdate();
            connection.commit();
        }
    }

    protected void deleteFromMetaFile(Connection connection, DRBlock block, MetaFileType metaFileType) throws Exception {
        this.deleteFromMetaFile(connection, block.blockName(), metaFileType);
    }

    private String getTableName(MetaFileType fileType) {
        switch (fileType) {
            case MAIN: {
                return this.mainTableName;
            }
            case ARCHIVE: {
                return this.archiveTableName;
            }
        }
        return " ";
    }

    protected boolean checkIfMetaFileExists(Connection connection, MetaFileType metaType) throws Exception {
        boolean tableExists = false;
        String tableName = this.getTableName(metaType);
        try (ResultSet rs = connection.getMetaData().getTables(null, null, null, new String[]{"TABLE"});){
            while (rs.next()) {
                String tName = rs.getString("TABLE_NAME");
                if (tName == null || !tName.equalsIgnoreCase(tableName)) continue;
                tableExists = true;
                break;
            }
        }
        return tableExists;
    }

    protected void createMetaFile(Connection connection, MetaFileType metaFileType) throws Exception {
        String fieldSeparator = "\t";
        String fieldSeparatorWithEscape = "\\t";
        String tableName = this.getTableName(metaFileType);
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("CREATE TEXT TABLE " + tableName + "(");
        strBuilder.append("block_id INTEGER NOT NULL PRIMARY KEY GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),");
        strBuilder.append("block_name VARCHAR(100) NOT NULL,");
        strBuilder.append("version INTEGER,");
        strBuilder.append("datarepository_name VARCHAR(100) NOT NULL,");
        strBuilder.append("creation_time BIGINT,");
        strBuilder.append("state VARCHAR(50),");
        strBuilder.append("status VARCHAR(250),");
        strBuilder.append("range_from BIGINT,");
        strBuilder.append("range_to BIGINT,");
        strBuilder.append("doc_count INTEGER,");
        strBuilder.append("zip_password VARCHAR(100),");
        strBuilder.append("is_merged BOOLEAN,");
        strBuilder.append("size BIGINT,");
        strBuilder.append("raw_size BIGINT");
        if (metaFileType == MetaFileType.ARCHIVE) {
            strBuilder.append(",cold_size BIGINT)");
        } else {
            strBuilder.append(")");
        }
        StringBuilder header = new StringBuilder();
        header.append("\"block_id" + fieldSeparator);
        header.append("block_name" + fieldSeparator);
        header.append("version" + fieldSeparator);
        header.append("datarepository_name" + fieldSeparator);
        header.append("creation_time" + fieldSeparator);
        header.append("state" + fieldSeparator);
        header.append("status" + fieldSeparator);
        header.append("range_from" + fieldSeparator);
        header.append("range_to" + fieldSeparator);
        header.append("doc_count" + fieldSeparator);
        header.append("zip_password" + fieldSeparator);
        header.append("is_merged" + fieldSeparator);
        header.append("size" + fieldSeparator);
        header.append("raw_size" + fieldSeparator);
        if (metaFileType == MetaFileType.ARCHIVE) {
            header.append("cold_size" + fieldSeparator + "\"");
        } else {
            header.append("\"");
        }
        try (PreparedStatement preparedStatement = connection.prepareStatement(strBuilder.toString());){
            preparedStatement.execute();
        }
        String query = "SET TABLE " + tableName + " SOURCE \"" + tableName + ".meta;encoding=UTF-8;cache_rows=1;cache_size=1;ignore_first=true;fs=\\t\"";
        try (PreparedStatement preparedStatement = connection.prepareStatement(query);){
            preparedStatement.execute();
        }
        query = "SET TABLE " + tableName + " SOURCE HEADER " + header.toString();
        preparedStatement = connection.prepareStatement(query);
        var10_12 = null;
        try {
            preparedStatement.execute();
            connection.commit();
        }
        catch (Throwable throwable) {
            var10_12 = throwable;
            throw throwable;
        }
        finally {
            if (preparedStatement != null) {
                if (var10_12 != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (Throwable throwable) {
                        var10_12.addSuppressed(throwable);
                    }
                } else {
                    preparedStatement.close();
                }
            }
        }
    }

    protected void dropMetaFile(Connection connection, MetaFileType metaFileType) throws Exception {
        String tableName = this.getTableName(metaFileType);
        String query = "SET TABLE " + tableName + " SOURCE OFF";
        try (PreparedStatement preparedStatement = connection.prepareStatement(query);){
            preparedStatement.execute();
            connection.commit();
        }
        String query2 = "DROP TABLE " + tableName;
        try (PreparedStatement preparedStatement = connection.prepareStatement(query2);){
            preparedStatement.execute();
            connection.commit();
        }
    }

    protected void removeDuplicateArchiveEntries(Connection connection) throws Exception {
        String query = "DELETE FROM " + this.archiveTableName + " WHERE " + "block_id" + " NOT IN (SELECT MIN(" + "block_id" + ") FROM " + this.archiveTableName + " GROUP BY (" + "block_name" + "))";
        try (PreparedStatement preparedStatement = connection.prepareStatement(query);){
            preparedStatement.executeUpdate();
            connection.commit();
        }
    }

    protected void deleteMetaFile(MetaFileType metaFileType) throws Exception {
        String tableName = this.getTableName(metaFileType);
        File srcFile = new File(Environment.XNODE_DB_DIR.value() + File.separator + (String)Environment.XNODE_DB_STORE_DBNAME.value() + File.separator + tableName + ".meta");
        if (srcFile.exists()) {
            if (FileUtils.deleteQuietly((File)srcFile)) {
                LOGGER.info("MetaFile '" + srcFile.getName() + "' has been deleted!");
            } else {
                LOGGER.info("Unable to delete MetaFile '" + srcFile.getName() + "'!");
            }
        }
    }

    public JSONArray getBlocksToMarkForDelete(Connection connection, int retentionDays, MetaFileType metaFileType, boolean isStage1) throws Exception {
        JSONObject blockObj = null;
        JSONArray blockList = new JSONArray();
        long retentionThreshInSecs = DateTime.now().minusDays(retentionDays).getMillis() / 1000L;
        String query = "SELECT * FROM " + this.getTableName(metaFileType) + " WHERE (" + "version" + "=? ";
        if (!isStage1) {
            query = query + " OR version=? ";
        }
        query = query + ") AND range_to <? AND state IN ('FROZEN', 'COLD')";
        try (PreparedStatement preparedStatement = connection.prepareStatement(query);){
            int psArgCount = 1;
            if (isStage1) {
                preparedStatement.setLong(psArgCount++, 11L);
            } else {
                preparedStatement.setLong(psArgCount++, 10L);
                preparedStatement.setLong(psArgCount++, 1L);
            }
            preparedStatement.setLong(psArgCount++, retentionThreshInSecs);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    blockObj = this.readFromMetaFile(resultSet, metaFileType);
                    blockList.put((Object)blockObj);
                }
            }
        }
        return blockList;
    }

    public JSONArray getBlocksToPurge(Connection connection, int graceDays, boolean isMain) throws Exception {
        JSONObject blockObj = null;
        JSONArray blockList = new JSONArray();
        long graceThreshMillis = DateTime.now().minusDays(graceDays).getMillis();
        String statusCrit = isMain ? "MAIN_MARK_FOR_DELETION" : "FROZEN_MARK_FOR_DELETION";
        String query = "SELECT * FROM " + this.archiveTableName + " WHERE (" + "status" + "=? AND " + "state" + " = " + "'DELETED'" + ") AND " + "creation_time" + " <?";
        try (PreparedStatement preparedStatement = connection.prepareStatement(query);){
            int psArgCount = 1;
            preparedStatement.setString(psArgCount++, statusCrit);
            preparedStatement.setLong(psArgCount++, graceThreshMillis);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    blockObj = this.readFromMetaFile(resultSet, MetaFileType.ARCHIVE);
                    blockList.put((Object)blockObj);
                }
            }
        }
        return blockList;
    }

    public JSONArray getToBeDeletedBlocks(Connection connection, long startTime, long endTime, long threshMillis, long defrostMillis, MetaFileType metaFileType, String searchText) throws Exception {
        JSONObject blockObj = null;
        JSONArray blockList = new JSONArray();
        JSONArray searchCriteriaValueList = new JSONArray();
        long retentionThreshInSecs = endTime - threshMillis;
        long negatedDefrostRetention = (endTime - defrostMillis) * 1000L;
        String tableName = this.getTableName(metaFileType);
        String query = "SELECT * FROM " + tableName + " WHERE " + "range_to" + " <=? ";
        query = metaFileType == MetaFileType.ARCHIVE ? query + " AND ((state = 'FROZEN') OR (state = 'DEFROST' AND creation_time <=? ))" : query + "AND state != 'HOT'";
        if (searchText != null && !searchText.isEmpty()) {
            JSONObject temp = this.setSearchCriteria(query, searchText);
            query = temp.optString("query");
            searchCriteriaValueList = temp.getJSONArray("searchCriteriaValueList");
        }
        try (PreparedStatement preparedStatement = connection.prepareStatement(query);){
            int psArgCount = 1;
            preparedStatement.setLong(psArgCount++, retentionThreshInSecs);
            if (metaFileType == MetaFileType.ARCHIVE) {
                preparedStatement.setLong(psArgCount++, negatedDefrostRetention);
            }
            if (searchCriteriaValueList.length() > 0) {
                for (int i = 0; i < searchCriteriaValueList.length(); ++i) {
                    preparedStatement.setString(psArgCount++, searchCriteriaValueList.optString(i).replace("'", ""));
                }
            }
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    long scheduledDelTime = resultSet.getLong("range_to") + threshMillis;
                    String blockState = resultSet.getString("state");
                    long scheduledUnloadTime = resultSet.getLong("creation_time") / 1000L + defrostMillis;
                    if (scheduledDelTime < startTime && System.currentTimeMillis() / 1000L > scheduledDelTime) {
                        scheduledDelTime = startTime;
                    }
                    if (metaFileType == MetaFileType.ARCHIVE && blockState.equalsIgnoreCase("DEFROST") && scheduledDelTime <= scheduledUnloadTime) {
                        scheduledDelTime = scheduledUnloadTime + 86400L;
                    }
                    if (scheduledDelTime < startTime || scheduledDelTime > endTime) continue;
                    blockObj = new JSONObject();
                    blockObj.put("block_name", (Object)resultSet.getString("block_name"));
                    blockObj.put("creation_time", resultSet.getLong("creation_time"));
                    blockObj.put("range_from", resultSet.getLong("range_from"));
                    blockObj.put("range_to", resultSet.getLong("range_to"));
                    if (MetaFileType.ARCHIVE == metaFileType) {
                        blockObj.put("size", resultSet.getLong("raw_size"));
                    } else {
                        blockObj.put("size", resultSet.getLong("size"));
                    }
                    blockObj.put("deleted_time", scheduledDelTime);
                    blockList.put((Object)blockObj);
                }
            }
        }
        return blockList;
    }

    public long readColdBlocksSizeFromMetaFile(Connection connection, MetaFileType metaFileType) throws Exception {
        long size;
        block27: {
            size = 0L;
            String query = "SELECT SUM(cold_size) AS cold_size FROM " + this.getTableName(metaFileType) + " WHERE " + "state" + " != " + "'DELETED'";
            try (PreparedStatement preparedStatement = connection.prepareStatement(query);
                 ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    size = resultSet.getLong("cold_size");
                }
            }
            catch (Exception e) {
                if (!e.getMessage().contains("COLD_SIZE")) break block27;
                LOGGER.info("Cold size column yet to be updated in DB");
            }
        }
        return size;
    }

    public long readFrozenBlocksSizeFromMetaFile(Connection connection, MetaFileType metaFileType) throws Exception {
        long size = 0L;
        String query = "SELECT SUM(raw_size) AS raw_size FROM " + this.getTableName(metaFileType) + " WHERE " + "state" + " != " + "'DELETED'";
        try (PreparedStatement preparedStatement = connection.prepareStatement(query);){
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    size = resultSet.getLong("raw_size");
                }
            }
            catch (NullPointerException | SQLException ex) {
                LOGGER.info("DEBUG :: " + preparedStatement);
                LOGGER.info("DEBUG :: " + this.getTableName(metaFileType));
                throw ex;
            }
        }
        return size;
    }

    public long readLiveBlocksSizeFromMetaFile(Connection connection, MetaFileType metaFileType, String searchText) throws Exception {
        JSONArray searchCriteriaValueList = new JSONArray();
        long size = 0L;
        String query = "SELECT SUM(size) AS size FROM " + this.getTableName(metaFileType);
        if (searchText != null && !searchText.isEmpty()) {
            JSONObject temp = this.setSearchCriteria(query, searchText);
            query = temp.optString("query");
            searchCriteriaValueList = temp.getJSONArray("searchCriteriaValueList");
        }
        try (PreparedStatement preparedStatement = connection.prepareStatement(query);){
            int psArgCount = 1;
            if (searchCriteriaValueList.length() > 0) {
                for (int i = 0; i < searchCriteriaValueList.length(); ++i) {
                    preparedStatement.setString(psArgCount++, searchCriteriaValueList.optString(i).replace("'", ""));
                }
            }
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    size = resultSet.getLong("size");
                }
            }
        }
        return size;
    }

    protected JSONArray getDeletedBlocks(Connection connection, long fromTime, long toTime, int size, int offset, String sortField, String sortOrder, String searchText) throws Exception {
        JSONObject blockObj = null;
        JSONArray blockList = new JSONArray();
        JSONArray searchCriteriaValueList = new JSONArray();
        boolean isTimeSet = false;
        boolean isSizeSet = false;
        String query = "SELECT * FROM " + this.getTableName(MetaFileType.ARCHIVE);
        if (!(fromTime == -1L && toTime == -1L || fromTime == 0L && toTime == 0L)) {
            query = query + " WHERE ((NOT (range_from<? AND range_to<?)) AND (NOT (range_from>? AND range_to>?)))";
            isTimeSet = true;
        }
        query = query + (query.contains("WHERE") ? " AND state='DELETED'" : " WHERE state='DELETED'");
        if (searchText != null && !searchText.isEmpty()) {
            JSONObject temp = this.setSearchCriteria(query, searchText);
            query = temp.optString("query");
            searchCriteriaValueList = temp.getJSONArray("searchCriteriaValueList");
        }
        if (sortField != null && !sortField.isEmpty() && sortOrder != null && !sortOrder.isEmpty() && this.sortOrderCheck(sortOrder) && this.sortColumnCheck(sortField)) {
            query = query + " ORDER BY " + sortField + " " + sortOrder;
        }
        if (size != 0) {
            query = query + " LIMIT ? OFFSET ?";
            isSizeSet = true;
        }
        try (PreparedStatement preparedStatement = connection.prepareStatement(query);){
            int psArgCount = 1;
            if (isTimeSet) {
                preparedStatement.setLong(psArgCount++, fromTime);
                preparedStatement.setLong(psArgCount++, fromTime);
                preparedStatement.setLong(psArgCount++, toTime);
                preparedStatement.setLong(psArgCount++, toTime);
            }
            if (searchCriteriaValueList.length() > 0) {
                for (int i = 0; i < searchCriteriaValueList.length(); ++i) {
                    preparedStatement.setString(psArgCount++, searchCriteriaValueList.optString(i).replace("'", ""));
                }
            }
            if (isSizeSet) {
                preparedStatement.setInt(psArgCount++, size);
                preparedStatement.setInt(psArgCount++, offset);
            }
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    blockObj = this.readFromMetaFile(resultSet, MetaFileType.ARCHIVE);
                    blockList.put((Object)blockObj);
                }
            }
        }
        return blockList;
    }

    private boolean sortOrderCheck(String sortOrder) {
        if (sortOrder.equalsIgnoreCase("ASC") || sortOrder.equalsIgnoreCase("DESC")) {
            return true;
        }
        LOGGER.info("Sort Order Check failed!");
        return false;
    }

    private boolean sortColumnCheck(String sortColumn) {
        String[] columns = new String[]{"range_from", "range_to", "block_name", "size", "raw_size", "state"};
        for (int i = 0; i < columns.length; ++i) {
            if (!sortColumn.equalsIgnoreCase(columns[i])) continue;
            return true;
        }
        LOGGER.info("Sort Column Check failed!");
        return false;
    }

    private String setSearchText(String query, String searchText, String splitBy) {
        String[] searchArr = searchText.split(splitBy);
        query = query + searchArr[0] + " like ?";
        return query;
    }

    private String addSearchCriteriaValue(String searchText, String splitBy) {
        String[] searchArr = searchText.split(splitBy);
        return searchArr[1];
    }

    private JSONObject setSearchCriteria(String query, String searchText) {
        JSONArray searchCriteriaValueList = new JSONArray();
        if (searchText.contains(" OR ") || searchText.contains(" AND ")) {
            String[] searchTextArr = null;
            String logicalOp = "";
            if (searchText.contains(" OR ")) {
                searchTextArr = searchText.split(" OR ");
                logicalOp = " OR ";
            } else if (searchText.contains(" AND ")) {
                searchTextArr = searchText.split(" AND ");
                logicalOp = " AND ";
            }
            if (searchTextArr != null && !logicalOp.equals("")) {
                query = query + (query.contains("WHERE") ? " AND ( " : " WHERE ( ");
                for (int i = 0; i < searchTextArr.length; ++i) {
                    if (searchTextArr[i].contains(" like ")) {
                        query = this.setSearchText(query, searchTextArr[i], " like ");
                        query = query + (i < searchTextArr.length - 1 ? logicalOp : "");
                        searchCriteriaValueList.put((Object)this.addSearchCriteriaValue(searchTextArr[i], " like "));
                        continue;
                    }
                    if (searchTextArr[i].contains(" LIKE ")) {
                        query = this.setSearchText(query, searchTextArr[i], " LIKE ");
                        query = query + (i < searchTextArr.length - 1 ? logicalOp : "");
                        searchCriteriaValueList.put((Object)this.addSearchCriteriaValue(searchTextArr[i], " LIKE "));
                        continue;
                    }
                    LOGGER.info("Unable to Process Search Criteria " + searchText + "!");
                }
                query = query + " )";
            }
        } else if (searchText.contains(" like ")) {
            query = query + (query.contains("WHERE") ? " AND " : " WHERE ");
            query = this.setSearchText(query, searchText, " like ");
            searchCriteriaValueList.put((Object)this.addSearchCriteriaValue(searchText, " like "));
        } else if (searchText.contains(" LIKE ")) {
            query = query + (query.contains("WHERE") ? " AND " : " WHERE ");
            query = this.setSearchText(query, searchText, " LIKE ");
            searchCriteriaValueList.put((Object)this.addSearchCriteriaValue(searchText, " LIKE "));
        } else {
            LOGGER.info("Unable to Process Search Criteria " + searchText + "!");
        }
        JSONObject result = new JSONObject();
        result.put("query", (Object)query);
        result.put("searchCriteriaValueList", (Object)searchCriteriaValueList);
        return result;
    }

    private void updateHeader(String drName, String columnaName) throws Exception {
        String metaFilePath = Environment.XNODE_DB_DIR.value() + File.separator + (String)Environment.XNODE_DB_STORE_DBNAME.value() + File.separator + drName + ".meta";
        FileWriter writer = null;
        BufferedReader bfr = null;
        boolean isHeader = true;
        StringBuilder oldContent = new StringBuilder();
        try {
            bfr = new BufferedReader(new FileReader(metaFilePath));
            String line = "";
            while ((line = bfr.readLine()) != null) {
                if (isHeader) {
                    String newHeader = line.concat("\t" + columnaName);
                    oldContent.append(newHeader).append(System.getProperty("line.separator"));
                    isHeader = false;
                    continue;
                }
                oldContent.append(line).append(System.getProperty("line.separator"));
            }
            writer = new FileWriter(metaFilePath);
            writer.write(oldContent.toString());
            writer.flush();
            LOGGER.info("Added Column " + columnaName + " in " + metaFilePath);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.info("Error when trying to update header column. Error is " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean addColumn(Connection connection, String columnName, String dataType, String defaultValue, MetaFileType metaFileType) {
        boolean isAddSuccess = true;
        String drName = this.getTableName(metaFileType);
        String setSourceQuery = "SET TABLE " + drName + " SOURCE ";
        try {
            String alterQuery = "ALTER TABLE " + drName + " ADD COLUMN " + columnName + " " + dataType + " DEFAULT " + defaultValue;
            try (PreparedStatement preparedStatement = connection.prepareStatement(setSourceQuery + "OFF");){
                preparedStatement.execute();
            }
            preparedStatement = connection.prepareStatement(alterQuery);
            var11_20 = null;
            try {
                preparedStatement.execute();
            }
            catch (Throwable throwable) {
                var11_20 = throwable;
                throw throwable;
            }
            finally {
                if (preparedStatement != null) {
                    if (var11_20 != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable) {
                            var11_20.addSuppressed(throwable);
                        }
                    } else {
                        preparedStatement.close();
                    }
                }
            }
            this.updateHeader(drName, columnName);
            return isAddSuccess;
        }
        catch (SQLSyntaxErrorException ex) {
            if (!ex.getMessage().contains("already exist") && !ex.getSQLState().equals("42504")) {
                ex.printStackTrace();
                isAddSuccess = false;
                return isAddSuccess;
            }
            isAddSuccess = true;
            return isAddSuccess;
        }
        catch (Exception e) {
            LOGGER.info("Error when adding metatable entry with column " + columnName);
            e.printStackTrace();
            isAddSuccess = false;
            return isAddSuccess;
        }
        finally {
            try (PreparedStatement preparedStatement = connection.prepareStatement(setSourceQuery + "ON");){
                preparedStatement.execute();
                connection.commit();
            }
            catch (Exception e) {
                LOGGER.info("Error when setting SOURCE to ON");
                e.printStackTrace();
            }
        }
    }

    public boolean updateColumn(Connection connection, String columnName, String value, MetaFileType metaFileType) {
        boolean isUpdateSuccess = true;
        String drName = this.getTableName(metaFileType);
        try {
            String updateCrit = " WHERE version > 0";
            String addedColUpdate = "UPDATE " + drName + " SET " + columnName + " = " + value + updateCrit;
            try (PreparedStatement preparedStatement = connection.prepareStatement(addedColUpdate);){
                preparedStatement.executeUpdate();
            }
            connection.commit();
        }
        catch (Exception e) {
            LOGGER.info("Error when updating metatable entry " + columnName + " with value " + value);
            e.printStackTrace();
            isUpdateSuccess = false;
        }
        return isUpdateSuccess;
    }
}

