/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository;

import com.manageengine.dataengine.commons.datarepository.DRFieldDataType;
import com.manageengine.dataengine.commons.datarepository.DRIndexField;
import com.manageengine.dataengine.xnode.datarepository.DataRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;

public class DRQueryParser
extends QueryParser {
    private DRFieldDataType fieldDataType;
    private List<DataRepository> dataRepositoryList;

    public DRQueryParser(String field, Analyzer analyzer, List<DataRepository> dataRepositoryList) {
        super(field, analyzer);
        this.dataRepositoryList = dataRepositoryList;
        this.setAllowLeadingWildcard(true);
    }

    private Collection<String> extractMultiFields(String field) {
        if (field == null) {
            List<String> fields = Collections.singletonList("*");
            return fields;
        }
        if (field.equals("*")) {
            HashSet<String> fieldSet = new HashSet<String>();
            for (DataRepository dataRepository : this.dataRepositoryList) {
                ArrayList<DRIndexField> fieldList = dataRepository.getIndexFields();
                for (DRIndexField DRIndexField2 : fieldList) {
                    fieldSet.add(DRIndexField2.getFieldName());
                }
            }
            return fieldSet;
        }
        String[] fieldArr = field.split(",");
        int len = fieldArr.length;
        ArrayList<String> fieldList = new ArrayList<String>();
        for (int i = 0; i < len; ++i) {
            if (fieldArr[i] == null || fieldArr[i].trim().isEmpty()) continue;
            fieldList.add(fieldArr[i].trim());
        }
        return this.convertAliasNameToActualName(fieldList);
    }

    private ArrayList<String> convertAliasNameToActualName(ArrayList<String> fieldList) {
        ArrayList<String> newFieldList = new ArrayList<String>();
        for (String fieldName : fieldList) {
            DataRepository dataRepository;
            DRIndexField drField = null;
            Iterator<DataRepository> iterator = this.dataRepositoryList.iterator();
            while (iterator.hasNext() && (drField = (dataRepository = iterator.next()).getIndexField(fieldName)) == null) {
            }
            if (drField == null) {
                throw new NoSuchElementException("IndexField for " + fieldName + " not found!");
            }
            newFieldList.add(drField.getFieldName());
        }
        return newFieldList;
    }

    private DRFieldDataType getFieldType(String fieldName) {
        DRFieldDataType drFieldType = null;
        for (DataRepository dataRepository : this.dataRepositoryList) {
            DRIndexField drField = dataRepository.getIndexField(fieldName);
            if (drField == null) continue;
            String fieldType = drField.getDataType();
            DRFieldDataType curDRrFieldType = DRFieldDataType.get((String)fieldType);
            if (drFieldType != null && drFieldType != curDRrFieldType) {
                throw new IllegalStateException("Found different datatypes[" + drFieldType + ", " + curDRrFieldType + "] for field - " + fieldName + "!");
            }
            drFieldType = curDRrFieldType;
        }
        return drFieldType;
    }

    protected Query getBooleanQuery(List<BooleanClause> clauses) throws ParseException {
        Query q = super.getBooleanQuery(clauses);
        if (q == null) {
            return null;
        }
        return this.fixNegativeQueryIfNeeded(q);
    }

    private boolean isNegativeQuery(Query q) {
        if (!(q instanceof BooleanQuery)) {
            return false;
        }
        List clauses = ((BooleanQuery)q).clauses();
        if (clauses.isEmpty()) {
            return false;
        }
        for (BooleanClause clause : clauses) {
            if (clause.isProhibited()) continue;
            return false;
        }
        return true;
    }

    public Query fixNegativeQueryIfNeeded(Query q) {
        if (this.isNegativeQuery(q)) {
            BooleanQuery bq = (BooleanQuery)q;
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            for (BooleanClause clause : bq) {
                builder.add(clause);
            }
            builder.add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.MUST);
            return builder.build();
        }
        return q;
    }

    public Query getFieldQuery(String field, String queryText, boolean quoted) throws ParseException {
        Collection<String> fields = this.extractMultiFields(field);
        if (fields != null) {
            if (fields.size() == 1) {
                return this.getFieldQuerySingle(fields.iterator().next(), queryText, quoted);
            }
            BooleanQuery.Builder booleanQueryBuilder = new BooleanQuery.Builder();
            int clausesCount = 0;
            for (String mField : fields) {
                Query q = this.getFieldQuerySingle(mField, queryText, quoted);
                if (q == null) continue;
                booleanQueryBuilder.add(new BooleanClause(q, BooleanClause.Occur.SHOULD));
                ++clausesCount;
            }
            if (clausesCount == 0) {
                return null;
            }
            return booleanQueryBuilder.build();
        }
        return this.getFieldQuerySingle(field, queryText, quoted);
    }

    private Query getFieldQuerySingle(String field, String queryText, boolean quoted) throws ParseException {
        if (!quoted && queryText.length() > 1) {
            if (queryText.charAt(0) == '>') {
                if (queryText.length() > 2 && queryText.charAt(1) == '=') {
                    return this.getRangeQuerySingle(field, queryText.substring(2), null, true, true);
                }
                return this.getRangeQuerySingle(field, queryText.substring(1), null, false, true);
            }
            if (queryText.charAt(0) == '<') {
                if (queryText.length() > 2 && queryText.charAt(1) == '=') {
                    return this.getRangeQuerySingle(field, null, queryText.substring(2), true, true);
                }
                return this.getRangeQuerySingle(field, null, queryText.substring(1), true, false);
            }
            if (queryText.length() > 2 && queryText.charAt(0) == '\\' && (queryText.charAt(1) == '>' || queryText.charAt(1) == '<')) {
                queryText = queryText.substring(1);
            }
        }
        this.fieldDataType = this.getFieldType(field);
        if (this.fieldDataType != null && !this.fieldDataType.isTokenized()) {
            return this.fieldDataType.termQuery(field, (Object)queryText);
        }
        return super.getFieldQuery(field, queryText, quoted);
    }

    protected Query getRangeQuery(String field, String part1, String part2, boolean startInclusive, boolean endInclusive) throws ParseException {
        Collection<String> fields;
        if ("*".equals(part1)) {
            part1 = null;
        }
        if ("*".equals(part2)) {
            part2 = null;
        }
        if ((fields = this.extractMultiFields(field)) == null) {
            return this.getRangeQuerySingle(field, part1, part2, startInclusive, endInclusive);
        }
        if (fields.size() == 1) {
            return this.getRangeQuerySingle(fields.iterator().next(), part1, part2, startInclusive, endInclusive);
        }
        BooleanQuery.Builder booleanQueryBuilder = new BooleanQuery.Builder();
        int clausesCount = 0;
        for (String mField : fields) {
            Query q = this.getRangeQuerySingle(mField, part1, part2, startInclusive, endInclusive);
            if (q == null) continue;
            booleanQueryBuilder.add(new BooleanClause(q, BooleanClause.Occur.SHOULD));
            ++clausesCount;
        }
        if (clausesCount == 0) {
            return null;
        }
        return booleanQueryBuilder.build();
    }

    private Query getRangeQuerySingle(String field, String part1, String part2, boolean startInclusive, boolean endInclusive) {
        this.fieldDataType = this.getFieldType(field);
        if (this.fieldDataType != null) {
            BytesRef part1Binary = part1 == null ? null : this.getAnalyzer().normalize(field, part1);
            BytesRef part2Binary = part2 == null ? null : this.getAnalyzer().normalize(field, part2);
            Query rangeQuery = this.fieldDataType.rangeQuery(field, (Object)part1Binary, (Object)part2Binary, startInclusive, endInclusive);
            return rangeQuery;
        }
        return this.newRangeQuery(field, part1, part2, startInclusive, endInclusive);
    }

    protected Query getWildcardQuery(String field, String termStr) throws ParseException {
        if (termStr.equals("*") && "*".equals(field)) {
            return this.newMatchAllDocsQuery();
        }
        Collection<String> fields = this.extractMultiFields(field);
        if (fields != null) {
            if (fields.size() == 1) {
                return this.getWildcardQuerySingle(fields.iterator().next(), termStr);
            }
            BooleanQuery.Builder booleanQueryBuilder = new BooleanQuery.Builder();
            boolean added = false;
            for (String mField : fields) {
                Query q = this.getWildcardQuerySingle(mField, termStr);
                if (q == null) continue;
                added = true;
                booleanQueryBuilder.add(new BooleanClause(q, BooleanClause.Occur.SHOULD));
            }
            if (!added) {
                return null;
            }
            return booleanQueryBuilder.build();
        }
        return this.getWildcardQuerySingle(field, termStr);
    }

    private Query getWildcardQuerySingle(String field, String termStr) throws ParseException {
        this.fieldDataType = this.getFieldType(field);
        if (this.fieldDataType != null && this.fieldDataType.isWhiteSpace()) {
            String[] terms = (termStr = termStr.replace("\\ ", " ").replace("*", "")).split(" ");
            if (terms.length == 1) {
                return super.getWildcardQuery(field, "*" + termStr + "*");
            }
            BooleanQuery.Builder booleanQueryBuilder = new BooleanQuery.Builder();
            for (String term : terms) {
                Query q = super.getWildcardQuery(field, "*" + term.trim() + "*");
                if (q == null) continue;
                booleanQueryBuilder.add(new BooleanClause(q, BooleanClause.Occur.MUST));
            }
            return booleanQueryBuilder.build();
        }
        return super.getWildcardQuery(field, termStr);
    }

    protected Query getPrefixQuery(String field, String termStr) throws ParseException {
        Collection<String> fields = this.extractMultiFields(field);
        if (fields != null) {
            if (fields.size() == 1) {
                return this.getPrefixQuerySingle(fields.iterator().next(), termStr);
            }
            BooleanQuery.Builder booleanQueryBuilder = new BooleanQuery.Builder();
            boolean added = false;
            for (String mField : fields) {
                Query q = this.getPrefixQuerySingle(mField, termStr);
                if (q == null) continue;
                added = true;
                booleanQueryBuilder.add(new BooleanClause(q, BooleanClause.Occur.SHOULD));
            }
            if (!added) {
                return null;
            }
            return booleanQueryBuilder.build();
        }
        return this.getPrefixQuerySingle(field, termStr);
    }

    private Query getPrefixQuerySingle(String field, String termStr) throws ParseException {
        return super.getPrefixQuery(field, termStr);
    }
}

