/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository;

import com.manageengine.dataengine.commons.datarepository.DRBlockRotationType;
import com.manageengine.dataengine.commons.datarepository.DRIndexField;
import com.manageengine.dataengine.commons.datarepository.DRSchema;
import com.manageengine.dataengine.commons.datarepository.DRType;
import com.manageengine.dataengine.commons.datarepository.XNodeDRConfFile;
import com.manageengine.dataengine.xnode.database.DBManager;
import com.manageengine.dataengine.xnode.datarepository.DRBlock;
import com.manageengine.dataengine.xnode.datarepository.DRPersistenceHandler;
import com.manageengine.dataengine.xnode.datarepository.DataRepositoryActionRequest;
import com.manageengine.dataengine.xnode.datarepository.DataRepositoryActions;
import com.manageengine.dataengine.xnode.datarepository.DataRepositoryManager;
import com.manageengine.dataengine.xnode.datarepository.MetaFileType;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.Sort;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class DataRepository
implements DataRepositoryActions {
    private String repositoryName;
    private String repositoryState;
    private String description;
    private DRType repositoryType;
    private String containerName;
    private boolean isLegacy;
    private String legacyTableName;
    private DRSchema schema;
    private boolean storeRawData;
    private boolean containsDuplicate;
    private String blockPrefix;
    private int hotBlockCount;
    private int hotBlockRefreshInterval;
    private DRBlockRotationType hotBlockRotationType;
    private int hotBlockRotationSize;
    private String hotBlockRotationPeriod;
    private int mainBlockRetentionDays;
    private int frozenBlockS1RetentionDays;
    private int frozenBlockRetentionDays;
    private int defrostBlockRetentionDays;
    private int graceBlockRetentionDays;
    private ArrayList<String> xnodes;
    private String defaultMainBlocksLocation;
    private String defaultArchiveBlocksLocation;
    private String currentArchiveBlocksLocation;
    private String defaultFrozenBlocksLocation;
    private String currentFrozenBlocksLocation;
    private String defaultDefrostBlocksLocation;
    private String mainBlocksMetaFile;
    private String archiveBlocksMetaFile;
    private DRPersistenceHandler persistenceHandler;
    private static final long SECONDS_IN_DAY = 86400L;
    private static final Logger LOGGER = LogManager.getLogger((String)"DataRepository");

    public DataRepository(XNodeDRConfFile.DataRepositoryBean drBean) throws Exception {
        if (drBean.repositoryName() == null || drBean.schemaName() == null) {
            throw new NullPointerException("Trying to initialize DataRepository with null parameters!");
        }
        this.repositoryName = drBean.repositoryName();
        this.repositoryState = drBean.repositoryState();
        this.description = drBean.description();
        this.repositoryType = DRType.get((String)drBean.repositoryType());
        this.containerName = drBean.containerName() == null ? "default-container" : drBean.containerName();
        this.isLegacy = drBean.isLegacy();
        this.legacyTableName = drBean.legacyTableName();
        this.schema = DataRepositoryManager.getDRSchema(drBean.schemaName());
        this.storeRawData = this.repositoryType == DRType.GENERIC ? false : drBean.storeRawData();
        this.blockPrefix = drBean.blockPrefix();
        this.hotBlockCount = drBean.blockMainHotCount() == null ? 1 : drBean.blockMainHotCount();
        this.hotBlockRefreshInterval = drBean.blockMainHotRefreshInterval() == null ? 0 : drBean.blockMainHotRefreshInterval();
        this.hotBlockRotationType = drBean.blockMainHotRotationType() == null ? DRBlockRotationType.SIZE : DRBlockRotationType.valueOf((String)drBean.blockMainHotRotationType());
        this.hotBlockRotationSize = drBean.blockMainHotRotationSize() == null ? 3000000 : drBean.blockMainHotRotationSize();
        this.hotBlockRotationPeriod = drBean.blockMainHotRotationPeriod();
        this.mainBlockRetentionDays = drBean.blockMainRetentionDays() == null ? 150 : drBean.blockMainRetentionDays();
        this.frozenBlockS1RetentionDays = drBean.blockFrozenS1RetentionDays() == null ? -1 : drBean.blockFrozenS1RetentionDays();
        this.frozenBlockRetentionDays = drBean.blockFrozenRetentionDays() == null ? 99999 : drBean.blockFrozenRetentionDays();
        this.defrostBlockRetentionDays = drBean.blockDefrostRetentionDays() == null ? 7 : drBean.blockDefrostRetentionDays();
        this.graceBlockRetentionDays = drBean.blockGraceRetentionDays() == null ? 20 : drBean.blockGraceRetentionDays();
        this.xnodes = drBean.nodes();
        this.defaultMainBlocksLocation = DataRepositoryManager.DE_MAIN_DATA_DIR + File.separator + this.containerName + File.separator + this.repositoryName + File.separator;
        this.currentArchiveBlocksLocation = this.defaultArchiveBlocksLocation = DataRepositoryManager.DE_ARCHIVE_DATA_DIR + File.separator + this.containerName + File.separator + this.repositoryName + File.separator;
        this.defaultFrozenBlocksLocation = this.defaultArchiveBlocksLocation + "frozen" + File.separator;
        this.currentFrozenBlocksLocation = this.currentArchiveBlocksLocation + File.separator + "frozen" + File.separator;
        this.defaultDefrostBlocksLocation = this.defaultArchiveBlocksLocation + "defrost" + File.separator;
        this.mainBlocksMetaFile = this.defaultMainBlocksLocation + "blocks.meta";
        this.archiveBlocksMetaFile = this.defaultArchiveBlocksLocation + "archive-blocks.meta";
        new File(this.defaultMainBlocksLocation).mkdirs();
        new File(this.defaultFrozenBlocksLocation).mkdirs();
        new File(this.defaultDefrostBlocksLocation).mkdirs();
        if (this.repositoryType == null) {
            throw new Exception("Respository Type - " + this.repositoryType + " not supported!");
        }
        if (this.hotBlockCount < 1) {
            LOGGER.error("EXCEPTION : hotBlocksCount value for DataRepository '" + this.repositoryName + "'is set to " + this.hotBlockCount + ", it should have atleast a minimum value of 1");
            throw new Exception("hotBlocksCount value for DataRepository '" + this.repositoryName + "'is set to " + this.hotBlockCount + ", it should have atleast a minimum value of 1");
        }
        this.validateSchema();
        this.persistenceHandler = new DRPersistenceHandler(this);
    }

    public DataRepository update(XNodeDRConfFile.DataRepositoryBean drBean) throws Exception {
        this.repositoryState = drBean.repositoryState();
        this.description = drBean.description();
        this.isLegacy = drBean.isLegacy();
        this.legacyTableName = drBean.legacyTableName();
        this.schema = DataRepositoryManager.getDRSchema(drBean.schemaName());
        this.hotBlockCount = drBean.blockMainHotCount() == null ? 1 : drBean.blockMainHotCount();
        this.storeRawData = this.repositoryType == DRType.GENERIC ? false : drBean.storeRawData();
        this.blockPrefix = drBean.blockPrefix();
        this.hotBlockRefreshInterval = drBean.blockMainHotRefreshInterval() == null ? 0 : drBean.blockMainHotRefreshInterval();
        this.hotBlockRotationType = drBean.blockMainHotRotationType() == null ? DRBlockRotationType.SIZE : DRBlockRotationType.valueOf((String)drBean.blockMainHotRotationType());
        this.hotBlockRotationSize = drBean.blockMainHotRotationSize() == null ? 3000000 : drBean.blockMainHotRotationSize();
        this.hotBlockRotationPeriod = drBean.blockMainHotRotationPeriod();
        this.mainBlockRetentionDays = drBean.blockMainRetentionDays() == null ? 150 : drBean.blockMainRetentionDays();
        this.frozenBlockS1RetentionDays = drBean.blockFrozenS1RetentionDays() == null ? -1 : drBean.blockFrozenS1RetentionDays();
        this.frozenBlockRetentionDays = drBean.blockFrozenRetentionDays() == null ? 99999 : drBean.blockFrozenRetentionDays();
        this.defrostBlockRetentionDays = drBean.blockDefrostRetentionDays() == null ? 7 : drBean.blockDefrostRetentionDays();
        this.graceBlockRetentionDays = drBean.blockGraceRetentionDays() == null ? 20 : drBean.blockGraceRetentionDays();
        this.xnodes = drBean.nodes();
        if (this.hotBlockCount < 1) {
            LOGGER.error("EXCEPTION : hotBlocksCount value for DataRepository '" + this.repositoryName + "'is set to " + this.hotBlockCount + ", it should have atleast a minimum value of 1");
            throw new Exception("hotBlocksCount value for DataRepository '" + this.repositoryName + "'is set to " + this.hotBlockCount + ", it should have atleast a minimum value of 1");
        }
        this.validateSchema();
        return this;
    }

    public String repositoryName() {
        return this.repositoryName;
    }

    public String repositoryState() {
        return this.repositoryState;
    }

    public String description() {
        return this.description;
    }

    public DRType repositoryType() {
        return this.repositoryType;
    }

    public String containerName() {
        return this.containerName;
    }

    public boolean isLegacy() {
        return this.isLegacy;
    }

    public String legacyTableName() {
        return this.legacyTableName;
    }

    public DRSchema schema() {
        return this.schema;
    }

    public boolean storeRawData() {
        return this.storeRawData;
    }

    public boolean containsDuplicate() {
        return this.containsDuplicate;
    }

    public String blockPrefix() {
        return this.blockPrefix;
    }

    public int hotBlockCount() {
        return this.hotBlockCount;
    }

    public int hotBlockRefreshInterval() {
        return this.hotBlockRefreshInterval;
    }

    public DRBlockRotationType hotBlockRotationType() {
        return this.hotBlockRotationType;
    }

    public int hotBlockRotationSize() {
        return this.hotBlockRotationSize;
    }

    public String hotBlockRotationPeriod() {
        return this.hotBlockRotationPeriod;
    }

    public int mainBlockRetentionDays() {
        return this.mainBlockRetentionDays;
    }

    public int frozenS1BlockRetentionDays() {
        return this.frozenBlockS1RetentionDays;
    }

    public int frozenBlockRetentionDays() {
        return this.frozenBlockRetentionDays;
    }

    public int graceBlockRetentionDays() {
        return this.graceBlockRetentionDays;
    }

    public int absoluteFrozenS1BlockRetentionDays() {
        return (this.mainBlockRetentionDays != -1 ? this.mainBlockRetentionDays : 0) + this.frozenBlockS1RetentionDays;
    }

    public int absoluteFrozenBlockRetentionDays() {
        return (this.mainBlockRetentionDays != -1 ? this.mainBlockRetentionDays : 0) + (this.frozenBlockS1RetentionDays != -1 ? this.frozenBlockS1RetentionDays : 0) + this.frozenBlockRetentionDays;
    }

    public int defrostBlockRetentionDays() {
        return this.defrostBlockRetentionDays;
    }

    public ArrayList<String> xnodes() {
        return this.xnodes;
    }

    protected int hotBlockThresholdDocCount() {
        return this.hotBlockRotationSize;
    }

    protected String defaultMainBlocksLocation() {
        return this.defaultMainBlocksLocation;
    }

    protected String defaultArchiveBlocksLocation() {
        return this.defaultArchiveBlocksLocation;
    }

    protected String currentArchiveBlocksLocation() {
        return this.currentArchiveBlocksLocation;
    }

    protected String defaultFrozenBlocksLocation() {
        return this.defaultFrozenBlocksLocation;
    }

    public String currentFrozenBlocksLocation() {
        return this.currentFrozenBlocksLocation;
    }

    protected String defaultDefrostBlocksLocation() {
        return this.defaultDefrostBlocksLocation;
    }

    protected void setCurrentArchiveBlocksLocation(String path) {
        this.currentArchiveBlocksLocation = path + File.separator + this.containerName + File.separator + this.repositoryName + File.separator;
        this.currentFrozenBlocksLocation = this.currentArchiveBlocksLocation + "frozen" + File.separator;
    }

    protected String mainBlocksMetaFile() {
        return this.mainBlocksMetaFile;
    }

    protected String archiveBlocksMetaFile() {
        return this.archiveBlocksMetaFile;
    }

    public DRPersistenceHandler persistenceHandler() {
        return this.persistenceHandler;
    }

    public DRIndexField getIndexField(String fieldName) {
        return this.schema.getIndexField(fieldName);
    }

    public DRIndexField getIndexFieldByAliasName(String fieldAliasName) {
        return this.schema.getIndexFieldByAliasName(fieldAliasName);
    }

    public boolean hasIndexField(String fieldName) {
        return this.schema.hasIndexField(fieldName);
    }

    public ArrayList<DRIndexField> getIndexFields() {
        return this.schema.getIndexFields();
    }

    public ArrayList<DRIndexField> getUniqueIndexFields() {
        return this.schema.getUniqueFields();
    }

    public Sort getIndexSortObj() {
        return this.schema.getIndexSortObj();
    }

    public Analyzer getAnalyzerWrapper() throws IOException {
        return this.schema.getAnalyzerWrapper();
    }

    public Map<String, Analyzer> getFieldVsAnalyzer() throws IOException {
        return this.schema.getFieldVsAnalyzer();
    }

    public String getBlockArchivePath(DRBlock block) {
        ArrayList<String> locationList = DataRepositoryManager.getArchiveLocations();
        for (String archiveLocation : locationList) {
            String absArchivePath = null;
            if (block.version() == 1) {
                absArchivePath = archiveLocation + File.separator + block.blockName() + ".zip";
                if (!new File(absArchivePath).exists()) continue;
                return absArchivePath;
            }
            absArchivePath = archiveLocation + File.separator + this.containerName() + File.separator + this.repositoryName() + File.separator + "frozen";
            if (new File(absArchivePath + File.separator + block.blockName() + "_S1.7z").exists()) {
                return absArchivePath + File.separator + block.blockName() + "_S1.7z";
            }
            if (new File(absArchivePath + File.separator + block.blockName() + "_S2.gz").exists()) {
                return absArchivePath + File.separator + block.blockName() + "_S2.gz";
            }
            if (!new File(absArchivePath + File.separator + block.blockName() + ".gz").exists()) continue;
            return absArchivePath + File.separator + block.blockName() + ".gz";
        }
        return null;
    }

    public void removeDuplicateEntries() throws Exception {
        try (Connection connection = DBManager.getStoreConnection();){
            this.persistenceHandler().removeDuplicateArchiveEntries(connection);
        }
    }

    public void cleanArchiveMeta() throws Exception {
        try (Connection connection = DBManager.getStoreConnection();){
            this.persistenceHandler().dropMetaFile(connection, MetaFileType.ARCHIVE);
            this.persistenceHandler().deleteMetaFile(MetaFileType.ARCHIVE);
            this.persistenceHandler().createMetaFile(connection, MetaFileType.ARCHIVE);
        }
    }

    public void addEntriesToArchiveMeta(JSONArray blockList) throws Exception {
        try (Connection connection = DBManager.getStoreConnection();){
            this.persistenceHandler().addToMetaFile(connection, blockList, MetaFileType.ARCHIVE);
        }
    }

    public long getMainBlocksDiskSize() throws Exception {
        String[] files = new File(this.defaultMainBlocksLocation()).list();
        long totalSize = 0L;
        for (String file : files) {
            try {
                totalSize += FileUtils.sizeOf((File)new File(this.defaultMainBlocksLocation() + File.separator + file));
            }
            catch (IllegalArgumentException e) {
                LOGGER.info("Unable to fetch main block size due to activity in " + this.defaultMainBlocksLocation() + File.separator + file);
            }
        }
        return totalSize;
    }

    public long fetchColdBlocksDiskSize() throws Exception {
        long coldSize = 0L;
        try (Connection storeCon = DBManager.getStoreConnection();){
            coldSize = this.persistenceHandler().readColdBlocksSizeFromMetaFile(storeCon, MetaFileType.ARCHIVE);
        }
        return coldSize;
    }

    public long fetchFrozenBlocksDiskSize() throws Exception {
        long frozenSize = 0L;
        try (Connection storeCon = DBManager.getStoreConnection();){
            frozenSize = this.persistenceHandler().readFrozenBlocksSizeFromMetaFile(storeCon, MetaFileType.ARCHIVE);
        }
        return frozenSize;
    }

    public JSONArray fetchBlocksMetaFromFile(boolean isMain, long fromTime, long toTime, int size, int offset, String sortField, String sortOrder, String searchText) throws Exception {
        JSONArray blockList = new JSONArray();
        if (!isMain && this.repositoryType() != DRType.AUDIT_LOG) {
            return blockList;
        }
        try (Connection storeCon = DBManager.getStoreConnection();){
            blockList = this.persistenceHandler().readFromMetaFile(storeCon, isMain ? MetaFileType.MAIN : MetaFileType.ARCHIVE, fromTime, toTime, size, offset, sortField, sortOrder, searchText);
        }
        return blockList;
    }

    public int fetchBlocksCountFromFile(boolean isMain, long fromTime, long toTime, String searchText) throws Exception {
        int count = 0;
        if (!isMain && this.repositoryType() != DRType.AUDIT_LOG) {
            return count;
        }
        try (Connection storeCon = DBManager.getStoreConnection();){
            count = this.persistenceHandler().getBlocksCount(storeCon, isMain ? MetaFileType.MAIN : MetaFileType.ARCHIVE, fromTime, toTime, searchText);
        }
        return count;
    }

    public JSONArray fetchToDeleteBlocksMetaFromFile(boolean isMain, long startTime, long endTime, int retentionDays, String searchText) throws Exception {
        JSONArray blockList = new JSONArray();
        if (this.repositoryType() != DRType.AUDIT_LOG) {
            return blockList;
        }
        try (Connection storeCon = DBManager.getStoreConnection();){
            if (retentionDays != -1) {
                blockList = this.persistenceHandler().getToBeDeletedBlocks(storeCon, startTime, endTime, (long)retentionDays * 86400L, (long)this.defrostBlockRetentionDays() * 86400L, isMain ? MetaFileType.MAIN : MetaFileType.ARCHIVE, searchText);
            }
        }
        return blockList;
    }

    public JSONArray fetchDeletedBlocksMetaFromFile(long fromTime, long toTime, int size, int offset, String sortField, String sortOrder, String searchText) throws Exception {
        JSONArray blockList = new JSONArray();
        if (this.repositoryType() != DRType.AUDIT_LOG) {
            return blockList;
        }
        try (Connection storeCon = DBManager.getStoreConnection();){
            blockList = this.persistenceHandler().getDeletedBlocks(storeCon, fromTime, toTime, size, offset, sortField, sortOrder, searchText);
        }
        return blockList;
    }

    public long fetchLiveBlocksSize() throws Exception {
        long liveSize = 0L;
        if (this.repositoryType() != DRType.AUDIT_LOG) {
            return liveSize;
        }
        try (Connection storeCon = DBManager.getStoreConnection();){
            liveSize = this.persistenceHandler().readLiveBlocksSizeFromMetaFile(storeCon, MetaFileType.MAIN, null);
        }
        return liveSize += this.persistenceHandler().readLiveBlocksSizeFromMetaFile(storeCon, MetaFileType.ARCHIVE, "STATE like '%DEFROST%'");
    }

    public boolean addDRMetaCol(String columnName, String columnsType, String defaultValue, boolean isMain) throws Exception {
        try (Connection storeCon = DBManager.getStoreConnection();){
            boolean bl = this.persistenceHandler().addColumn(storeCon, columnName, columnsType, defaultValue, isMain ? MetaFileType.MAIN : MetaFileType.ARCHIVE);
            return bl;
        }
    }

    public boolean updateDRMetaInfo(String columnName, String columnValue, boolean isMain) throws Exception {
        try (Connection storeCon = DBManager.getStoreConnection();){
            boolean bl = this.persistenceHandler().updateColumn(storeCon, columnName, columnValue, isMain ? MetaFileType.MAIN : MetaFileType.ARCHIVE);
            return bl;
        }
    }

    @Override
    public JSONObject fetchBlocksMeta(DataRepositoryActionRequest request) throws Exception {
        JSONObject jResponse = new JSONObject();
        jResponse.put("dr_blocks_meta", (Object)this.fetchBlocksMetaFromFile(request.isMain(), request.fromTime(), request.toTime(), request.size(), request.offset(), request.sortField(), request.sortOrder(), request.searchText()));
        return jResponse;
    }

    @Override
    public JSONObject addDRMetaCol(DataRepositoryActionRequest request) throws Exception {
        JSONObject jRes = new JSONObject();
        boolean updateSuccess = this.addDRMetaCol(request.columnName(), request.columnType(), request.defaultValue(), request.isMain());
        return jRes.put("add_success", updateSuccess);
    }

    @Override
    public JSONObject updateDRMetaInfo(DataRepositoryActionRequest request) throws Exception {
        JSONObject jRes = new JSONObject();
        boolean updateSuccess = this.updateDRMetaInfo(request.columnName(), request.columnValue(), request.isMain());
        return jRes.put("update_success", updateSuccess);
    }

    @Override
    public JSONObject fetchBlocksCount(DataRepositoryActionRequest request) throws Exception {
        JSONObject jResponse = new JSONObject();
        jResponse.put("dr_blocks_count", this.fetchBlocksCountFromFile(request.isMain(), request.fromTime(), request.toTime(), request.searchText()));
        return jResponse;
    }

    @Override
    public JSONObject fetchToDeleteBlocksMeta(DataRepositoryActionRequest request) throws Exception {
        JSONObject jResponse = new JSONObject();
        long startTime = request.startTime();
        long endTime = request.endTime();
        String searchText = request.searchText();
        JSONArray mainToBeDeleted = new JSONArray();
        JSONArray frozenToBeDeleted = new JSONArray();
        if (this.mainBlockRetentionDays() != -1) {
            int retDays = this.frozenBlockRetentionDays() == -1 ? this.mainBlockRetentionDays() : (this.frozenS1BlockRetentionDays() == -1 ? this.mainBlockRetentionDays() + this.frozenBlockRetentionDays() : this.absoluteFrozenBlockRetentionDays());
            mainToBeDeleted = this.fetchToDeleteBlocksMetaFromFile(true, startTime, endTime, retDays, searchText);
        }
        if (this.mainBlockRetentionDays() != -1 && this.frozenBlockRetentionDays() != -1 && this.frozenBlockRetentionDays() != 99999) {
            frozenToBeDeleted = this.fetchToDeleteBlocksMetaFromFile(false, startTime, endTime, this.absoluteFrozenBlockRetentionDays(), searchText);
        }
        for (int i = 0; i < frozenToBeDeleted.length(); ++i) {
            mainToBeDeleted.put(frozenToBeDeleted.get(i));
        }
        jResponse.put("dr_to_delete_blocks_meta", (Object)mainToBeDeleted);
        return jResponse;
    }

    @Override
    public JSONObject fetchDeletedBlocksMeta(DataRepositoryActionRequest request) throws Exception {
        JSONObject jResponse = new JSONObject();
        jResponse.put("dr_deleted_blocks_meta", (Object)this.fetchDeletedBlocksMetaFromFile(request.fromTime(), request.toTime(), request.size(), request.offset(), request.sortField(), request.sortOrder(), request.searchText()));
        return jResponse;
    }

    private void validateSchema() throws Exception {
        if (this.repositoryType == DRType.AUDIT_LOG) {
            if (!this.schema.getRangeField().equalsIgnoreCase(DRType.AUDIT_LOG.getDefaultTimeField())) {
                throw new Exception("Schema '" + this.schema.getSchemaName() + "' of DataRepository '" + this.repositoryName + "' should have the default range field '" + DRType.AUDIT_LOG.getDefaultTimeField() + "'!");
            }
            ArrayList fieldList = this.schema.getIndexFieldNames();
            boolean timeFieldFound = false;
            for (String field : fieldList) {
                if (!field.equalsIgnoreCase(DRType.AUDIT_LOG.getDefaultTimeField())) continue;
                timeFieldFound = true;
                break;
            }
            if (!timeFieldFound) {
                throw new Exception("Schema '" + this.schema.getSchemaName() + "' of DataRepository '" + this.repositoryName + "' should have the time field '" + DRType.AUDIT_LOG.getDefaultTimeField() + "'!");
            }
        }
    }

    public abstract ArrayList<DRBlock> getBlocksInRange(Long var1, Long var2) throws Exception;

    public abstract ArrayList<DRBlock> getBlocksFromList(JSONArray var1);

    public abstract long getMainBlocksDiskSizeOlderThan(int var1) throws Exception;

    public abstract boolean drop() throws Exception;

    public abstract void doStop();

    public abstract boolean doClose();

    public abstract boolean isStopping();
}

