/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.dataengine.xnode.datarepository;

import com.manageengine.dataengine.xnode.connector.global.transport.TransportRequest;
import com.manageengine.dataengine.xnode.datarepository.DRQueryParser;
import com.manageengine.dataengine.xnode.datarepository.DataRepository;
import com.manageengine.dataengine.xnode.datarepository.DataRepositoryManager;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.search.Query;
import org.json.JSONArray;
import org.json.JSONObject;

public class DataRepositoryActionRequest {
    private final long requestId;
    private final String actionType;
    private DataRepository dataRepository;
    private JSONObject dataRepositoryListObj;
    private JSONArray dataRepositoryList;
    private JSONObject drSchemaListObj;
    private JSONArray archiveLocationList;
    private long fromTime = -1L;
    private long toTime = -1L;
    private long creationTime = -1L;
    private int offset = 0;
    private int size = 0;
    private String sortField = null;
    private String sortOrder = null;
    private String searchText = null;
    private String dataFilePath = null;
    private JSONArray dataFilePathList = null;
    private Charset fileEncoding;
    private char splitBy;
    private JSONArray bulkData = null;
    private boolean isMain = true;
    private boolean clean = false;
    private boolean isCurrentPathUpdate = false;
    private String blockName;
    private String queryText;
    private Query query;
    private boolean canLoad = true;
    private String availableSpace = null;
    private int archiveSchedulerInterval = 2;
    private long startTime;
    private long endTime;
    private String columnName;
    private String columnValue;
    private String columnType;
    private String defaultValue;

    public String columnName() {
        return this.columnName;
    }

    public String columnType() {
        return this.columnType;
    }

    public String columnValue() {
        return this.columnValue;
    }

    public String defaultValue() {
        return this.defaultValue;
    }

    private DataRepositoryActionRequest(long requestId, String actionType) {
        this.requestId = requestId;
        this.actionType = actionType;
    }

    public String actionType() {
        return this.actionType;
    }

    public DataRepository dataRepository() {
        return this.dataRepository;
    }

    public JSONObject dataRepositoryListObj() {
        return this.dataRepositoryListObj;
    }

    public JSONArray dataRepositoryList() {
        return this.dataRepositoryList;
    }

    public JSONObject drSchemaListObj() {
        return this.drSchemaListObj;
    }

    public JSONArray archiveLocationList() {
        return this.archiveLocationList;
    }

    public long fromTime() {
        return this.fromTime;
    }

    public long toTime() {
        return this.toTime;
    }

    public long startTime() {
        return this.startTime;
    }

    public long endTime() {
        return this.endTime;
    }

    public long creationTime() {
        return this.creationTime;
    }

    public int offset() {
        return this.offset;
    }

    public int size() {
        return this.size;
    }

    public String sortField() {
        return this.sortField;
    }

    public String sortOrder() {
        return this.sortOrder;
    }

    public String searchText() {
        return this.searchText;
    }

    public String dataFilePath() {
        return this.dataFilePath;
    }

    public JSONArray dataFilePathList() {
        return this.dataFilePathList;
    }

    public Charset fileEncoding() {
        return this.fileEncoding;
    }

    public char splitBy() {
        return this.splitBy;
    }

    public JSONArray bulkData() {
        return this.bulkData;
    }

    public String blockName() {
        return this.blockName;
    }

    public boolean isMain() {
        return this.isMain;
    }

    public boolean clean() {
        return this.clean;
    }

    public boolean isCurrentPathUpdate() {
        return this.isCurrentPathUpdate;
    }

    public String queryText() {
        return this.queryText;
    }

    public Query query() {
        return this.query;
    }

    public boolean canLoad() {
        return this.canLoad;
    }

    public String availableSpace() {
        return this.availableSpace;
    }

    public int archiveSchedulerInterval() {
        return this.archiveSchedulerInterval;
    }

    public static DataRepositoryActionRequest buildDataAddRequest(TransportRequest request) throws Exception {
        DataRepositoryActionRequest drRequest = new DataRepositoryActionRequest(request.requestId(), request.actionType());
        if (!request.has("dr_name")) {
            throw new Exception("EXCEPTION while processing data-add-request, missing some mandatory request parameters(dr_name)");
        }
        if (!request.has("data_file_path") && !request.has("data_doc_list")) {
            throw new Exception("EXCEPTION while processing index-request, request should have either data_file_path or data_doc_list parameter!");
        }
        if (request.has("data_file_path")) {
            drRequest.dataFilePath = request.getString("data_file_path");
            drRequest.fileEncoding = Charset.forName(request.optString("file_encoding", "UTF-8"));
            drRequest.splitBy = request.optString("file_line_split_by", "\t").charAt(0);
        } else {
            drRequest.bulkData = request.getJSONArray("data_doc_list");
        }
        String repoName = request.getString("dr_name");
        drRequest.dataRepository = DataRepositoryManager.getDataRepository(repoName);
        return drRequest;
    }

    public static DataRepositoryActionRequest buildMigrationDataAddRequest(TransportRequest request) throws Exception {
        DataRepositoryActionRequest drRequest = new DataRepositoryActionRequest(request.requestId(), request.actionType());
        if (!request.has("dr_name") || !request.has("data_file_path_list")) {
            throw new Exception("EXCEPTION while processing migration-data-add-request, missing some mandatory request parameters(dr_name|data_file_path_list)");
        }
        drRequest.dataFilePathList = request.getJSONArray("data_file_path_list");
        drRequest.creationTime = request.getLong("creation_time");
        String encoding = request.optString("file_encoding", null);
        drRequest.fileEncoding = encoding == null || encoding.isEmpty() ? null : Charset.forName(encoding);
        drRequest.splitBy = request.optString("file_line_split_by", "\t").charAt(0);
        String repoName = request.getString("dr_name");
        drRequest.dataRepository = DataRepositoryManager.getDataRepository(repoName);
        return drRequest;
    }

    public static DataRepositoryActionRequest buildMigrationDataValidateRequest(TransportRequest request) throws Exception {
        DataRepositoryActionRequest drRequest = new DataRepositoryActionRequest(request.requestId(), request.actionType());
        if (!request.has("dr_name") || !request.has("creation_time")) {
            throw new Exception("EXCEPTION while processing migration-data-validate-request, missing some mandatory request parameters(dr_name|creation_time)");
        }
        drRequest.creationTime = request.getLong("creation_time");
        String repoName = request.getString("dr_name");
        drRequest.dataRepository = DataRepositoryManager.getDataRepository(repoName);
        return drRequest;
    }

    public static DataRepositoryActionRequest buildDataUpdateRequest(TransportRequest request) throws Exception {
        DataRepositoryActionRequest drRequest = new DataRepositoryActionRequest(request.requestId(), request.actionType());
        return drRequest;
    }

    public static DataRepositoryActionRequest buildDataDeleteRequest(TransportRequest request) throws Exception {
        DataRepositoryActionRequest drRequest = new DataRepositoryActionRequest(request.requestId(), request.actionType());
        if (!request.has("query") || !request.has("dr_name")) {
            throw new Exception("Error while processing data-delete-request, missing some mandatory request parameters(query|dr_name)");
        }
        drRequest.queryText = request.getString("query");
        drRequest.dataRepository = DataRepositoryManager.getDataRepository(request.getString("dr_name"));
        List<DataRepository> dataRepositoryList = Arrays.asList(drRequest.dataRepository);
        DRQueryParser parser = new DRQueryParser(null, DataRepositoryManager.getAnalyzerWrapper(dataRepositoryList), dataRepositoryList);
        drRequest.query = parser.parse(drRequest.queryText);
        return drRequest;
    }

    public static DataRepositoryActionRequest buildArchiveBlocksLoadRequest(TransportRequest request) throws Exception {
        DataRepositoryActionRequest drRequest = new DataRepositoryActionRequest(request.requestId(), request.actionType());
        if (!request.has("dr_name")) {
            throw new Exception("Error while processing defrost-request, missing some mandatory request parameters(dr_name)");
        }
        if (!request.has("dr_block_name")) {
            throw new Exception("EXCEPTION while processing defrost-request, missing dr_block_name parameter!");
        }
        drRequest.blockName = request.getString("dr_block_name");
        String repoName = request.getString("dr_name");
        drRequest.canLoad = request.getBoolean("can_load");
        drRequest.availableSpace = request.getString("available_disk_space");
        drRequest.dataRepository = DataRepositoryManager.getDataRepository(repoName);
        return drRequest;
    }

    public static DataRepositoryActionRequest buildArchiveBlocksUnloadRequest(TransportRequest request) throws Exception {
        DataRepositoryActionRequest drRequest = new DataRepositoryActionRequest(request.requestId(), request.actionType());
        if (!request.has("dr_name")) {
            throw new Exception("Error while processing freeze-defrost-request, missing some mandatory request parameters(dr_name)");
        }
        if (!request.has("dr_block_name")) {
            throw new Exception("EXCEPTION while processing freeze-request, missing dr_block_name parameter!");
        }
        drRequest.blockName = request.getString("dr_block_name");
        String repoName = request.getString("dr_name");
        drRequest.dataRepository = DataRepositoryManager.getDataRepository(repoName);
        return drRequest;
    }

    public static DataRepositoryActionRequest buildBlocksMetaSyncRequest(TransportRequest request) throws Exception {
        DataRepositoryActionRequest drRequest = new DataRepositoryActionRequest(request.requestId(), request.actionType());
        if (!request.has("dr_list")) {
            throw new Exception("Error while processing sync-blocks-meta-request, missing some mandatory request parameters(dr_list)");
        }
        drRequest.dataRepositoryListObj = request.getJSONObject("dr_list");
        return drRequest;
    }

    public static DataRepositoryActionRequest buildBlocksMetaFetchRequest(TransportRequest request) throws Exception {
        DataRepositoryActionRequest drRequest = new DataRepositoryActionRequest(request.requestId(), request.actionType());
        if (!request.has("dr_name_list")) {
            throw new Exception("Error while processing blocks-meta-fetch-request, missing some mandatory request parameters(dr_name_list)");
        }
        drRequest.dataRepositoryList = request.getJSONArray("dr_name_list");
        drRequest.isMain = request.optBoolean("dr_is_main", true);
        drRequest.fromTime = request.optLong("from_time", -1L);
        drRequest.toTime = request.optLong("to_time", -1L);
        drRequest.offset = request.optInt("offset", 0);
        drRequest.size = request.optInt("size", 0);
        drRequest.sortField = request.optString("sort_field", null);
        drRequest.sortOrder = request.optString("sort_order", null);
        drRequest.searchText = request.optString("search_text", null);
        return drRequest;
    }

    public static DataRepositoryActionRequest buildBlocksCountFetchRequest(TransportRequest request) throws Exception {
        DataRepositoryActionRequest drRequest = new DataRepositoryActionRequest(request.requestId(), request.actionType());
        if (!request.has("dr_name_list")) {
            throw new Exception("Error while processing blocks-meta-fetch-count-request, missing some mandatory request parameters(dr_name_list)");
        }
        drRequest.dataRepositoryList = request.getJSONArray("dr_name_list");
        drRequest.isMain = request.optBoolean("dr_is_main", true);
        drRequest.fromTime = request.optLong("from_time", -1L);
        drRequest.toTime = request.optLong("to_time", -1L);
        drRequest.searchText = request.optString("search_text", null);
        return drRequest;
    }

    public static DataRepositoryActionRequest buildDRSyncOrUpdateRequest(TransportRequest request) throws Exception {
        DataRepositoryActionRequest drRequest = new DataRepositoryActionRequest(request.requestId(), request.actionType());
        if (!request.has("dr_list")) {
            throw new Exception("Error while processing dr-request, missing some mandatory request parameters(dr_list)");
        }
        drRequest.dataRepositoryList = request.getJSONArray("dr_list");
        return drRequest;
    }

    public static DataRepositoryActionRequest buildDRSchemaSyncRequest(TransportRequest request) throws Exception {
        DataRepositoryActionRequest drRequest = new DataRepositoryActionRequest(request.requestId(), request.actionType());
        if (!request.has("dr_schema_list")) {
            throw new Exception("Error while processing dr-schema-sync-request, missing some mandatory request parameters(dr_schema_list)");
        }
        drRequest.drSchemaListObj = request.getJSONObject("dr_schema_list");
        return drRequest;
    }

    public static DataRepositoryActionRequest buildDRDiskSizeFetchRequest(TransportRequest request) throws Exception {
        DataRepositoryActionRequest drRequest = new DataRepositoryActionRequest(request.requestId(), request.actionType());
        if (!request.has("dr_name_list")) {
            throw new Exception("Error while processing dr-size-fetch-request, missing some mandatory request parameters(dr_name_list)");
        }
        drRequest.dataRepositoryList = request.getJSONArray("dr_name_list");
        return drRequest;
    }

    public static DataRepositoryActionRequest buildArchiveLocationsSyncRequest(TransportRequest request) throws Exception {
        DataRepositoryActionRequest drRequest = new DataRepositoryActionRequest(request.requestId(), request.actionType());
        if (!request.has("archive_location_list")) {
            throw new Exception("Error while processing archive-locations-sync-request, missing some mandatory request parameters(archive_location_list)");
        }
        drRequest.archiveLocationList = request.getJSONArray("archive_location_list");
        drRequest.clean = request.optBoolean("archive_location_clean", false);
        drRequest.isCurrentPathUpdate = request.optBoolean("archive_location_current_path_update", false);
        return drRequest;
    }

    public static DataRepositoryActionRequest buildToDeleteBlocksMetaFetchRequest(TransportRequest request) throws Exception {
        DataRepositoryActionRequest drRequest = new DataRepositoryActionRequest(request.requestId(), request.actionType());
        if (!request.has("dr_name_list")) {
            throw new Exception("Error while processing to-delete-blocks-meta-fetch-request, missing some mandatory request parameters(dr_name_list)");
        }
        drRequest.startTime = request.optLong("from_time", 0L);
        drRequest.endTime = request.getLong("to_time");
        drRequest.searchText = request.optString("search_text", null);
        drRequest.dataRepositoryList = request.getJSONArray("dr_name_list");
        return drRequest;
    }

    public static DataRepositoryActionRequest buildArchivePageInfoFetchRequest(TransportRequest request) throws Exception {
        DataRepositoryActionRequest drRequest = new DataRepositoryActionRequest(request.requestId(), request.actionType());
        if (!request.has("dr_name_list")) {
            throw new Exception("Error while processing build-archive-page-info-fetch-request, missing some mandatory request parameters(dr_name_list)");
        }
        drRequest.dataRepositoryList = request.getJSONArray("dr_name_list");
        return drRequest;
    }

    public static DataRepositoryActionRequest buildDRArchiveSchedulerSyncRequest(TransportRequest request) throws Exception {
        DataRepositoryActionRequest drRequest = new DataRepositoryActionRequest(request.requestId(), request.actionType());
        if (!request.has("dr_archive_scheduler_interval")) {
            throw new Exception("Error while processing archive-scheduler-sync-request, missing some mandatory request parameters(dr_archive_scheduler_interval)");
        }
        drRequest.archiveSchedulerInterval = request.getInt("dr_archive_scheduler_interval");
        return drRequest;
    }

    public static DataRepositoryActionRequest buildDeletedBlocksMetaFetchRequest(TransportRequest request) throws Exception {
        DataRepositoryActionRequest drRequest = new DataRepositoryActionRequest(request.requestId(), request.actionType());
        if (!request.has("dr_name_list")) {
            throw new Exception("Error while processing deleted-blocks-meta-fetch-request, missing some mandatory request parameters(dr_name_list)");
        }
        drRequest.dataRepositoryList = request.getJSONArray("dr_name_list");
        drRequest.fromTime = request.optLong("from_time", -1L);
        drRequest.toTime = request.optLong("to_time", -1L);
        drRequest.offset = request.optInt("offset", 0);
        drRequest.size = request.optInt("size", 0);
        drRequest.sortField = request.optString("sort_field", null);
        drRequest.sortOrder = request.optString("sort_order", null);
        drRequest.searchText = request.optString("search_text", null);
        return drRequest;
    }

    public static DataRepositoryActionRequest buildMetaColAddRequest(TransportRequest request) throws Exception {
        DataRepositoryActionRequest drRequest = new DataRepositoryActionRequest(request.requestId(), request.actionType());
        if (!request.has("column_name") && !request.has("column_type")) {
            throw new Exception("Error while processing dr-meta-column-add-request, missing some mandatory request parameters(column_name|column_type");
        }
        drRequest.columnName = request.getString("column_name");
        drRequest.columnType = request.getString("column_type");
        drRequest.defaultValue = request.optString("default_value", "");
        drRequest.isMain = request.optBoolean("dr_is_main", false);
        return drRequest;
    }

    public static DataRepositoryActionRequest buildMetaInfoUpdateRequest(TransportRequest request) throws Exception {
        DataRepositoryActionRequest drRequest = new DataRepositoryActionRequest(request.requestId(), request.actionType());
        if (!request.has("column_name") && !request.has("column_value")) {
            throw new Exception("Error while processing dr-meta-column-update-request, missing some mandatory request parameters (column_name|column_value");
        }
        drRequest.columnName = request.getString("column_name");
        drRequest.columnValue = request.getString("column_value");
        drRequest.isMain = request.optBoolean("dr_is_main", false);
        return drRequest;
    }
}

